/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.network;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.ClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.SkyClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.client.color.BetaColorSampler;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Level;

public class WorldInfoMessage
implements IMessage {
    public static final WorldInfoMessage EMPTY = new WorldInfoMessage(0L, "");
    private static final int BYTE_BUFFER_LEN = 2048;
    private static final String UTF_8 = "UTF-8";
    private long seed;
    private String settings;

    public WorldInfoMessage() {
    }

    public WorldInfoMessage(long seed, String settings) {
        this.seed = seed;
        this.settings = settings;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.seed);
        try {
            byte[] bytes = this.compressBytes(this.settings.getBytes(UTF_8));
            ModernBeta.log(Level.DEBUG, "Compressed size: " + bytes.length);
            buf.writeBytes(bytes);
        }
        catch (UnsupportedEncodingException e) {
            ModernBeta.log(Level.ERROR, String.format("Generator options couldn't be encoded!", new Object[0]));
            ModernBeta.log(Level.ERROR, "Error: " + e.getMessage());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.seed = buf.readLong();
        try {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            ModernBeta.log(Level.DEBUG, "Read size: " + bytes.length);
            this.settings = new String(this.decompressBytes(bytes), UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            ModernBeta.log(Level.ERROR, String.format("Generator options couldn't be decoded!", new Object[0]));
            ModernBeta.log(Level.ERROR, "Error: " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] compressBytes(byte[] bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private byte[] decompressBytes(byte[] bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class WorldInfoMessageHandler
    implements IMessageHandler<WorldInfoMessage, IMessage> {
        public IMessage onMessage(WorldInfoMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                BetaColorSampler.INSTANCE.resetClimateSamplers();
                if (message.seed != 0L) {
                    ModernBetaGeneratorSettings settings = ModernBetaGeneratorSettings.build(message.settings);
                    BiomeSource biomeSource = ModernBetaRegistries.BIOME_SOURCE.get(settings.biomeSource).apply(message.seed, settings);
                    if (biomeSource instanceof ClimateSampler && ModernBetaConfig.visualOptions.useBetaBiomeColors) {
                        BetaColorSampler.INSTANCE.setClimateSampler((ClimateSampler)((Object)biomeSource), settings.snowLineOffset);
                    }
                    if (biomeSource instanceof SkyClimateSampler && ModernBetaConfig.visualOptions.useBetaSkyColors) {
                        BetaColorSampler.INSTANCE.setSkyClimateSampler((SkyClimateSampler)((Object)biomeSource));
                    }
                }
            });
            return null;
        }
    }
}

