/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.registry;

import java.util.function.Supplier;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.client.gui.GuiCustomizePreset;
import mod.bespectacled.modernbetaforge.api.client.gui.GuiPredicate;
import mod.bespectacled.modernbetaforge.api.datafix.ModDataFix;
import mod.bespectacled.modernbetaforge.api.property.BiomeProperty;
import mod.bespectacled.modernbetaforge.api.property.BlockProperty;
import mod.bespectacled.modernbetaforge.api.property.BooleanProperty;
import mod.bespectacled.modernbetaforge.api.property.EntityEntryProperty;
import mod.bespectacled.modernbetaforge.api.property.FloatProperty;
import mod.bespectacled.modernbetaforge.api.property.IntProperty;
import mod.bespectacled.modernbetaforge.api.property.ListProperty;
import mod.bespectacled.modernbetaforge.api.property.Property;
import mod.bespectacled.modernbetaforge.api.property.PropertyGuiType;
import mod.bespectacled.modernbetaforge.api.property.StringProperty;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaClientRegistries;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistry;
import mod.bespectacled.modernbetaforge.api.world.chunk.noise.NoiseSettings;
import mod.bespectacled.modernbetaforge.api.world.spawn.WorldSpawner;
import mod.bespectacled.modernbetaforge.client.gui.GuiCustomizePresets;
import mod.bespectacled.modernbetaforge.client.gui.GuiPredicates;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.registry.ModernBetaBuiltInTypes;
import mod.bespectacled.modernbetaforge.util.ForgeRegistryUtil;
import mod.bespectacled.modernbetaforge.util.datafix.ModDataFixers;
import mod.bespectacled.modernbetaforge.world.biome.source.BetaBiomeSource;
import mod.bespectacled.modernbetaforge.world.biome.source.PEBiomeSource;
import mod.bespectacled.modernbetaforge.world.biome.source.ReleaseBiomeSource;
import mod.bespectacled.modernbetaforge.world.biome.source.SingleBiomeSource;
import mod.bespectacled.modernbetaforge.world.carver.MapGenBeta18Cave;
import mod.bespectacled.modernbetaforge.world.carver.MapGenBetaCave;
import mod.bespectacled.modernbetaforge.world.carver.MapGenBetaCaveHell;
import mod.bespectacled.modernbetaforge.world.carver.MapGenBetaCaveUnderwater;
import mod.bespectacled.modernbetaforge.world.carver.MapGenCavesExtended;
import mod.bespectacled.modernbetaforge.world.carver.MapGenNoOp;
import mod.bespectacled.modernbetaforge.world.carver.MapGenRavineExtended;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.chunk.noise.ModernBetaNoiseSettings;
import mod.bespectacled.modernbetaforge.world.chunk.source.AlphaChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.BetaChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.Classic23aChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.DebugNoiseChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.EndChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.IndevChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.Infdev227ChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.Infdev415ChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.Infdev420ChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.Infdev611ChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.PEChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.ReleaseChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.SkylandsChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.surface.Alpha12SurfaceBuilder;
import mod.bespectacled.modernbetaforge.world.chunk.surface.AlphaSurfaceBuilder;
import mod.bespectacled.modernbetaforge.world.chunk.surface.BetaSurfaceBuilder;
import mod.bespectacled.modernbetaforge.world.chunk.surface.Infdev227SurfaceBuilder;
import mod.bespectacled.modernbetaforge.world.chunk.surface.InfdevSurfaceBuilder;
import mod.bespectacled.modernbetaforge.world.chunk.surface.PESurfaceBuilder;
import mod.bespectacled.modernbetaforge.world.chunk.surface.ReleaseSurfaceBuilder;
import mod.bespectacled.modernbetaforge.world.spawn.BetaWorldSpawner;
import mod.bespectacled.modernbetaforge.world.spawn.FarLandsWorldSpawner;
import mod.bespectacled.modernbetaforge.world.spawn.InfdevWorldSpawner;
import mod.bespectacled.modernbetaforge.world.spawn.NoOpWorldSpawner;
import mod.bespectacled.modernbetaforge.world.spawn.PEWorldSpawner;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModernBetaBuiltInRegistries {
    public static void registerChunkSources() {
        ModernBetaRegistry<ModernBetaRegistries.ChunkSourceCreator> registry = ModernBetaRegistries.CHUNK_SOURCE;
        registry.register(ModernBetaBuiltInTypes.Chunk.BETA.getRegistryKey(), BetaChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.ALPHA.getRegistryKey(), AlphaChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.SKYLANDS.getRegistryKey(), SkylandsChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.INFDEV_611.getRegistryKey(), Infdev611ChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.INFDEV_420.getRegistryKey(), Infdev420ChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.INFDEV_415.getRegistryKey(), Infdev415ChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.INFDEV_227.getRegistryKey(), Infdev227ChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.INDEV.getRegistryKey(), IndevChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.CLASSIC_0_0_23A.getRegistryKey(), Classic23aChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.PE.getRegistryKey(), PEChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.RELEASE.getRegistryKey(), ReleaseChunkSource::new);
        registry.register(ModernBetaBuiltInTypes.Chunk.END.getRegistryKey(), EndChunkSource::new);
        if (ModernBetaConfig.debugOptions.registerDebugNoiseChunkSource) {
            registry.register(ModernBetaBuiltInTypes.Chunk.DEBUG_NOISE.getRegistryKey(), DebugNoiseChunkSource::new);
        }
    }

    public static void registerBiomeSources() {
        ModernBetaRegistry<ModernBetaRegistries.BiomeSourceCreator> registry = ModernBetaRegistries.BIOME_SOURCE;
        registry.register(ModernBetaBuiltInTypes.Biome.BETA.getRegistryKey(), BetaBiomeSource::new);
        registry.register(ModernBetaBuiltInTypes.Biome.SINGLE.getRegistryKey(), SingleBiomeSource::new);
        registry.register(ModernBetaBuiltInTypes.Biome.PE.getRegistryKey(), PEBiomeSource::new);
        registry.register(ModernBetaBuiltInTypes.Biome.RELEASE.getRegistryKey(), ReleaseBiomeSource::new);
    }

    public static void registerNoiseSettings() {
        ModernBetaRegistry<NoiseSettings> registry = ModernBetaRegistries.NOISE_SETTING;
        registry.register(ModernBetaBuiltInTypes.Chunk.BETA.getRegistryKey(), ModernBetaNoiseSettings.BETA);
        registry.register(ModernBetaBuiltInTypes.Chunk.ALPHA.getRegistryKey(), ModernBetaNoiseSettings.ALPHA);
        registry.register(ModernBetaBuiltInTypes.Chunk.SKYLANDS.getRegistryKey(), ModernBetaNoiseSettings.SKYLANDS);
        registry.register(ModernBetaBuiltInTypes.Chunk.INFDEV_611.getRegistryKey(), ModernBetaNoiseSettings.INFDEV_611);
        registry.register(ModernBetaBuiltInTypes.Chunk.INFDEV_420.getRegistryKey(), ModernBetaNoiseSettings.INFDEV_420);
        registry.register(ModernBetaBuiltInTypes.Chunk.INFDEV_415.getRegistryKey(), ModernBetaNoiseSettings.INFDEV_415);
        registry.register(ModernBetaBuiltInTypes.Chunk.PE.getRegistryKey(), ModernBetaNoiseSettings.PE);
        registry.register(ModernBetaBuiltInTypes.Chunk.RELEASE.getRegistryKey(), ModernBetaNoiseSettings.RELEASE);
        registry.register(ModernBetaBuiltInTypes.Chunk.END.getRegistryKey(), ModernBetaNoiseSettings.END);
        if (ModernBetaConfig.debugOptions.registerDebugNoiseChunkSource) {
            registry.register(ModernBetaBuiltInTypes.Chunk.DEBUG_NOISE.getRegistryKey(), ModernBetaNoiseSettings.BETA);
        }
    }

    public static void registerSurfaceBuilders() {
        ModernBetaRegistry<ModernBetaRegistries.SurfaceBuilderCreator> registry = ModernBetaRegistries.SURFACE_BUILDER;
        registry.register(ModernBetaBuiltInTypes.Surface.BETA.getRegistryKey(), BetaSurfaceBuilder::new);
        registry.register(ModernBetaBuiltInTypes.Surface.ALPHA.getRegistryKey(), AlphaSurfaceBuilder::new);
        registry.register(ModernBetaBuiltInTypes.Surface.ALPHA_1_2.getRegistryKey(), Alpha12SurfaceBuilder::new);
        registry.register(ModernBetaBuiltInTypes.Surface.INFDEV_227.getRegistryKey(), Infdev227SurfaceBuilder::new);
        registry.register(ModernBetaBuiltInTypes.Surface.INFDEV.getRegistryKey(), InfdevSurfaceBuilder::new);
        registry.register(ModernBetaBuiltInTypes.Surface.PE.getRegistryKey(), PESurfaceBuilder::new);
        registry.register(ModernBetaBuiltInTypes.Surface.RELEASE.getRegistryKey(), ReleaseSurfaceBuilder::new);
    }

    public static void registerCarvers() {
        ModernBetaRegistry<ModernBetaRegistries.CarverCreator> registry = ModernBetaRegistries.CARVER;
        registry.register(ModernBetaChunkGenerator.CAVE_KEY, (chunkSource, settings) -> TerrainGen.getModdedMapGen((MapGenBase)ModernBetaRegistries.CAVE_CARVER.get(settings.caveCarver).apply(chunkSource, settings), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE));
        registry.register(ModernBetaChunkGenerator.RAVINE_KEY, (chunkSource, settings) -> settings.useRavines ? TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavineExtended(chunkSource, settings), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE) : new MapGenNoOp(chunkSource, settings));
        registry.register(ModernBetaChunkGenerator.CAVE_WATER_KEY, (chunkSource, settings) -> settings.useUnderwaterCaves ? TerrainGen.getModdedMapGen((MapGenBase)new MapGenBetaCaveUnderwater(chunkSource, settings), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CUSTOM) : new MapGenNoOp(chunkSource, settings));
    }

    public static void registerCaveCarvers() {
        ModernBetaRegistry<ModernBetaRegistries.CaveCarverCreator> registry = ModernBetaRegistries.CAVE_CARVER;
        registry.register(ModernBetaBuiltInTypes.Carver.BETA.getRegistryKey(), MapGenBetaCave::new);
        registry.register(ModernBetaBuiltInTypes.Carver.BETA_1_8.getRegistryKey(), MapGenBeta18Cave::new);
        registry.register(ModernBetaBuiltInTypes.Carver.BETA_NETHER.getRegistryKey(), MapGenBetaCaveHell::new);
        registry.register(ModernBetaBuiltInTypes.Carver.RELEASE.getRegistryKey(), MapGenCavesExtended::new);
        registry.register(ModernBetaBuiltInTypes.Carver.NONE.getRegistryKey(), MapGenNoOp::new);
    }

    public static void registerWorldSpawners() {
        ModernBetaRegistry<WorldSpawner> registry = ModernBetaRegistries.WORLD_SPAWNER;
        registry.register(ModernBetaBuiltInTypes.WorldSpawner.BETA.getRegistryKey(), new BetaWorldSpawner());
        registry.register(ModernBetaBuiltInTypes.WorldSpawner.INFDEV.getRegistryKey(), new InfdevWorldSpawner());
        registry.register(ModernBetaBuiltInTypes.WorldSpawner.PE.getRegistryKey(), new PEWorldSpawner());
        registry.register(ModernBetaBuiltInTypes.WorldSpawner.FAR_LANDS.getRegistryKey(), new FarLandsWorldSpawner());
        registry.register(ModernBetaBuiltInTypes.WorldSpawner.DEFAULT.getRegistryKey(), WorldSpawner.DEFAULT);
        registry.register(ModernBetaBuiltInTypes.WorldSpawner.RELEASE.getRegistryKey(), new NoOpWorldSpawner());
    }

    public static void registerDefaultBlocks() {
        ModernBetaRegistry<Supplier<Block>> registry = ModernBetaRegistries.DEFAULT_BLOCK;
        registry.register(Blocks.field_150348_b.getRegistryName(), () -> Blocks.field_150348_b);
        registry.register(Blocks.field_150424_aL.getRegistryName(), () -> Blocks.field_150424_aL);
        registry.register(Blocks.field_150377_bs.getRegistryName(), () -> Blocks.field_150377_bs);
    }

    public static void registerProperties() {
        ModernBetaRegistry<Property<?>> registry = ModernBetaRegistries.PROPERTY;
        registry.register(ModernBeta.createRegistryKey("booleanProp"), new BooleanProperty(true));
        registry.register(ModernBeta.createRegistryKey("intProp"), new IntProperty(4, -50, 500, PropertyGuiType.SLIDER));
        registry.register(ModernBeta.createRegistryKey("intProp2"), new IntProperty(4, -50, 500, PropertyGuiType.FIELD));
        registry.register(ModernBeta.createRegistryKey("floatProp"), new FloatProperty(13.0f, 0.0f, 500.0f, PropertyGuiType.SLIDER));
        registry.register(ModernBeta.createRegistryKey("floatProp2"), new FloatProperty(13.0f, 0.0f, 500.0f, PropertyGuiType.FIELD));
        registry.register(ModernBeta.createRegistryKey("floatProp3"), new FloatProperty(0.5f, 0.0f, 1.0f, PropertyGuiType.SLIDER, 1));
        registry.register(ModernBeta.createRegistryKey("floatProp4"), new FloatProperty(0.5f, 0.0f, 1.0f, PropertyGuiType.FIELD, 2));
        registry.register(ModernBeta.createRegistryKey("stringProp"), new StringProperty("test"));
        registry.register(ModernBeta.createRegistryKey("listProp"), new ListProperty(1, new String[]{"test0", "test1", "test2"}));
        registry.register(ModernBeta.createRegistryKey("biomeProp"), new BiomeProperty(Biomes.field_76772_c.getRegistryName()));
        registry.register(ModernBeta.createRegistryKey("blockProp"), new BlockProperty(Blocks.field_150349_c.getRegistryName()));
        registry.register(ModernBeta.createRegistryKey("fluidProp"), new BlockProperty(Blocks.field_150355_j.getRegistryName(), key -> ForgeRegistryUtil.getFluidBlockRegistryNames().contains(key)));
        registry.register(ModernBeta.createRegistryKey("entityProp"), new EntityEntryProperty(new ResourceLocation("pig")));
    }

    public static void registerModDataFixes() {
        ModernBetaRegistry<ModDataFix> registry = ModernBetaRegistries.MOD_DATA_FIX;
        registry.register(ModDataFixers.BIOME_MAP_FIX_KEY, ModDataFixers.BIOME_MAP_FIX);
        registry.register(ModDataFixers.SANDSTONE_WOLVES_SURFACE_FIX_KEY, ModDataFixers.SANDSTONE_WOLVES_SURFACE_FIX);
        registry.register(ModDataFixers.SKYLANDS_SURFACE_FIX_KEY, ModDataFixers.SKYLANDS_SURFACE_FIX);
        registry.register(ModDataFixers.SINGLE_BIOME_FIX_KEY, ModDataFixers.SINGLE_BIOME_FIX);
        registry.register(ModDataFixers.INDEV_HOUSE_FIX_KEY, ModDataFixers.INDEV_HOUSE_FIX);
        registry.register(ModDataFixers.RESOURCE_LOCATION_FIX_KEY, ModDataFixers.RESOURCE_LOCATION_FIX);
        registry.register(ModDataFixers.SCALE_NOISE_FIX_KEY, ModDataFixers.SCALE_NOISE_FIX);
        registry.register(ModDataFixers.LAYER_SIZE_FIX_KEY, ModDataFixers.LAYER_SIZE_FIX);
        registry.register(ModDataFixers.CAVE_CARVER_NONE_FIX_KEY, ModDataFixers.CAVE_CARVER_NONE_FIX);
        registry.register(ModDataFixers.SPAWN_LOCATOR_FIX_KEY, ModDataFixers.SPAWN_LOCATOR_FIX);
        registry.register(ModDataFixers.DEFAULT_FLUID_FIX_KEY, ModDataFixers.DEFAULT_FLUID_FIX);
        registry.register(ModDataFixers.DISKS_FIX_KEY, ModDataFixers.DISKS_FIX);
        registry.register(ModDataFixers.DOUBLE_PLANT_FIX_KEY, ModDataFixers.DOUBLE_PLANT_FIX);
        registry.register(ModDataFixers.LAYER_VERSION_FIX_KEY, ModDataFixers.LAYER_VERSION_FIX);
        registry.register(ModDataFixers.RIVER_BIOMES_FIX_KEY, ModDataFixers.RIVER_BIOMES_FIX);
        registry.register(ModDataFixers.RELEASE_WORLD_SPAWNER_FIX_KEY, ModDataFixers.RELEASE_WORLD_SPAWNER_FIX);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerPresets() {
        ModernBetaRegistry<GuiCustomizePreset> registry = ModernBetaClientRegistries.GUI_PRESET;
        registry.register(GuiCustomizePresets.CLASSIC_BETA, GuiCustomizePresets.PRESET_CLASSIC_BETA);
        registry.register(GuiCustomizePresets.CLASSIC_ALPHA_1_2, GuiCustomizePresets.PRESET_CLASSIC_ALPHA_1_2);
        registry.register(GuiCustomizePresets.CLASSIC_ALPHA, GuiCustomizePresets.PRESET_CLASSIC_ALPHA);
        registry.register(GuiCustomizePresets.CLASSIC_ALPHA_WINTER, GuiCustomizePresets.PRESET_CLASSIC_ALPHA_WINTER);
        registry.register(GuiCustomizePresets.CLASSIC_INFDEV_611, GuiCustomizePresets.PRESET_CLASSIC_INFDEV_611);
        registry.register(GuiCustomizePresets.CLASSIC_INFDEV_420, GuiCustomizePresets.PRESET_CLASSIC_INFDEV_420);
        registry.register(GuiCustomizePresets.CLASSIC_INFDEV_415, GuiCustomizePresets.PRESET_CLASSIC_INFDEV_415);
        registry.register(GuiCustomizePresets.CLASSIC_INFDEV_227, GuiCustomizePresets.PRESET_CLASSIC_INFDEV_227);
        registry.register(GuiCustomizePresets.CLASSIC_INDEV_ISLAND, GuiCustomizePresets.PRESET_CLASSIC_INDEV_ISLAND);
        registry.register(GuiCustomizePresets.CLASSIC_0_0_23A, GuiCustomizePresets.PRESET_CLASSIC_0_0_23A);
        registry.register(GuiCustomizePresets.CLASSIC_SKYLANDS, GuiCustomizePresets.PRESET_CLASSIC_SKYLANDS);
        registry.register(GuiCustomizePresets.BETA_SKYLANDS, GuiCustomizePresets.PRESET_BETA_SKYLANDS);
        registry.register(GuiCustomizePresets.BETA_END, GuiCustomizePresets.PRESET_BETA_END);
        registry.register(GuiCustomizePresets.BETA_PE, GuiCustomizePresets.PRESET_BETA_PE);
        registry.register(GuiCustomizePresets.BETA_REALISTIC, GuiCustomizePresets.PRESET_BETA_REALISTIC);
        registry.register(GuiCustomizePresets.BETA_PLUS, GuiCustomizePresets.PRESET_BETA_PLUS);
        registry.register(GuiCustomizePresets.BETA_RELEASE, GuiCustomizePresets.PRESET_BETA_RELEASE);
        if (ModernBetaConfig.debugOptions.registerDebugNoiseChunkSource) {
            registry.register(GuiCustomizePresets.DEBUG_NOISE, GuiCustomizePresets.PRESET_DEBUG_NOISE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerPredicates() {
        ModernBetaRegistry<GuiPredicate> registry = ModernBetaClientRegistries.GUI_PREDICATE;
        registry.register(GuiPredicate.SURFACE_BUILDER, GuiPredicates.SURFACE_BUILDER_TEST);
        registry.register(GuiPredicate.SPAWN_LOCATOR, GuiPredicates.SPAWN_LOCATOR_TEST);
        registry.register(GuiPredicate.SINGLE_BIOME, GuiPredicates.SINGLE_BIOME_TEST);
        registry.register(GuiPredicate.REPLACE_OCEAN, GuiPredicates.REPLACE_OCEAN_TEST);
        registry.register(GuiPredicate.REPLACE_BEACH, GuiPredicates.REPLACE_BEACH_TEST);
        registry.register(GuiPredicate.REPLACE_RIVER, GuiPredicates.REPLACE_RIVER_TEST);
        registry.register(GuiPredicate.SEA_LEVEL, GuiPredicates.SEA_LEVEL_TEST);
        registry.register(GuiPredicate.CAVE_WIDTH, GuiPredicates.CAVE_WIDTH_TEST);
        registry.register(GuiPredicate.CAVE_HEIGHT, GuiPredicates.CAVE_HEIGHT_TEST);
        registry.register(GuiPredicate.CAVE_COUNT, GuiPredicates.CAVE_COUNT_TEST);
        registry.register(GuiPredicate.CAVE_CHANCE, GuiPredicates.CAVE_CHANCE_TEST);
        registry.register(GuiPredicate.USE_STRONGHOLDS, GuiPredicates.USE_STRONGHOLDS_TEST);
        registry.register(GuiPredicate.USE_VILLAGES, GuiPredicates.USE_VILLAGES_TEST);
        registry.register(GuiPredicate.USE_VILLAGE_VARIANTS, GuiPredicates.USE_VILLAGE_VARIANTS_TEST);
        registry.register(GuiPredicate.USE_TEMPLES, GuiPredicates.USE_TEMPLES_TEST);
        registry.register(GuiPredicate.USE_MONUMENTS, GuiPredicates.USE_MONUMENTS_TEST);
        registry.register(GuiPredicate.USE_MANSIONS, GuiPredicates.USE_MANSIONS_TEST);
        registry.register(GuiPredicate.DUNGEON_CHANCE, GuiPredicates.DUNGEON_CHANCE_TEST);
        registry.register(GuiPredicate.WATER_LAKE_CHANCE, GuiPredicates.WATER_LAKE_CHANCE_TEST);
        registry.register(GuiPredicate.LAVA_LAKE_CHANCE, GuiPredicates.LAVA_LAKE_CHANCE_TEST);
        registry.register(GuiPredicate.USE_SANDSTONE, GuiPredicates.USE_SANDSTONE_TEST);
        registry.register(GuiPredicate.USE_OLD_NETHER, GuiPredicates.USE_OLD_NETHER_TEST);
        registry.register(GuiPredicate.USE_NETHER_CAVES, GuiPredicates.USE_NETHER_CAVES_TEST);
        registry.register(GuiPredicate.USE_FORTRESSES, GuiPredicates.USE_FORTRESSES_TEST);
        registry.register(GuiPredicate.USE_LAVA_POCKETS, GuiPredicates.USE_LAVA_POCKETS_TEST);
        registry.register(GuiPredicate.LEVEL_THEME, GuiPredicates.LEVEL_THEME_TEST);
        registry.register(GuiPredicate.LEVEL_TYPE, GuiPredicates.LEVEL_TYPE_TEST);
        registry.register(GuiPredicate.LEVEL_WIDTH, GuiPredicates.LEVEL_WIDTH_TEST);
        registry.register(GuiPredicate.LEVEL_HEIGHT, GuiPredicates.LEVEL_HEIGHT_TEST);
        registry.register(GuiPredicate.LEVEL_LENGTH, GuiPredicates.LEVEL_LENGTH_TEST);
        registry.register(GuiPredicate.LEVEL_HOUSE, GuiPredicates.LEVEL_HOUSE_TEST);
        registry.register(GuiPredicate.LEVEL_CAVE_WIDTH, GuiPredicates.LEVEL_CAVE_WIDTH_TEST);
        registry.register(GuiPredicate.USE_INDEV_CAVES, GuiPredicates.USE_INDEV_CAVES_TEST);
        registry.register(GuiPredicate.USE_INFDEV_WALLS, GuiPredicates.USE_INFDEV_WALLS_TEST);
        registry.register(GuiPredicate.USE_INFDEV_PYRAMIDS, GuiPredicates.USE_INFDEV_PYRAMIDS_TEST);
        registry.register(GuiPredicate.USE_TALL_GRASS, GuiPredicates.USE_TALL_GRASS_TEST);
        registry.register(GuiPredicate.USE_NEW_FLOWERS, GuiPredicates.USE_NEW_FLOWERS_TEST);
        registry.register(GuiPredicate.USE_DOUBLE_PLANTS, GuiPredicates.USE_DOUBLE_PLANTS_TEST);
        registry.register(GuiPredicate.USE_LILY_PADS, GuiPredicates.USE_LILY_PADS_TEST);
        registry.register(GuiPredicate.USE_MELONS, GuiPredicates.USE_MELONS_TEST);
        registry.register(GuiPredicate.USE_DESERT_WELLS, GuiPredicates.USE_DESERT_WELLS_TEST);
        registry.register(GuiPredicate.USE_FOSSILS, GuiPredicates.USE_FOSSILS_TEST);
        registry.register(GuiPredicate.USE_SAND_DISKS, GuiPredicates.USE_SAND_DISKS_TEST);
        registry.register(GuiPredicate.USE_GRAVEL_DISKS, GuiPredicates.USE_GRAVEL_DISKS_TEST);
        registry.register(GuiPredicate.USE_CLAY_DISKS, GuiPredicates.USE_CLAY_DISKS_TEST);
        registry.register(GuiPredicate.USE_BIRCH_TREES, GuiPredicates.USE_BIRCH_TREES_TEST);
        registry.register(GuiPredicate.USE_PINE_TREES, GuiPredicates.USE_PINE_TREES_TEST);
        registry.register(GuiPredicate.USE_SWAMP_TREES, GuiPredicates.USE_SWAMP_TREES_TEST);
        registry.register(GuiPredicate.USE_JUNGLE_TREES, GuiPredicates.USE_JUNGLE_TREES_TEST);
        registry.register(GuiPredicate.USE_ACACIA_TREES, GuiPredicates.USE_ACACIA_TREES_TEST);
        registry.register(GuiPredicate.USE_NEW_FANCY_OAK_TREES, GuiPredicates.USE_NEW_FANCY_OAK_TREES_TEST);
        registry.register(GuiPredicate.SPAWN_NEW_MONSTER_MOBS, GuiPredicates.SPAWN_NEW_MONSTER_MOBS_TEST);
        registry.register(GuiPredicate.SPAWN_NEW_CREATURE_MOBS, GuiPredicates.SPAWN_NEW_CREATURE_MOBS_TEST);
        registry.register(GuiPredicate.SPAWN_WATER_MOBS, GuiPredicates.SPAWN_WATER_MOBS_TEST);
        registry.register(GuiPredicate.SPAWN_AMBIENT_MOBS, GuiPredicates.SPAWN_AMBIENT_MOBS_TEST);
        registry.register(GuiPredicate.SPAWN_WOLVES, GuiPredicates.SPAWN_WOLVES_TEST);
        registry.register(GuiPredicate.USE_OLD_ORES, GuiPredicates.USE_OLD_ORES_TEST);
        registry.register(GuiPredicate.CLAY_SIZE, GuiPredicates.CLAY_SIZE_TEST);
        registry.register(GuiPredicate.CLAY_COUNT, GuiPredicates.CLAY_COUNT_TEST);
        registry.register(GuiPredicate.CLAY_MIN_HEIGHT, GuiPredicates.CLAY_MIN_HEIGHT_TEST);
        registry.register(GuiPredicate.CLAY_MAX_HEIGHT, GuiPredicates.CLAY_MAX_HEIGHT_TEST);
        registry.register(GuiPredicate.EMERALD_SIZE, GuiPredicates.EMERALD_SIZE_TEST);
        registry.register(GuiPredicate.EMERALD_COUNT, GuiPredicates.EMERALD_COUNT_TEST);
        registry.register(GuiPredicate.EMERALD_MIN_HEIGHT, GuiPredicates.EMERALD_MIN_HEIGHT_TEST);
        registry.register(GuiPredicate.EMERALD_MAX_HEIGHT, GuiPredicates.EMERALD_MAX_HEIGHT_TEST);
        registry.register(GuiPredicate.QUARTZ_SIZE, GuiPredicates.QUARTZ_SIZE_TEST);
        registry.register(GuiPredicate.QUARTZ_COUNT, GuiPredicates.QUARTZ_COUNT_TEST);
        registry.register(GuiPredicate.MAGMA_SIZE, GuiPredicates.MAGMA_SIZE_TEST);
        registry.register(GuiPredicate.MAGMA_COUNT, GuiPredicates.MAGMA_COUNT_TEST);
        registry.register(GuiPredicate.COORDINATE_SCALE, GuiPredicates.COORDINATE_SCALE_TEST);
        registry.register(GuiPredicate.HEIGHT_SCALE, GuiPredicates.HEIGHT_SCALE_TEST);
        registry.register(GuiPredicate.LOWER_LIMIT_SCALE, GuiPredicates.LOWER_LIMIT_SCALE_TEST);
        registry.register(GuiPredicate.UPPER_LIMIT_SCALE, GuiPredicates.UPPER_LIMIT_SCALE_TEST);
        registry.register(GuiPredicate.SCALE_NOISE_SCALE_X, GuiPredicates.SCALE_NOISE_SCALE_X_TEST);
        registry.register(GuiPredicate.SCALE_NOISE_SCALE_Z, GuiPredicates.SCALE_NOISE_SCALE_Z_TEST);
        registry.register(GuiPredicate.DEPTH_NOISE_SCALE_X, GuiPredicates.DEPTH_NOISE_SCALE_X_TEST);
        registry.register(GuiPredicate.DEPTH_NOISE_SCALE_Z, GuiPredicates.DEPTH_NOISE_SCALE_Z_TEST);
        registry.register(GuiPredicate.MAIN_NOISE_SCALE_X, GuiPredicates.MAIN_NOISE_SCALE_X_TEST);
        registry.register(GuiPredicate.MAIN_NOISE_SCALE_Y, GuiPredicates.MAIN_NOISE_SCALE_Y_TEST);
        registry.register(GuiPredicate.MAIN_NOISE_SCALE_Z, GuiPredicates.MAIN_NOISE_SCALE_Z_TEST);
        registry.register(GuiPredicate.BASE_SIZE, GuiPredicates.BASE_SIZE_TEST);
        registry.register(GuiPredicate.STRETCH_Y, GuiPredicates.STRETCH_Y_TEST);
        registry.register(GuiPredicate.HEIGHT, GuiPredicates.HEIGHT_TEST);
        registry.register(GuiPredicate.TEMP_NOISE_SCALE, GuiPredicates.TEMP_NOISE_SCALE_TEST);
        registry.register(GuiPredicate.RAIN_NOISE_SCALE, GuiPredicates.RAIN_NOISE_SCALE_TEST);
        registry.register(GuiPredicate.DETAIL_NOISE_SCALE, GuiPredicates.DETAIL_NOISE_SCALE_TEST);
        registry.register(GuiPredicate.SNOW_LINE_OFFSET, GuiPredicates.SNOW_LINE_OFFSET_TEST);
        registry.register(GuiPredicate.USE_CLIMATE_FEATURES, GuiPredicates.USE_CLIMATE_FEATURES_TEST);
        registry.register(GuiPredicate.BIOME_DEPTH_WEIGHT, GuiPredicates.BIOME_DEPTH_WEIGHT_TEST);
        registry.register(GuiPredicate.BIOME_DEPTH_OFFSET, GuiPredicates.BIOME_DEPTH_OFFSET_TEST);
        registry.register(GuiPredicate.BIOME_SCALE_WEIGHT, GuiPredicates.BIOME_SCALE_WEIGHT_TEST);
        registry.register(GuiPredicate.BIOME_SCALE_OFFSET, GuiPredicates.BIOME_SCALE_OFFSET_TEST);
        registry.register(GuiPredicate.BIOME_SIZE, GuiPredicates.BIOME_SIZE_TEST);
        registry.register(GuiPredicate.RIVER_SIZE, GuiPredicates.RIVER_SIZE_TEST);
        registry.register(GuiPredicate.USE_BIOME_DEPTH_SCALE, GuiPredicates.USE_BIOME_DEPTH_SCALE_TEST);
        registry.register(GuiPredicate.USE_AMPLIFIED, GuiPredicates.USE_AMPLIFIED_TEST);
        registry.register(GuiPredicate.LAYER_TYPE, GuiPredicates.LAYER_TYPE_TEST);
        registry.register(GuiPredicate.LAYER_SIZE, GuiPredicates.LAYER_SIZE_TEST);
        registry.register(GuiPredicate.SNOWY_BIOME_CHANCE, GuiPredicates.SNOWY_BIOME_CHANCE_TEST);
        registry.register(GuiPredicate.BASE_BIOME, GuiPredicates.BASE_BIOME_TEST);
        registry.register(GuiPredicate.OCEAN_BIOME, GuiPredicates.OCEAN_BIOME_TEST);
        registry.register(GuiPredicate.BEACH_BIOME, GuiPredicates.BEACH_BIOME_TEST);
        registry.register(GuiPredicate.END_ISLAND_OFFSET, GuiPredicates.END_ISLAND_OFFSET_TEST);
        registry.register(GuiPredicate.END_ISLAND_WEIGHT, GuiPredicates.END_ISLAND_WEIGHT_TEST);
        registry.register(GuiPredicate.END_OUTER_ISLAND_DISTANCE, GuiPredicates.END_OUTER_ISLAND_DISTANCE_TEST);
        registry.register(GuiPredicate.END_OUTER_ISLAND_OFFSET, GuiPredicates.END_OUTER_ISLAND_OFFSET_TEST);
        registry.register(GuiPredicate.USE_END_OUTER_ISLANDS, GuiPredicates.USE_END_OUTER_ISLANDS_TEST);
    }
}

