/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.util.datafix;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.datafix.DataFix;
import mod.bespectacled.modernbetaforge.api.datafix.ModDataFix;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaModRegistry;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.util.datafix.DataFixer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Level;

public class ModDataFixer {
    public static final ModDataFixer INSTANCE = new ModDataFixer();
    private final Map<String, ModFixs> modFixers = ModDataFixer.initModFixers(FMLCommonHandler.instance().getDataFixer());

    private ModDataFixer() {
    }

    public void register() {
        ModernBetaRegistries.MOD_DATA_FIX.getEntries().forEach(entry -> this.registerModDataFix((ResourceLocation)entry.getKey(), (ModDataFix)entry.getValue()));
    }

    private void registerModDataFix(ResourceLocation registryKey, ModDataFix fix) {
        String namespace = registryKey.func_110624_b();
        if (this.modFixers.containsKey(namespace)) {
            this.modFixers.get(namespace).registerFix(fix.getFixType(), fix.getFixableData());
        }
    }

    public static NBTTagCompound fixGeneratorSettings(NBTTagCompound compound, DataFix[] dataFixes, int fixVersion) {
        String worldName;
        String string = worldName = compound.func_74764_b("LevelName") ? compound.func_74779_i("LevelName") : "";
        if (compound.func_74764_b("generatorName") && compound.func_74779_i("generatorName").equals("modernbeta") && compound.func_74764_b("generatorOptions")) {
            JsonObject jsonObject = ModDataFixer.getAsJsonObject(compound.func_74779_i("generatorOptions"));
            DataFixer.runDataFixer(dataFixes, jsonObject, worldName, fixVersion);
            compound.func_74778_a("generatorOptions", jsonObject.toString().replace("\n", ""));
        }
        return compound;
    }

    public static JsonObject getAsJsonObject(String json) {
        JsonObject jsonObject;
        try {
            jsonObject = new JsonParser().parse(json).getAsJsonObject();
        }
        catch (Exception e) {
            ModernBeta.log(Level.ERROR, "Couldn't parse generator options for data fixer..");
            jsonObject = new JsonObject();
        }
        return jsonObject;
    }

    private static Map<String, ModFixs> initModFixers(CompoundDataFixer forgeDataFixer) {
        List<Map.Entry<String, Integer>> mods = ModernBetaModRegistry.INSTANCE.getEntries();
        LinkedHashMap<String, ModFixs> modFixers = new LinkedHashMap<String, ModFixs>();
        for (Map.Entry<String, Integer> mod : mods) {
            modFixers.put(mod.getKey(), forgeDataFixer.init(mod.getKey(), mod.getValue().intValue()));
        }
        return modFixers;
    }
}

