/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.biomes.infdev;

import java.util.Random;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeDecorator;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class BiomeDecoratorInfdev
extends ModernBetaBiomeDecorator {
    private final WorldGenAbstractTree treeFeature;

    public BiomeDecoratorInfdev(WorldGenAbstractTree treeFeature) {
        this.treeFeature = treeFeature;
    }

    public void func_180292_a(World world, Random random, Biome biome, BlockPos startPos) {
        ModernBetaGeneratorSettings settings = ModernBetaGeneratorSettings.buildOrGet(world);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        this.field_180294_c = startPos;
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        ChunkPos chunkPos = new ChunkPos(startX >> 4, startZ >> 4);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(world, random, chunkPos));
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(world, random, startPos));
        this.populateOres(world, random, biome, startPos, mutablePos);
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(world, random, startPos));
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            this.populateTrees(world, random, biome, startPos, mutablePos, () -> this.treeFeature);
        }
        if (settings.useTallGrass && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            BiomeDecoratorInfdev.populateTallGrassChance(world, random, biome, startPos, mutablePos, 2, settings.height);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(world, random, chunkPos));
    }

    @Override
    protected int getTreeCount(World world, Random random, Biome biome, BlockPos startPos) {
        PerlinOctaveNoise forestOctaveNoise = this.getForestOctaveNoise(world, startPos.func_177958_n() >> 4, startPos.func_177952_p() >> 4);
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        double scale = 0.25;
        return (int)forestOctaveNoise.sample((double)startX * scale, (double)startZ * scale) << 3;
    }
}

