/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.layer.custom;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.compat.BiomeCompat;
import mod.bespectacled.modernbetaforge.compat.Compat;
import mod.bespectacled.modernbetaforge.compat.ModCompat;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiome;
import net.minecraftforge.common.BiomeManager;
import org.apache.logging.log4j.Level;

public class GenLayerBiomeExtended
extends GenLayerBiome {
    private final List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];

    public GenLayerBiomeExtended(long seed, GenLayer parent, WorldType worldType, ChunkGeneratorSettings vanillaSettings, ModernBetaGeneratorSettings settings) {
        super(seed, parent, worldType, vanillaSettings);
        this.populateInitialBiomes(this.biomes, worldType);
        this.populateAdditionalBiomes(this.biomes, settings);
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? this.func_75902_a(totalWeight) : this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }

    private void populateInitialBiomes(List<BiomeManager.BiomeEntry>[] biomes, WorldType worldType) {
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            int idx = type.ordinal();
            if (biomes[idx] == null) {
                biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
        int desertNdx = BiomeManager.BiomeType.DESERT.ordinal();
        biomes[desertNdx].add(new BiomeManager.BiomeEntry(Biomes.field_76769_d, 30));
        biomes[desertNdx].add(new BiomeManager.BiomeEntry(Biomes.field_150588_X, 20));
        biomes[desertNdx].add(new BiomeManager.BiomeEntry(Biomes.field_76772_c, 10));
        if (worldType == WorldType.field_77136_e) {
            biomes[desertNdx].clear();
            biomes[desertNdx].add(new BiomeManager.BiomeEntry(Biomes.field_76769_d, 10));
            biomes[desertNdx].add(new BiomeManager.BiomeEntry(Biomes.field_76767_f, 10));
            biomes[desertNdx].add(new BiomeManager.BiomeEntry(Biomes.field_76770_e, 10));
            biomes[desertNdx].add(new BiomeManager.BiomeEntry(Biomes.field_76780_h, 10));
            biomes[desertNdx].add(new BiomeManager.BiomeEntry(Biomes.field_76772_c, 10));
            biomes[desertNdx].add(new BiomeManager.BiomeEntry(Biomes.field_76768_g, 10));
        }
    }

    private void populateAdditionalBiomes(List<BiomeManager.BiomeEntry>[] biomes, ModernBetaGeneratorSettings settings) {
        for (Map.Entry<String, Compat> entry : ModCompat.LOADED_MODS.entrySet()) {
            Compat compat = entry.getValue();
            if (!(compat instanceof BiomeCompat)) continue;
            ModernBeta.log(Level.DEBUG, String.format("Adding biomes to Release Biome Source from mod '%s'", entry.getKey()));
            BiomeCompat biomeCompat = (BiomeCompat)((Object)compat);
            if (!biomeCompat.shouldGetBiomeEntries(settings)) continue;
            for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
                int ndx = type.ordinal();
                biomes[ndx].addAll(biomeCompat.getBiomeEntries(settings)[ndx]);
            }
        }
    }
}

