/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.source;

import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverBeach;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverOcean;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverRiver;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.util.BiomeUtil;
import mod.bespectacled.modernbetaforge.util.chunk.BiomeChunk;
import mod.bespectacled.modernbetaforge.util.chunk.ChunkCache;
import mod.bespectacled.modernbetaforge.world.ModernBetaWorldType;
import mod.bespectacled.modernbetaforge.world.biome.layer.ModernBetaGenLayer;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.init.Biomes;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeDictionary;

public class ReleaseBiomeSource
extends BiomeSource
implements BiomeResolverOcean,
BiomeResolverBeach,
BiomeResolverRiver {
    private final ChunkCache<BiomeChunk> biomeCache = new ChunkCache<BiomeChunk>("biome", (chunkX, chunkZ) -> new BiomeChunk((int)chunkX, (int)chunkZ, this::getBiomes));
    private final ChunkCache<BiomeChunk> oceanCache = new ChunkCache<BiomeChunk>("ocean", (chunkX, chunkZ) -> new BiomeChunk((int)chunkX, (int)chunkZ, this::getOceanBiomes));
    private final GenLayer biomeLayer;
    private final GenLayer oceanLayer;

    public ReleaseBiomeSource(long seed, ModernBetaGeneratorSettings settings) {
        super(seed, settings);
        GenLayer[] biomeLayers = ModernBetaGenLayer.initBiomeLayers(seed, ModernBetaWorldType.INSTANCE, settings);
        biomeLayers = BiomeUtil.getModdedBiomeGenerators(WorldType.field_180271_f, seed, biomeLayers);
        GenLayer[] oceanLayers = ModernBetaGenLayer.initOceanLayers(seed, ModernBetaWorldType.INSTANCE, settings);
        oceanLayers = BiomeUtil.getModdedBiomeGenerators(WorldType.field_180271_f, seed, oceanLayers);
        this.biomeLayer = biomeLayers[1];
        this.oceanLayer = oceanLayers[1];
    }

    @Override
    public Biome getBiome(int x, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.biomeCache.get(chunkX, chunkZ).sample(x, z);
    }

    @Override
    public Biome getOceanBiome(int x, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        Biome baseBiome = this.biomeCache.get(chunkX, chunkZ).sample(x, z);
        Biome oceanBiome = this.oceanCache.get(chunkX, chunkZ).sample(x, z);
        return ReleaseBiomeSource.isSnowy(baseBiome) ? Biomes.field_76776_l : oceanBiome;
    }

    @Override
    public Biome getDeepOceanBiome(int x, int z) {
        return ReleaseBiomeSource.isSnowy(this.getBiome(x, z)) ? Biomes.field_76776_l : Biomes.field_150575_M;
    }

    @Override
    public Biome getBeachBiome(int x, int z) {
        return ReleaseBiomeSource.isSnowy(this.getBiome(x, z)) ? Biomes.field_150577_O : Biomes.field_76787_r;
    }

    @Override
    public Biome getRiverBiome(int x, int z) {
        return ReleaseBiomeSource.isSnowy(this.getBiome(x, z)) ? Biomes.field_76777_m : Biomes.field_76781_i;
    }

    private Biome[] getBiomes(int x, int z) {
        IntCache.func_76446_a();
        int[] ints = this.biomeLayer.func_75904_a(x, z, 16, 16);
        Biome[] biomes = new Biome[256];
        for (int i = 0; i < 256; ++i) {
            biomes[i] = Biome.func_180276_a((int)ints[i], (Biome)Biomes.field_180279_ad);
        }
        return biomes;
    }

    private Biome[] getOceanBiomes(int x, int z) {
        IntCache.func_76446_a();
        int[] ints = this.oceanLayer.func_75904_a(x, z, 16, 16);
        Biome[] biomes = new Biome[256];
        for (int i = 0; i < 256; ++i) {
            biomes[i] = Biome.func_180276_a((int)ints[i], (Biome)Biomes.field_180279_ad);
        }
        return biomes;
    }

    private static boolean isSnowy(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY);
    }
}

