/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.carver;

import java.util.Random;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.world.carver.MapGenBetaCave;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class MapGenBeta18Cave
extends MapGenBetaCave {
    public MapGenBeta18Cave(ChunkSource chunkSource, ModernBetaGeneratorSettings settings) {
        super(chunkSource, settings);
    }

    public MapGenBeta18Cave() {
        super(BlockStates.STONE, BlockStates.WATER, BlockStates.AIR, 1.0f, 128, 40, 15);
    }

    protected MapGenBeta18Cave(IBlockState defaultBlock, IBlockState defaultFluid, IBlockState defaultFill, float caveWidth, int caveHeight, int caveCount, int caveChance) {
        super(defaultBlock, defaultFluid, defaultFill, caveWidth, caveHeight, caveCount, caveChance);
    }

    @Override
    public void func_186125_a(World world, int originChunkX, int originChunkZ, ChunkPrimer chunkPrimer) {
        this.field_75039_c = world;
        this.field_75038_b.setSeed(world.func_72905_C());
        long randomLong0 = this.field_75038_b.nextLong();
        long randomLong1 = this.field_75038_b.nextLong();
        for (int chunkX = originChunkX - this.field_75040_a; chunkX <= originChunkX + this.field_75040_a; ++chunkX) {
            for (int chunkZ = originChunkZ - this.field_75040_a; chunkZ <= originChunkZ + this.field_75040_a; ++chunkZ) {
                long randomLong2 = (long)chunkX * randomLong0;
                long randomLong3 = (long)chunkZ * randomLong1;
                long chunkSeed = randomLong2 ^ randomLong3 ^ world.func_72905_C();
                this.field_75038_b.setSeed(chunkSeed);
                this.tunnelRandom.setSeed(chunkSeed);
                this.func_180701_a(world, chunkX, chunkZ, originChunkX, originChunkZ, chunkPrimer);
            }
        }
    }

    @Override
    protected void func_180701_a(World world, int chunkX, int chunkZ, int originChunkX, int originChunkZ, ChunkPrimer chunkPrimer) {
        int caveCount = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.caveCount) + 1) + 1);
        if (this.field_75038_b.nextInt(this.caveChance) != 0) {
            caveCount = 0;
        }
        for (int i = 0; i < caveCount; ++i) {
            double x = chunkX * 16 + this.field_75038_b.nextInt(16);
            double y = this.getCaveY(this.field_75038_b);
            double z = chunkZ * 16 + this.field_75038_b.nextInt(16);
            int tunnelCount = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.carveCave(this.field_75038_b.nextLong(), chunkPrimer, originChunkX, originChunkZ, x, y, z);
                tunnelCount += this.field_75038_b.nextInt(4);
            }
            for (int j = 0; j < tunnelCount; ++j) {
                float tunnelC = this.field_75038_b.nextFloat() * 3.141593f * 2.0f;
                float f1 = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float tunnelSysWidth = this.getTunnelSystemWidth(this.field_75038_b, this.tunnelRandom);
                this.carveTunnels(this.field_75038_b.nextLong(), chunkPrimer, originChunkX, originChunkZ, x, y, z, tunnelSysWidth, tunnelC, f1, 0, 0, this.getTunnelWHRatio());
            }
        }
    }

    @Override
    protected float getTunnelSystemWidth(Random random, Random tunnelRandom) {
        float tunnelSysWidth = this.getBaseTunnelSystemWidth(random);
        if (random.nextInt(10) == 0) {
            tunnelSysWidth *= random.nextFloat() * random.nextFloat() * 3.0f + 1.0f;
        }
        return tunnelSysWidth * this.getTunnelWidthMultiplier(tunnelRandom);
    }

    private void carveCave(long seed, ChunkPrimer chunkPrimer, int chunkX, int chunkZ, double x, double y, double z) {
        this.carveTunnels(seed, chunkPrimer, chunkX, chunkZ, x, y, z, 1.0f + this.field_75038_b.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    private void carveTunnels(long seed, ChunkPrimer chunkPrimer, int chunkX, int chunkZ, double x, double y, double z, float tunnelSysWidth, float tunnelC, float f1, int branch, int branchCount, double tunnelWHRatio) {
        boolean vary;
        float f2 = 0.0f;
        float f3 = 0.0f;
        Random newRandom = new Random(seed);
        if (branchCount <= 0) {
            int someNumMaxStarts = 112;
            branchCount = someNumMaxStarts - newRandom.nextInt(someNumMaxStarts / 4);
        }
        boolean noStarts = false;
        if (branch == -1) {
            branch = branchCount / 2;
            noStarts = true;
        }
        int randBranch = newRandom.nextInt(branchCount / 2) + branchCount / 4;
        boolean bl = vary = newRandom.nextInt(6) == 0;
        while (branch < branchCount) {
            double yaw = 1.5 + (double)(MathHelper.func_76126_a((float)((float)branch * 3.141593f / (float)branchCount)) * tunnelSysWidth * 1.0f);
            double pitch = yaw * tunnelWHRatio;
            float f5 = MathHelper.func_76134_b((float)f1);
            float f6 = MathHelper.func_76126_a((float)f1);
            x += (double)(MathHelper.func_76134_b((float)tunnelC) * f5);
            y += (double)f6;
            z += (double)(MathHelper.func_76126_a((float)tunnelC) * f5);
            f1 *= vary ? 0.92f : 0.7f;
            f1 += f3 * 0.1f;
            tunnelC += f2 * 0.1f;
            f3 *= 0.9f;
            f2 *= 0.75f;
            f3 += (newRandom.nextFloat() - newRandom.nextFloat()) * newRandom.nextFloat() * 2.0f;
            f2 += (newRandom.nextFloat() - newRandom.nextFloat()) * newRandom.nextFloat() * 4.0f;
            if (!noStarts && branch == randBranch && tunnelSysWidth > 1.0f) {
                this.carveTunnels(newRandom.nextLong(), chunkPrimer, chunkX, chunkZ, x, y, z, newRandom.nextFloat() * 0.5f + 0.5f, tunnelC - 1.570796f, f1 / 3.0f, branch, branchCount, 1.0);
                this.carveTunnels(newRandom.nextLong(), chunkPrimer, chunkX, chunkZ, x, y, z, newRandom.nextFloat() * 0.5f + 0.5f, tunnelC + 1.570796f, f1 / 3.0f, branch, branchCount, 1.0);
                return;
            }
            if (noStarts || newRandom.nextInt(4) != 0) {
                if (!this.canCarveBranch(chunkX, chunkZ, x, z, branch, branchCount, tunnelSysWidth)) {
                    return;
                }
                this.carveRegion(chunkPrimer, 0L, 64, chunkX, chunkZ, x, y, z, yaw, pitch);
                if (noStarts) break;
            }
            ++branch;
        }
    }
}

