/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.carver;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.compat.CarverCompat;
import mod.bespectacled.modernbetaforge.compat.Compat;
import mod.bespectacled.modernbetaforge.compat.ModCompat;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import org.apache.logging.log4j.Level;

public class MapGenBetaCave
extends MapGenBase {
    private static final int STRUCTURE_PADDING_XZ = 4;
    private static final int STRUCTURE_PADDING_Y = 8;
    protected static final int LAVA_LEVEL = 10;
    protected final Block defaultBlock;
    protected final Set<Block> defaultFluids;
    protected final Block defaultFill;
    protected final Set<Block> carvables;
    protected final Random tunnelRandom;
    protected final Random featureRandom;
    protected final float caveWidth;
    protected final int caveHeight;
    protected final int caveCount;
    protected final int caveChance;
    private List<StructureComponent> structureComponents;

    public MapGenBetaCave(ChunkSource chunkSource, ModernBetaGeneratorSettings settings) {
        this(chunkSource.getDefaultBlock(), chunkSource.getDefaultFluid(), BlockStates.AIR, settings.caveWidth, settings.caveHeight, settings.caveCount, settings.caveChance);
    }

    public MapGenBetaCave() {
        this(BlockStates.STONE, BlockStates.WATER, BlockStates.AIR, 1.0f, 128, 40, 15);
    }

    protected MapGenBetaCave(IBlockState defaultBlock, IBlockState defaultFluid, IBlockState defaultFill, float caveWidth, int caveHeight, int caveCount, int caveChance) {
        this.defaultBlock = defaultBlock.func_177230_c();
        this.defaultFluids = MapGenBetaCave.getDefaultFluids(defaultFluid);
        this.defaultFill = defaultFill.func_177230_c();
        this.carvables = this.initializeCarvables(defaultBlock.func_177230_c()).build();
        this.caveWidth = caveWidth;
        this.caveHeight = caveHeight;
        this.caveCount = caveCount;
        this.caveChance = caveChance;
        this.tunnelRandom = new Random();
        this.featureRandom = new Random();
    }

    public void generate(World world, int originChunkX, int originChunkZ, ChunkPrimer chunkPrimer, Biome[] biomes, List<StructureComponent> structureComponents) {
        this.structureComponents = structureComponents;
        this.func_186125_a(world, originChunkX, originChunkZ, chunkPrimer);
    }

    public void func_186125_a(World world, int originChunkX, int originChunkZ, ChunkPrimer chunkPrimer) {
        this.field_75039_c = world;
        this.field_75038_b.setSeed(world.func_72905_C());
        long randomLong0 = this.field_75038_b.nextLong() / 2L * 2L + 1L;
        long randomLong1 = this.field_75038_b.nextLong() / 2L * 2L + 1L;
        for (int chunkX = originChunkX - this.field_75040_a; chunkX <= originChunkX + this.field_75040_a; ++chunkX) {
            for (int chunkZ = originChunkZ - this.field_75040_a; chunkZ <= originChunkZ + this.field_75040_a; ++chunkZ) {
                long chunkSeed = (long)chunkX * randomLong0 + (long)chunkZ * randomLong1 ^ world.func_72905_C();
                this.setRandoms(chunkSeed);
                this.func_180701_a(world, chunkX, chunkZ, originChunkX, originChunkZ, chunkPrimer);
            }
        }
    }

    protected void func_180701_a(World world, int chunkX, int chunkZ, int originChunkX, int originChunkZ, ChunkPrimer chunkPrimer) {
        int caveCount = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.caveCount) + 1) + 1);
        if (this.field_75038_b.nextInt(this.caveChance) != 0) {
            caveCount = 0;
        }
        for (int i = 0; i < caveCount; ++i) {
            double x = chunkX * 16 + this.field_75038_b.nextInt(16);
            double y = this.getCaveY(this.field_75038_b);
            double z = chunkZ * 16 + this.field_75038_b.nextInt(16);
            int tunnelCount = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.carveCave(chunkPrimer, originChunkX, originChunkZ, x, y, z);
                tunnelCount += this.field_75038_b.nextInt(4);
            }
            for (int j = 0; j < tunnelCount; ++j) {
                float tunnelC = this.field_75038_b.nextFloat() * 3.141593f * 2.0f;
                float f1 = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float tunnelSysWidth = this.getTunnelSystemWidth(this.field_75038_b, this.tunnelRandom);
                this.carveTunnels(chunkPrimer, originChunkX, originChunkZ, x, y, z, tunnelSysWidth, tunnelC, f1, 0, 0, this.getTunnelWHRatio());
            }
        }
    }

    protected boolean canCarveBranch(int mainChunkX, int mainChunkZ, double x, double z, int branch, int branchCount, float baseWidth) {
        double ctrX = mainChunkX * 16 + 8;
        double d1 = x - ctrX;
        double ctrZ = mainChunkZ * 16 + 8;
        double d2 = z - ctrZ;
        double d3 = branchCount - branch;
        double d4 = baseWidth + 2.0f + 16.0f;
        return !(d1 * d1 + d2 * d2 - d3 * d3 > d4 * d4);
    }

    protected boolean carveRegion(ChunkPrimer chunkPrimer, long seed, int seaLevel, int chunkX, int chunkZ, double x, double y, double z, double yaw, double pitch) {
        double ctrX = chunkX * 16 + 8;
        double ctrZ = chunkZ * 16 + 8;
        if (x < ctrX - 16.0 - yaw * 2.0 || z < ctrZ - 16.0 - yaw * 2.0 || x > ctrX + 16.0 + yaw * 2.0 || z > ctrZ + 16.0 + yaw * 2.0) {
            return false;
        }
        int minX = MathHelper.func_76128_c((double)(x - yaw)) - chunkX * 16 - 1;
        int maxX = MathHelper.func_76128_c((double)(x + yaw)) - chunkX * 16 + 1;
        int minY = MathHelper.func_76128_c((double)(y - pitch)) - 1;
        int maxY = MathHelper.func_76128_c((double)(y + pitch)) + 1;
        int minZ = MathHelper.func_76128_c((double)(z - yaw)) - chunkZ * 16 - 1;
        int maxZ = MathHelper.func_76128_c((double)(z + yaw)) - chunkZ * 16 + 1;
        if (minX < 0) {
            minX = 0;
        }
        if (maxX > 16) {
            maxX = 16;
        }
        if (minY < 1) {
            minY = 1;
        }
        if (maxY > this.caveHeight - 8) {
            maxY = this.caveHeight - 8;
        }
        if (minZ < 0) {
            minZ = 0;
        }
        if (maxZ > 16) {
            maxZ = 16;
        }
        if (this.isRegionUncarvable(chunkPrimer, chunkX, chunkZ, minX, maxX, minY, maxY, minZ, maxZ)) {
            return false;
        }
        for (int localX = minX; localX < maxX; ++localX) {
            double scaledLocalX = ((double)(localX + chunkX * 16) + 0.5 - x) / yaw;
            for (int localZ = minZ; localZ < maxZ; ++localZ) {
                double scaledLocalZ = ((double)(localZ + chunkZ * 16) + 0.5 - z) / yaw;
                boolean isGrassBlock = false;
                for (int localY = maxY; localY >= minY; --localY) {
                    double scaledLocalY = ((double)localY - 1.0 + 0.5 - y) / pitch;
                    if (!this.isPositionExcluded(scaledLocalX, scaledLocalY, scaledLocalZ)) continue;
                    Block block = chunkPrimer.func_177856_a(localX, localY, localZ).func_177230_c();
                    if (block == Blocks.field_150349_c) {
                        isGrassBlock = true;
                    }
                    this.carveAtPoint(chunkPrimer, localX, localY, localZ, block, isGrassBlock);
                }
            }
        }
        return true;
    }

    protected void carveAtPoint(ChunkPrimer chunkPrimer, int localX, int localY, int localZ, Block block, boolean isGrassBlock) {
        if (this.carvables.contains(block)) {
            if (localY - 1 < 10) {
                chunkPrimer.func_177855_a(localX, localY, localZ, Blocks.field_150353_l.func_176223_P());
            } else {
                chunkPrimer.func_177855_a(localX, localY, localZ, this.defaultFill.func_176223_P());
                if (isGrassBlock && chunkPrimer.func_177856_a(localX, localY - 1, localZ).func_177230_c() == Blocks.field_150346_d) {
                    chunkPrimer.func_177855_a(localX, localY - 1, localZ, Blocks.field_150349_c.func_176223_P());
                }
            }
        }
    }

    protected int getCaveY(Random random) {
        return random.nextInt(random.nextInt(this.caveHeight - 8) + 8);
    }

    protected float getTunnelSystemWidth(Random random, Random tunnelRandom) {
        return this.getBaseTunnelSystemWidth(random) * this.getTunnelWidthMultiplier(tunnelRandom);
    }

    protected double getTunnelWHRatio() {
        return 1.0;
    }

    protected final float getTunnelWidthMultiplier(Random random) {
        return MathUtil.getRandomFloatInRange(1.0f, this.caveWidth, random);
    }

    protected final float getBaseTunnelSystemWidth(Random random) {
        return random.nextFloat() * 2.0f + random.nextFloat();
    }

    protected final void setRandoms(long chunkSeed) {
        this.field_75038_b.setSeed(chunkSeed);
        this.tunnelRandom.setSeed(chunkSeed);
        this.featureRandom.setSeed(chunkSeed);
    }

    protected ImmutableSet.Builder<Block> initializeCarvables(Block defaultBlock) {
        ImmutableSet.Builder carvables = new ImmutableSet.Builder();
        carvables.add((Object)defaultBlock).add((Object)Blocks.field_150348_b).add((Object)Blocks.field_150349_c).add((Object)Blocks.field_150346_d).add((Object)Blocks.field_150365_q).add((Object)Blocks.field_150366_p);
        for (Map.Entry<String, Compat> entry : ModCompat.LOADED_MODS.entrySet()) {
            Compat compat = entry.getValue();
            if (!(compat instanceof CarverCompat)) continue;
            ModernBeta.log(Level.DEBUG, String.format("Adding carvables from mod '%s'", entry.getKey()));
            carvables.addAll(((CarverCompat)((Object)compat)).getCarvables());
        }
        return carvables;
    }

    private void carveCave(ChunkPrimer chunkPrimer, int chunkX, int chunkZ, double x, double y, double z) {
        this.carveTunnels(chunkPrimer, chunkX, chunkZ, x, y, z, 1.0f + this.field_75038_b.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    private void carveTunnels(ChunkPrimer chunkPrimer, int chunkX, int chunkZ, double x, double y, double z, float tunnelSysWidth, float tunnelC, float f1, int branch, int branchCount, double tunnelWHRatio) {
        boolean vary;
        float f2 = 0.0f;
        float f3 = 0.0f;
        Random newRandom = new Random(this.field_75038_b.nextLong());
        if (branchCount <= 0) {
            int someNumMaxStarts = 112;
            branchCount = someNumMaxStarts - newRandom.nextInt(someNumMaxStarts / 4);
        }
        boolean noStarts = false;
        if (branch == -1) {
            branch = branchCount / 2;
            noStarts = true;
        }
        int randBranch = newRandom.nextInt(branchCount / 2) + branchCount / 4;
        boolean bl = vary = newRandom.nextInt(6) == 0;
        while (branch < branchCount) {
            double yaw = 1.5 + (double)(MathHelper.func_76126_a((float)((float)branch * 3.141593f / (float)branchCount)) * tunnelSysWidth * 1.0f);
            double pitch = yaw * tunnelWHRatio;
            float f5 = MathHelper.func_76134_b((float)f1);
            float f6 = MathHelper.func_76126_a((float)f1);
            x += (double)(MathHelper.func_76134_b((float)tunnelC) * f5);
            y += (double)f6;
            z += (double)(MathHelper.func_76126_a((float)tunnelC) * f5);
            f1 *= vary ? 0.92f : 0.7f;
            f1 += f3 * 0.1f;
            tunnelC += f2 * 0.1f;
            f3 *= 0.9f;
            f2 *= 0.75f;
            f3 += (newRandom.nextFloat() - newRandom.nextFloat()) * newRandom.nextFloat() * 2.0f;
            f2 += (newRandom.nextFloat() - newRandom.nextFloat()) * newRandom.nextFloat() * 4.0f;
            if (!noStarts && branch == randBranch && tunnelSysWidth > 1.0f) {
                this.carveTunnels(chunkPrimer, chunkX, chunkZ, x, y, z, newRandom.nextFloat() * 0.5f + 0.5f, tunnelC - 1.570796f, f1 / 3.0f, branch, branchCount, 1.0);
                this.carveTunnels(chunkPrimer, chunkX, chunkZ, x, y, z, newRandom.nextFloat() * 0.5f + 0.5f, tunnelC + 1.570796f, f1 / 3.0f, branch, branchCount, 1.0);
                return;
            }
            if (noStarts || newRandom.nextInt(4) != 0) {
                if (!this.canCarveBranch(chunkX, chunkZ, x, z, branch, branchCount, tunnelSysWidth)) {
                    return;
                }
                this.carveRegion(chunkPrimer, 0L, 64, chunkX, chunkZ, x, y, z, yaw, pitch);
                if (noStarts) break;
            }
            ++branch;
        }
    }

    private boolean isRegionUncarvable(ChunkPrimer chunkPrimer, int mainChunkX, int mainChunkZ, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        int startX = mainChunkX << 4;
        int startZ = mainChunkZ << 4;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        IChunkGenerator chunkGenerator = ((WorldServer)this.field_75039_c).func_72863_F().field_186029_c;
        boolean isModernBetaChunkGenerator = chunkGenerator instanceof ModernBetaChunkGenerator;
        for (int localX = minX; localX < maxX; ++localX) {
            int x = startX + localX;
            for (int localZ = minZ; localZ < maxZ; ++localZ) {
                int z = startZ + localZ;
                int height = 255;
                if (isModernBetaChunkGenerator) {
                    height = ((ModernBetaChunkGenerator)chunkGenerator).getChunkSource().getHeight(x, z, HeightmapChunk.Type.STRUCTURE);
                }
                for (int y = maxY + 1; y >= minY - 1; --y) {
                    mutablePos.func_181079_c(x, y, z);
                    if (y < 0 || y >= this.caveHeight) continue;
                    if (this.defaultFluids.contains(chunkPrimer.func_177856_a(localX, y, localZ).func_177230_c())) {
                        return true;
                    }
                    if (this.structureComponents != null && !this.structureComponents.isEmpty() && isModernBetaChunkGenerator) {
                        for (int i = 0; i < this.structureComponents.size(); ++i) {
                            StructureBoundingBox box = this.structureComponents.get(i).func_74874_b();
                            int boxMinX = box.field_78897_a - 4;
                            int boxMaxX = box.field_78893_d + 4;
                            int boxMinZ = box.field_78896_c - 4;
                            int boxMaxZ = box.field_78892_f + 4;
                            int minHeight = height - 8;
                            if (x < boxMinX || x > boxMaxX || z < boxMinZ || z > boxMaxZ || y < minHeight) continue;
                            return true;
                        }
                    }
                    if (y == minY - 1 || !this.isOnBoundary(minX, maxX, minZ, maxZ, localX, localZ)) continue;
                    y = minY;
                }
            }
        }
        return false;
    }

    private boolean isPositionExcluded(double scaledX, double scaledY, double scaledZ) {
        return scaledY > -0.7 && scaledX * scaledX + scaledY * scaledY + scaledZ * scaledZ < 1.0;
    }

    private boolean isOnBoundary(int minX, int maxX, int minZ, int maxZ, int localX, int localZ) {
        return localX != minX && localX != maxX - 1 && localZ != minZ && localZ != maxZ - 1;
    }

    public static Set<Block> getDefaultFluids(IBlockState defaultFluid) {
        HashSet<Block> defaultFluids = new HashSet<Block>();
        defaultFluids.add(defaultFluid.func_177230_c());
        try {
            defaultFluids.add((Block)BlockLiquid.func_176361_a((Material)defaultFluid.func_185904_a()));
        }
        catch (Exception e) {
            ModernBeta.log(Level.DEBUG, "Cave carver fluid is not flowable!");
        }
        return defaultFluids;
    }
}

