/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.carver;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.world.carver.MapGenBeta18Cave;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.BiomeDictionary;

public class MapGenBetaCaveUnderwater
extends MapGenBeta18Cave {
    public MapGenBetaCaveUnderwater(ChunkSource chunkSource, ModernBetaGeneratorSettings settings) {
        super(chunkSource.getDefaultBlock(), BlockStates.AIR, chunkSource.getDefaultFluid(), 1.0f, chunkSource.getSeaLevel(), 20, 15);
    }

    @Override
    public void generate(World world, int originChunkX, int originChunkZ, ChunkPrimer chunkPrimer, Biome[] biomes, List<StructureComponent> structureComponents) {
        int x = originChunkX << 4;
        int z = originChunkZ << 4;
        if (BiomeDictionary.hasType((Biome)biomes[(x & 0xF) + (z & 0xF) * 16], (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            super.generate(world, originChunkX, originChunkZ, chunkPrimer, biomes, structureComponents);
        }
    }

    @Override
    public void func_186125_a(World world, int originChunkX, int originChunkZ, ChunkPrimer chunkPrimer) {
        this.field_75039_c = world;
        this.field_75038_b.setSeed(world.func_72905_C());
        long randomLong0 = this.field_75038_b.nextLong() / 2L * 3L + 2L;
        long randomLong1 = this.field_75038_b.nextLong() / 2L * 3L + 2L;
        for (int chunkX = originChunkX - this.field_75040_a; chunkX <= originChunkX + this.field_75040_a; ++chunkX) {
            for (int chunkZ = originChunkZ - this.field_75040_a; chunkZ <= originChunkZ + this.field_75040_a; ++chunkZ) {
                long randomLong2 = (long)chunkX * randomLong0;
                long randomLong3 = (long)chunkZ * randomLong1;
                long chunkSeed = randomLong2 ^ randomLong3 ^ world.func_72905_C();
                this.setRandoms(chunkSeed);
                this.func_180701_a(world, chunkX, chunkZ, originChunkX, originChunkZ, chunkPrimer);
            }
        }
    }

    @Override
    protected void carveAtPoint(ChunkPrimer chunkPrimer, int localX, int localY, int localZ, Block block, boolean isGrassBlock) {
        if (this.carvables.contains(block) && localY - 1 == 9) {
            chunkPrimer.func_177855_a(localX, localY, localZ, BlockStates.OBSIDIAN);
        } else {
            super.carveAtPoint(chunkPrimer, localX, localY, localZ, block, isGrassBlock);
        }
    }

    @Override
    protected ImmutableSet.Builder<Block> initializeCarvables(Block defaultBlock) {
        return super.initializeCarvables(defaultBlock).add((Object)Blocks.field_150351_n).add((Object)Blocks.field_150354_m);
    }
}

