/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.chunk;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeDecorator;
import mod.bespectacled.modernbetaforge.world.carver.MapGenBetaCaveHell;
import mod.bespectacled.modernbetaforge.world.feature.OreType;
import mod.bespectacled.modernbetaforge.world.feature.WorldGenHellSpring;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenFire;
import net.minecraft.world.gen.feature.WorldGenGlowStone1;
import net.minecraft.world.gen.feature.WorldGenGlowStone2;
import net.minecraft.world.gen.feature.WorldGenHellLava;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ModernBetaChunkGeneratorHell
extends ChunkGeneratorHell {
    private static final Predicate<IBlockState> NETHERRACK_PREDICATE = BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL);
    private final ModernBetaGeneratorSettings settings;
    private final World world;
    private final boolean mapFeaturesEnabled;
    private final WorldGenFire fireFeature;
    private final WorldGenGlowStone1 glowstoneFeature1;
    private final WorldGenGlowStone2 glowstoneFeature2;
    private final WorldGenerator quartzOreFeature;
    private final WorldGenerator magmaOreFeature;
    private final WorldGenHellLava lavaPocketFeature;
    private final WorldGenHellSpring lavaSpringFeature;
    private final WorldGenBush brownMushroomFeature;
    private final WorldGenBush redMushroomFeature;
    private final MapGenNetherBridge netherFortressGenerator;
    private final MapGenBase netherCaveCarver;

    public ModernBetaChunkGeneratorHell(World world, boolean mapFeaturesEnabled, long seed, String generatorOptions) {
        super(world, mapFeaturesEnabled, seed);
        this.settings = ModernBetaGeneratorSettings.build(generatorOptions);
        this.world = world;
        this.mapFeaturesEnabled = mapFeaturesEnabled;
        OreType oreType = OreType.fromId(this.settings.oreType);
        this.fireFeature = new WorldGenFire();
        this.glowstoneFeature1 = new WorldGenGlowStone1();
        this.glowstoneFeature2 = new WorldGenGlowStone2();
        this.quartzOreFeature = ModernBetaBiomeDecorator.createMinable(BlockStates.QUARTZ_ORE, this.settings.quartzSize, NETHERRACK_PREDICATE, oreType);
        this.magmaOreFeature = ModernBetaBiomeDecorator.createMinable(BlockStates.MAGMA, this.settings.magmaSize, NETHERRACK_PREDICATE, oreType);
        this.lavaPocketFeature = new WorldGenHellLava((Block)Blocks.field_150356_k, true);
        this.lavaSpringFeature = new WorldGenHellSpring((Block)Blocks.field_150356_k);
        this.brownMushroomFeature = new WorldGenBush(Blocks.field_150338_P);
        this.redMushroomFeature = new WorldGenBush(Blocks.field_150337_Q);
        this.netherFortressGenerator = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)new MapGenNetherBridge(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        this.netherCaveCarver = TerrainGen.getModdedMapGen((MapGenBase)new MapGenBetaCaveHell(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.field_185954_p.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.func_185936_a(chunkX, chunkZ, chunkprimer);
        this.func_185937_b(chunkX, chunkZ, chunkprimer);
        if (this.settings.useNetherCaves) {
            this.netherCaveCarver.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
        }
        if (this.mapFeaturesEnabled && this.settings.useFortresses) {
            this.netherFortressGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, chunkX, chunkZ);
        Biome[] biomes = this.world.func_72959_q().func_76933_b(null, chunkX * 16, chunkZ * 16, 16, 16);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)biomes[i]);
        }
        chunk.func_76613_n();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int z;
        int y;
        int x;
        int i;
        BlockFalling.field_149832_M = true;
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        BlockPos startPos = new BlockPos(startX, 0, startZ);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(startPos);
        Biome biome = this.world.func_180494_b((BlockPos)mutablePos.func_181079_c(startX + 16, 0, startZ + 16));
        Random random = this.field_185954_p;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)random, (int)chunkX, (int)chunkZ, (boolean)false);
        if (this.mapFeaturesEnabled && this.settings.useFortresses) {
            this.netherFortressGenerator.func_175794_a(this.world, random, chunkpos);
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA)) {
            for (i = 0; i < 8; ++i) {
                x = startX + random.nextInt(16) + 8;
                y = random.nextInt(120) + 4;
                z = startZ + random.nextInt(16) + 8;
                this.lavaSpringFeature.func_180709_b(this.world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.FIRE)) {
            for (i = 0; i < random.nextInt(random.nextInt(10) + 1) + 1; ++i) {
                x = startX + random.nextInt(16) + 8;
                y = random.nextInt(120) + 4;
                z = startZ + random.nextInt(16) + 8;
                this.fireFeature.func_180709_b(this.world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE)) {
            for (i = 0; i < random.nextInt(random.nextInt(10) + 1); ++i) {
                x = startX + random.nextInt(16) + 8;
                y = random.nextInt(120) + 4;
                z = startZ + random.nextInt(16) + 8;
                this.glowstoneFeature1.func_180709_b(this.world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
            }
            for (i = 0; i < 10; ++i) {
                x = startX + random.nextInt(16) + 8;
                y = random.nextInt(128);
                z = startZ + random.nextInt(16) + 8;
                this.glowstoneFeature2.func_180709_b(this.world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)random, (int)chunkX, (int)chunkZ, (boolean)false);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, random, chunkpos));
        if (TerrainGen.decorate((World)this.world, (Random)random, (ChunkPos)chunkpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            int z2;
            int y2;
            int x2;
            if (random.nextBoolean()) {
                x2 = startX + random.nextInt(16) + 8;
                y2 = random.nextInt(128);
                z2 = startZ + random.nextInt(16) + 8;
                this.brownMushroomFeature.func_180709_b(this.world, random, (BlockPos)mutablePos.func_181079_c(x2, y2, z2));
            }
            if (random.nextBoolean()) {
                x2 = startX + random.nextInt(16) + 8;
                y2 = random.nextInt(128);
                z2 = startZ + random.nextInt(16) + 8;
                this.redMushroomFeature.func_180709_b(this.world, random, (BlockPos)mutablePos.func_181079_c(x2, y2, z2));
            }
        }
        if (TerrainGen.generateOre((World)this.world, (Random)random, (WorldGenerator)this.quartzOreFeature, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.QUARTZ)) {
            for (i = 0; i < this.settings.quartzCount; ++i) {
                x = startX + random.nextInt(16);
                y = random.nextInt(108) + 10;
                z = startZ + random.nextInt(16);
                this.quartzOreFeature.func_180709_b(this.world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_MAGMA)) {
            int netherSeaLevel = this.world.func_181545_F() / 2 + 1;
            for (int i2 = 0; i2 < this.settings.magmaCount; ++i2) {
                int x3 = startX + random.nextInt(16);
                int y3 = netherSeaLevel - 5 + random.nextInt(10);
                int z3 = startZ + random.nextInt(16);
                this.magmaOreFeature.func_180709_b(this.world, random, (BlockPos)mutablePos.func_181079_c(x3, y3, z3));
            }
        }
        if (this.settings.useLavaPockets && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA2)) {
            for (i = 0; i < 16; ++i) {
                x = startX + random.nextInt(16) + 8;
                y = random.nextInt(108) + 10;
                z = startZ + random.nextInt(16) + 8;
                this.lavaPocketFeature.func_180709_b(this.world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
            }
        }
        biome.func_180624_a(this.world, random, new BlockPos(startX, 0, startZ));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, random, startPos));
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        ArrayList<Biome.SpawnListEntry> spawnEntries = new ArrayList<Biome.SpawnListEntry>(this.getPossibleCreaturesInclStructures(creatureType, pos));
        if (!this.settings.spawnNewMonsterMobs) {
            Iterator iterator = spawnEntries.iterator();
            while (iterator.hasNext()) {
                Biome.SpawnListEntry spawnEntry = (Biome.SpawnListEntry)iterator.next();
                if (spawnEntry.field_76300_b != EntityMagmaCube.class && spawnEntry.field_76300_b != EntityEnderman.class && spawnEntry.field_76300_b != EntityWitherSkeleton.class) continue;
                iterator.remove();
            }
        }
        return spawnEntries;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if (!this.mapFeaturesEnabled) {
            return false;
        }
        if (this.settings.useFortresses && "Fortress".equals(structureName) && this.netherFortressGenerator != null) {
            return this.netherFortressGenerator.func_175795_b(pos);
        }
        return false;
    }

    @Nullable
    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        if (!this.mapFeaturesEnabled) {
            return null;
        }
        if (this.settings.useFortresses && "Fortress".equals(structureName) && this.netherFortressGenerator != null) {
            return this.netherFortressGenerator.func_180706_b(world, position, findUnexplored);
        }
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        if (!this.mapFeaturesEnabled) {
            return;
        }
        if (this.settings.useFortresses) {
            this.netherFortressGenerator.func_186125_a(this.world, x, z, null);
        }
    }

    private List<Biome.SpawnListEntry> getPossibleCreaturesInclStructures(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            if (this.mapFeaturesEnabled && this.settings.useFortresses && this.netherFortressGenerator.func_175795_b(pos)) {
                return this.netherFortressGenerator.func_75059_a();
            }
            if (this.mapFeaturesEnabled && this.settings.useFortresses && this.netherFortressGenerator.func_175796_a(this.world, pos) && this.world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj) {
                return this.netherFortressGenerator.func_75059_a();
            }
        }
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }
}

