/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenClay
extends WorldGenerator {
    private final Block block = Blocks.field_150435_aG;
    private final int numBlocks;

    public WorldGenClay(int numberOfBlocks) {
        this.numBlocks = numberOfBlocks;
    }

    public boolean func_180709_b(World world, Random random, BlockPos blockPos) {
        if (world.func_180495_p(blockPos).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int startX = blockPos.func_177958_n();
        int startY = blockPos.func_177956_o();
        int startZ = blockPos.func_177952_p();
        float theta = random.nextFloat() * 3.141593f;
        float numBlocks = this.numBlocks;
        double maxBX = (float)(startX + 8) + MathHelper.func_76126_a((float)theta) * numBlocks / 8.0f;
        double minBX = (float)(startX + 8) - MathHelper.func_76126_a((float)theta) * numBlocks / 8.0f;
        double maxBZ = (float)(startZ + 8) + MathHelper.func_76134_b((float)theta) * numBlocks / 8.0f;
        double minBZ = (float)(startZ + 8) - MathHelper.func_76134_b((float)theta) * numBlocks / 8.0f;
        double maxBY = startY + random.nextInt(3) + 2;
        double minBY = startY + random.nextInt(3) + 2;
        for (int b = 0; b <= this.numBlocks; ++b) {
            double bX = maxBX + (minBX - maxBX) * (double)b / (double)numBlocks;
            double bY = maxBY + (minBY - maxBY) * (double)b / (double)numBlocks;
            double bZ = maxBZ + (minBZ - maxBZ) * (double)b / (double)numBlocks;
            double f = random.nextDouble() * (double)numBlocks / 16.0;
            theta = (float)b * 3.141593f / numBlocks;
            double tW = (double)(MathHelper.func_76126_a((float)theta) + 1.0f) * f + 1.0;
            double tH = (double)(MathHelper.func_76126_a((float)theta) + 1.0f) * f + 1.0;
            int minX = MathHelper.func_76128_c((double)(bX - tW / 2.0));
            int maxX = MathHelper.func_76128_c((double)(bX + tW / 2.0));
            int minY = MathHelper.func_76128_c((double)(bY - tH / 2.0));
            int maxY = MathHelper.func_76128_c((double)(bY + tH / 2.0));
            int minZ = MathHelper.func_76128_c((double)(bZ - tW / 2.0));
            int maxZ = MathHelper.func_76128_c((double)(bZ + tW / 2.0));
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Block block;
                        double dX = ((double)x + 0.5 - bX) / (tW / 2.0);
                        double dY = ((double)y + 0.5 - bY) / (tH / 2.0);
                        double dZ = ((double)z + 0.5 - bZ) / (tW / 2.0);
                        if (dX * dX + dY * dY + dZ * dZ >= 1.0 || (block = world.func_180495_p((BlockPos)mutablePos.func_181079_c(x, y, z)).func_177230_c()) != Blocks.field_150354_m) continue;
                        world.func_175656_a((BlockPos)mutablePos, this.block.func_176223_P());
                    }
                }
            }
        }
        return true;
    }
}

