/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.feature;

import com.google.common.base.Predicate;
import java.util.Random;
import java.util.function.Consumer;
import mod.bespectacled.modernbetaforge.world.feature.OreType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenMinableMutable
extends WorldGenMinable {
    public static final Predicate<IBlockState> STONE_PREDICATE = new Predicate<IBlockState>(){

        public boolean apply(IBlockState blockState) {
            if (blockState != null && blockState.func_177230_c() == Blocks.field_150348_b) {
                return ((BlockStone.EnumType)blockState.func_177229_b((IProperty)BlockStone.field_176247_a)).func_190912_e();
            }
            return false;
        }
    };
    private final OreType oreType;

    public WorldGenMinableMutable(IBlockState state, int blockCount, Predicate<IBlockState> predicate, OreType oreType) {
        super(state, blockCount, predicate);
        this.oreType = oreType;
    }

    public WorldGenMinableMutable(IBlockState state, int blockCount, OreType oreType) {
        this(state, blockCount, STONE_PREDICATE, oreType);
    }

    public boolean func_180709_b(World world, Random random, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean useOldOre = this.oreType == OreType.CLASSIC;
        int startX = blockPos.func_177958_n();
        int startY = blockPos.func_177956_o();
        int startZ = blockPos.func_177952_p();
        float theta = random.nextFloat() * 3.141593f;
        float numBlocks = this.field_76541_b;
        double maxBX = (float)(startX + 8) + MathHelper.func_76126_a((float)theta) * numBlocks / 8.0f;
        double minBX = (float)(startX + 8) - MathHelper.func_76126_a((float)theta) * numBlocks / 8.0f;
        double maxBZ = (float)(startZ + 8) + MathHelper.func_76134_b((float)theta) * numBlocks / 8.0f;
        double minBZ = (float)(startZ + 8) - MathHelper.func_76134_b((float)theta) * numBlocks / 8.0f;
        double maxBY = startY + random.nextInt(3) + (useOldOre ? 2 : -2);
        double minBY = startY + random.nextInt(3) + (useOldOre ? 2 : -2);
        Consumer<Integer> oreGenerator = i -> {
            double progress = (double)i.intValue() / (double)numBlocks;
            double bX = maxBX + (minBX - maxBX) * progress;
            double bY = maxBY + (minBY - maxBY) * progress;
            double bZ = maxBZ + (minBZ - maxBZ) * progress;
            double f = random.nextDouble() * (double)this.field_76541_b / 16.0;
            float tTheta = 3.141593f * (float)progress;
            double tW = (double)(MathHelper.func_76126_a((float)tTheta) + 1.0f) * f + 1.0;
            double tH = (double)(MathHelper.func_76126_a((float)tTheta) + 1.0f) * f + 1.0;
            int minX = MathHelper.func_76128_c((double)(bX - tW / 2.0));
            int maxX = MathHelper.func_76128_c((double)(bX + tW / 2.0));
            int minY = MathHelper.func_76128_c((double)(bY - tH / 2.0));
            int maxY = MathHelper.func_76128_c((double)(bY + tH / 2.0));
            int minZ = MathHelper.func_76128_c((double)(bZ - tW / 2.0));
            int maxZ = MathHelper.func_76128_c((double)(bZ + tW / 2.0));
            for (int x = minX; x <= maxX; ++x) {
                double dX = ((double)x + 0.5 - bX) / (tW / 2.0);
                if (dX * dX >= 1.0) continue;
                for (int y = minY; y <= maxY; ++y) {
                    double dY = ((double)y + 0.5 - bY) / (tH / 2.0);
                    if (dX * dX + dY * dY >= 1.0) continue;
                    for (int z = minZ; z <= maxZ; ++z) {
                        IBlockState state;
                        Block block;
                        double dZ = ((double)z + 0.5 - bZ) / (tW / 2.0);
                        if (dX * dX + dY * dY + dZ * dZ >= 1.0 || !(block = (state = world.func_180495_p((BlockPos)mutablePos.func_181079_c(x, y, z))).func_177230_c()).isReplaceableOreGen(state, (IBlockAccess)world, (BlockPos)mutablePos, this.field_175919_c)) continue;
                        world.func_180501_a((BlockPos)mutablePos, this.field_175920_a, 2);
                    }
                }
            }
        };
        if (useOldOre) {
            for (int i2 = 0; i2 <= this.field_76541_b; ++i2) {
                oreGenerator.accept(i2);
            }
        } else {
            for (int i3 = 0; i3 < this.field_76541_b; ++i3) {
                oreGenerator.accept(i3);
            }
        }
        return true;
    }
}

