/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.setting;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.property.BiomeProperty;
import mod.bespectacled.modernbetaforge.api.property.BlockProperty;
import mod.bespectacled.modernbetaforge.api.property.BooleanProperty;
import mod.bespectacled.modernbetaforge.api.property.EntityEntryProperty;
import mod.bespectacled.modernbetaforge.api.property.FloatProperty;
import mod.bespectacled.modernbetaforge.api.property.IntProperty;
import mod.bespectacled.modernbetaforge.api.property.ListProperty;
import mod.bespectacled.modernbetaforge.api.property.Property;
import mod.bespectacled.modernbetaforge.api.property.PropertyGuiType;
import mod.bespectacled.modernbetaforge.api.property.StringProperty;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.property.visitor.FactoryPropertyVisitor;
import mod.bespectacled.modernbetaforge.registry.ModernBetaBuiltInTypes;
import mod.bespectacled.modernbetaforge.util.ForgeRegistryUtil;
import mod.bespectacled.modernbetaforge.world.biome.layer.GenLayerType;
import mod.bespectacled.modernbetaforge.world.biome.layer.GenLayerVersion;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevHouse;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevTheme;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevType;
import mod.bespectacled.modernbetaforge.world.feature.OreType;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class ModernBetaGeneratorSettings {
    public static final int[] LEVEL_WIDTHS = new int[]{64, 128, 256, 512, 768, 1024, 1536, 2048, 2560};
    public static final int[] LEVEL_HEIGHTS = new int[]{64, 96, 128, 160, 192, 224, 256};
    public static final int MAX_PRESET_LENGTH = 25000;
    public static final int MIN_HEIGHT = 1;
    public static final int MAX_HEIGHT = 255;
    public static final int MIN_SEA_LEVEL = 0;
    public static final int MAX_SEA_LEVEL = 255;
    public static final int MIN_DUNGEON_CHANCE = 1;
    public static final int MAX_DUNGEON_CHANCE = 100;
    public static final int MIN_WATER_LAKE_CHANCE = 1;
    public static final int MAX_WATER_LAKE_CHANCE = 100;
    public static final int MIN_LAVA_LAKE_CHANCE = 10;
    public static final int MAX_LAVA_LAKE_CHANCE = 100;
    public static final float MIN_LEVEL_CAVE_WIDTH = 1.0f;
    public static final float MAX_LEVEL_CAVE_WIDTH = 5.0f;
    public static final int MIN_SNOWY_BIOME_CHANCE = 1;
    public static final int MAX_SNOWY_BIOME_CHANCE = 12;
    public static final int MIN_ORE_SIZE = 1;
    public static final int MAX_ORE_SIZE = 50;
    public static final int MIN_ORE_COUNT = 0;
    public static final int MAX_ORE_COUNT = 40;
    public static final int MIN_ORE_HEIGHT = 0;
    public static final int MAX_ORE_HEIGHT = 255;
    public static final int MIN_ORE_CENTER = 0;
    public static final int MAX_ORE_CENTER = 255;
    public static final int MIN_ORE_SPREAD = 1;
    public static final int MAX_ORE_SPREAD = 255;
    public static final float MIN_CAVE_WIDTH = 1.0f;
    public static final float MAX_CAVE_WIDTH = 7.5f;
    public static final int MIN_CAVE_HEIGHT = 9;
    public static final int MAX_CAVE_HEIGHT = 255;
    public static final int MIN_CAVE_COUNT = 1;
    public static final int MAX_CAVE_COUNT = 100;
    public static final int MIN_CAVE_CHANCE = 1;
    public static final int MAX_CAVE_CHANCE = 100;
    public static final int MIN_BIOME_SIZE = 1;
    public static final int MAX_BIOME_SIZE = 8;
    public static final int MIN_RIVER_SIZE = 1;
    public static final int MAX_RIVER_SIZE = 5;
    public static final float MIN_MAIN_NOISE = 1.0f;
    public static final float MAX_MAIN_NOISE = 5000.0f;
    public static final float MIN_SCALE_NOISE = 1.0f;
    public static final float MAX_SCALE_NOISE = 20.0f;
    public static final float MIN_DEPTH_NOISE = 1.0f;
    public static final float MAX_DEPTH_NOISE = 2000.0f;
    public static final float MIN_BASE_SIZE = 1.0f;
    public static final float MAX_BASE_SIZE = 25.0f;
    public static final float MIN_COORD_SCALE = 1.0f;
    public static final float MAX_COORD_SCALE = 6000.0f;
    public static final float MIN_HEIGHT_SCALE = 1.0f;
    public static final float MAX_HEIGHT_SCALE = 6000.0f;
    public static final float MIN_STRETCH_Y = 0.01f;
    public static final float MAX_STRETCH_Y = 50.0f;
    public static final float MIN_LIMIT_SCALE = 1.0f;
    public static final float MAX_LIMIT_SCALE = 5000.0f;
    public static final float MIN_BIOME_SCALE = 0.1f;
    public static final float MAX_BIOME_SCALE = 8.0f;
    public static final float MIN_BIOME_WEIGHT = 1.0f;
    public static final float MAX_BIOME_WEIGHT = 20.0f;
    public static final float MIN_BIOME_OFFSET = 0.0f;
    public static final float MAX_BIOME_OFFSET = 20.0f;
    public static final float MIN_END_OFFSET = 0.0f;
    public static final float MAX_END_OFFSET = 2000.0f;
    public static final float MIN_END_WEIGHT = 1.0f;
    public static final float MAX_END_WEIGHT = 20.0f;
    public static final int MIN_END_DIST = 0;
    public static final int MAX_END_DIST = 256;
    public final ResourceLocation chunkSource;
    public final ResourceLocation biomeSource;
    public final ResourceLocation surfaceBuilder;
    public final ResourceLocation caveCarver;
    public final ResourceLocation worldSpawner;
    public final ResourceLocation singleBiome;
    public final ResourceLocation defaultBlock;
    public final ResourceLocation defaultFluid;
    public final boolean replaceOceanBiomes;
    public final boolean replaceBeachBiomes;
    public final boolean replaceRiverBiomes;
    public final float coordinateScale;
    public final float heightScale;
    public final float upperLimitScale;
    public final float lowerLimitScale;
    public final float scaleNoiseScaleX;
    public final float scaleNoiseScaleZ;
    public final float depthNoiseScaleX;
    public final float depthNoiseScaleZ;
    public final float mainNoiseScaleX;
    public final float mainNoiseScaleY;
    public final float mainNoiseScaleZ;
    public final float baseSize;
    public final float stretchY;
    public final int seaLevel;
    public final int height;
    public final float tempNoiseScale;
    public final float rainNoiseScale;
    public final float detailNoiseScale;
    public final int snowLineOffset;
    public final boolean useClimateFeatures;
    public final float biomeDepthWeight;
    public final float biomeDepthOffset;
    public final float biomeScaleWeight;
    public final float biomeScaleOffset;
    public final boolean useBiomeDepthScale;
    public final boolean useAmplified;
    public final int biomeSize;
    public final int riverSize;
    public final String layerType;
    public final int layerSize;
    public final int layerVersion;
    public final int snowyBiomeChance;
    public final float endIslandOffset;
    public final float endIslandWeight;
    public final float endOuterIslandOffset;
    public final int endOuterIslandDistance;
    public final boolean useEndOuterIslands;
    public final float caveWidth;
    public final int caveHeight;
    public final int caveCount;
    public final int caveChance;
    public final boolean useDungeons;
    public final int dungeonChance;
    public final boolean useStrongholds;
    public final boolean useVillages;
    public final boolean useVillageVariants;
    public final boolean useMineShafts;
    public final boolean useTemples;
    public final boolean useMonuments;
    public final boolean useMansions;
    public final boolean useRavines;
    public final boolean useUnderwaterCaves;
    public final boolean useWaterLakes;
    public final int waterLakeChance;
    public final boolean useLavaLakes;
    public final int lavaLakeChance;
    public final boolean useSandstone;
    public final boolean useOldNether;
    public final boolean useNetherCaves;
    public final boolean useFortresses;
    public final boolean useLavaPockets;
    public final boolean useInfdevWalls;
    public final boolean useInfdevPyramids;
    public final String levelTheme;
    public final String levelType;
    public final int levelWidth;
    public final int levelLength;
    public final int levelHeight;
    public final String levelHouse;
    public final boolean useIndevCaves;
    public final float levelCaveWidth;
    public final String oreType;
    public final int claySize;
    public final int clayCount;
    public final int clayMinHeight;
    public final int clayMaxHeight;
    public final int dirtSize;
    public final int dirtCount;
    public final int dirtMinHeight;
    public final int dirtMaxHeight;
    public final int gravelSize;
    public final int gravelCount;
    public final int gravelMinHeight;
    public final int gravelMaxHeight;
    public final int graniteSize;
    public final int graniteCount;
    public final int graniteMinHeight;
    public final int graniteMaxHeight;
    public final int dioriteSize;
    public final int dioriteCount;
    public final int dioriteMinHeight;
    public final int dioriteMaxHeight;
    public final int andesiteSize;
    public final int andesiteCount;
    public final int andesiteMinHeight;
    public final int andesiteMaxHeight;
    public final int coalSize;
    public final int coalCount;
    public final int coalMinHeight;
    public final int coalMaxHeight;
    public final int ironSize;
    public final int ironCount;
    public final int ironMinHeight;
    public final int ironMaxHeight;
    public final int goldSize;
    public final int goldCount;
    public final int goldMinHeight;
    public final int goldMaxHeight;
    public final int redstoneSize;
    public final int redstoneCount;
    public final int redstoneMinHeight;
    public final int redstoneMaxHeight;
    public final int diamondSize;
    public final int diamondCount;
    public final int diamondMinHeight;
    public final int diamondMaxHeight;
    public final int lapisSize;
    public final int lapisCount;
    public final int lapisCenterHeight;
    public final int lapisSpread;
    public final int emeraldSize;
    public final int emeraldCount;
    public final int emeraldMinHeight;
    public final int emeraldMaxHeight;
    public final int quartzSize;
    public final int quartzCount;
    public final int magmaSize;
    public final int magmaCount;
    public final boolean useTallGrass;
    public final boolean useNewFlowers;
    public final boolean useDoublePlants;
    public final boolean useLilyPads;
    public final boolean useMelons;
    public final boolean useDesertWells;
    public final boolean useFossils;
    public final boolean useSandDisks;
    public final boolean useGravelDisks;
    public final boolean useClayDisks;
    public final boolean useBirchTrees;
    public final boolean usePineTrees;
    public final boolean useSwampTrees;
    public final boolean useJungleTrees;
    public final boolean useAcaciaTrees;
    public final boolean useNewFancyOakTrees;
    public final boolean spawnNewCreatureMobs;
    public final boolean spawnNewMonsterMobs;
    public final boolean spawnWaterMobs;
    public final boolean spawnAmbientMobs;
    public final boolean spawnWolves;
    public final ResourceLocation desertBiomeBase;
    public final ResourceLocation desertBiomeOcean;
    public final ResourceLocation desertBiomeBeach;
    public final ResourceLocation forestBiomeBase;
    public final ResourceLocation forestBiomeOcean;
    public final ResourceLocation forestBiomeBeach;
    public final ResourceLocation iceDesertBiomeBase;
    public final ResourceLocation iceDesertBiomeOcean;
    public final ResourceLocation iceDesertBiomeBeach;
    public final ResourceLocation plainsBiomeBase;
    public final ResourceLocation plainsBiomeOcean;
    public final ResourceLocation plainsBiomeBeach;
    public final ResourceLocation rainforestBiomeBase;
    public final ResourceLocation rainforestBiomeOcean;
    public final ResourceLocation rainforestBiomeBeach;
    public final ResourceLocation savannaBiomeBase;
    public final ResourceLocation savannaBiomeOcean;
    public final ResourceLocation savannaBiomeBeach;
    public final ResourceLocation shrublandBiomeBase;
    public final ResourceLocation shrublandBiomeOcean;
    public final ResourceLocation shrublandBiomeBeach;
    public final ResourceLocation seasonalForestBiomeBase;
    public final ResourceLocation seasonalForestBiomeOcean;
    public final ResourceLocation seasonalForestBiomeBeach;
    public final ResourceLocation swamplandBiomeBase;
    public final ResourceLocation swamplandBiomeOcean;
    public final ResourceLocation swamplandBiomeBeach;
    public final ResourceLocation taigaBiomeBase;
    public final ResourceLocation taigaBiomeOcean;
    public final ResourceLocation taigaBiomeBeach;
    public final ResourceLocation tundraBiomeBase;
    public final ResourceLocation tundraBiomeOcean;
    public final ResourceLocation tundraBiomeBeach;
    private final Map<ResourceLocation, Property<?>> customProperties;

    private ModernBetaGeneratorSettings(Factory factory) {
        this.chunkSource = new ResourceLocation(factory.chunkSource);
        this.biomeSource = new ResourceLocation(factory.biomeSource);
        this.surfaceBuilder = new ResourceLocation(factory.surfaceBuilder);
        this.caveCarver = new ResourceLocation(factory.caveCarver);
        this.worldSpawner = new ResourceLocation(factory.worldSpawner);
        this.singleBiome = new ResourceLocation(factory.singleBiome);
        this.defaultBlock = new ResourceLocation(factory.defaultBlock);
        this.defaultFluid = new ResourceLocation(factory.defaultFluid);
        this.replaceOceanBiomes = factory.replaceOceanBiomes;
        this.replaceBeachBiomes = factory.replaceBeachBiomes;
        this.replaceRiverBiomes = factory.replaceRiverBiomes;
        this.coordinateScale = factory.coordinateScale;
        this.heightScale = factory.heightScale;
        this.upperLimitScale = factory.upperLimitScale;
        this.lowerLimitScale = factory.lowerLimitScale;
        this.scaleNoiseScaleX = factory.scaleNoiseScaleX;
        this.scaleNoiseScaleZ = factory.scaleNoiseScaleZ;
        this.depthNoiseScaleX = factory.depthNoiseScaleX;
        this.depthNoiseScaleZ = factory.depthNoiseScaleZ;
        this.mainNoiseScaleX = factory.mainNoiseScaleX;
        this.mainNoiseScaleY = factory.mainNoiseScaleY;
        this.mainNoiseScaleZ = factory.mainNoiseScaleZ;
        this.baseSize = factory.baseSize;
        this.stretchY = factory.stretchY;
        this.seaLevel = factory.seaLevel;
        this.height = factory.height;
        this.tempNoiseScale = factory.tempNoiseScale;
        this.rainNoiseScale = factory.rainNoiseScale;
        this.detailNoiseScale = factory.detailNoiseScale;
        this.snowLineOffset = factory.snowLineOffset;
        this.useClimateFeatures = factory.useClimateFeatures;
        this.biomeDepthWeight = factory.biomeDepthWeight;
        this.biomeDepthOffset = factory.biomeDepthOffset;
        this.biomeScaleWeight = factory.biomeScaleWeight;
        this.biomeScaleOffset = factory.biomeScaleOffset;
        this.useBiomeDepthScale = factory.useBiomeDepthScale;
        this.useAmplified = factory.useAmplified;
        this.biomeSize = factory.biomeSize;
        this.riverSize = factory.riverSize;
        this.layerType = factory.layerType;
        this.layerSize = factory.layerSize;
        this.layerVersion = factory.layerVersion;
        this.snowyBiomeChance = factory.snowyBiomeChance;
        this.endIslandOffset = factory.endIslandOffset;
        this.endIslandWeight = factory.endIslandWeight;
        this.endOuterIslandOffset = factory.endOuterIslandOffset;
        this.endOuterIslandDistance = factory.endOuterIslandDistance;
        this.useEndOuterIslands = factory.useEndOuterIslands;
        this.caveWidth = factory.caveWidth;
        this.caveHeight = factory.caveHeight;
        this.caveCount = factory.caveCount;
        this.caveChance = factory.caveChance;
        this.useDungeons = factory.useDungeons;
        this.dungeonChance = factory.dungeonChance;
        this.useStrongholds = factory.useStrongholds;
        this.useVillages = factory.useVillages;
        this.useVillageVariants = factory.useVillageVariants;
        this.useMineShafts = factory.useMineShafts;
        this.useTemples = factory.useTemples;
        this.useMonuments = factory.useMonuments;
        this.useMansions = factory.useMansions;
        this.useRavines = factory.useRavines;
        this.useUnderwaterCaves = factory.useUnderwaterCaves;
        this.useBirchTrees = factory.useBirchTrees;
        this.usePineTrees = factory.usePineTrees;
        this.useSwampTrees = factory.useSwampTrees;
        this.useJungleTrees = factory.useJungleTrees;
        this.useAcaciaTrees = factory.useAcaciaTrees;
        this.useNewFancyOakTrees = factory.useNewFancyOakTrees;
        this.useWaterLakes = factory.useWaterLakes;
        this.waterLakeChance = factory.waterLakeChance;
        this.useLavaLakes = factory.useLavaLakes;
        this.lavaLakeChance = factory.lavaLakeChance;
        this.useSandstone = factory.useSandstone;
        this.useOldNether = factory.useOldNether;
        this.useNetherCaves = factory.useNetherCaves;
        this.useFortresses = factory.useFortresses;
        this.useLavaPockets = factory.useLavaPockets;
        this.useInfdevWalls = factory.useInfdevWalls;
        this.useInfdevPyramids = factory.useInfdevPyramids;
        this.levelTheme = factory.levelTheme;
        this.levelType = factory.levelType;
        this.levelLength = factory.levelLength;
        this.levelWidth = factory.levelWidth;
        this.levelHeight = factory.levelHeight;
        this.levelHouse = factory.levelHouse;
        this.useIndevCaves = factory.useIndevCaves;
        this.levelCaveWidth = factory.levelCaveWidth;
        this.oreType = factory.oreType;
        this.claySize = factory.claySize;
        this.clayCount = factory.clayCount;
        this.clayMinHeight = factory.clayMinHeight;
        this.clayMaxHeight = factory.clayMaxHeight;
        this.dirtSize = factory.dirtSize;
        this.dirtCount = factory.dirtCount;
        this.dirtMinHeight = factory.dirtMinHeight;
        this.dirtMaxHeight = factory.dirtMaxHeight;
        this.gravelSize = factory.gravelSize;
        this.gravelCount = factory.gravelCount;
        this.gravelMinHeight = factory.gravelMinHeight;
        this.gravelMaxHeight = factory.gravelMaxHeight;
        this.graniteSize = factory.graniteSize;
        this.graniteCount = factory.graniteCount;
        this.graniteMinHeight = factory.graniteMinHeight;
        this.graniteMaxHeight = factory.graniteMaxHeight;
        this.dioriteSize = factory.dioriteSize;
        this.dioriteCount = factory.dioriteCount;
        this.dioriteMinHeight = factory.dioriteMinHeight;
        this.dioriteMaxHeight = factory.dioriteMaxHeight;
        this.andesiteSize = factory.andesiteSize;
        this.andesiteCount = factory.andesiteCount;
        this.andesiteMinHeight = factory.andesiteMinHeight;
        this.andesiteMaxHeight = factory.andesiteMaxHeight;
        this.coalSize = factory.coalSize;
        this.coalCount = factory.coalCount;
        this.coalMinHeight = factory.coalMinHeight;
        this.coalMaxHeight = factory.coalMaxHeight;
        this.ironSize = factory.ironSize;
        this.ironCount = factory.ironCount;
        this.ironMinHeight = factory.ironMinHeight;
        this.ironMaxHeight = factory.ironMaxHeight;
        this.goldSize = factory.goldSize;
        this.goldCount = factory.goldCount;
        this.goldMinHeight = factory.goldMinHeight;
        this.goldMaxHeight = factory.goldMaxHeight;
        this.redstoneSize = factory.redstoneSize;
        this.redstoneCount = factory.redstoneCount;
        this.redstoneMinHeight = factory.redstoneMinHeight;
        this.redstoneMaxHeight = factory.redstoneMaxHeight;
        this.diamondSize = factory.diamondSize;
        this.diamondCount = factory.diamondCount;
        this.diamondMinHeight = factory.diamondMinHeight;
        this.diamondMaxHeight = factory.diamondMaxHeight;
        this.lapisSize = factory.lapisSize;
        this.lapisCount = factory.lapisCount;
        this.lapisCenterHeight = factory.lapisCenterHeight;
        this.lapisSpread = factory.lapisSpread;
        this.emeraldSize = factory.emeraldSize;
        this.emeraldCount = factory.emeraldCount;
        this.emeraldMinHeight = factory.emeraldMinHeight;
        this.emeraldMaxHeight = factory.emeraldMaxHeight;
        this.quartzSize = factory.quartzSize;
        this.quartzCount = factory.quartzCount;
        this.magmaSize = factory.magmaSize;
        this.magmaCount = factory.magmaCount;
        this.useTallGrass = factory.useTallGrass;
        this.useNewFlowers = factory.useNewFlowers;
        this.useDoublePlants = factory.useDoublePlants;
        this.useLilyPads = factory.useLilyPads;
        this.useMelons = factory.useMelons;
        this.useDesertWells = factory.useDesertWells;
        this.useFossils = factory.useFossils;
        this.useSandDisks = factory.useSandDisks;
        this.useGravelDisks = factory.useGravelDisks;
        this.useClayDisks = factory.useClayDisks;
        this.spawnNewCreatureMobs = factory.spawnNewCreatureMobs;
        this.spawnNewMonsterMobs = factory.spawnNewMonsterMobs;
        this.spawnWaterMobs = factory.spawnWaterMobs;
        this.spawnAmbientMobs = factory.spawnAmbientMobs;
        this.spawnWolves = factory.spawnWolves;
        this.desertBiomeBase = new ResourceLocation(factory.desertBiomeBase);
        this.desertBiomeOcean = new ResourceLocation(factory.desertBiomeOcean);
        this.desertBiomeBeach = new ResourceLocation(factory.desertBiomeBeach);
        this.forestBiomeBase = new ResourceLocation(factory.forestBiomeBase);
        this.forestBiomeOcean = new ResourceLocation(factory.forestBiomeOcean);
        this.forestBiomeBeach = new ResourceLocation(factory.forestBiomeBeach);
        this.iceDesertBiomeBase = new ResourceLocation(factory.iceDesertBiomeBase);
        this.iceDesertBiomeOcean = new ResourceLocation(factory.iceDesertBiomeOcean);
        this.iceDesertBiomeBeach = new ResourceLocation(factory.iceDesertBiomeBeach);
        this.plainsBiomeBase = new ResourceLocation(factory.plainsBiomeBase);
        this.plainsBiomeOcean = new ResourceLocation(factory.plainsBiomeOcean);
        this.plainsBiomeBeach = new ResourceLocation(factory.plainsBiomeBeach);
        this.rainforestBiomeBase = new ResourceLocation(factory.rainforestBiomeBase);
        this.rainforestBiomeOcean = new ResourceLocation(factory.rainforestBiomeOcean);
        this.rainforestBiomeBeach = new ResourceLocation(factory.rainforestBiomeBeach);
        this.savannaBiomeBase = new ResourceLocation(factory.savannaBiomeBase);
        this.savannaBiomeOcean = new ResourceLocation(factory.savannaBiomeOcean);
        this.savannaBiomeBeach = new ResourceLocation(factory.savannaBiomeBeach);
        this.shrublandBiomeBase = new ResourceLocation(factory.shrublandBiomeBase);
        this.shrublandBiomeOcean = new ResourceLocation(factory.shrublandBiomeOcean);
        this.shrublandBiomeBeach = new ResourceLocation(factory.shrublandBiomeBeach);
        this.seasonalForestBiomeBase = new ResourceLocation(factory.seasonalForestBiomeBase);
        this.seasonalForestBiomeOcean = new ResourceLocation(factory.seasonalForestBiomeOcean);
        this.seasonalForestBiomeBeach = new ResourceLocation(factory.seasonalForestBiomeBeach);
        this.swamplandBiomeBase = new ResourceLocation(factory.swamplandBiomeBase);
        this.swamplandBiomeOcean = new ResourceLocation(factory.swamplandBiomeOcean);
        this.swamplandBiomeBeach = new ResourceLocation(factory.swamplandBiomeBeach);
        this.taigaBiomeBase = new ResourceLocation(factory.taigaBiomeBase);
        this.taigaBiomeOcean = new ResourceLocation(factory.taigaBiomeOcean);
        this.taigaBiomeBeach = new ResourceLocation(factory.taigaBiomeBeach);
        this.tundraBiomeBase = new ResourceLocation(factory.tundraBiomeBase);
        this.tundraBiomeOcean = new ResourceLocation(factory.tundraBiomeOcean);
        this.tundraBiomeBeach = new ResourceLocation(factory.tundraBiomeBeach);
        this.customProperties = ImmutableMap.copyOf(factory.customProperties);
    }

    public boolean containsProperty(ResourceLocation registryKey) {
        return this.customProperties.containsKey(registryKey);
    }

    public boolean getBooleanProperty(ResourceLocation registryKey) {
        Property<?> property = this.customProperties.get(registryKey);
        if (property != null && property instanceof BooleanProperty) {
            return (Boolean)((BooleanProperty)property).getValue();
        }
        throw new IllegalArgumentException(String.format("[Modern Beta] Boolean Property '%s' was not found!", registryKey));
    }

    public float getFloatProperty(ResourceLocation registryKey) {
        Property<?> property = this.customProperties.get(registryKey);
        if (property != null && property instanceof FloatProperty) {
            return ((Float)((FloatProperty)property).getValue()).floatValue();
        }
        throw new IllegalArgumentException(String.format("[Modern Beta] Float Property '%s' was not found!", registryKey));
    }

    public int getIntProperty(ResourceLocation registryKey) {
        Property<?> property = this.customProperties.get(registryKey);
        if (property != null && property instanceof IntProperty) {
            return (Integer)((IntProperty)property).getValue();
        }
        throw new IllegalArgumentException(String.format("[Modern Beta] Int Property '%s' was not found!", registryKey));
    }

    public String getStringProperty(ResourceLocation registryKey) {
        Property<?> property = this.customProperties.get(registryKey);
        if (property != null && property instanceof StringProperty) {
            return (String)((StringProperty)property).getValue();
        }
        throw new IllegalArgumentException(String.format("[Modern Beta] String Property '%s' was not found!", registryKey));
    }

    public String getListProperty(ResourceLocation registryKey) {
        return this.getStringProperty(registryKey);
    }

    public Biome getBiomeProperty(ResourceLocation registryKey) {
        return (Biome)ForgeRegistryUtil.get(new ResourceLocation(this.getStringProperty(registryKey)), ForgeRegistries.BIOMES);
    }

    public Block getBlockProperty(ResourceLocation registryKey) {
        return (Block)ForgeRegistryUtil.get(new ResourceLocation(this.getStringProperty(registryKey)), ForgeRegistries.BLOCKS);
    }

    public EntityEntry getEntityEntryProperty(ResourceLocation registryKey) {
        return (EntityEntry)ForgeRegistryUtil.get(new ResourceLocation(this.getStringProperty(registryKey)), ForgeRegistries.ENTITIES);
    }

    public static ModernBetaGeneratorSettings build() {
        return new Factory().build();
    }

    public static ModernBetaGeneratorSettings build(String generatorSettings) {
        if (generatorSettings.length() > 25000) {
            ModernBeta.log(Level.ERROR, String.format("Generator settings string exceeds maximum length (%d)!", 25000));
            return ModernBetaGeneratorSettings.build();
        }
        return Factory.jsonToFactory(generatorSettings).build();
    }

    public static ModernBetaGeneratorSettings buildOrGet(World world) {
        if (world instanceof WorldServer && ((WorldServer)world).func_72863_F().field_186029_c instanceof ModernBetaChunkGenerator) {
            ModernBetaChunkGenerator chunkGenerator = (ModernBetaChunkGenerator)((WorldServer)world).func_72863_F().field_186029_c;
            return chunkGenerator.getGeneratorSettings();
        }
        return ModernBetaGeneratorSettings.build(world.func_72912_H().func_82571_y());
    }

    private static class WriteFactoryPropertyVisitor
    implements FactoryPropertyVisitor {
        private WriteFactoryPropertyVisitor() {
        }

        @Override
        public void visit(BooleanProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            jsonObject.addProperty(registryKey.toString(), (Boolean)property.getValue());
        }

        @Override
        public void visit(FloatProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            jsonObject.addProperty(registryKey.toString(), (Number)property.getValue());
        }

        @Override
        public void visit(IntProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            jsonObject.addProperty(registryKey.toString(), (Number)property.getValue());
        }

        @Override
        public void visit(StringProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            jsonObject.addProperty(registryKey.toString(), (String)property.getValue());
        }

        @Override
        public void visit(ListProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            jsonObject.addProperty(registryKey.toString(), (String)property.getValue());
        }

        @Override
        public void visit(BiomeProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            jsonObject.addProperty(registryKey.toString(), (String)property.getValue());
        }

        @Override
        public void visit(BlockProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            jsonObject.addProperty(registryKey.toString(), (String)property.getValue());
        }

        @Override
        public void visit(EntityEntryProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            jsonObject.addProperty(registryKey.toString(), (String)property.getValue());
        }
    }

    private static class ReadFactoryPropertyVisitor
    implements FactoryPropertyVisitor {
        private ReadFactoryPropertyVisitor() {
        }

        @Override
        public void visit(BooleanProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            boolean value = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)registryKey.toString(), (boolean)((Boolean)property.getValue()));
            factory.customProperties.put(registryKey, new BooleanProperty(value));
        }

        @Override
        public void visit(FloatProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            float value = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)registryKey.toString(), (float)((Float)property.getValue()).floatValue());
            float minValue = ((Float)property.getMinValue()).floatValue();
            float maxValue = ((Float)property.getMaxValue()).floatValue();
            PropertyGuiType guiType = property.getGuiType();
            int decimalPlaces = property.getScale();
            factory.customProperties.put(registryKey, new FloatProperty(value, minValue, maxValue, guiType, decimalPlaces));
        }

        @Override
        public void visit(IntProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            int value = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)registryKey.toString(), (int)((Integer)property.getValue()));
            int minValue = (Integer)property.getMinValue();
            int maxValue = (Integer)property.getMaxValue();
            PropertyGuiType guiType = property.getGuiType();
            factory.customProperties.put(registryKey, new IntProperty(value, minValue, maxValue, guiType));
        }

        @Override
        public void visit(StringProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            String value = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)registryKey.toString(), (String)((String)property.getValue()));
            factory.customProperties.put(registryKey, new StringProperty(value));
        }

        @Override
        public void visit(ListProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            String value = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)registryKey.toString(), (String)((String)property.getValue()));
            factory.customProperties.put(registryKey, new ListProperty(property.indexOf(value), property.getValues()));
        }

        @Override
        public void visit(BiomeProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            String value = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)registryKey.toString(), (String)((String)property.getValue()));
            Predicate<ResourceLocation> predicate = property.getFilter();
            ResourceLocation resourceLocation = ForgeRegistryUtil.validateOrElse(new ResourceLocation(value), Biomes.field_76772_c.getRegistryName(), ForgeRegistries.BIOMES);
            factory.customProperties.put(registryKey, new BiomeProperty(resourceLocation, predicate));
        }

        @Override
        public void visit(BlockProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            String value = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)registryKey.toString(), (String)((String)property.getValue()));
            Predicate<ResourceLocation> predicate = property.getFilter();
            ResourceLocation resourceLocation = ForgeRegistryUtil.validateOrElse(new ResourceLocation(value), Blocks.field_150350_a.getRegistryName(), ForgeRegistries.BLOCKS);
            factory.customProperties.put(registryKey, new BlockProperty(resourceLocation, predicate));
        }

        @Override
        public void visit(EntityEntryProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            String value = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)registryKey.toString(), (String)((String)property.getValue()));
            Predicate<ResourceLocation> predicate = property.getFilter();
            ResourceLocation resourceLocation = ForgeRegistryUtil.validateOrElse(new ResourceLocation(value), new ResourceLocation("pig"), ForgeRegistries.ENTITIES);
            factory.customProperties.put(registryKey, new EntityEntryProperty(resourceLocation, predicate));
        }
    }

    private static class NewFactoryPropertyVisitor
    implements FactoryPropertyVisitor {
        private NewFactoryPropertyVisitor() {
        }

        @Override
        public void visit(BooleanProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            factory.customProperties.put(registryKey, new BooleanProperty((Boolean)property.getValue()));
        }

        @Override
        public void visit(FloatProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            float value = ((Float)property.getValue()).floatValue();
            float minValue = ((Float)property.getMinValue()).floatValue();
            float maxValue = ((Float)property.getMaxValue()).floatValue();
            PropertyGuiType type = property.getGuiType();
            int decimalPlaces = property.getScale();
            factory.customProperties.put(registryKey, new FloatProperty(value, minValue, maxValue, type, decimalPlaces));
        }

        @Override
        public void visit(IntProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            int value = (Integer)property.getValue();
            int minValue = (Integer)property.getMinValue();
            int maxValue = (Integer)property.getMaxValue();
            PropertyGuiType type = property.getGuiType();
            factory.customProperties.put(registryKey, new IntProperty(value, minValue, maxValue, type));
        }

        @Override
        public void visit(StringProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            String value = (String)property.getValue();
            factory.customProperties.put(registryKey, new StringProperty(value));
        }

        @Override
        public void visit(ListProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            String value = (String)property.getValue();
            String[] values = property.getValues();
            factory.customProperties.put(registryKey, new ListProperty(property.indexOf(value), values));
        }

        @Override
        public void visit(BiomeProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            String value = (String)property.getValue();
            Predicate<ResourceLocation> predicate = property.getFilter();
            ResourceLocation resourceLocation = ForgeRegistryUtil.validateOrElse(new ResourceLocation(value), Biomes.field_76772_c.getRegistryName(), ForgeRegistries.BIOMES);
            factory.customProperties.put(registryKey, new BiomeProperty(resourceLocation, predicate));
        }

        @Override
        public void visit(BlockProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            String value = (String)property.getValue();
            Predicate<ResourceLocation> predicate = property.getFilter();
            ResourceLocation resourceLocation = ForgeRegistryUtil.validateOrElse(new ResourceLocation(value), Blocks.field_150350_a.getRegistryName(), ForgeRegistries.BLOCKS);
            factory.customProperties.put(registryKey, new BlockProperty(resourceLocation, predicate));
        }

        @Override
        public void visit(EntityEntryProperty property, Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
            String value = (String)property.getValue();
            Predicate<ResourceLocation> predicate = property.getFilter();
            ResourceLocation resourceLocation = ForgeRegistryUtil.validateOrElse(new ResourceLocation(value), new ResourceLocation("pig"), ForgeRegistries.ENTITIES);
            factory.customProperties.put(registryKey, new EntityEntryProperty(resourceLocation, predicate));
        }
    }

    public static class Serializer
    implements JsonDeserializer<Factory>,
    JsonSerializer<Factory> {
        public Factory deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Factory factory = new Factory();
            ModernBetaGeneratorSettings defaults = factory.build();
            try {
                factory.chunkSource = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)factory.chunkSource);
                factory.biomeSource = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"biomeSource", (String)factory.biomeSource);
                factory.surfaceBuilder = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"surfaceBuilder", (String)factory.surfaceBuilder);
                factory.caveCarver = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"caveCarver", (String)factory.caveCarver);
                factory.worldSpawner = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"worldSpawner", (String)factory.worldSpawner);
                factory.singleBiome = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"singleBiome", (String)factory.singleBiome);
                factory.defaultBlock = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"defaultBlock", (String)factory.defaultBlock);
                factory.defaultFluid = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"defaultFluid", (String)factory.defaultFluid);
                factory.replaceOceanBiomes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"replaceOceanBiomes", (boolean)factory.replaceOceanBiomes);
                factory.replaceBeachBiomes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"replaceBeachBiomes", (boolean)factory.replaceBeachBiomes);
                factory.replaceRiverBiomes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"replaceRiverBiomes", (boolean)factory.replaceRiverBiomes);
                factory.coordinateScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"coordinateScale", (float)factory.coordinateScale);
                factory.heightScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"heightScale", (float)factory.heightScale);
                factory.lowerLimitScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"lowerLimitScale", (float)factory.lowerLimitScale);
                factory.upperLimitScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"upperLimitScale", (float)factory.upperLimitScale);
                factory.scaleNoiseScaleX = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"scaleNoiseScaleX", (float)factory.scaleNoiseScaleX);
                factory.scaleNoiseScaleZ = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"scaleNoiseScaleZ", (float)factory.scaleNoiseScaleZ);
                factory.depthNoiseScaleX = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"depthNoiseScaleX", (float)factory.depthNoiseScaleX);
                factory.depthNoiseScaleZ = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"depthNoiseScaleZ", (float)factory.depthNoiseScaleZ);
                factory.mainNoiseScaleX = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"mainNoiseScaleX", (float)factory.mainNoiseScaleX);
                factory.mainNoiseScaleY = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"mainNoiseScaleY", (float)factory.mainNoiseScaleY);
                factory.mainNoiseScaleZ = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"mainNoiseScaleZ", (float)factory.mainNoiseScaleZ);
                factory.baseSize = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"baseSize", (float)factory.baseSize);
                factory.stretchY = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"stretchY", (float)factory.stretchY);
                factory.seaLevel = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"seaLevel", (int)factory.seaLevel);
                factory.height = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"height", (int)factory.height);
                factory.tempNoiseScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"tempNoiseScale", (float)factory.tempNoiseScale);
                factory.rainNoiseScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"rainNoiseScale", (float)factory.rainNoiseScale);
                factory.detailNoiseScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"detailNoiseScale", (float)factory.detailNoiseScale);
                factory.snowLineOffset = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"snowLineOffset", (int)factory.snowLineOffset);
                factory.useClimateFeatures = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useClimateFeatures", (boolean)factory.useClimateFeatures);
                factory.biomeDepthWeight = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"biomeDepthWeight", (float)factory.biomeDepthWeight);
                factory.biomeDepthOffset = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"biomeDepthOffset", (float)factory.biomeDepthOffset);
                factory.biomeScaleWeight = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"biomeScaleWeight", (float)factory.biomeScaleWeight);
                factory.biomeScaleOffset = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"biomeScaleOffset", (float)factory.biomeScaleOffset);
                factory.useBiomeDepthScale = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useBiomeDepthScale", (boolean)factory.useBiomeDepthScale);
                factory.useAmplified = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useAmplified", (boolean)factory.useAmplified);
                factory.biomeSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"biomeSize", (int)factory.biomeSize);
                factory.riverSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"riverSize", (int)factory.riverSize);
                factory.layerType = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"layerType", (String)factory.layerType);
                factory.layerSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"layerSize", (int)factory.layerSize);
                factory.layerVersion = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"layerVersion", (int)factory.layerVersion);
                factory.snowyBiomeChance = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"snowyBiomeChance", (int)factory.snowyBiomeChance);
                factory.endIslandOffset = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"endIslandOffset", (float)factory.endIslandOffset);
                factory.endIslandWeight = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"endIslandWeight", (float)factory.endIslandWeight);
                factory.endOuterIslandOffset = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"endOuterIslandOffset", (float)factory.endOuterIslandOffset);
                factory.endOuterIslandDistance = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"endOuterIslandDistance", (int)factory.endOuterIslandDistance);
                factory.useEndOuterIslands = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useEndOuterIslands", (boolean)factory.useEndOuterIslands);
                factory.caveWidth = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"caveWidth", (float)factory.caveWidth);
                factory.caveHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"caveHeight", (int)factory.caveHeight);
                factory.caveCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"caveCount", (int)factory.caveCount);
                factory.caveChance = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"caveChance", (int)factory.caveChance);
                factory.useDungeons = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useDungeons", (boolean)factory.useDungeons);
                factory.dungeonChance = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dungeonChance", (int)factory.dungeonChance);
                factory.useStrongholds = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useStrongholds", (boolean)factory.useStrongholds);
                factory.useVillages = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useVillages", (boolean)factory.useVillages);
                factory.useVillageVariants = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useVillageVariants", (boolean)factory.useVillageVariants);
                factory.useMineShafts = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useMineShafts", (boolean)factory.useMineShafts);
                factory.useTemples = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useTemples", (boolean)factory.useTemples);
                factory.useMonuments = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useMonuments", (boolean)factory.useMonuments);
                factory.useMansions = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useMansions", (boolean)factory.useMansions);
                factory.useRavines = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useRavines", (boolean)factory.useRavines);
                factory.useUnderwaterCaves = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useUnderwaterCaves", (boolean)factory.useUnderwaterCaves);
                factory.useWaterLakes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useWaterLakes", (boolean)factory.useWaterLakes);
                factory.waterLakeChance = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"waterLakeChance", (int)factory.waterLakeChance);
                factory.useLavaLakes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useLavaLakes", (boolean)factory.useLavaLakes);
                factory.lavaLakeChance = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"lavaLakeChance", (int)factory.lavaLakeChance);
                factory.useSandstone = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useSandstone", (boolean)factory.useSandstone);
                factory.useOldNether = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useOldNether", (boolean)factory.useOldNether);
                factory.useNetherCaves = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useNetherCaves", (boolean)factory.useNetherCaves);
                factory.useFortresses = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useFortresses", (boolean)factory.useFortresses);
                factory.useLavaPockets = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useLavaPockets", (boolean)factory.useLavaPockets);
                factory.useInfdevWalls = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useInfdevWalls", (boolean)factory.useInfdevWalls);
                factory.useInfdevPyramids = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useInfdevPyramids", (boolean)factory.useInfdevPyramids);
                factory.levelTheme = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"levelTheme", (String)factory.levelTheme);
                factory.levelType = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"levelType", (String)factory.levelType);
                factory.levelWidth = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"levelWidth", (int)factory.levelWidth);
                factory.levelLength = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"levelLength", (int)factory.levelLength);
                factory.levelHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"levelHeight", (int)factory.levelHeight);
                factory.levelHouse = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"levelHouse", (String)factory.levelHouse);
                factory.useIndevCaves = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useIndevCaves", (boolean)factory.useIndevCaves);
                factory.levelCaveWidth = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"levelCaveWidth", (float)factory.levelCaveWidth);
                factory.oreType = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"oreType", (String)factory.oreType);
                factory.claySize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"claySize", (int)factory.claySize);
                factory.clayCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"clayCount", (int)factory.clayCount);
                factory.clayMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"clayMinHeight", (int)factory.clayMinHeight);
                factory.clayMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"clayMaxHeight", (int)factory.clayMaxHeight);
                factory.dirtSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dirtSize", (int)factory.dirtSize);
                factory.dirtCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dirtCount", (int)factory.dirtCount);
                factory.dirtMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dirtMinHeight", (int)factory.dirtMinHeight);
                factory.dirtMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dirtMaxHeight", (int)factory.dirtMaxHeight);
                factory.gravelSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"gravelSize", (int)factory.gravelSize);
                factory.gravelCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"gravelCount", (int)factory.gravelCount);
                factory.gravelMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"gravelMinHeight", (int)factory.gravelMinHeight);
                factory.gravelMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"gravelMaxHeight", (int)factory.gravelMaxHeight);
                factory.graniteSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"graniteSize", (int)factory.graniteSize);
                factory.graniteCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"graniteCount", (int)factory.graniteCount);
                factory.graniteMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"graniteMinHeight", (int)factory.graniteMinHeight);
                factory.graniteMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"graniteMaxHeight", (int)factory.graniteMaxHeight);
                factory.dioriteSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dioriteSize", (int)factory.dioriteSize);
                factory.dioriteCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dioriteCount", (int)factory.dioriteCount);
                factory.dioriteMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dioriteMinHeight", (int)factory.dioriteMinHeight);
                factory.dioriteMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dioriteMaxHeight", (int)factory.dioriteMaxHeight);
                factory.andesiteSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"andesiteSize", (int)factory.andesiteSize);
                factory.andesiteCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"andesiteCount", (int)factory.andesiteCount);
                factory.andesiteMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"andesiteMinHeight", (int)factory.andesiteMinHeight);
                factory.andesiteMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"andesiteMaxHeight", (int)factory.andesiteMaxHeight);
                factory.coalSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"coalSize", (int)factory.coalSize);
                factory.coalCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"coalCount", (int)factory.coalCount);
                factory.coalMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"coalMinHeight", (int)factory.coalMinHeight);
                factory.coalMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"coalMaxHeight", (int)factory.coalMaxHeight);
                factory.ironSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"ironSize", (int)factory.ironSize);
                factory.ironCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"ironCount", (int)factory.ironCount);
                factory.ironMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"ironMinHeight", (int)factory.ironMinHeight);
                factory.ironMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"ironMaxHeight", (int)factory.ironMaxHeight);
                factory.goldSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"goldSize", (int)factory.goldSize);
                factory.goldCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"goldCount", (int)factory.goldCount);
                factory.goldMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"goldMinHeight", (int)factory.goldMinHeight);
                factory.goldMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"goldMaxHeight", (int)factory.goldMaxHeight);
                factory.redstoneSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"redstoneSize", (int)factory.redstoneSize);
                factory.redstoneCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"redstoneCount", (int)factory.redstoneCount);
                factory.redstoneMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"redstoneMinHeight", (int)factory.redstoneMinHeight);
                factory.redstoneMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"redstoneMaxHeight", (int)factory.redstoneMaxHeight);
                factory.diamondSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"diamondSize", (int)factory.diamondSize);
                factory.diamondCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"diamondCount", (int)factory.diamondCount);
                factory.diamondMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"diamondMinHeight", (int)factory.diamondMinHeight);
                factory.diamondMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"diamondMaxHeight", (int)factory.diamondMaxHeight);
                factory.lapisSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"lapisSize", (int)factory.lapisSize);
                factory.lapisCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"lapisCount", (int)factory.lapisCount);
                factory.lapisCenterHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"lapisCenterHeight", (int)factory.lapisCenterHeight);
                factory.lapisSpread = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"lapisSpread", (int)factory.lapisSpread);
                factory.emeraldSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"emeraldSize", (int)factory.emeraldSize);
                factory.emeraldCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"emeraldCount", (int)factory.emeraldCount);
                factory.emeraldMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"emeraldMinHeight", (int)factory.emeraldMinHeight);
                factory.emeraldMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"emeraldMaxHeight", (int)factory.emeraldMaxHeight);
                factory.quartzSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"quartzSize", (int)factory.quartzSize);
                factory.quartzCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"quartzCount", (int)factory.quartzCount);
                factory.magmaSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"magmaSize", (int)factory.magmaSize);
                factory.magmaCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"magmaCount", (int)factory.magmaCount);
                factory.useTallGrass = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useTallGrass", (boolean)factory.useTallGrass);
                factory.useNewFlowers = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useNewFlowers", (boolean)factory.useNewFlowers);
                factory.useDoublePlants = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useDoublePlants", (boolean)factory.useDoublePlants);
                factory.useLilyPads = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useLilyPads", (boolean)factory.useLilyPads);
                factory.useMelons = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useMelons", (boolean)factory.useMelons);
                factory.useDesertWells = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useDesertWells", (boolean)factory.useDesertWells);
                factory.useFossils = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useFossils", (boolean)factory.useFossils);
                factory.useSandDisks = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useSandDisks", (boolean)factory.useSandDisks);
                factory.useGravelDisks = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useGravelDisks", (boolean)factory.useGravelDisks);
                factory.useClayDisks = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useClayDisks", (boolean)factory.useClayDisks);
                factory.useBirchTrees = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useBirchTrees", (boolean)factory.useBirchTrees);
                factory.usePineTrees = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"usePineTrees", (boolean)factory.usePineTrees);
                factory.useSwampTrees = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useSwampTrees", (boolean)factory.useSwampTrees);
                factory.useJungleTrees = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useJungleTrees", (boolean)factory.useJungleTrees);
                factory.useAcaciaTrees = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useAcaciaTrees", (boolean)factory.useAcaciaTrees);
                factory.useNewFancyOakTrees = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useNewFancyOakTrees", (boolean)factory.useNewFancyOakTrees);
                factory.spawnNewCreatureMobs = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"spawnNewCreatureMobs", (boolean)factory.spawnNewCreatureMobs);
                factory.spawnNewMonsterMobs = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"spawnNewMonsterMobs", (boolean)factory.spawnNewMonsterMobs);
                factory.spawnWaterMobs = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"spawnWaterMobs", (boolean)factory.spawnWaterMobs);
                factory.spawnAmbientMobs = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"spawnAmbientMobs", (boolean)factory.spawnAmbientMobs);
                factory.spawnWolves = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"spawnWolves", (boolean)factory.spawnWolves);
                factory.desertBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"desertBiomeBase", (String)factory.desertBiomeBase);
                factory.desertBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"desertBiomeOcean", (String)factory.desertBiomeOcean);
                factory.desertBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"desertBiomeBeach", (String)factory.desertBiomeBeach);
                factory.forestBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"forestBiomeBase", (String)factory.forestBiomeBase);
                factory.forestBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"forestBiomeOcean", (String)factory.forestBiomeOcean);
                factory.forestBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"forestBiomeBeach", (String)factory.forestBiomeBeach);
                factory.iceDesertBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"iceDesertBiomeBase", (String)factory.iceDesertBiomeBase);
                factory.iceDesertBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"iceDesertBiomeOcean", (String)factory.iceDesertBiomeOcean);
                factory.iceDesertBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"iceDesertBiomeBeach", (String)factory.iceDesertBiomeBeach);
                factory.plainsBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"plainsBiomeBase", (String)factory.plainsBiomeBase);
                factory.plainsBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"plainsBiomeOcean", (String)factory.plainsBiomeOcean);
                factory.plainsBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"plainsBiomeBeach", (String)factory.plainsBiomeBeach);
                factory.rainforestBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"rainforestBiomeBase", (String)factory.rainforestBiomeBase);
                factory.rainforestBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"rainforestBiomeOcean", (String)factory.rainforestBiomeOcean);
                factory.rainforestBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"rainforestBiomeBeach", (String)factory.rainforestBiomeBeach);
                factory.savannaBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"savannaBiomeBase", (String)factory.savannaBiomeBase);
                factory.savannaBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"savannaBiomeOcean", (String)factory.savannaBiomeOcean);
                factory.savannaBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"savannaBiomeBeach", (String)factory.savannaBiomeBeach);
                factory.shrublandBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"shrublandBiomeBase", (String)factory.shrublandBiomeBase);
                factory.shrublandBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"shrublandBiomeOcean", (String)factory.shrublandBiomeOcean);
                factory.shrublandBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"shrublandBiomeBeach", (String)factory.shrublandBiomeBeach);
                factory.seasonalForestBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"seasonalForestBiomeBase", (String)factory.seasonalForestBiomeBase);
                factory.seasonalForestBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"seasonalForestBiomeOcean", (String)factory.seasonalForestBiomeOcean);
                factory.seasonalForestBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"seasonalForestBiomeBeach", (String)factory.seasonalForestBiomeBeach);
                factory.swamplandBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"swamplandBiomeBase", (String)factory.swamplandBiomeBase);
                factory.swamplandBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"swamplandBiomeOcean", (String)factory.swamplandBiomeOcean);
                factory.swamplandBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"swamplandBiomeBeach", (String)factory.swamplandBiomeBeach);
                factory.taigaBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"taigaBiomeBase", (String)factory.taigaBiomeBase);
                factory.taigaBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"taigaBiomeOcean", (String)factory.taigaBiomeOcean);
                factory.taigaBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"taigaBiomeBeach", (String)factory.taigaBiomeBeach);
                factory.tundraBiomeBase = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"tundraBiomeBase", (String)factory.tundraBiomeBase);
                factory.tundraBiomeOcean = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"tundraBiomeOcean", (String)factory.tundraBiomeOcean);
                factory.tundraBiomeBeach = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"tundraBiomeBeach", (String)factory.tundraBiomeBeach);
                factory.caveCarver = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useCaves", (boolean)true) ? factory.caveCarver : ModernBetaBuiltInTypes.Carver.NONE.getRegistryString();
                factory.defaultFluid = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useLavaOceans", (boolean)false) ? Blocks.field_150353_l.getRegistryName().toString() : factory.defaultFluid;
                factory.coordinateScale = MathHelper.func_76131_a((float)factory.coordinateScale, (float)1.0f, (float)6000.0f);
                factory.heightScale = MathHelper.func_76131_a((float)factory.heightScale, (float)1.0f, (float)6000.0f);
                factory.lowerLimitScale = MathHelper.func_76131_a((float)factory.lowerLimitScale, (float)1.0f, (float)5000.0f);
                factory.upperLimitScale = MathHelper.func_76131_a((float)factory.upperLimitScale, (float)1.0f, (float)5000.0f);
                factory.scaleNoiseScaleX = MathHelper.func_76131_a((float)factory.scaleNoiseScaleX, (float)1.0f, (float)20.0f);
                factory.scaleNoiseScaleZ = MathHelper.func_76131_a((float)factory.scaleNoiseScaleZ, (float)1.0f, (float)20.0f);
                factory.depthNoiseScaleX = MathHelper.func_76131_a((float)factory.depthNoiseScaleX, (float)1.0f, (float)2000.0f);
                factory.depthNoiseScaleZ = MathHelper.func_76131_a((float)factory.depthNoiseScaleZ, (float)1.0f, (float)2000.0f);
                factory.mainNoiseScaleX = MathHelper.func_76131_a((float)factory.mainNoiseScaleX, (float)1.0f, (float)5000.0f);
                factory.mainNoiseScaleY = MathHelper.func_76131_a((float)factory.mainNoiseScaleY, (float)1.0f, (float)5000.0f);
                factory.mainNoiseScaleZ = MathHelper.func_76131_a((float)factory.mainNoiseScaleZ, (float)1.0f, (float)5000.0f);
                factory.baseSize = MathHelper.func_76131_a((float)factory.baseSize, (float)1.0f, (float)25.0f);
                factory.stretchY = MathHelper.func_76131_a((float)factory.stretchY, (float)0.01f, (float)50.0f);
                factory.seaLevel = MathHelper.func_76125_a((int)factory.seaLevel, (int)0, (int)255);
                factory.height = MathHelper.func_76125_a((int)factory.height, (int)1, (int)255);
                factory.tempNoiseScale = MathHelper.func_76131_a((float)factory.tempNoiseScale, (float)0.1f, (float)8.0f);
                factory.rainNoiseScale = MathHelper.func_76131_a((float)factory.rainNoiseScale, (float)0.1f, (float)8.0f);
                factory.detailNoiseScale = MathHelper.func_76131_a((float)factory.detailNoiseScale, (float)0.1f, (float)8.0f);
                factory.snowLineOffset = MathHelper.func_76125_a((int)factory.snowLineOffset, (int)0, (int)255);
                factory.biomeDepthWeight = MathHelper.func_76131_a((float)factory.biomeDepthWeight, (float)1.0f, (float)20.0f);
                factory.biomeDepthOffset = MathHelper.func_76131_a((float)factory.biomeDepthOffset, (float)0.0f, (float)20.0f);
                factory.biomeScaleWeight = MathHelper.func_76131_a((float)factory.biomeScaleWeight, (float)1.0f, (float)20.0f);
                factory.biomeScaleOffset = MathHelper.func_76131_a((float)factory.biomeScaleOffset, (float)0.0f, (float)20.0f);
                factory.biomeSize = MathHelper.func_76125_a((int)factory.biomeSize, (int)1, (int)8);
                factory.riverSize = MathHelper.func_76125_a((int)factory.riverSize, (int)1, (int)5);
                factory.layerSize = MathHelper.func_76125_a((int)factory.layerSize, (int)1, (int)8);
                factory.snowyBiomeChance = MathHelper.func_76125_a((int)factory.snowyBiomeChance, (int)1, (int)12);
                factory.endIslandOffset = MathHelper.func_76131_a((float)factory.endIslandOffset, (float)0.0f, (float)2000.0f);
                factory.endIslandWeight = MathHelper.func_76131_a((float)factory.endIslandWeight, (float)1.0f, (float)20.0f);
                factory.endOuterIslandOffset = MathHelper.func_76131_a((float)factory.endOuterIslandOffset, (float)0.0f, (float)2000.0f);
                factory.endOuterIslandDistance = MathHelper.func_76125_a((int)factory.endOuterIslandDistance, (int)0, (int)256);
                factory.caveWidth = MathHelper.func_76131_a((float)factory.caveWidth, (float)1.0f, (float)7.5f);
                factory.caveHeight = MathHelper.func_76125_a((int)factory.caveHeight, (int)9, (int)255);
                factory.caveCount = MathHelper.func_76125_a((int)factory.caveCount, (int)1, (int)100);
                factory.caveChance = MathHelper.func_76125_a((int)factory.caveChance, (int)1, (int)100);
                factory.dungeonChance = MathHelper.func_76125_a((int)factory.dungeonChance, (int)1, (int)100);
                factory.waterLakeChance = MathHelper.func_76125_a((int)factory.waterLakeChance, (int)1, (int)100);
                factory.lavaLakeChance = MathHelper.func_76125_a((int)factory.lavaLakeChance, (int)10, (int)100);
                factory.levelWidth = MathHelper.func_76125_a((int)factory.levelWidth, (int)LEVEL_WIDTHS[0], (int)LEVEL_WIDTHS[LEVEL_WIDTHS.length - 1]);
                factory.levelLength = MathHelper.func_76125_a((int)factory.levelLength, (int)LEVEL_WIDTHS[0], (int)LEVEL_WIDTHS[LEVEL_WIDTHS.length - 1]);
                factory.levelHeight = MathHelper.func_76125_a((int)factory.levelHeight, (int)LEVEL_HEIGHTS[0], (int)LEVEL_HEIGHTS[LEVEL_HEIGHTS.length - 1]);
                factory.levelCaveWidth = MathHelper.func_76131_a((float)factory.levelCaveWidth, (float)1.0f, (float)5.0f);
                factory.claySize = MathHelper.func_76125_a((int)factory.claySize, (int)1, (int)50);
                factory.clayCount = MathHelper.func_76125_a((int)factory.clayCount, (int)0, (int)40);
                factory.clayMinHeight = MathHelper.func_76125_a((int)factory.clayMinHeight, (int)0, (int)255);
                factory.clayMaxHeight = MathHelper.func_76125_a((int)factory.clayMaxHeight, (int)0, (int)255);
                factory.dirtSize = MathHelper.func_76125_a((int)factory.dirtSize, (int)1, (int)50);
                factory.dirtCount = MathHelper.func_76125_a((int)factory.dirtCount, (int)0, (int)40);
                factory.dirtMinHeight = MathHelper.func_76125_a((int)factory.dirtMinHeight, (int)0, (int)255);
                factory.dirtMaxHeight = MathHelper.func_76125_a((int)factory.dirtMaxHeight, (int)0, (int)255);
                factory.gravelSize = MathHelper.func_76125_a((int)factory.gravelSize, (int)1, (int)50);
                factory.gravelCount = MathHelper.func_76125_a((int)factory.gravelCount, (int)0, (int)40);
                factory.gravelMinHeight = MathHelper.func_76125_a((int)factory.gravelMinHeight, (int)0, (int)255);
                factory.gravelMaxHeight = MathHelper.func_76125_a((int)factory.gravelMaxHeight, (int)0, (int)255);
                factory.graniteSize = MathHelper.func_76125_a((int)factory.graniteSize, (int)1, (int)50);
                factory.graniteCount = MathHelper.func_76125_a((int)factory.graniteCount, (int)0, (int)40);
                factory.graniteMinHeight = MathHelper.func_76125_a((int)factory.graniteMinHeight, (int)0, (int)255);
                factory.graniteMaxHeight = MathHelper.func_76125_a((int)factory.graniteMaxHeight, (int)0, (int)255);
                factory.dioriteSize = MathHelper.func_76125_a((int)factory.dioriteSize, (int)1, (int)50);
                factory.dioriteCount = MathHelper.func_76125_a((int)factory.dioriteCount, (int)0, (int)40);
                factory.dioriteMinHeight = MathHelper.func_76125_a((int)factory.dioriteMinHeight, (int)0, (int)255);
                factory.dioriteMaxHeight = MathHelper.func_76125_a((int)factory.dioriteMaxHeight, (int)0, (int)255);
                factory.andesiteSize = MathHelper.func_76125_a((int)factory.andesiteSize, (int)1, (int)50);
                factory.andesiteCount = MathHelper.func_76125_a((int)factory.andesiteCount, (int)0, (int)40);
                factory.andesiteMinHeight = MathHelper.func_76125_a((int)factory.andesiteMinHeight, (int)0, (int)255);
                factory.andesiteMaxHeight = MathHelper.func_76125_a((int)factory.andesiteMaxHeight, (int)0, (int)255);
                factory.coalSize = MathHelper.func_76125_a((int)factory.coalSize, (int)1, (int)50);
                factory.coalCount = MathHelper.func_76125_a((int)factory.coalCount, (int)0, (int)40);
                factory.coalMinHeight = MathHelper.func_76125_a((int)factory.coalMinHeight, (int)0, (int)255);
                factory.coalMaxHeight = MathHelper.func_76125_a((int)factory.coalMaxHeight, (int)0, (int)255);
                factory.ironSize = MathHelper.func_76125_a((int)factory.ironSize, (int)1, (int)50);
                factory.ironCount = MathHelper.func_76125_a((int)factory.ironCount, (int)0, (int)40);
                factory.ironMinHeight = MathHelper.func_76125_a((int)factory.ironMinHeight, (int)0, (int)255);
                factory.ironMaxHeight = MathHelper.func_76125_a((int)factory.ironMaxHeight, (int)0, (int)255);
                factory.goldSize = MathHelper.func_76125_a((int)factory.goldSize, (int)1, (int)50);
                factory.goldCount = MathHelper.func_76125_a((int)factory.goldCount, (int)0, (int)40);
                factory.goldMinHeight = MathHelper.func_76125_a((int)factory.goldMinHeight, (int)0, (int)255);
                factory.goldMaxHeight = MathHelper.func_76125_a((int)factory.goldMaxHeight, (int)0, (int)255);
                factory.redstoneSize = MathHelper.func_76125_a((int)factory.redstoneSize, (int)1, (int)50);
                factory.redstoneCount = MathHelper.func_76125_a((int)factory.redstoneCount, (int)0, (int)40);
                factory.redstoneMinHeight = MathHelper.func_76125_a((int)factory.redstoneMinHeight, (int)0, (int)255);
                factory.redstoneMaxHeight = MathHelper.func_76125_a((int)factory.redstoneMaxHeight, (int)0, (int)255);
                factory.diamondSize = MathHelper.func_76125_a((int)factory.diamondSize, (int)1, (int)50);
                factory.diamondCount = MathHelper.func_76125_a((int)factory.diamondCount, (int)0, (int)40);
                factory.diamondMinHeight = MathHelper.func_76125_a((int)factory.diamondMinHeight, (int)0, (int)255);
                factory.diamondMaxHeight = MathHelper.func_76125_a((int)factory.diamondMaxHeight, (int)0, (int)255);
                factory.lapisSize = MathHelper.func_76125_a((int)factory.lapisSize, (int)1, (int)50);
                factory.lapisCount = MathHelper.func_76125_a((int)factory.lapisCount, (int)0, (int)40);
                factory.lapisCenterHeight = MathHelper.func_76125_a((int)factory.lapisCenterHeight, (int)0, (int)255);
                factory.lapisSpread = MathHelper.func_76125_a((int)factory.lapisSpread, (int)1, (int)255);
                factory.emeraldSize = MathHelper.func_76125_a((int)factory.emeraldSize, (int)1, (int)50);
                factory.emeraldCount = MathHelper.func_76125_a((int)factory.emeraldCount, (int)0, (int)40);
                factory.emeraldMinHeight = MathHelper.func_76125_a((int)factory.emeraldMinHeight, (int)0, (int)255);
                factory.emeraldMaxHeight = MathHelper.func_76125_a((int)factory.emeraldMaxHeight, (int)0, (int)255);
                factory.quartzSize = MathHelper.func_76125_a((int)factory.quartzSize, (int)1, (int)50);
                factory.quartzCount = MathHelper.func_76125_a((int)factory.quartzCount, (int)0, (int)40);
                factory.magmaSize = MathHelper.func_76125_a((int)factory.magmaSize, (int)1, (int)50);
                factory.magmaCount = MathHelper.func_76125_a((int)factory.magmaCount, (int)0, (int)40);
                factory.chunkSource = ModernBetaRegistries.CHUNK_SOURCE.validateOrElse(new ResourceLocation(factory.chunkSource), defaults.chunkSource).toString();
                factory.biomeSource = ModernBetaRegistries.BIOME_SOURCE.validateOrElse(new ResourceLocation(factory.biomeSource), defaults.biomeSource).toString();
                factory.surfaceBuilder = ModernBetaRegistries.SURFACE_BUILDER.validateOrElse(new ResourceLocation(factory.surfaceBuilder), defaults.surfaceBuilder).toString();
                factory.caveCarver = ModernBetaRegistries.CAVE_CARVER.validateOrElse(new ResourceLocation(factory.caveCarver), defaults.caveCarver).toString();
                factory.worldSpawner = ModernBetaRegistries.WORLD_SPAWNER.validateOrElse(new ResourceLocation(factory.worldSpawner), defaults.worldSpawner).toString();
                factory.singleBiome = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.singleBiome), defaults.singleBiome, ForgeRegistries.BIOMES).toString();
                factory.defaultBlock = ModernBetaRegistries.DEFAULT_BLOCK.validateOrElse(new ResourceLocation(factory.defaultBlock), defaults.defaultBlock).toString();
                factory.defaultFluid = ForgeRegistryUtil.getFluid(new ResourceLocation(factory.defaultFluid)).getBlock().getRegistryName().toString();
                factory.layerType = GenLayerType.fromIdOrElse((String)factory.layerType, (GenLayerType)GenLayerType.fromId((String)defaults.layerType)).id;
                factory.levelTheme = IndevTheme.fromIdOrElse((String)factory.levelTheme, (IndevTheme)IndevTheme.fromId((String)defaults.levelTheme)).id;
                factory.levelType = IndevType.fromIdOrElse((String)factory.levelType, (IndevType)IndevType.fromId((String)defaults.levelType)).id;
                factory.levelHouse = IndevHouse.fromIdOrElse((String)factory.levelHouse, (IndevHouse)IndevHouse.fromId((String)defaults.levelHouse)).id;
                factory.oreType = OreType.fromIdOrElse((String)factory.oreType, (OreType)OreType.fromId((String)defaults.oreType)).id;
                factory.desertBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.desertBiomeBase), defaults.desertBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.desertBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.desertBiomeOcean), defaults.desertBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.desertBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.desertBiomeBeach), defaults.desertBiomeBeach, ForgeRegistries.BIOMES).toString();
                factory.forestBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.forestBiomeBase), defaults.forestBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.forestBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.forestBiomeOcean), defaults.forestBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.forestBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.forestBiomeBeach), defaults.forestBiomeBeach, ForgeRegistries.BIOMES).toString();
                factory.iceDesertBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.iceDesertBiomeBase), defaults.iceDesertBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.iceDesertBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.iceDesertBiomeOcean), defaults.iceDesertBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.iceDesertBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.iceDesertBiomeBeach), defaults.iceDesertBiomeBeach, ForgeRegistries.BIOMES).toString();
                factory.plainsBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.plainsBiomeBase), defaults.plainsBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.plainsBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.plainsBiomeOcean), defaults.plainsBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.plainsBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.plainsBiomeBeach), defaults.plainsBiomeBeach, ForgeRegistries.BIOMES).toString();
                factory.rainforestBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.rainforestBiomeBase), defaults.rainforestBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.rainforestBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.rainforestBiomeOcean), defaults.rainforestBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.rainforestBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.rainforestBiomeBeach), defaults.rainforestBiomeBeach, ForgeRegistries.BIOMES).toString();
                factory.savannaBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.savannaBiomeBase), defaults.savannaBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.savannaBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.savannaBiomeOcean), defaults.savannaBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.savannaBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.savannaBiomeBeach), defaults.savannaBiomeBeach, ForgeRegistries.BIOMES).toString();
                factory.shrublandBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.shrublandBiomeBase), defaults.shrublandBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.shrublandBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.shrublandBiomeOcean), defaults.shrublandBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.shrublandBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.shrublandBiomeBeach), defaults.shrublandBiomeBeach, ForgeRegistries.BIOMES).toString();
                factory.seasonalForestBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.seasonalForestBiomeBase), defaults.seasonalForestBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.seasonalForestBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.seasonalForestBiomeOcean), defaults.seasonalForestBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.seasonalForestBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.seasonalForestBiomeBeach), defaults.seasonalForestBiomeBeach, ForgeRegistries.BIOMES).toString();
                factory.swamplandBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.swamplandBiomeBase), defaults.swamplandBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.swamplandBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.swamplandBiomeOcean), defaults.swamplandBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.swamplandBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.swamplandBiomeBeach), defaults.swamplandBiomeBeach, ForgeRegistries.BIOMES).toString();
                factory.taigaBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.taigaBiomeBase), defaults.taigaBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.taigaBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.taigaBiomeOcean), defaults.taigaBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.taigaBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.taigaBiomeBeach), defaults.taigaBiomeBeach, ForgeRegistries.BIOMES).toString();
                factory.tundraBiomeBase = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.tundraBiomeBase), defaults.tundraBiomeBase, ForgeRegistries.BIOMES).toString();
                factory.tundraBiomeOcean = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.tundraBiomeOcean), defaults.tundraBiomeOcean, ForgeRegistries.BIOMES).toString();
                factory.tundraBiomeBeach = ForgeRegistryUtil.validateOrElse(new ResourceLocation(factory.tundraBiomeBeach), defaults.tundraBiomeBeach, ForgeRegistries.BIOMES).toString();
                ModernBetaRegistries.PROPERTY.getKeys().forEach(key -> {
                    Property<?> property = ModernBetaRegistries.PROPERTY.get((ResourceLocation)key);
                    property.visitFactory(new ReadFactoryPropertyVisitor(), factory, (ResourceLocation)key, jsonObject);
                });
            }
            catch (Exception e) {
                ModernBeta.log(Level.ERROR, "[Modern Beta] Failed to deserialize generator settings!");
                ModernBeta.log(Level.ERROR, "Error: " + e.getMessage());
            }
            return factory;
        }

        public JsonElement serialize(Factory factory, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("chunkSource", factory.chunkSource);
            jsonObject.addProperty("biomeSource", factory.biomeSource);
            jsonObject.addProperty("surfaceBuilder", factory.surfaceBuilder);
            jsonObject.addProperty("caveCarver", factory.caveCarver);
            jsonObject.addProperty("worldSpawner", factory.worldSpawner);
            jsonObject.addProperty("singleBiome", factory.singleBiome);
            jsonObject.addProperty("defaultBlock", factory.defaultBlock);
            jsonObject.addProperty("defaultFluid", factory.defaultFluid);
            jsonObject.addProperty("replaceOceanBiomes", Boolean.valueOf(factory.replaceOceanBiomes));
            jsonObject.addProperty("replaceBeachBiomes", Boolean.valueOf(factory.replaceBeachBiomes));
            jsonObject.addProperty("replaceRiverBiomes", Boolean.valueOf(factory.replaceRiverBiomes));
            jsonObject.addProperty("coordinateScale", (Number)Float.valueOf(factory.coordinateScale));
            jsonObject.addProperty("heightScale", (Number)Float.valueOf(factory.heightScale));
            jsonObject.addProperty("lowerLimitScale", (Number)Float.valueOf(factory.lowerLimitScale));
            jsonObject.addProperty("upperLimitScale", (Number)Float.valueOf(factory.upperLimitScale));
            jsonObject.addProperty("scaleNoiseScaleX", (Number)Float.valueOf(factory.scaleNoiseScaleX));
            jsonObject.addProperty("scaleNoiseScaleZ", (Number)Float.valueOf(factory.scaleNoiseScaleZ));
            jsonObject.addProperty("depthNoiseScaleX", (Number)Float.valueOf(factory.depthNoiseScaleX));
            jsonObject.addProperty("depthNoiseScaleZ", (Number)Float.valueOf(factory.depthNoiseScaleZ));
            jsonObject.addProperty("mainNoiseScaleX", (Number)Float.valueOf(factory.mainNoiseScaleX));
            jsonObject.addProperty("mainNoiseScaleY", (Number)Float.valueOf(factory.mainNoiseScaleY));
            jsonObject.addProperty("mainNoiseScaleZ", (Number)Float.valueOf(factory.mainNoiseScaleZ));
            jsonObject.addProperty("baseSize", (Number)Float.valueOf(factory.baseSize));
            jsonObject.addProperty("stretchY", (Number)Float.valueOf(factory.stretchY));
            jsonObject.addProperty("seaLevel", (Number)factory.seaLevel);
            jsonObject.addProperty("height", (Number)factory.height);
            jsonObject.addProperty("tempNoiseScale", (Number)Float.valueOf(factory.tempNoiseScale));
            jsonObject.addProperty("rainNoiseScale", (Number)Float.valueOf(factory.rainNoiseScale));
            jsonObject.addProperty("detailNoiseScale", (Number)Float.valueOf(factory.detailNoiseScale));
            jsonObject.addProperty("snowLineOffset", (Number)factory.snowLineOffset);
            jsonObject.addProperty("useClimateFeatures", Boolean.valueOf(factory.useClimateFeatures));
            jsonObject.addProperty("biomeDepthWeight", (Number)Float.valueOf(factory.biomeDepthWeight));
            jsonObject.addProperty("biomeDepthOffset", (Number)Float.valueOf(factory.biomeDepthOffset));
            jsonObject.addProperty("biomeScaleWeight", (Number)Float.valueOf(factory.biomeScaleWeight));
            jsonObject.addProperty("biomeScaleOffset", (Number)Float.valueOf(factory.biomeScaleOffset));
            jsonObject.addProperty("useBiomeDepthScale", Boolean.valueOf(factory.useBiomeDepthScale));
            jsonObject.addProperty("useAmplified", Boolean.valueOf(factory.useAmplified));
            jsonObject.addProperty("biomeSize", (Number)factory.biomeSize);
            jsonObject.addProperty("riverSize", (Number)factory.riverSize);
            jsonObject.addProperty("layerType", factory.layerType);
            jsonObject.addProperty("layerSize", (Number)factory.layerSize);
            jsonObject.addProperty("layerVersion", (Number)factory.layerVersion);
            jsonObject.addProperty("snowyBiomeChance", (Number)factory.snowyBiomeChance);
            jsonObject.addProperty("endIslandOffset", (Number)Float.valueOf(factory.endIslandOffset));
            jsonObject.addProperty("endIslandWeight", (Number)Float.valueOf(factory.endIslandWeight));
            jsonObject.addProperty("endOuterIslandOffset", (Number)Float.valueOf(factory.endOuterIslandOffset));
            jsonObject.addProperty("endOuterIslandDistance", (Number)factory.endOuterIslandDistance);
            jsonObject.addProperty("useEndOuterIslands", Boolean.valueOf(factory.useEndOuterIslands));
            jsonObject.addProperty("caveWidth", (Number)Float.valueOf(factory.caveWidth));
            jsonObject.addProperty("caveHeight", (Number)factory.caveHeight);
            jsonObject.addProperty("caveCount", (Number)factory.caveCount);
            jsonObject.addProperty("caveChance", (Number)factory.caveChance);
            jsonObject.addProperty("useDungeons", Boolean.valueOf(factory.useDungeons));
            jsonObject.addProperty("dungeonChance", (Number)factory.dungeonChance);
            jsonObject.addProperty("useStrongholds", Boolean.valueOf(factory.useStrongholds));
            jsonObject.addProperty("useVillages", Boolean.valueOf(factory.useVillages));
            jsonObject.addProperty("useVillageVariants", Boolean.valueOf(factory.useVillageVariants));
            jsonObject.addProperty("useMineShafts", Boolean.valueOf(factory.useMineShafts));
            jsonObject.addProperty("useTemples", Boolean.valueOf(factory.useTemples));
            jsonObject.addProperty("useMonuments", Boolean.valueOf(factory.useMonuments));
            jsonObject.addProperty("useMansions", Boolean.valueOf(factory.useMansions));
            jsonObject.addProperty("useRavines", Boolean.valueOf(factory.useRavines));
            jsonObject.addProperty("useUnderwaterCaves", Boolean.valueOf(factory.useUnderwaterCaves));
            jsonObject.addProperty("useWaterLakes", Boolean.valueOf(factory.useWaterLakes));
            jsonObject.addProperty("waterLakeChance", (Number)factory.waterLakeChance);
            jsonObject.addProperty("useLavaLakes", Boolean.valueOf(factory.useLavaLakes));
            jsonObject.addProperty("lavaLakeChance", (Number)factory.lavaLakeChance);
            jsonObject.addProperty("useSandstone", Boolean.valueOf(factory.useSandstone));
            jsonObject.addProperty("useOldNether", Boolean.valueOf(factory.useOldNether));
            jsonObject.addProperty("useNetherCaves", Boolean.valueOf(factory.useNetherCaves));
            jsonObject.addProperty("useFortresses", Boolean.valueOf(factory.useFortresses));
            jsonObject.addProperty("useLavaPockets", Boolean.valueOf(factory.useLavaPockets));
            jsonObject.addProperty("useInfdevWalls", Boolean.valueOf(factory.useInfdevWalls));
            jsonObject.addProperty("useInfdevPyramids", Boolean.valueOf(factory.useInfdevPyramids));
            jsonObject.addProperty("levelTheme", factory.levelTheme);
            jsonObject.addProperty("levelType", factory.levelType);
            jsonObject.addProperty("levelWidth", (Number)factory.levelWidth);
            jsonObject.addProperty("levelLength", (Number)factory.levelLength);
            jsonObject.addProperty("levelHeight", (Number)factory.levelHeight);
            jsonObject.addProperty("levelHouse", factory.levelHouse);
            jsonObject.addProperty("useIndevCaves", Boolean.valueOf(factory.useIndevCaves));
            jsonObject.addProperty("levelCaveWidth", (Number)Float.valueOf(factory.levelCaveWidth));
            jsonObject.addProperty("oreType", factory.oreType);
            jsonObject.addProperty("claySize", (Number)factory.claySize);
            jsonObject.addProperty("clayCount", (Number)factory.clayCount);
            jsonObject.addProperty("clayMinHeight", (Number)factory.clayMinHeight);
            jsonObject.addProperty("clayMaxHeight", (Number)factory.clayMaxHeight);
            jsonObject.addProperty("dirtSize", (Number)factory.dirtSize);
            jsonObject.addProperty("dirtCount", (Number)factory.dirtCount);
            jsonObject.addProperty("dirtMinHeight", (Number)factory.dirtMinHeight);
            jsonObject.addProperty("dirtMaxHeight", (Number)factory.dirtMaxHeight);
            jsonObject.addProperty("gravelSize", (Number)factory.gravelSize);
            jsonObject.addProperty("gravelCount", (Number)factory.gravelCount);
            jsonObject.addProperty("gravelMinHeight", (Number)factory.gravelMinHeight);
            jsonObject.addProperty("gravelMaxHeight", (Number)factory.gravelMaxHeight);
            jsonObject.addProperty("graniteSize", (Number)factory.graniteSize);
            jsonObject.addProperty("graniteCount", (Number)factory.graniteCount);
            jsonObject.addProperty("graniteMinHeight", (Number)factory.graniteMinHeight);
            jsonObject.addProperty("graniteMaxHeight", (Number)factory.graniteMaxHeight);
            jsonObject.addProperty("dioriteSize", (Number)factory.dioriteSize);
            jsonObject.addProperty("dioriteCount", (Number)factory.dioriteCount);
            jsonObject.addProperty("dioriteMinHeight", (Number)factory.dioriteMinHeight);
            jsonObject.addProperty("dioriteMaxHeight", (Number)factory.dioriteMaxHeight);
            jsonObject.addProperty("andesiteSize", (Number)factory.andesiteSize);
            jsonObject.addProperty("andesiteCount", (Number)factory.andesiteCount);
            jsonObject.addProperty("andesiteMinHeight", (Number)factory.andesiteMinHeight);
            jsonObject.addProperty("andesiteMaxHeight", (Number)factory.andesiteMaxHeight);
            jsonObject.addProperty("coalSize", (Number)factory.coalSize);
            jsonObject.addProperty("coalCount", (Number)factory.coalCount);
            jsonObject.addProperty("coalMinHeight", (Number)factory.coalMinHeight);
            jsonObject.addProperty("coalMaxHeight", (Number)factory.coalMaxHeight);
            jsonObject.addProperty("ironSize", (Number)factory.ironSize);
            jsonObject.addProperty("ironCount", (Number)factory.ironCount);
            jsonObject.addProperty("ironMinHeight", (Number)factory.ironMinHeight);
            jsonObject.addProperty("ironMaxHeight", (Number)factory.ironMaxHeight);
            jsonObject.addProperty("goldSize", (Number)factory.goldSize);
            jsonObject.addProperty("goldCount", (Number)factory.goldCount);
            jsonObject.addProperty("goldMinHeight", (Number)factory.goldMinHeight);
            jsonObject.addProperty("goldMaxHeight", (Number)factory.goldMaxHeight);
            jsonObject.addProperty("redstoneSize", (Number)factory.redstoneSize);
            jsonObject.addProperty("redstoneCount", (Number)factory.redstoneCount);
            jsonObject.addProperty("redstoneMinHeight", (Number)factory.redstoneMinHeight);
            jsonObject.addProperty("redstoneMaxHeight", (Number)factory.redstoneMaxHeight);
            jsonObject.addProperty("diamondSize", (Number)factory.diamondSize);
            jsonObject.addProperty("diamondCount", (Number)factory.diamondCount);
            jsonObject.addProperty("diamondMinHeight", (Number)factory.diamondMinHeight);
            jsonObject.addProperty("diamondMaxHeight", (Number)factory.diamondMaxHeight);
            jsonObject.addProperty("lapisSize", (Number)factory.lapisSize);
            jsonObject.addProperty("lapisCount", (Number)factory.lapisCount);
            jsonObject.addProperty("lapisCenterHeight", (Number)factory.lapisCenterHeight);
            jsonObject.addProperty("lapisSpread", (Number)factory.lapisSpread);
            jsonObject.addProperty("emeraldSize", (Number)factory.emeraldSize);
            jsonObject.addProperty("emeraldCount", (Number)factory.emeraldCount);
            jsonObject.addProperty("emeraldMinHeight", (Number)factory.emeraldMinHeight);
            jsonObject.addProperty("emeraldMaxHeight", (Number)factory.emeraldMaxHeight);
            jsonObject.addProperty("quartzSize", (Number)factory.quartzSize);
            jsonObject.addProperty("quartzCount", (Number)factory.quartzCount);
            jsonObject.addProperty("magmaSize", (Number)factory.magmaSize);
            jsonObject.addProperty("magmaCount", (Number)factory.magmaCount);
            jsonObject.addProperty("useTallGrass", Boolean.valueOf(factory.useTallGrass));
            jsonObject.addProperty("useNewFlowers", Boolean.valueOf(factory.useNewFlowers));
            jsonObject.addProperty("useDoublePlants", Boolean.valueOf(factory.useDoublePlants));
            jsonObject.addProperty("useLilyPads", Boolean.valueOf(factory.useLilyPads));
            jsonObject.addProperty("useMelons", Boolean.valueOf(factory.useMelons));
            jsonObject.addProperty("useDesertWells", Boolean.valueOf(factory.useDesertWells));
            jsonObject.addProperty("useFossils", Boolean.valueOf(factory.useFossils));
            jsonObject.addProperty("useSandDisks", Boolean.valueOf(factory.useSandDisks));
            jsonObject.addProperty("useGravelDisks", Boolean.valueOf(factory.useGravelDisks));
            jsonObject.addProperty("useClayDisks", Boolean.valueOf(factory.useClayDisks));
            jsonObject.addProperty("useBirchTrees", Boolean.valueOf(factory.useBirchTrees));
            jsonObject.addProperty("usePineTrees", Boolean.valueOf(factory.usePineTrees));
            jsonObject.addProperty("useSwampTrees", Boolean.valueOf(factory.useSwampTrees));
            jsonObject.addProperty("useJungleTrees", Boolean.valueOf(factory.useJungleTrees));
            jsonObject.addProperty("useAcaciaTrees", Boolean.valueOf(factory.useAcaciaTrees));
            jsonObject.addProperty("useNewFancyOakTrees", Boolean.valueOf(factory.useNewFancyOakTrees));
            jsonObject.addProperty("spawnNewCreatureMobs", Boolean.valueOf(factory.spawnNewCreatureMobs));
            jsonObject.addProperty("spawnNewMonsterMobs", Boolean.valueOf(factory.spawnNewMonsterMobs));
            jsonObject.addProperty("spawnWaterMobs", Boolean.valueOf(factory.spawnWaterMobs));
            jsonObject.addProperty("spawnAmbientMobs", Boolean.valueOf(factory.spawnAmbientMobs));
            jsonObject.addProperty("spawnWolves", Boolean.valueOf(factory.spawnWolves));
            jsonObject.addProperty("desertBiomeBase", factory.desertBiomeBase);
            jsonObject.addProperty("desertBiomeOcean", factory.desertBiomeOcean);
            jsonObject.addProperty("desertBiomeBeach", factory.desertBiomeBeach);
            jsonObject.addProperty("forestBiomeBase", factory.forestBiomeBase);
            jsonObject.addProperty("forestBiomeOcean", factory.forestBiomeOcean);
            jsonObject.addProperty("forestBiomeBeach", factory.forestBiomeBeach);
            jsonObject.addProperty("iceDesertBiomeBase", factory.iceDesertBiomeBase);
            jsonObject.addProperty("iceDesertBiomeOcean", factory.iceDesertBiomeOcean);
            jsonObject.addProperty("iceDesertBiomeBeach", factory.iceDesertBiomeBeach);
            jsonObject.addProperty("plainsBiomeBase", factory.plainsBiomeBase);
            jsonObject.addProperty("plainsBiomeOcean", factory.plainsBiomeOcean);
            jsonObject.addProperty("plainsBiomeBeach", factory.plainsBiomeBeach);
            jsonObject.addProperty("rainforestBiomeBase", factory.rainforestBiomeBase);
            jsonObject.addProperty("rainforestBiomeOcean", factory.rainforestBiomeOcean);
            jsonObject.addProperty("rainforestBiomeBeach", factory.rainforestBiomeBeach);
            jsonObject.addProperty("savannaBiomeBase", factory.savannaBiomeBase);
            jsonObject.addProperty("savannaBiomeOcean", factory.savannaBiomeOcean);
            jsonObject.addProperty("savannaBiomeBeach", factory.savannaBiomeBeach);
            jsonObject.addProperty("shrublandBiomeBase", factory.shrublandBiomeBase);
            jsonObject.addProperty("shrublandBiomeOcean", factory.shrublandBiomeOcean);
            jsonObject.addProperty("shrublandBiomeBeach", factory.shrublandBiomeBeach);
            jsonObject.addProperty("seasonalForestBiomeBase", factory.seasonalForestBiomeBase);
            jsonObject.addProperty("seasonalForestBiomeOcean", factory.seasonalForestBiomeOcean);
            jsonObject.addProperty("seasonalForestBiomeBeach", factory.seasonalForestBiomeBeach);
            jsonObject.addProperty("swamplandBiomeBase", factory.swamplandBiomeBase);
            jsonObject.addProperty("swamplandBiomeOcean", factory.swamplandBiomeOcean);
            jsonObject.addProperty("swamplandBiomeBeach", factory.swamplandBiomeBeach);
            jsonObject.addProperty("taigaBiomeBase", factory.taigaBiomeBase);
            jsonObject.addProperty("taigaBiomeOcean", factory.taigaBiomeOcean);
            jsonObject.addProperty("taigaBiomeBeach", factory.taigaBiomeBeach);
            jsonObject.addProperty("tundraBiomeBase", factory.tundraBiomeBase);
            jsonObject.addProperty("tundraBiomeOcean", factory.tundraBiomeOcean);
            jsonObject.addProperty("tundraBiomeBeach", factory.tundraBiomeBeach);
            factory.customProperties.keySet().forEach(key -> {
                Property<?> property = factory.customProperties.get(key);
                property.visitFactory(new WriteFactoryPropertyVisitor(), factory, (ResourceLocation)key, jsonObject);
            });
            return jsonObject;
        }
    }

    public static class Factory {
        static final Gson JSON_ADAPTER = new GsonBuilder().registerTypeAdapter(Factory.class, (Object)new Serializer()).create();
        public String chunkSource = ModernBetaBuiltInTypes.Chunk.BETA.getRegistryString();
        public String biomeSource = ModernBetaBuiltInTypes.Biome.BETA.getRegistryString();
        public String surfaceBuilder = ModernBetaBuiltInTypes.Surface.BETA.getRegistryString();
        public String caveCarver = ModernBetaBuiltInTypes.Carver.BETA.getRegistryString();
        public String worldSpawner = ModernBetaBuiltInTypes.WorldSpawner.BETA.getRegistryString();
        public String singleBiome = Biomes.field_76772_c.getRegistryName().toString();
        public String defaultBlock = Blocks.field_150348_b.getRegistryName().toString();
        public String defaultFluid = Blocks.field_150355_j.getRegistryName().toString();
        public boolean replaceOceanBiomes = true;
        public boolean replaceBeachBiomes = true;
        public boolean replaceRiverBiomes = true;
        public float coordinateScale = 684.412f;
        public float heightScale = 684.412f;
        public float upperLimitScale = 512.0f;
        public float lowerLimitScale = 512.0f;
        public float scaleNoiseScaleX = 1.121f;
        public float scaleNoiseScaleZ = 1.121f;
        public float depthNoiseScaleX = 200.0f;
        public float depthNoiseScaleZ = 200.0f;
        public float mainNoiseScaleX = 80.0f;
        public float mainNoiseScaleY = 160.0f;
        public float mainNoiseScaleZ = 80.0f;
        public float baseSize = 8.5f;
        public float stretchY = 12.0f;
        public int seaLevel = 64;
        public int height = 128;
        public float tempNoiseScale = 1.0f;
        public float rainNoiseScale = 1.0f;
        public float detailNoiseScale = 1.0f;
        public int snowLineOffset = 64;
        public boolean useClimateFeatures = true;
        public float biomeDepthWeight = 1.0f;
        public float biomeDepthOffset = 0.0f;
        public float biomeScaleWeight = 1.0f;
        public float biomeScaleOffset = 0.0f;
        public boolean useBiomeDepthScale = true;
        public boolean useAmplified = false;
        public int biomeSize = 4;
        public int riverSize = 4;
        public String layerType;
        public int layerSize;
        public int layerVersion;
        public int snowyBiomeChance;
        public float endIslandOffset;
        public float endIslandWeight;
        public float endOuterIslandOffset;
        public int endOuterIslandDistance;
        public boolean useEndOuterIslands;
        public float caveWidth;
        public int caveHeight;
        public int caveCount;
        public int caveChance;
        public boolean useDungeons;
        public int dungeonChance;
        public boolean useStrongholds;
        public boolean useVillages;
        public boolean useVillageVariants;
        public boolean useMineShafts;
        public boolean useTemples;
        public boolean useMonuments;
        public boolean useMansions;
        public boolean useRavines;
        public boolean useUnderwaterCaves;
        public boolean useWaterLakes;
        public int waterLakeChance;
        public boolean useLavaLakes;
        public int lavaLakeChance;
        public boolean useSandstone;
        public boolean useOldNether;
        public boolean useNetherCaves;
        public boolean useFortresses;
        public boolean useLavaPockets;
        public boolean useInfdevWalls;
        public boolean useInfdevPyramids;
        public String levelTheme;
        public String levelType;
        public int levelWidth;
        public int levelLength;
        public int levelHeight;
        public String levelHouse;
        public boolean useIndevCaves;
        public float levelCaveWidth;
        public String oreType;
        public int claySize;
        public int clayCount;
        public int clayMinHeight;
        public int clayMaxHeight;
        public int dirtSize;
        public int dirtCount;
        public int dirtMinHeight;
        public int dirtMaxHeight;
        public int gravelSize;
        public int gravelCount;
        public int gravelMinHeight;
        public int gravelMaxHeight;
        public int graniteSize;
        public int graniteCount;
        public int graniteMinHeight;
        public int graniteMaxHeight;
        public int dioriteSize;
        public int dioriteCount;
        public int dioriteMinHeight;
        public int dioriteMaxHeight;
        public int andesiteSize;
        public int andesiteCount;
        public int andesiteMinHeight;
        public int andesiteMaxHeight;
        public int coalSize;
        public int coalCount;
        public int coalMinHeight;
        public int coalMaxHeight;
        public int ironSize;
        public int ironCount;
        public int ironMinHeight;
        public int ironMaxHeight;
        public int goldSize;
        public int goldCount;
        public int goldMinHeight;
        public int goldMaxHeight;
        public int redstoneSize;
        public int redstoneCount;
        public int redstoneMinHeight;
        public int redstoneMaxHeight;
        public int diamondSize;
        public int diamondCount;
        public int diamondMinHeight;
        public int diamondMaxHeight;
        public int lapisSize;
        public int lapisCount;
        public int lapisCenterHeight;
        public int lapisSpread;
        public int emeraldSize;
        public int emeraldCount;
        public int emeraldMinHeight;
        public int emeraldMaxHeight;
        public int quartzSize;
        public int quartzCount;
        public int magmaSize;
        public int magmaCount;
        public boolean useTallGrass;
        public boolean useNewFlowers;
        public boolean useDoublePlants;
        public boolean useLilyPads;
        public boolean useMelons;
        public boolean useDesertWells;
        public boolean useFossils;
        public boolean useSandDisks;
        public boolean useGravelDisks;
        public boolean useClayDisks;
        public boolean useBirchTrees;
        public boolean usePineTrees;
        public boolean useSwampTrees;
        public boolean useJungleTrees;
        public boolean useAcaciaTrees;
        public boolean useNewFancyOakTrees;
        public boolean spawnNewCreatureMobs;
        public boolean spawnNewMonsterMobs;
        public boolean spawnWaterMobs;
        public boolean spawnAmbientMobs;
        public boolean spawnWolves;
        public String desertBiomeBase;
        public String desertBiomeOcean;
        public String desertBiomeBeach;
        public String forestBiomeBase;
        public String forestBiomeOcean;
        public String forestBiomeBeach;
        public String iceDesertBiomeBase;
        public String iceDesertBiomeOcean;
        public String iceDesertBiomeBeach;
        public String plainsBiomeBase;
        public String plainsBiomeOcean;
        public String plainsBiomeBeach;
        public String rainforestBiomeBase;
        public String rainforestBiomeOcean;
        public String rainforestBiomeBeach;
        public String savannaBiomeBase;
        public String savannaBiomeOcean;
        public String savannaBiomeBeach;
        public String shrublandBiomeBase;
        public String shrublandBiomeOcean;
        public String shrublandBiomeBeach;
        public String seasonalForestBiomeBase;
        public String seasonalForestBiomeOcean;
        public String seasonalForestBiomeBeach;
        public String swamplandBiomeBase;
        public String swamplandBiomeOcean;
        public String swamplandBiomeBeach;
        public String taigaBiomeBase;
        public String taigaBiomeOcean;
        public String taigaBiomeBeach;
        public String tundraBiomeBase;
        public String tundraBiomeOcean;
        public String tundraBiomeBeach;
        public Map<ResourceLocation, Property<?>> customProperties;

        public Factory() {
            this.layerType = GenLayerType.VANILLA.id;
            this.layerSize = 4;
            this.layerVersion = GenLayerVersion.getVersion();
            this.snowyBiomeChance = 8;
            this.endIslandOffset = 100.0f;
            this.endIslandWeight = 8.0f;
            this.endOuterIslandOffset = 100.0f;
            this.endOuterIslandDistance = 64;
            this.useEndOuterIslands = true;
            this.caveWidth = 1.0f;
            this.caveHeight = 128;
            this.caveCount = 40;
            this.caveChance = 15;
            this.useDungeons = true;
            this.dungeonChance = 8;
            this.useStrongholds = true;
            this.useVillages = true;
            this.useVillageVariants = true;
            this.useMineShafts = true;
            this.useTemples = true;
            this.useMonuments = true;
            this.useMansions = true;
            this.useRavines = true;
            this.useUnderwaterCaves = false;
            this.useWaterLakes = true;
            this.waterLakeChance = 4;
            this.useLavaLakes = true;
            this.lavaLakeChance = 80;
            this.useSandstone = true;
            this.useOldNether = false;
            this.useNetherCaves = true;
            this.useFortresses = true;
            this.useLavaPockets = true;
            this.useInfdevWalls = true;
            this.useInfdevPyramids = true;
            this.levelTheme = IndevTheme.NORMAL.id;
            this.levelType = IndevType.ISLAND.id;
            this.levelWidth = 256;
            this.levelLength = 256;
            this.levelHeight = 64;
            this.levelHouse = IndevHouse.OAK.id;
            this.useIndevCaves = true;
            this.levelCaveWidth = 1.0f;
            this.oreType = OreType.DEFAULT.id;
            this.claySize = 33;
            this.clayCount = 10;
            this.clayMinHeight = 0;
            this.clayMaxHeight = 128;
            this.dirtSize = 33;
            this.dirtCount = 20;
            this.dirtMinHeight = 0;
            this.dirtMaxHeight = 128;
            this.gravelSize = 33;
            this.gravelCount = 10;
            this.gravelMinHeight = 0;
            this.gravelMaxHeight = 128;
            this.graniteSize = 33;
            this.graniteCount = 10;
            this.graniteMinHeight = 0;
            this.graniteMaxHeight = 80;
            this.dioriteSize = 33;
            this.dioriteCount = 10;
            this.dioriteMinHeight = 0;
            this.dioriteMaxHeight = 80;
            this.andesiteSize = 33;
            this.andesiteCount = 10;
            this.andesiteMinHeight = 0;
            this.andesiteMaxHeight = 80;
            this.coalSize = 17;
            this.coalCount = 20;
            this.coalMinHeight = 0;
            this.coalMaxHeight = 128;
            this.ironSize = 9;
            this.ironCount = 20;
            this.ironMinHeight = 0;
            this.ironMaxHeight = 64;
            this.goldSize = 9;
            this.goldCount = 2;
            this.goldMinHeight = 0;
            this.goldMaxHeight = 32;
            this.redstoneSize = 8;
            this.redstoneCount = 8;
            this.redstoneMinHeight = 0;
            this.redstoneMaxHeight = 16;
            this.diamondSize = 8;
            this.diamondCount = 1;
            this.diamondMinHeight = 0;
            this.diamondMaxHeight = 16;
            this.lapisSize = 7;
            this.lapisCount = 1;
            this.lapisCenterHeight = 16;
            this.lapisSpread = 16;
            this.emeraldSize = 3;
            this.emeraldCount = 1;
            this.emeraldMinHeight = 95;
            this.emeraldMaxHeight = 128;
            this.quartzSize = 14;
            this.quartzCount = 16;
            this.magmaSize = 33;
            this.magmaCount = 4;
            this.useTallGrass = true;
            this.useNewFlowers = true;
            this.useDoublePlants = true;
            this.useLilyPads = false;
            this.useMelons = true;
            this.useDesertWells = true;
            this.useFossils = true;
            this.useSandDisks = false;
            this.useGravelDisks = false;
            this.useClayDisks = false;
            this.useBirchTrees = true;
            this.usePineTrees = true;
            this.useSwampTrees = false;
            this.useJungleTrees = false;
            this.useAcaciaTrees = false;
            this.useNewFancyOakTrees = false;
            this.spawnNewCreatureMobs = true;
            this.spawnNewMonsterMobs = true;
            this.spawnWaterMobs = true;
            this.spawnAmbientMobs = true;
            this.spawnWolves = true;
            this.desertBiomeBase = ModernBeta.createRegistryKey("beta_desert").toString();
            this.desertBiomeOcean = ModernBeta.createRegistryKey("beta_ocean").toString();
            this.desertBiomeBeach = ModernBeta.createRegistryKey("beta_desert").toString();
            this.forestBiomeBase = ModernBeta.createRegistryKey("beta_forest").toString();
            this.forestBiomeOcean = ModernBeta.createRegistryKey("beta_ocean").toString();
            this.forestBiomeBeach = ModernBeta.createRegistryKey("beta_beach").toString();
            this.iceDesertBiomeBase = ModernBeta.createRegistryKey("beta_tundra").toString();
            this.iceDesertBiomeOcean = ModernBeta.createRegistryKey("beta_frozen_ocean").toString();
            this.iceDesertBiomeBeach = ModernBeta.createRegistryKey("beta_snowy_beach").toString();
            this.plainsBiomeBase = ModernBeta.createRegistryKey("beta_plains").toString();
            this.plainsBiomeOcean = ModernBeta.createRegistryKey("beta_ocean").toString();
            this.plainsBiomeBeach = ModernBeta.createRegistryKey("beta_beach").toString();
            this.rainforestBiomeBase = ModernBeta.createRegistryKey("beta_rainforest").toString();
            this.rainforestBiomeOcean = ModernBeta.createRegistryKey("beta_ocean").toString();
            this.rainforestBiomeBeach = ModernBeta.createRegistryKey("beta_beach").toString();
            this.savannaBiomeBase = ModernBeta.createRegistryKey("beta_savanna").toString();
            this.savannaBiomeOcean = ModernBeta.createRegistryKey("beta_ocean").toString();
            this.savannaBiomeBeach = ModernBeta.createRegistryKey("beta_beach").toString();
            this.shrublandBiomeBase = ModernBeta.createRegistryKey("beta_shrubland").toString();
            this.shrublandBiomeOcean = ModernBeta.createRegistryKey("beta_ocean").toString();
            this.shrublandBiomeBeach = ModernBeta.createRegistryKey("beta_beach").toString();
            this.seasonalForestBiomeBase = ModernBeta.createRegistryKey("beta_seasonal_forest").toString();
            this.seasonalForestBiomeOcean = ModernBeta.createRegistryKey("beta_ocean").toString();
            this.seasonalForestBiomeBeach = ModernBeta.createRegistryKey("beta_beach").toString();
            this.swamplandBiomeBase = ModernBeta.createRegistryKey("beta_swampland").toString();
            this.swamplandBiomeOcean = ModernBeta.createRegistryKey("beta_ocean").toString();
            this.swamplandBiomeBeach = ModernBeta.createRegistryKey("beta_beach").toString();
            this.taigaBiomeBase = ModernBeta.createRegistryKey("beta_taiga").toString();
            this.taigaBiomeOcean = ModernBeta.createRegistryKey("beta_frozen_ocean").toString();
            this.taigaBiomeBeach = ModernBeta.createRegistryKey("beta_snowy_beach").toString();
            this.tundraBiomeBase = ModernBeta.createRegistryKey("beta_tundra").toString();
            this.tundraBiomeOcean = ModernBeta.createRegistryKey("beta_frozen_ocean").toString();
            this.tundraBiomeBeach = ModernBeta.createRegistryKey("beta_snowy_beach").toString();
            this.customProperties = new LinkedHashMap();
            ModernBetaRegistries.PROPERTY.getKeys().forEach(registryKey -> {
                Property<?> property = ModernBetaRegistries.PROPERTY.get((ResourceLocation)registryKey);
                property.visitFactory(new NewFactoryPropertyVisitor(), this, (ResourceLocation)registryKey, null);
            });
        }

        public String toString() {
            return JSON_ADAPTER.toJson((Object)this);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Factory factory = (Factory)object;
            return this.chunkSource.equals(factory.chunkSource) && this.biomeSource.equals(factory.biomeSource) && this.surfaceBuilder.equals(factory.surfaceBuilder) && this.caveCarver.equals(factory.caveCarver) && this.worldSpawner.equals(factory.worldSpawner) && this.singleBiome.equals(factory.singleBiome) && this.defaultBlock.equals(factory.defaultBlock) && this.defaultFluid.equals(factory.defaultFluid) && this.replaceOceanBiomes == factory.replaceOceanBiomes && this.replaceBeachBiomes == factory.replaceBeachBiomes && this.replaceRiverBiomes == factory.replaceRiverBiomes && Float.compare(factory.coordinateScale, this.coordinateScale) == 0 && Float.compare(factory.heightScale, this.heightScale) == 0 && Float.compare(factory.upperLimitScale, this.upperLimitScale) == 0 && Float.compare(factory.lowerLimitScale, this.lowerLimitScale) == 0 && Float.compare(factory.scaleNoiseScaleX, this.scaleNoiseScaleX) == 0 && Float.compare(factory.scaleNoiseScaleZ, this.scaleNoiseScaleZ) == 0 && Float.compare(factory.depthNoiseScaleX, this.depthNoiseScaleX) == 0 && Float.compare(factory.depthNoiseScaleZ, this.depthNoiseScaleZ) == 0 && Float.compare(factory.mainNoiseScaleX, this.mainNoiseScaleX) == 0 && Float.compare(factory.mainNoiseScaleY, this.mainNoiseScaleY) == 0 && Float.compare(factory.mainNoiseScaleZ, this.mainNoiseScaleZ) == 0 && Float.compare(factory.baseSize, this.baseSize) == 0 && Float.compare(factory.stretchY, this.stretchY) == 0 && this.seaLevel == factory.seaLevel && this.height == factory.height && Float.compare(factory.tempNoiseScale, this.tempNoiseScale) == 0 && Float.compare(factory.rainNoiseScale, this.rainNoiseScale) == 0 && Float.compare(factory.detailNoiseScale, this.detailNoiseScale) == 0 && this.snowLineOffset == factory.snowLineOffset && this.useClimateFeatures == factory.useClimateFeatures && Float.compare(factory.biomeDepthWeight, this.biomeDepthWeight) == 0 && Float.compare(factory.biomeDepthOffset, this.biomeDepthOffset) == 0 && Float.compare(factory.biomeScaleWeight, this.biomeScaleWeight) == 0 && Float.compare(factory.biomeScaleOffset, this.biomeScaleOffset) == 0 && this.useBiomeDepthScale == factory.useBiomeDepthScale && this.useAmplified == factory.useAmplified && this.biomeSize == factory.biomeSize && this.riverSize == factory.riverSize && this.layerType.equals(factory.layerType) && this.layerSize == factory.layerSize && this.layerVersion == factory.layerVersion && this.snowyBiomeChance == factory.snowyBiomeChance && Float.compare(factory.endIslandOffset, this.endIslandOffset) == 0 && Float.compare(factory.endIslandWeight, this.endIslandWeight) == 0 && Float.compare(factory.endOuterIslandOffset, this.endOuterIslandOffset) == 0 && this.endOuterIslandDistance == factory.endOuterIslandDistance && this.useEndOuterIslands == factory.useEndOuterIslands && Float.compare(factory.caveWidth, this.caveWidth) == 0 && this.caveHeight == factory.caveHeight && this.caveCount == factory.caveCount && this.caveChance == factory.caveChance && this.useDungeons == factory.useDungeons && this.dungeonChance == factory.dungeonChance && this.useStrongholds == factory.useStrongholds && this.useVillages == factory.useVillages && this.useVillageVariants == factory.useVillageVariants && this.useMineShafts == factory.useMineShafts && this.useTemples == factory.useTemples && this.useMonuments == factory.useMonuments && this.useMansions == factory.useMansions && this.useRavines == factory.useRavines && this.useUnderwaterCaves == factory.useUnderwaterCaves && this.useWaterLakes == factory.useWaterLakes && this.waterLakeChance == factory.waterLakeChance && this.useLavaLakes == factory.useLavaLakes && this.lavaLakeChance == factory.lavaLakeChance && this.useSandstone == factory.useSandstone && this.useOldNether == factory.useOldNether && this.useNetherCaves == factory.useNetherCaves && this.useFortresses == factory.useFortresses && this.useLavaPockets == factory.useLavaPockets && this.useInfdevWalls == factory.useInfdevWalls && this.useInfdevPyramids == factory.useInfdevPyramids && this.levelTheme.equals(factory.levelTheme) && this.levelType.equals(factory.levelType) && this.levelWidth == factory.levelWidth && this.levelLength == factory.levelLength && this.levelHeight == factory.levelHeight && this.levelHouse.equals(factory.levelHouse) && this.useIndevCaves == factory.useIndevCaves && Float.compare(factory.levelCaveWidth, this.levelCaveWidth) == 0 && this.oreType.equals(factory.oreType) && this.claySize == factory.claySize && this.clayCount == factory.clayCount && this.clayMinHeight == factory.clayMinHeight && this.clayMaxHeight == factory.clayMaxHeight && this.dirtSize == factory.dirtSize && this.dirtCount == factory.dirtCount && this.dirtMinHeight == factory.dirtMinHeight && this.dirtMaxHeight == factory.dirtMaxHeight && this.gravelSize == factory.gravelSize && this.gravelCount == factory.gravelCount && this.gravelMinHeight == factory.gravelMinHeight && this.gravelMaxHeight == factory.gravelMaxHeight && this.graniteSize == factory.graniteSize && this.graniteCount == factory.graniteCount && this.graniteMinHeight == factory.graniteMinHeight && this.graniteMaxHeight == factory.graniteMaxHeight && this.dioriteSize == factory.dioriteSize && this.dioriteCount == factory.dioriteCount && this.dioriteMinHeight == factory.dioriteMinHeight && this.dioriteMaxHeight == factory.dioriteMaxHeight && this.andesiteSize == factory.andesiteSize && this.andesiteCount == factory.andesiteCount && this.andesiteMinHeight == factory.andesiteMinHeight && this.andesiteMaxHeight == factory.andesiteMaxHeight && this.coalSize == factory.coalSize && this.coalCount == factory.coalCount && this.coalMinHeight == factory.coalMinHeight && this.coalMaxHeight == factory.coalMaxHeight && this.ironSize == factory.ironSize && this.ironCount == factory.ironCount && this.ironMinHeight == factory.ironMinHeight && this.ironMaxHeight == factory.ironMaxHeight && this.goldSize == factory.goldSize && this.goldCount == factory.goldCount && this.goldMinHeight == factory.goldMinHeight && this.goldMaxHeight == factory.goldMaxHeight && this.redstoneSize == factory.redstoneSize && this.redstoneCount == factory.redstoneCount && this.redstoneMinHeight == factory.redstoneMinHeight && this.redstoneMaxHeight == factory.redstoneMaxHeight && this.diamondSize == factory.diamondSize && this.diamondCount == factory.diamondCount && this.diamondMinHeight == factory.diamondMinHeight && this.diamondMaxHeight == factory.diamondMaxHeight && this.lapisSize == factory.lapisSize && this.lapisCount == factory.lapisCount && this.lapisCenterHeight == factory.lapisCenterHeight && this.lapisSpread == factory.lapisSpread && this.emeraldSize == factory.emeraldSize && this.emeraldCount == factory.emeraldCount && this.emeraldMinHeight == factory.emeraldMinHeight && this.emeraldMaxHeight == factory.emeraldMaxHeight && this.quartzSize == factory.quartzSize && this.quartzCount == factory.quartzCount && this.magmaSize == factory.magmaSize && this.magmaCount == factory.magmaCount && this.useTallGrass == factory.useTallGrass && this.useNewFlowers == factory.useNewFlowers && this.useDoublePlants == factory.useDoublePlants && this.useLilyPads == factory.useLilyPads && this.useMelons == factory.useMelons && this.useDesertWells == factory.useDesertWells && this.useFossils == factory.useFossils && this.useSandDisks == factory.useSandDisks && this.useGravelDisks == factory.useGravelDisks && this.useClayDisks == factory.useClayDisks && this.useBirchTrees == factory.useBirchTrees && this.usePineTrees == factory.usePineTrees && this.useSwampTrees == factory.useSwampTrees && this.useJungleTrees == factory.useJungleTrees && this.useAcaciaTrees == factory.useAcaciaTrees && this.useNewFancyOakTrees == factory.useNewFancyOakTrees && this.spawnNewCreatureMobs == factory.spawnNewCreatureMobs && this.spawnNewMonsterMobs == factory.spawnNewMonsterMobs && this.spawnWaterMobs == factory.spawnWaterMobs && this.spawnAmbientMobs == factory.spawnAmbientMobs && this.spawnWolves == factory.spawnWolves && this.desertBiomeBase.equals(factory.desertBiomeBase) && this.desertBiomeOcean.equals(factory.desertBiomeOcean) && this.desertBiomeBeach.equals(factory.desertBiomeBeach) && this.forestBiomeBase.equals(factory.forestBiomeBase) && this.forestBiomeOcean.equals(factory.forestBiomeOcean) && this.forestBiomeBeach.equals(factory.forestBiomeBeach) && this.iceDesertBiomeBase.equals(factory.iceDesertBiomeBase) && this.iceDesertBiomeOcean.equals(factory.iceDesertBiomeOcean) && this.iceDesertBiomeBeach.equals(factory.iceDesertBiomeBeach) && this.plainsBiomeBase.equals(factory.plainsBiomeBase) && this.plainsBiomeOcean.equals(factory.plainsBiomeOcean) && this.plainsBiomeBeach.equals(factory.plainsBiomeBeach) && this.rainforestBiomeBase.equals(factory.rainforestBiomeBase) && this.rainforestBiomeOcean.equals(factory.rainforestBiomeOcean) && this.rainforestBiomeBeach.equals(factory.rainforestBiomeBeach) && this.savannaBiomeBase.equals(factory.savannaBiomeBase) && this.savannaBiomeOcean.equals(factory.savannaBiomeOcean) && this.savannaBiomeBeach.equals(factory.savannaBiomeBeach) && this.shrublandBiomeBase.equals(factory.shrublandBiomeBase) && this.shrublandBiomeOcean.equals(factory.shrublandBiomeOcean) && this.shrublandBiomeBeach.equals(factory.shrublandBiomeBeach) && this.seasonalForestBiomeBase.equals(factory.seasonalForestBiomeBase) && this.seasonalForestBiomeOcean.equals(factory.seasonalForestBiomeOcean) && this.seasonalForestBiomeBeach.equals(factory.seasonalForestBiomeBeach) && this.swamplandBiomeBase.equals(factory.swamplandBiomeBase) && this.swamplandBiomeOcean.equals(factory.swamplandBiomeOcean) && this.swamplandBiomeBeach.equals(factory.swamplandBiomeBeach) && this.taigaBiomeBase.equals(factory.taigaBiomeBase) && this.taigaBiomeOcean.equals(factory.taigaBiomeOcean) && this.taigaBiomeBeach.equals(factory.taigaBiomeBeach) && this.tundraBiomeBase.equals(factory.tundraBiomeBase) && this.tundraBiomeOcean.equals(factory.tundraBiomeOcean) && this.tundraBiomeBeach.equals(factory.tundraBiomeBeach) && this.customProperties.equals(factory.customProperties);
        }

        public int hashCode() {
            int hashCode = this.chunkSource.hashCode();
            hashCode = 31 * hashCode + this.biomeSource.hashCode();
            hashCode = 31 * hashCode + this.surfaceBuilder.hashCode();
            hashCode = 31 * hashCode + this.caveCarver.hashCode();
            hashCode = 31 * hashCode + this.worldSpawner.hashCode();
            hashCode = 31 * hashCode + this.singleBiome.hashCode();
            hashCode = 31 * hashCode + this.defaultBlock.hashCode();
            hashCode = 31 * hashCode + this.defaultFluid.hashCode();
            hashCode = 31 * hashCode + (this.replaceOceanBiomes ? 1 : 0);
            hashCode = 31 * hashCode + (this.replaceBeachBiomes ? 1 : 0);
            hashCode = 31 * hashCode + (this.replaceRiverBiomes ? 1 : 0);
            hashCode = 31 * hashCode + (this.coordinateScale == 0.0f ? 0 : Float.floatToIntBits(this.coordinateScale));
            hashCode = 31 * hashCode + (this.heightScale == 0.0f ? 0 : Float.floatToIntBits(this.heightScale));
            hashCode = 31 * hashCode + (this.upperLimitScale == 0.0f ? 0 : Float.floatToIntBits(this.upperLimitScale));
            hashCode = 31 * hashCode + (this.lowerLimitScale == 0.0f ? 0 : Float.floatToIntBits(this.lowerLimitScale));
            hashCode = 31 * hashCode + (this.scaleNoiseScaleX == 0.0f ? 0 : Float.floatToIntBits(this.scaleNoiseScaleX));
            hashCode = 31 * hashCode + (this.scaleNoiseScaleZ == 0.0f ? 0 : Float.floatToIntBits(this.scaleNoiseScaleZ));
            hashCode = 31 * hashCode + (this.depthNoiseScaleX == 0.0f ? 0 : Float.floatToIntBits(this.depthNoiseScaleX));
            hashCode = 31 * hashCode + (this.depthNoiseScaleZ == 0.0f ? 0 : Float.floatToIntBits(this.depthNoiseScaleZ));
            hashCode = 31 * hashCode + (this.mainNoiseScaleX == 0.0f ? 0 : Float.floatToIntBits(this.mainNoiseScaleX));
            hashCode = 31 * hashCode + (this.mainNoiseScaleY == 0.0f ? 0 : Float.floatToIntBits(this.mainNoiseScaleY));
            hashCode = 31 * hashCode + (this.mainNoiseScaleZ == 0.0f ? 0 : Float.floatToIntBits(this.mainNoiseScaleZ));
            hashCode = 31 * hashCode + (this.baseSize == 0.0f ? 0 : Float.floatToIntBits(this.baseSize));
            hashCode = 31 * hashCode + (this.stretchY == 0.0f ? 0 : Float.floatToIntBits(this.stretchY));
            hashCode = 31 * hashCode + this.seaLevel;
            hashCode = 31 * hashCode + this.height;
            hashCode = 31 * hashCode + (this.tempNoiseScale == 0.0f ? 0 : Float.floatToIntBits(this.tempNoiseScale));
            hashCode = 31 * hashCode + (this.rainNoiseScale == 0.0f ? 0 : Float.floatToIntBits(this.rainNoiseScale));
            hashCode = 31 * hashCode + (this.detailNoiseScale == 0.0f ? 0 : Float.floatToIntBits(this.detailNoiseScale));
            hashCode = 31 * hashCode + this.snowLineOffset;
            hashCode = 31 * hashCode + (this.useClimateFeatures ? 1 : 0);
            hashCode = 31 * hashCode + (this.biomeDepthWeight == 0.0f ? 0 : Float.floatToIntBits(this.biomeDepthWeight));
            hashCode = 31 * hashCode + (this.biomeDepthOffset == 0.0f ? 0 : Float.floatToIntBits(this.biomeDepthOffset));
            hashCode = 31 * hashCode + (this.biomeScaleWeight == 0.0f ? 0 : Float.floatToIntBits(this.biomeScaleWeight));
            hashCode = 31 * hashCode + (this.biomeDepthOffset == 0.0f ? 0 : Float.floatToIntBits(this.biomeDepthOffset));
            hashCode = 31 * hashCode + (this.useBiomeDepthScale ? 1 : 0);
            hashCode = 31 * hashCode + (this.useAmplified ? 1 : 0);
            hashCode = 31 * hashCode + this.biomeSize;
            hashCode = 31 * hashCode + this.riverSize;
            hashCode = 31 * hashCode + this.layerType.hashCode();
            hashCode = 31 * hashCode + this.layerSize;
            hashCode = 31 * hashCode + this.layerVersion;
            hashCode = 31 * hashCode + this.snowyBiomeChance;
            hashCode = 31 * hashCode + (this.endIslandOffset == 0.0f ? 0 : Float.floatToIntBits(this.endIslandOffset));
            hashCode = 31 * hashCode + (this.endIslandWeight == 0.0f ? 0 : Float.floatToIntBits(this.endIslandWeight));
            hashCode = 31 * hashCode + (this.endOuterIslandOffset == 0.0f ? 0 : Float.floatToIntBits(this.endOuterIslandOffset));
            hashCode = 31 * hashCode + this.endOuterIslandDistance;
            hashCode = 31 * hashCode + (this.useEndOuterIslands ? 1 : 0);
            hashCode = 31 * hashCode + (this.caveWidth == 0.0f ? 0 : Float.floatToIntBits(this.caveWidth));
            hashCode = 31 * hashCode + this.caveHeight;
            hashCode = 31 * hashCode + this.caveCount;
            hashCode = 31 * hashCode + this.caveChance;
            hashCode = 31 * hashCode + (this.useDungeons ? 1 : 0);
            hashCode = 31 * hashCode + this.dungeonChance;
            hashCode = 31 * hashCode + (this.useStrongholds ? 1 : 0);
            hashCode = 31 * hashCode + (this.useVillages ? 1 : 0);
            hashCode = 31 * hashCode + (this.useVillageVariants ? 1 : 0);
            hashCode = 31 * hashCode + (this.useMineShafts ? 1 : 0);
            hashCode = 31 * hashCode + (this.useTemples ? 1 : 0);
            hashCode = 31 * hashCode + (this.useMonuments ? 1 : 0);
            hashCode = 31 * hashCode + (this.useMansions ? 1 : 0);
            hashCode = 31 * hashCode + (this.useRavines ? 1 : 0);
            hashCode = 31 * hashCode + (this.useUnderwaterCaves ? 1 : 0);
            hashCode = 31 * hashCode + (this.useWaterLakes ? 1 : 0);
            hashCode = 31 * hashCode + this.waterLakeChance;
            hashCode = 31 * hashCode + (this.useLavaLakes ? 1 : 0);
            hashCode = 31 * hashCode + this.lavaLakeChance;
            hashCode = 31 * hashCode + (this.useSandstone ? 1 : 0);
            hashCode = 31 * hashCode + (this.useOldNether ? 1 : 0);
            hashCode = 31 * hashCode + (this.useNetherCaves ? 1 : 0);
            hashCode = 31 * hashCode + (this.useFortresses ? 1 : 0);
            hashCode = 31 * hashCode + (this.useLavaPockets ? 1 : 0);
            hashCode = 31 * hashCode + (this.useInfdevWalls ? 1 : 0);
            hashCode = 31 * hashCode + (this.useInfdevPyramids ? 1 : 0);
            hashCode = 31 * hashCode + this.levelTheme.hashCode();
            hashCode = 31 * hashCode + this.levelType.hashCode();
            hashCode = 31 * hashCode + this.levelWidth;
            hashCode = 31 * hashCode + this.levelLength;
            hashCode = 31 * hashCode + this.levelHeight;
            hashCode = 31 * hashCode + this.levelHouse.hashCode();
            hashCode = 31 * hashCode + (this.useIndevCaves ? 1 : 0);
            hashCode = 31 * hashCode + (this.levelCaveWidth == 0.0f ? 0 : Float.floatToIntBits(this.levelCaveWidth));
            hashCode = 31 * hashCode + this.oreType.hashCode();
            hashCode = 31 * hashCode + this.claySize;
            hashCode = 31 * hashCode + this.clayCount;
            hashCode = 31 * hashCode + this.clayMinHeight;
            hashCode = 31 * hashCode + this.clayMaxHeight;
            hashCode = 31 * hashCode + this.dirtSize;
            hashCode = 31 * hashCode + this.dirtCount;
            hashCode = 31 * hashCode + this.dirtMinHeight;
            hashCode = 31 * hashCode + this.dirtMaxHeight;
            hashCode = 31 * hashCode + this.gravelSize;
            hashCode = 31 * hashCode + this.gravelCount;
            hashCode = 31 * hashCode + this.gravelMinHeight;
            hashCode = 31 * hashCode + this.gravelMaxHeight;
            hashCode = 31 * hashCode + this.graniteSize;
            hashCode = 31 * hashCode + this.graniteCount;
            hashCode = 31 * hashCode + this.graniteMinHeight;
            hashCode = 31 * hashCode + this.graniteMaxHeight;
            hashCode = 31 * hashCode + this.dioriteSize;
            hashCode = 31 * hashCode + this.dioriteCount;
            hashCode = 31 * hashCode + this.dioriteMinHeight;
            hashCode = 31 * hashCode + this.dioriteMaxHeight;
            hashCode = 31 * hashCode + this.andesiteSize;
            hashCode = 31 * hashCode + this.andesiteCount;
            hashCode = 31 * hashCode + this.andesiteMinHeight;
            hashCode = 31 * hashCode + this.andesiteMaxHeight;
            hashCode = 31 * hashCode + this.coalSize;
            hashCode = 31 * hashCode + this.coalCount;
            hashCode = 31 * hashCode + this.coalMinHeight;
            hashCode = 31 * hashCode + this.coalMaxHeight;
            hashCode = 31 * hashCode + this.ironSize;
            hashCode = 31 * hashCode + this.ironCount;
            hashCode = 31 * hashCode + this.ironMinHeight;
            hashCode = 31 * hashCode + this.ironMaxHeight;
            hashCode = 31 * hashCode + this.goldSize;
            hashCode = 31 * hashCode + this.goldCount;
            hashCode = 31 * hashCode + this.goldMinHeight;
            hashCode = 31 * hashCode + this.goldMaxHeight;
            hashCode = 31 * hashCode + this.redstoneSize;
            hashCode = 31 * hashCode + this.redstoneCount;
            hashCode = 31 * hashCode + this.redstoneMinHeight;
            hashCode = 31 * hashCode + this.redstoneMaxHeight;
            hashCode = 31 * hashCode + this.diamondSize;
            hashCode = 31 * hashCode + this.diamondCount;
            hashCode = 31 * hashCode + this.diamondMinHeight;
            hashCode = 31 * hashCode + this.diamondMaxHeight;
            hashCode = 31 * hashCode + this.lapisSize;
            hashCode = 31 * hashCode + this.lapisCount;
            hashCode = 31 * hashCode + this.lapisCenterHeight;
            hashCode = 31 * hashCode + this.lapisSpread;
            hashCode = 31 * hashCode + this.emeraldSize;
            hashCode = 31 * hashCode + this.emeraldCount;
            hashCode = 31 * hashCode + this.emeraldMinHeight;
            hashCode = 31 * hashCode + this.emeraldMaxHeight;
            hashCode = 31 * hashCode + this.quartzSize;
            hashCode = 31 * hashCode + this.quartzCount;
            hashCode = 31 * hashCode + this.magmaSize;
            hashCode = 31 * hashCode + this.magmaCount;
            hashCode = 31 * hashCode + (this.useTallGrass ? 1 : 0);
            hashCode = 31 * hashCode + (this.useNewFlowers ? 1 : 0);
            hashCode = 31 * hashCode + (this.useDoublePlants ? 1 : 0);
            hashCode = 31 * hashCode + (this.useLilyPads ? 1 : 0);
            hashCode = 31 * hashCode + (this.useMelons ? 1 : 0);
            hashCode = 31 * hashCode + (this.useDesertWells ? 1 : 0);
            hashCode = 31 * hashCode + (this.useFossils ? 1 : 0);
            hashCode = 31 * hashCode + (this.useSandDisks ? 1 : 0);
            hashCode = 31 * hashCode + (this.useGravelDisks ? 1 : 0);
            hashCode = 31 * hashCode + (this.useClayDisks ? 1 : 0);
            hashCode = 31 * hashCode + (this.useBirchTrees ? 1 : 0);
            hashCode = 31 * hashCode + (this.usePineTrees ? 1 : 0);
            hashCode = 31 * hashCode + (this.useSwampTrees ? 1 : 0);
            hashCode = 31 * hashCode + (this.useJungleTrees ? 1 : 0);
            hashCode = 31 * hashCode + (this.useAcaciaTrees ? 1 : 0);
            hashCode = 31 * hashCode + (this.useNewFancyOakTrees ? 1 : 0);
            hashCode = 31 * hashCode + (this.spawnNewCreatureMobs ? 1 : 0);
            hashCode = 31 * hashCode + (this.spawnNewMonsterMobs ? 1 : 0);
            hashCode = 31 * hashCode + (this.spawnWaterMobs ? 1 : 0);
            hashCode = 31 * hashCode + (this.spawnAmbientMobs ? 1 : 0);
            hashCode = 31 * hashCode + (this.spawnWolves ? 1 : 0);
            hashCode = 31 * hashCode + this.desertBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.desertBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.desertBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.forestBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.forestBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.forestBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.iceDesertBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.iceDesertBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.iceDesertBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.plainsBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.plainsBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.plainsBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.rainforestBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.rainforestBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.rainforestBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.savannaBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.savannaBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.savannaBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.shrublandBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.shrublandBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.shrublandBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.seasonalForestBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.seasonalForestBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.seasonalForestBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.swamplandBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.swamplandBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.swamplandBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.taigaBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.taigaBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.taigaBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.tundraBiomeBase.hashCode();
            hashCode = 31 * hashCode + this.tundraBiomeOcean.hashCode();
            hashCode = 31 * hashCode + this.tundraBiomeBeach.hashCode();
            hashCode = 31 * hashCode + this.customProperties.hashCode();
            return hashCode;
        }

        public ModernBetaGeneratorSettings build() {
            return new ModernBetaGeneratorSettings(this);
        }

        public static Factory jsonToFactory(String string) {
            if (string == null || string.isEmpty()) {
                return new Factory();
            }
            try {
                return (Factory)JsonUtils.func_188178_a((Gson)JSON_ADAPTER, (String)string, Factory.class);
            }
            catch (Exception e) {
                return new Factory();
            }
        }

        public static Factory jsonToFactoryChecked(String string) throws Exception {
            if (string == null || string.isEmpty()) {
                return new Factory();
            }
            return (Factory)JsonUtils.func_188178_a((Gson)JSON_ADAPTER, (String)string, Factory.class);
        }
    }
}

