/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeHolders;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeLists;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.WoodlandMansion;
import net.minecraftforge.common.BiomeManager;

public class ModernBetaStructures {
    public static final ResourceLocation VILLAGE = new ResourceLocation("village");
    public static final ResourceLocation STRONGHOLD = new ResourceLocation("stronghold");
    public static final ResourceLocation MINESHAFT = new ResourceLocation("mineshaft");
    public static final ResourceLocation MONUMENT = new ResourceLocation("monument");
    public static final ResourceLocation MANSION = new ResourceLocation("mansion");
    public static final ResourceLocation TEMPLE = new ResourceLocation("temple");

    public static void register() {
        for (Biome biome : ModernBetaBiomeLists.BETA_BIOMES) {
            if (biome == ModernBetaBiomeHolders.BETA_OCEAN || biome == ModernBetaBiomeHolders.BETA_FROZEN_OCEAN) continue;
            ModernBetaStructures.addStrongholdBiome(biome);
        }
        ModernBetaStructures.addVillageBiome(ModernBetaBiomeHolders.BETA_DESERT);
        ModernBetaStructures.addVillageBiome(ModernBetaBiomeHolders.BETA_SAVANNA);
        ModernBetaStructures.addVillageBiome(ModernBetaBiomeHolders.BETA_SHRUBLAND);
        ModernBetaStructures.addVillageBiome(ModernBetaBiomeHolders.BETA_TAIGA);
        ModernBetaStructures.addVillageBiome(ModernBetaBiomeHolders.BETA_ICE_DESERT);
        ModernBetaStructures.addVillageBiome(ModernBetaBiomeHolders.BETA_SKY);
        for (Biome biome : ModernBetaBiomeLists.ALPHA_BIOMES) {
            ModernBetaStructures.addStrongholdBiome(biome);
            ModernBetaStructures.addVillageBiome(biome);
        }
        for (Biome biome : ModernBetaBiomeLists.INFDEV_BIOMES) {
            ModernBetaStructures.addStrongholdBiome(biome);
            ModernBetaStructures.addVillageBiome(biome);
        }
        for (Biome biome : ModernBetaBiomeLists.INDEV_BIOMES) {
            ModernBetaStructures.addStrongholdBiome(biome);
            ModernBetaStructures.addVillageBiome(biome);
        }
    }

    public static ChunkPos getFiniteStrongholdPosition(FiniteChunkSource chunkSource) {
        Random random = new Random(chunkSource.getSeed());
        int chunkWidth = chunkSource.getLevelWidth() >> 4;
        int chunkLength = chunkSource.getLevelLength() >> 4;
        int buffer = Math.min(Math.min(chunkWidth, chunkLength) / 2, 4);
        int chunkX = MathHelper.func_76125_a((int)random.nextInt(chunkWidth), (int)buffer, (int)(chunkWidth - buffer)) - chunkWidth / 2;
        int chunkZ = MathHelper.func_76125_a((int)random.nextInt(chunkLength), (int)buffer, (int)(chunkWidth - buffer)) - chunkLength / 2;
        return new ChunkPos(chunkX, chunkZ);
    }

    private static void addStrongholdBiome(Biome biome) {
        BiomeManager.addStrongholdBiome((Biome)biome);
    }

    private static void addVillageBiome(Biome biome) {
        BiomeManager.addVillageBiome((Biome)biome, (boolean)false);
    }

    static {
        StructureOceanMonument.field_175802_d = new ArrayList(StructureOceanMonument.field_175802_d);
        StructureOceanMonument.field_175802_d.addAll(Arrays.asList(ModernBetaBiomeHolders.BETA_FROZEN_OCEAN, ModernBetaBiomeHolders.BETA_OCEAN));
        StructureOceanMonument.field_186134_b = new ArrayList(StructureOceanMonument.field_186134_b);
        StructureOceanMonument.field_186134_b.addAll(Arrays.asList(ModernBetaBiomeHolders.BETA_OCEAN));
        WoodlandMansion.field_191072_a = new ArrayList(WoodlandMansion.field_191072_a);
        WoodlandMansion.field_191072_a.addAll(Arrays.asList(ModernBetaBiomeHolders.BETA_SEASONAL_FOREST));
        MapGenScatteredFeature.field_75061_e = new ArrayList(MapGenScatteredFeature.field_75061_e);
        MapGenScatteredFeature.field_75061_e.addAll(Arrays.asList(ModernBetaBiomeHolders.BETA_DESERT, ModernBetaBiomeHolders.BETA_RAINFOREST, ModernBetaBiomeHolders.BETA_SWAMPLAND, ModernBetaBiomeHolders.BETA_TUNDRA, ModernBetaBiomeHolders.BETA_TAIGA));
    }
}

