/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.client.gui.GuiCustomizePreset;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaClientRegistries;
import mod.bespectacled.modernbetaforge.client.gui.GuiBoundsChecker;
import mod.bespectacled.modernbetaforge.client.gui.GuiCustomizePresetsDataHandler;
import mod.bespectacled.modernbetaforge.client.gui.GuiScreenCustomizeWorld;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.util.SoundUtil;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenCustomizePresets
extends GuiScreen {
    private static final ResourceLocation SCROLL_UP = ModernBeta.createRegistryKey("textures/gui/scroll_up.png");
    private static final ResourceLocation SCROLL_DOWN = ModernBeta.createRegistryKey("textures/gui/scroll_down.png");
    private static final ResourceLocation KZ = new ResourceLocation("textures/painting/paintings_kristoffer_zetterstrand.png");
    private static final ResourceLocation UNKNOWN_PACK = new ResourceLocation("textures/misc/unknown_pack.png");
    private static final IconTexture[] ICON_TEXTURES = new IconTexture[]{new IconTexture(UNKNOWN_PACK), new IconTexture(ModernBeta.createRegistryKey("textures/gui/presets/pack.png")), new IconTexture(new ResourceLocation("textures/blocks/grass_side.png")), new IconTexture(new ResourceLocation("textures/blocks/dirt.png")), new IconTexture(new ResourceLocation("textures/blocks/sand.png")), new IconTexture(new ResourceLocation("textures/blocks/gravel.png")), new IconTexture(new ResourceLocation("textures/blocks/stone.png")), new IconTexture(new ResourceLocation("textures/blocks/cobblestone.png")), new IconTexture(new ResourceLocation("textures/blocks/log_oak.png")), new IconTexture(new ResourceLocation("textures/blocks/planks_oak.png")), new IconTexture(new ResourceLocation("textures/blocks/coal_ore.png")), new IconTexture(new ResourceLocation("textures/blocks/iron_ore.png")), new IconTexture(new ResourceLocation("textures/blocks/gold_ore.png")), new IconTexture(new ResourceLocation("textures/blocks/redstone_ore.png")), new IconTexture(new ResourceLocation("textures/blocks/diamond_ore.png")), new IconTexture(new ResourceLocation("textures/blocks/lapis_ore.png")), new IconTexture(new ResourceLocation("textures/blocks/obsidian.png")), new IconTexture(new ResourceLocation("textures/blocks/netherrack.png")), new IconTexture(new ResourceLocation("textures/blocks/glowstone.png")), new IconTexture(new ResourceLocation("textures/blocks/end_stone.png")), new IconTexture(new ResourceLocation("textures/blocks/sponge.png")), new IconTexture(new ResourceLocation("textures/blocks/tnt_side.png")), new IconTexture(new ResourceLocation("textures/blocks/pumpkin_face_off.png")), new IconTexture(new ResourceLocation("textures/entity/steve.png"), 0.125, 0.125, 0.125), new IconTexture(new ResourceLocation("textures/entity/alex.png"), 0.125, 0.125, 0.125), new IconTexture(new ResourceLocation("textures/entity/zombie/zombie.png"), 0.125, 0.125, 0.125), new IconTexture(new ResourceLocation("textures/entity/skeleton/skeleton.png"), 0.125, 0.25, 0.125, 0.25), new IconTexture(new ResourceLocation("textures/entity/creeper/creeper.png"), 0.125, 0.25, 0.125, 0.25), new IconTexture(KZ, 0.0, 0.0, 0.0625), new IconTexture(KZ, 0.0625, 0.0, 0.0625), new IconTexture(KZ, 0.125, 0.0, 0.0625), new IconTexture(KZ, 0.1875, 0.0, 0.0625), new IconTexture(KZ, 0.25, 0.0, 0.0625), new IconTexture(KZ, 0.3125, 0.0, 0.0625), new IconTexture(KZ, 0.375, 0.0, 0.0625), new IconTexture(KZ, 0.0, 0.0, 0.0625), new IconTexture(KZ, 0.0, 0.5, 0.125), new IconTexture(KZ, 0.125, 0.5, 0.125), new IconTexture(KZ, 0.25, 0.5, 0.125), new IconTexture(KZ, 0.375, 0.5, 0.125), new IconTexture(KZ, 0.5, 0.5, 0.125), new IconTexture(KZ, 0.625, 0.5, 0.125), new IconTexture(KZ, 0.0, 0.75, 0.25), new IconTexture(KZ, 0.25, 0.75, 0.25), new IconTexture(KZ, 0.5, 0.75, 0.25)};
    private static final String PREFIX = "createWorld.customize.presets.modernbetaforge.";
    private static final String PREFIX_FILTER = "createWorld.customize.presets.modernbetaforge.filter";
    private static final int SLOT_HEIGHT = 32;
    private static final int SLOT_PADDING = 6;
    private static final int MAX_PRESET_DESC_LINE_LENGTH = 188;
    private static final int MAX_PRESET_NAME_LENGTH = 30;
    private static final int MAX_PRESET_DESC_LENGTH = 60;
    private static final int MODAL_WIDTH = 160;
    private static final int MODAL_HEIGHT = 100;
    private static final int MODAL_WIDTH_SMALL = 112;
    private static final int MODAL_HEIGHT_SMALL = 62;
    private static final int MODAL_NAME_FIELD_LENGTH = 220;
    private static final int MODAL_DESC_FIELD_LENGTH = 220;
    private static final int MODAL_SETTINGS_FIELD_LENGTH = 300;
    private static final int MODAL_ICON_PADDING_R = 20;
    private static final int MODAL_ICON_PADDING_T = 36;
    private static final int MODAL_ICON_SIZE = 50;
    private static final int SCROLL_TEXTURE_SIZE_W = 13;
    private static final int SCROLL_TEXTURE_SIZE_H = 9;
    private static final int BUTTON_SMALL_SPACE = 4;
    private static final int BUTTON_SMALL_WIDTH = 80;
    private static final int BUTTON_LARGE_WIDTH = 164;
    private static final int GUI_ID_FILTER = 0;
    private static final int GUI_ID_SELECT = 1;
    private static final int GUI_ID_CANCEL = 2;
    private static final int GUI_ID_SAVE = 3;
    private static final int GUI_ID_EDIT = 4;
    private static final int GUI_ID_DELETE = 5;
    private static final int GUI_ID_EXPORT = 6;
    private static final int GUI_ID_MODAL_CONFIRM = 10;
    private static final int GUI_ID_MODAL_CANCEL = 11;
    private static final int GUI_ID_MODAL_NAME = 12;
    private static final int GUI_ID_MODAL_DESC = 13;
    private static final int GUI_ID_MODAL_SETTINGS = 14;
    private static final int GUI_ID_MODAL_NEXT = 15;
    private static final int GUI_ID_MODAL_PREV = 16;
    private final GuiScreenCustomizeWorld parent;
    private final FilterType filterType;
    private final GuiCustomizePresetsDataHandler dataHandler;
    private final List<Info> presets;
    private final int initialPreset;
    private final GuiBoundsChecker iconBounds;
    protected String title = I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.title", (Object[])new Object[0]);
    private ListPreset list;
    private GuiTextField fieldExport;
    private GuiTextField fieldModalName;
    private GuiTextField fieldModalDesc;
    private GuiTextField fieldModalSettings;
    private GuiButton buttonSave;
    private GuiButton buttonEdit;
    private GuiButton buttonDelete;
    private GuiButton buttonFilter;
    private GuiButton buttonSelect;
    private GuiButton buttonCancel;
    private GuiButton buttonModalConfirm;
    private GuiButton buttonModalCancel;
    private GuiButton buttonModalPrev;
    private GuiButton buttonModalNext;
    private int selectedIcon;
    private String shareText;
    private int hoveredElement;
    private long hoveredTime;
    private ModalState modalState;
    private long confirmExitTime;

    public GuiScreenCustomizePresets(GuiScreenCustomizeWorld parent) {
        this(parent, ModernBetaConfig.guiOptions.defaultPresetFilter, -1);
    }

    public GuiScreenCustomizePresets(GuiScreenCustomizeWorld parent, FilterType filterType, int initialPreset) {
        this.parent = parent;
        this.filterType = filterType;
        this.dataHandler = new GuiCustomizePresetsDataHandler();
        this.presets = this.loadPresets(filterType, this.dataHandler);
        this.initialPreset = initialPreset;
        this.iconBounds = new GuiBoundsChecker();
        this.hoveredElement = -1;
        this.modalState = ModalState.NONE;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        int modalWidth = this.modalState == ModalState.DELETE || this.modalState == ModalState.OVERWRITE ? 112 : 160;
        int modalHeight = this.modalState == ModalState.DELETE || this.modalState == ModalState.OVERWRITE ? 62 : 100;
        int boxL = centerX + modalWidth - 50 - 1 - 20;
        int boxR = centerX + modalWidth - 0 - 20;
        int boxT = centerY - modalHeight - 0 + 36;
        int boxB = centerY - modalHeight + 50 + 1 + 36;
        int selectX = centerX + 2;
        int filterX = centerX + 2;
        int cancelX = centerX + 80 + 164 - 160 + 2;
        int saveX = centerX - 164 - 2;
        int editX = centerX - 164 - 2;
        int deleteX = centerX - 80 - 2;
        this.field_146292_n.clear();
        this.buttonSelect = this.func_189646_b(new GuiButton(1, selectX, this.field_146295_m - 50, 164, 20, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.select", (Object[])new Object[0])));
        this.buttonFilter = this.func_189646_b(new GuiButton(0, filterX, this.field_146295_m - 27, 80, 20, this.getFilterText()));
        this.buttonCancel = this.func_189646_b(new GuiButton(2, cancelX, this.field_146295_m - 27, 80, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.buttonSave = this.func_189646_b(new GuiButton(3, saveX, this.field_146295_m - 50, 164, 20, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.save", (Object[])new Object[0])));
        this.buttonEdit = this.func_189646_b(new GuiButton(4, editX, this.field_146295_m - 27, 80, 20, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.edit", (Object[])new Object[0])));
        this.buttonDelete = this.func_189646_b(new GuiButton(5, deleteX, this.field_146295_m - 27, 80, 20, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.delete", (Object[])new Object[0])));
        this.shareText = I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.share", (Object[])new Object[0]);
        this.list = this.list != null ? new ListPreset(this, this.list.selected) : new ListPreset(this, this.initialPreset);
        int slotHeight = 38;
        int slotSelected = this.list.selected;
        int slotsDisplayed = (this.list.field_148158_l - 66 - 54) / slotHeight;
        if (slotSelected > slotsDisplayed - 1) {
            this.list.func_148145_f(slotHeight * (slotSelected - slotsDisplayed) + slotHeight * slotsDisplayed);
        }
        String initialExportText = this.getInitialExportText();
        String initialModalNameText = this.fieldModalName != null ? this.fieldModalName.func_146179_b() : "";
        String initialModalDescText = this.fieldModalDesc != null ? this.fieldModalDesc.func_146179_b() : "";
        String intialModalSettingsText = this.fieldModalSettings != null ? this.fieldModalSettings.func_146179_b() : initialExportText;
        this.fieldExport = this.createInitialField(this.fieldExport, 6, 50, 40, this.field_146294_l - 100, 20, initialExportText, 25000);
        this.buttonModalConfirm = this.func_189646_b(new GuiButton(10, centerX - 62, centerY + modalHeight - 25, 60, 20, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.confirm", (Object[])new Object[0])));
        this.buttonModalCancel = this.func_189646_b(new GuiButton(11, centerX + 2, centerY + modalHeight - 25, 60, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.buttonModalPrev = this.func_189646_b(new GuiButton(16, boxL + 5, boxB + 5, 20, 20, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.prev", (Object[])new Object[0])));
        this.buttonModalNext = this.func_189646_b(new GuiButton(15, boxR - 23, boxB + 5, 20, 20, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.next", (Object[])new Object[0])));
        this.fieldModalName = this.createInitialField(this.fieldModalName, 12, centerX - modalWidth + 10, centerY - 50, 220, 20, initialModalNameText, 30);
        this.fieldModalDesc = this.createInitialField(this.fieldModalDesc, 13, centerX - modalWidth + 10, centerY - 10, 220, 20, initialModalDescText, 60);
        this.fieldModalSettings = this.createInitialField(this.fieldModalSettings, 14, centerX - modalWidth + 10, centerY + 30, 300, 20, intialModalSettingsText, 25000);
        this.iconBounds.updateBounds(boxL + 1, boxT + 1, 50, 50);
        this.updateButtonValidity();
    }

    public void func_146274_d() throws IOException {
        int dWheel;
        int mouseY;
        int mouseX;
        super.func_146274_d();
        if (this.canInteract() && this.modalState == ModalState.NONE) {
            this.list.func_178039_p();
        }
        if (this.iconBounds.inBounds(mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c, mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1) && Mouse.hasWheel() && (dWheel = Mouse.getEventDWheel()) != 0) {
            this.incrementSelectedIcon(dWheel < 0 ? -1 : 1);
            this.updateButtonValidity();
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 12, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.shareText, 50, 30, 0xA0A0A0);
        this.fieldExport.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.modalState != ModalState.NONE) {
            Info selectedPreset = this.presets.size() > 0 ? this.presets.get(this.list.selected > -1 ? this.list.selected : 0) : new Info();
            Gui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)Integer.MIN_VALUE);
            int centerX = this.field_146294_l / 2;
            int centerY = this.field_146295_m / 2;
            int modalWidth = this.modalState == ModalState.DELETE || this.modalState == ModalState.OVERWRITE ? 112 : 160;
            int modalHeight = this.modalState == ModalState.DELETE || this.modalState == ModalState.OVERWRITE ? 62 : 100;
            this.func_73730_a(centerX - modalWidth - 1, centerX + modalWidth, centerY - modalHeight - 1, -2039584);
            this.func_73730_a(centerX - modalWidth - 1, centerX + modalWidth, centerY + modalHeight, -6250336);
            this.func_73728_b(centerX - modalWidth - 1, centerY - modalHeight - 1, centerY + modalHeight, -2039584);
            this.func_73728_b(centerX + modalWidth, centerY - modalHeight - 1, centerY + modalHeight, -6250336);
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            this.field_146297_k.func_110434_K().func_110577_a(GuiScreenCustomizeWorld.field_110325_k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferBuilder.func_181662_b((double)(centerX - modalWidth), (double)(centerY + modalHeight), 0.0).func_187315_a(0.0, 2.65625).func_181669_b(64, 64, 64, 64).func_181675_d();
            bufferBuilder.func_181662_b((double)(centerX + modalWidth), (double)(centerY + modalHeight), 0.0).func_187315_a(5.625, 2.65625).func_181669_b(64, 64, 64, 64).func_181675_d();
            bufferBuilder.func_181662_b((double)(centerX + modalWidth), (double)(centerY - modalHeight), 0.0).func_187315_a(5.625, 0.0).func_181669_b(64, 64, 64, 64).func_181675_d();
            bufferBuilder.func_181662_b((double)(centerX - modalWidth), (double)(centerY - modalHeight), 0.0).func_187315_a(0.0, 0.0).func_181669_b(64, 64, 64, 64).func_181675_d();
            tessellator.func_78381_a();
            String confirmTitle = "";
            switch (this.modalState) {
                case SAVE: {
                    confirmTitle = I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.save.title", (Object[])new Object[0]);
                    this.drawSaveScreen(centerX, centerY, modalWidth, modalHeight, mouseX, mouseY);
                    break;
                }
                case EDIT: {
                    confirmTitle = I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.edit.title", (Object[])new Object[0]);
                    this.drawSaveScreen(centerX, centerY, modalWidth, modalHeight, mouseX, mouseY);
                    break;
                }
                case DELETE: {
                    confirmTitle = I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.delete.title", (Object[])new Object[0]);
                    this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.delete.confirm", (Object[])new Object[0]), centerX, centerY - 16, 0xFFA0A0);
                    this.func_73732_a(this.field_146289_q, selectedPreset.name, centerX, centerY + 2, 0xFFFFFF);
                    break;
                }
                case OVERWRITE: {
                    confirmTitle = I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.overwrite.title", (Object[])new Object[0]);
                    this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.overwrite.confirm", (Object[])new Object[0]), centerX, centerY - 16, 0xFFA0A0);
                    this.func_73732_a(this.field_146289_q, this.fieldModalName.func_146179_b(), centerX, centerY + 2, 0xFFFFFF);
                    break;
                }
            }
            this.func_73732_a(this.field_146289_q, confirmTitle, centerX, centerY - modalHeight + 10, 0xFFFFFF);
            this.buttonModalConfirm.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.buttonModalCancel.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.buttonModalPrev.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.buttonModalNext.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
    }

    public void func_73876_c() {
        this.fieldExport.func_146178_a();
        this.fieldModalName.func_146178_a();
        this.fieldModalDesc.func_146178_a();
        this.fieldModalSettings.func_146178_a();
        super.func_73876_c();
    }

    public void updateButtonValidity() {
        boolean editable = this.list.selected > -1 && this.presets.get((int)this.list.selected).custom;
        this.buttonSave.field_146124_l = false;
        this.buttonEdit.field_146124_l = false;
        this.buttonDelete.field_146124_l = false;
        this.buttonSelect.field_146124_l = false;
        this.buttonFilter.field_146124_l = false;
        this.buttonCancel.field_146124_l = false;
        this.buttonModalConfirm.field_146125_m = false;
        this.buttonModalCancel.field_146125_m = false;
        this.buttonModalPrev.field_146125_m = false;
        this.buttonModalNext.field_146125_m = false;
        this.buttonModalConfirm.field_146124_l = false;
        this.buttonModalCancel.field_146124_l = false;
        this.buttonModalPrev.field_146124_l = false;
        this.buttonModalNext.field_146124_l = false;
        this.fieldModalName.func_146189_e(false);
        this.fieldModalDesc.func_146189_e(false);
        this.fieldModalSettings.func_146189_e(false);
        switch (this.modalState) {
            case NONE: {
                this.buttonSave.field_146124_l = true;
                this.buttonEdit.field_146124_l = editable;
                this.buttonDelete.field_146124_l = editable;
                this.buttonSelect.field_146124_l = this.hasValidSelection();
                this.buttonFilter.field_146124_l = true;
                this.buttonCancel.field_146124_l = true;
                break;
            }
            case OVERWRITE: {
                this.buttonModalConfirm.field_146125_m = true;
                this.buttonModalCancel.field_146125_m = true;
                this.buttonModalConfirm.field_146124_l = true;
                this.buttonModalCancel.field_146124_l = true;
                break;
            }
            case SAVE: 
            case EDIT: {
                this.buttonModalConfirm.field_146125_m = true;
                this.buttonModalCancel.field_146125_m = true;
                this.buttonModalPrev.field_146125_m = true;
                this.buttonModalNext.field_146125_m = true;
                this.buttonModalConfirm.field_146124_l = !this.fieldModalName.func_146179_b().isEmpty();
                this.buttonModalCancel.field_146124_l = true;
                this.buttonModalPrev.field_146124_l = this.selectedIcon > 0;
                this.buttonModalNext.field_146124_l = this.selectedIcon < ICON_TEXTURES.length - 1;
                this.fieldModalName.func_146189_e(true);
                this.fieldModalDesc.func_146189_e(true);
                this.fieldModalSettings.func_146189_e(true);
                break;
            }
            case DELETE: {
                this.buttonModalConfirm.field_146125_m = true;
                this.buttonModalCancel.field_146125_m = true;
                this.buttonModalConfirm.field_146124_l = true;
                this.buttonModalCancel.field_146124_l = true;
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int clicked) throws IOException {
        super.func_73864_a(mouseX, mouseY, clicked);
        switch (this.modalState) {
            case NONE: {
                this.fieldExport.func_146192_a(mouseX, mouseY, clicked);
                break;
            }
            case SAVE: 
            case EDIT: {
                this.fieldModalName.func_146192_a(mouseX, mouseY, clicked);
                this.fieldModalDesc.func_146192_a(mouseX, mouseY, clicked);
                this.fieldModalSettings.func_146192_a(mouseX, mouseY, clicked);
                break;
            }
        }
        this.updateButtonValidity();
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        boolean fieldTyped;
        boolean bl = fieldTyped = this.fieldExport.func_146201_a(character, keyCode) || this.fieldModalName.func_146201_a(character, keyCode) || this.fieldModalDesc.func_146201_a(character, keyCode) || this.fieldModalSettings.func_146201_a(character, keyCode);
        if (!fieldTyped) {
            switch (this.modalState) {
                case SAVE: 
                case EDIT: 
                case DELETE: 
                case OVERWRITE: {
                    if (keyCode == 1) {
                        this.updateModalState(ModalState.NONE);
                        this.updateModalButtons(ModalState.NONE);
                        break;
                    }
                }
                default: {
                    super.func_73869_a(character, keyCode);
                }
            }
        }
        this.updateButtonValidity();
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        Info selectedPreset = this.presets.size() > 0 ? this.presets.get(this.list.selected > -1 ? this.list.selected : 0) : new Info();
        int amount = GuiScreen.func_146272_n() ? 5 : 1;
        block0 : switch (guiButton.field_146127_k) {
            case 0: {
                FilterType[] values = FilterType.values();
                int increment = GuiScreen.func_146272_n() ? -1 : 1;
                int index = this.filterType.ordinal() + increment;
                if (index < 0) {
                    index = values.length - 1;
                }
                FilterType filterType = values[index % values.length];
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizePresets(this.parent, filterType, -1));
                break;
            }
            case 1: {
                this.parent.loadValues(this.fieldExport.func_146179_b());
                this.parent.isSettingsModified();
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                break;
            }
            case 2: {
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                break;
            }
            case 3: {
                this.fieldModalName.func_146180_a("");
                this.fieldModalDesc.func_146180_a("");
                this.fieldModalSettings.func_146180_a(this.getInitialExportText());
                this.selectedIcon = 0;
                this.updateModalState(ModalState.SAVE);
                break;
            }
            case 4: {
                this.fieldModalName.func_146180_a(selectedPreset.name);
                this.fieldModalDesc.func_146180_a(selectedPreset.desc);
                this.fieldModalSettings.func_146180_a(selectedPreset.settings.toString());
                this.selectedIcon = MathHelper.func_76125_a((int)this.dataHandler.getPreset((String)selectedPreset.name).icon, (int)0, (int)(ICON_TEXTURES.length - 1));
                this.updateModalState(ModalState.EDIT);
                break;
            }
            case 5: {
                this.updateModalState(ModalState.DELETE);
                break;
            }
            case 10: {
                switch (this.modalState) {
                    case SAVE: {
                        if (this.dataHandler.containsPreset(this.fieldModalName.func_146179_b())) {
                            this.updateModalState(ModalState.OVERWRITE);
                            break block0;
                        }
                        this.dataHandler.addPreset(this.selectedIcon, this.fieldModalName.func_146179_b(), this.fieldModalDesc.func_146179_b(), this.fieldModalSettings.func_146179_b());
                        this.dataHandler.writePresets();
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizePresets(this.parent, this.filterType, this.presets.size()));
                        break block0;
                    }
                    case DELETE: {
                        this.dataHandler.removePreset(selectedPreset.name);
                        this.dataHandler.writePresets();
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizePresets(this.parent, this.filterType, this.list.selected - 1));
                        break block0;
                    }
                    case EDIT: {
                        this.dataHandler.replacePreset(this.selectedIcon, selectedPreset.name, this.fieldModalName.func_146179_b(), this.fieldModalDesc.func_146179_b(), this.fieldModalSettings.func_146179_b());
                        this.dataHandler.writePresets();
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizePresets(this.parent, this.filterType, this.list.selected));
                        break block0;
                    }
                    case OVERWRITE: {
                        int ndx = this.dataHandler.replacePreset(this.selectedIcon, this.fieldModalName.func_146179_b(), this.fieldModalName.func_146179_b(), this.fieldModalDesc.func_146179_b(), this.fieldModalSettings.func_146179_b());
                        this.dataHandler.writePresets();
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizePresets(this.parent, this.filterType, this.presets.size() - this.dataHandler.getPresets().size() + ndx));
                        break block0;
                    }
                }
                break;
            }
            case 16: {
                this.incrementSelectedIcon(-amount);
                break;
            }
            case 15: {
                this.incrementSelectedIcon(amount);
                break;
            }
            case 11: {
                this.updateModalState(ModalState.NONE);
            }
        }
        this.updateModalButtons(this.modalState);
        this.updateButtonValidity();
    }

    private void drawSaveScreen(int centerX, int centerY, int modalWidth, int modalHeight, int mouseX, int mouseY) {
        IconTexture icon = ICON_TEXTURES[this.selectedIcon];
        int textStartX = centerX - modalWidth + 10;
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.name", (Object[])new Object[0]), textStartX, centerY - 60, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.desc", (Object[])new Object[0]), textStartX, centerY - 20, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.presets.modernbetaforge.settings", (Object[])new Object[0]), textStartX, centerY + 20, 0xA0A0A0);
        this.fieldModalName.func_146194_f();
        this.fieldModalDesc.func_146194_f();
        this.fieldModalSettings.func_146194_f();
        String nameNumChars = String.format("%d", 30 - this.fieldModalName.func_146179_b().length());
        String descNumChars = String.format("%d", 60 - this.fieldModalDesc.func_146179_b().length());
        String settingsNumChars = String.format("%d", 25000 - this.fieldModalSettings.func_146179_b().length());
        int nameNumCharsLen = this.field_146289_q.func_78256_a(nameNumChars);
        int descNumCharsLen = this.field_146289_q.func_78256_a(descNumChars);
        int settingsNumCharsLen = this.field_146289_q.func_78256_a(settingsNumChars);
        int nameNumCharsCol = 30 - this.fieldModalName.func_146179_b().length() > 4 ? 0xA0A0A0 : 0xFFA0A0;
        int descNumCharsCol = 60 - this.fieldModalDesc.func_146179_b().length() > 4 ? 0xA0A0A0 : 0xFFA0A0;
        int settingsNumCharsCol = 25000 - this.fieldModalSettings.func_146179_b().length() > 100 ? 0xA0A0A0 : 0xFFA0A0;
        this.func_73731_b(this.field_146289_q, nameNumChars, textStartX + 220 - nameNumCharsLen, centerY - 60, nameNumCharsCol);
        this.func_73731_b(this.field_146289_q, descNumChars, textStartX + 220 - descNumCharsLen, centerY - 20, descNumCharsCol);
        this.func_73731_b(this.field_146289_q, settingsNumChars, textStartX + 300 - settingsNumCharsLen, centerY + 20, settingsNumCharsCol);
        int boxL = centerX + modalWidth - 50 - 1 - 20;
        int boxR = centerX + modalWidth - 0 - 20;
        int boxT = centerY - modalHeight - 0 + 36;
        int boxB = centerY - modalHeight + 50 + 1 + 36;
        String iconText = String.format("%d/%d", this.selectedIcon + 1, ICON_TEXTURES.length);
        this.func_73732_a(this.field_146289_q, iconText, boxL + 25 + 1, boxT - 10, 0xA0A0A0);
        this.func_73730_a(boxL, boxR, boxT, -2039584);
        this.func_73730_a(boxL, boxR, boxB, -6250336);
        this.func_73728_b(boxL, boxT, boxB, -2039584);
        this.func_73728_b(boxR, boxT, boxB, -6250336);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(icon.identifier);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)(boxL + 1), (double)boxB, 0.0).func_187315_a(icon.u, icon.v + icon.h).func_181675_d();
        bufferBuilder.func_181662_b((double)boxR, (double)boxB, 0.0).func_187315_a(icon.u + icon.w, icon.v + icon.h).func_181675_d();
        bufferBuilder.func_181662_b((double)boxR, (double)(boxT + 1), 0.0).func_187315_a(icon.u + icon.w, icon.v).func_181675_d();
        bufferBuilder.func_181662_b((double)(boxL + 1), (double)(boxT + 1), 0.0).func_187315_a(icon.u, icon.v).func_181675_d();
        tessellator.func_78381_a();
        if (this.iconBounds.inBounds(mouseX, mouseY) && Mouse.hasWheel()) {
            int offsetX = 6;
            int offsetY = 12;
            int scrollL = mouseX + offsetX;
            int scrollR = mouseX + 13 + offsetX;
            int scrollT = mouseY - offsetY;
            int scrollB = mouseY + 9 - offsetY;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.selectedIcon < ICON_TEXTURES.length - 1) {
                this.field_146297_k.func_110434_K().func_110577_a(SCROLL_UP);
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferBuilder.func_181662_b((double)scrollL, (double)scrollB, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                bufferBuilder.func_181662_b((double)scrollR, (double)scrollB, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                bufferBuilder.func_181662_b((double)scrollR, (double)scrollT, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                bufferBuilder.func_181662_b((double)scrollL, (double)scrollT, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
            }
            if (this.selectedIcon > 0) {
                this.field_146297_k.func_110434_K().func_110577_a(SCROLL_DOWN);
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferBuilder.func_181662_b((double)scrollL, (double)(scrollB += 10), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                bufferBuilder.func_181662_b((double)scrollR, (double)scrollB, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                bufferBuilder.func_181662_b((double)scrollR, (double)(scrollT += 10), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                bufferBuilder.func_181662_b((double)scrollL, (double)scrollT, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
            }
        }
    }

    private List<Info> loadPresets(FilterType filterType, GuiCustomizePresetsDataHandler dataHandler) {
        ModernBetaGeneratorSettings.Factory factory;
        IconTexture texture;
        String desc;
        String name;
        ArrayList<Info> presets = new ArrayList<Info>();
        List filteredKeys = ModernBetaClientRegistries.GUI_PRESET.getKeys().stream().filter(key -> {
            switch (filterType) {
                case ALL: {
                    return true;
                }
                case BUILTIN: {
                    return key.func_110624_b().equals("modernbetaforge");
                }
                case ADDON: {
                    return !key.func_110624_b().equals("modernbetaforge");
                }
                case CUSTOM: {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        for (ResourceLocation key2 : filteredKeys) {
            GuiCustomizePreset preset = ModernBetaClientRegistries.GUI_PRESET.get(key2);
            name = GuiCustomizePreset.formatName(key2);
            desc = GuiCustomizePreset.formatInfo(key2);
            texture = new IconTexture(GuiCustomizePreset.formatTexture(key2));
            factory = ModernBetaGeneratorSettings.Factory.jsonToFactory(preset.settings);
            presets.add(new Info(name, desc, texture, factory, false));
        }
        if (filterType == FilterType.ALL || filterType == FilterType.CUSTOM) {
            for (GuiCustomizePresetsDataHandler.PresetData presetData : dataHandler.getPresets()) {
                name = presetData.name;
                desc = presetData.desc;
                texture = ICON_TEXTURES[MathHelper.func_76125_a((int)presetData.icon, (int)0, (int)(ICON_TEXTURES.length - 1))];
                factory = ModernBetaGeneratorSettings.Factory.jsonToFactory(presetData.settings);
                presets.add(new Info(name, desc, texture, factory, true));
            }
        }
        return presets;
    }

    private GuiTextField createInitialField(GuiTextField textField, int id, int x, int y, int width, int height, String initialText, int maxLength) {
        GuiTextField newTextField = new GuiTextField(id, this.field_146289_q, x, y, width, height);
        boolean initialized = textField != null;
        boolean initialFocused = initialized ? textField.func_146206_l() : false;
        int initialCursorPos = initialized ? textField.func_146198_h() : -1;
        newTextField.func_146203_f(maxLength);
        newTextField.func_146180_a(initialText);
        newTextField.func_146195_b(initialFocused);
        if (initialCursorPos != -1) {
            newTextField.func_146190_e(initialCursorPos);
        }
        return newTextField;
    }

    private String getInitialExportText() {
        return this.fieldExport != null ? this.fieldExport.func_146179_b() : (this.list != null && this.list.selected > -1 ? this.presets.get((int)this.list.selected).settings.toString() : this.parent.getSettingsString());
    }

    private String getFilterText() {
        return I18n.func_135052_a((String)PREFIX_FILTER, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("createWorld.customize.presets.modernbetaforge.filter." + this.filterType.name().toLowerCase()), (Object[])new Object[0]);
    }

    private void updateModalState(ModalState state) {
        if (this.modalState != state) {
            this.confirmExitTime = System.currentTimeMillis();
        }
        this.modalState = state;
    }

    private void updateModalButtons(ModalState state) {
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        int modalWidth = state == ModalState.DELETE || state == ModalState.OVERWRITE ? 112 : 160;
        int modalHeight = state == ModalState.DELETE || state == ModalState.OVERWRITE ? 62 : 100;
        int buttonModalY = centerY + modalHeight - 25;
        int fieldModalX = centerX - modalWidth + 10;
        int boxL = centerX + modalWidth - 50 - 1 - 20;
        int boxR = centerX + modalWidth - 0 - 20;
        int boxB = centerY - modalHeight + 50 + 1 + 36;
        this.buttonModalConfirm.field_146129_i = buttonModalY;
        this.buttonModalCancel.field_146129_i = buttonModalY;
        this.buttonModalPrev.field_146128_h = boxL + 5;
        this.buttonModalPrev.field_146129_i = boxB + 5;
        this.buttonModalNext.field_146128_h = boxR - 23;
        this.buttonModalNext.field_146129_i = boxB + 5;
        this.fieldModalName.field_146209_f = fieldModalX;
        this.fieldModalDesc.field_146209_f = fieldModalX;
        this.fieldModalSettings.field_146209_f = fieldModalX;
    }

    private boolean hasValidSelection() {
        return this.list.selected > -1 && this.list.selected < this.presets.size() || this.fieldExport.func_146179_b().length() > 1;
    }

    private boolean canInteract() {
        return System.currentTimeMillis() - this.confirmExitTime > 100L;
    }

    private void incrementSelectedIcon(int amount) {
        this.selectedIcon = MathHelper.func_76125_a((int)(this.selectedIcon + amount), (int)0, (int)(ICON_TEXTURES.length - 1));
    }

    @SideOnly(value=Side.CLIENT)
    private static class IconTexture {
        public ResourceLocation identifier;
        public final double u;
        public final double v;
        public final double w;
        public final double h;

        public IconTexture(ResourceLocation identifier) {
            this(identifier, 0.0, 0.0, 1.0, 1.0);
        }

        public IconTexture(ResourceLocation identifier, double u, double v, double w) {
            this(identifier, u, v, w, w);
        }

        public IconTexture(ResourceLocation identifier, double u, double v, double w, double h) {
            this.identifier = identifier;
            this.u = u;
            this.v = v;
            this.w = w;
            this.h = h;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class Info {
        public final String name;
        public final String desc;
        public final IconTexture icon;
        public final ModernBetaGeneratorSettings.Factory settings;
        public final boolean custom;

        public Info() {
            this("", "", null, null, false);
        }

        public Info(String name, String desc, IconTexture icon, ModernBetaGeneratorSettings.Factory factory, boolean custom) {
            this.name = name;
            this.desc = desc;
            this.icon = icon;
            this.settings = factory;
            this.custom = custom;
        }

        public IconTexture icon() {
            if (this.icon != null) {
                return this.icon;
            }
            return ICON_TEXTURES[0];
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ListPreset
    extends GuiSlot {
        private static final int LIST_PADDING_TOP = 66;
        private static final int LIST_PADDING_BOTTOM = 54;
        private final GuiScreenCustomizePresets parent;
        public int selected;

        public ListPreset(GuiScreenCustomizePresets parent, int selected) {
            super(parent.field_146297_k, parent.field_146294_l, parent.field_146295_m, 66, parent.field_146295_m - 54, 38);
            this.parent = parent;
            this.selected = MathHelper.func_76125_a((int)selected, (int)-1, (int)(parent.presets.size() - 1));
        }

        public void func_178039_p() {
            boolean inSlotBounds;
            super.func_178039_p();
            int paddingR = 0;
            int listL = (this.field_148155_a - this.func_148139_c()) / 2;
            int listR = (this.field_148155_a + this.func_148139_c()) / 2 + paddingR;
            int listMouseY = this.field_148162_h - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
            int element = listMouseY / this.field_148149_f;
            boolean inListBounds = this.func_148141_e(this.field_148162_h) && this.field_148162_h >= this.field_148153_b && this.field_148162_h <= this.field_148154_c;
            boolean bl = inSlotBounds = this.field_148150_g >= listL && this.field_148150_g <= listR;
            if (inListBounds && inSlotBounds && listMouseY >= 0 && element < this.func_148127_b()) {
                this.parent.hoveredElement = element;
                this.parent.hoveredTime = System.currentTimeMillis();
            } else {
                this.parent.hoveredElement = -1;
            }
        }

        public int func_148139_c() {
            return 233;
        }

        protected int func_148127_b() {
            return this.parent.presets.size();
        }

        protected void func_148144_a(int selected, boolean doubleClicked, int mouseX, int mouseY) {
            this.selected = selected;
            this.parent.updateButtonValidity();
            this.parent.fieldExport.func_146180_a(((Info)((GuiScreenCustomizePresets)this.parent).presets.get((int)((GuiScreenCustomizePresets)this.parent).list.selected)).settings.toString());
            if (doubleClicked) {
                SoundUtil.playClickSound(this.field_148161_k.func_147118_V());
                this.parent.parent.loadValues(this.parent.fieldExport.func_146179_b());
                this.parent.parent.isSettingsModified();
                this.parent.field_146297_k.func_147108_a((GuiScreen)this.parent.parent);
            }
        }

        protected boolean func_148131_a(int selected) {
            return selected == this.selected;
        }

        protected void func_148123_a() {
        }

        protected void func_192638_a(int insideLeft, int insideTop, int mouseX, int mouseY, float partialTicks) {
            int size = this.func_148127_b();
            int paddingL = 4;
            int paddingR = 0;
            int paddingY = 1;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            for (int preset = 0; preset < size; ++preset) {
                int y = insideTop + preset * this.field_148149_f + this.field_148160_j;
                int height = this.field_148149_f - 4;
                if (y > this.field_148154_c || y + height < this.field_148153_b) {
                    this.func_192639_a(preset, insideLeft, y, partialTicks);
                }
                if (this.field_148166_t && this.func_148131_a(preset)) {
                    int l = this.field_148152_e + (this.field_148155_a / 2 - this.func_148139_c() / 2) + paddingL;
                    int r = this.field_148152_e + this.field_148155_a / 2 + this.func_148139_c() / 2 + paddingR;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179090_x();
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    bufferbuilder.func_181662_b((double)l, (double)(y + height + 2 + paddingY), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)r, (double)(y + height + 2 + paddingY), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)r, (double)(y - 2 + paddingY), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)l, (double)(y - 2 + paddingY), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)(l + 1), (double)(y + height + 1 + paddingY), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)(r - 1), (double)(y + height + 1 + paddingY), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)(r - 1), (double)(y - 1 + paddingY), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)(l + 1), (double)(y - 1 + paddingY), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179098_w();
                }
                this.func_192637_a(preset, insideLeft, y, height, mouseX, mouseY, partialTicks);
            }
        }

        protected void func_192637_a(int preset, int x, int y, int height, int mouseX, int mouseY, float partialTicks) {
            Info info = (Info)this.parent.presets.get(preset);
            int paddingY = 2;
            boolean hovered = this.parent.hoveredElement == preset;
            int nameColor = hovered ? 0xFFFFA0 : 0xFFFFFF;
            int descColor = hovered ? 10526785 : 0xA0A0A0;
            this.blitIcon(x, y + paddingY, info.icon());
            this.parent.field_146289_q.func_78276_b(info.name, x + 32 + 10, y + 2 + paddingY, nameColor);
            List splitString = this.parent.field_146289_q.func_78271_c(info.desc, 188);
            if (splitString.size() > 1) {
                for (int i = 0; i < splitString.size(); ++i) {
                    String line = (String)splitString.get(i);
                    this.parent.field_146289_q.func_78276_b(line, x + 32 + 10, y + 13 + paddingY + i * 10, descColor);
                }
            } else {
                this.parent.field_146289_q.func_78276_b(info.desc, x + 32 + 10, y + 13 + paddingY, descColor);
            }
        }

        private void blitIcon(int x, int y, IconTexture icon) {
            int iX = x + 5;
            int iY = y;
            this.parent.func_73730_a(iX - 1, iX + 32, iY - 1, -2039584);
            this.parent.func_73730_a(iX - 1, iX + 32, iY + 32, -6250336);
            this.parent.func_73728_b(iX - 1, iY - 1, iY + 32, -2039584);
            this.parent.func_73728_b(iX + 32, iY - 1, iY + 32, -6250336);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            SimpleTexture iconTexture = new SimpleTexture(icon.identifier);
            if (!this.field_148161_k.func_110434_K().func_110579_a(icon.identifier, (ITextureObject)iconTexture)) {
                icon.identifier = UNKNOWN_PACK;
            }
            this.field_148161_k.func_110434_K().func_110577_a(icon.identifier);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferBuilder.func_181662_b((double)(iX + 0), (double)(iY + 32), 0.0).func_187315_a(icon.u, icon.v + icon.h).func_181675_d();
            bufferBuilder.func_181662_b((double)(iX + 32), (double)(iY + 32), 0.0).func_187315_a(icon.u + icon.w, icon.v + icon.h).func_181675_d();
            bufferBuilder.func_181662_b((double)(iX + 32), (double)(iY + 0), 0.0).func_187315_a(icon.u + icon.w, icon.v).func_181675_d();
            bufferBuilder.func_181662_b((double)(iX + 0), (double)(iY + 0), 0.0).func_187315_a(icon.u, icon.v).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    private static enum ModalState {
        NONE,
        SAVE,
        EDIT,
        DELETE,
        OVERWRITE;

    }

    public static enum FilterType {
        ALL,
        BUILTIN,
        ADDON,
        CUSTOM;

    }
}

