/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.event;

import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.ClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.SkyClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.client.color.BetaColorSampler;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.network.CloudHeightMessage;
import mod.bespectacled.modernbetaforge.network.ModernBetaPacketHandler;
import mod.bespectacled.modernbetaforge.network.WorldInfoMessage;
import mod.bespectacled.modernbetaforge.world.ModernBetaWorldType;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;

public class PlayerEventHandler {
    @SubscribeEvent
    public void onPlayerEventPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        ModernBeta.log(Level.DEBUG, "Firing PlayerLoggedInEvent..");
        ModernBeta.log(Level.DEBUG, "Is single player: " + player.field_71133_b.func_71264_H());
        this.sendMessages(player);
    }

    @SubscribeEvent
    public void onPlayerEventPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ModernBeta.log(Level.DEBUG, "Firing PlayerChangedDimensionEvent..");
        this.sendMessages((EntityPlayerMP)event.player);
    }

    private void sendMessages(EntityPlayerMP player) {
        boolean isSinglePlayer = player.field_71133_b.func_71264_H();
        WorldServer worldServer = player.func_71121_q();
        BiomeProvider biomeProvider = worldServer.func_72959_q();
        if (!(worldServer.func_175624_G() instanceof ModernBetaWorldType)) {
            ModernBeta.log(Level.DEBUG, "Not a Modern Beta world..");
            return;
        }
        if (!isSinglePlayer) {
            if (biomeProvider instanceof ModernBetaBiomeProvider) {
                String generatorOptions = worldServer.func_72912_H().func_82571_y();
                generatorOptions = ModernBetaGeneratorSettings.Factory.jsonToFactory(generatorOptions).toString();
                WorldInfoMessage message = ModernBetaConfig.serverOptions.sendWorldInfo ? new WorldInfoMessage(worldServer.func_72905_C(), generatorOptions.length() < 25000 ? generatorOptions : "") : WorldInfoMessage.EMPTY;
                ModernBetaPacketHandler.INSTANCE.sendTo((IMessage)message, player);
            }
            if (ModernBetaConfig.serverOptions.sendCloudHeight) {
                int cloudHeight = (int)ModernBetaWorldType.INSTANCE.getCloudHeight();
                ModernBetaPacketHandler.INSTANCE.sendTo((IMessage)new CloudHeightMessage(cloudHeight), player);
            }
        } else if (biomeProvider instanceof ModernBetaBiomeProvider) {
            BiomeSource biomeSource = ((ModernBetaBiomeProvider)worldServer.func_72959_q()).getBiomeSource();
            ModernBetaGeneratorSettings settings = ModernBetaGeneratorSettings.buildOrGet((World)worldServer);
            BetaColorSampler.INSTANCE.resetClimateSamplers();
            if (biomeSource instanceof ClimateSampler && ModernBetaConfig.visualOptions.useBetaBiomeColors) {
                BetaColorSampler.INSTANCE.setClimateSampler((ClimateSampler)((Object)biomeSource), settings.snowLineOffset);
            }
            if (biomeSource instanceof SkyClimateSampler && ModernBetaConfig.visualOptions.useBetaSkyColors) {
                BetaColorSampler.INSTANCE.setSkyClimateSampler((SkyClimateSampler)((Object)biomeSource));
            }
        }
    }
}

