/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.event;

import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.world.ModernBetaWorldType;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevHouse;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldEventHandler {
    @SubscribeEvent
    public void onWorldEventCreateSpawnPosition(WorldEvent.CreateSpawnPosition event) {
        WorldServer world = (WorldServer)event.getWorld();
        WorldSettings settings = event.getSettings();
        IChunkGenerator chunkGenerator = world.func_72863_F().field_186029_c;
        BiomeProvider biomeProvider = world.func_72959_q();
        if (settings.func_77165_h() instanceof ModernBetaWorldType) {
            BlockPos currentSpawnPos = world.func_175694_M();
            if (chunkGenerator instanceof ModernBetaChunkGenerator && biomeProvider instanceof ModernBetaBiomeProvider) {
                ChunkSource chunkSource = ((ModernBetaChunkGenerator)chunkGenerator).getChunkSource();
                BiomeSource biomeSource = ((ModernBetaBiomeProvider)biomeProvider).getBiomeSource();
                ModernBetaGeneratorSettings generatorSettings = chunkSource.getGeneratorSettings();
                BlockPos newSpawnPos = chunkSource.getWorldSpawner().locateSpawn(currentSpawnPos, chunkSource, biomeSource);
                if (newSpawnPos != null) {
                    world.func_72912_H().func_176143_a(newSpawnPos);
                    if (chunkSource instanceof FiniteChunkSource) {
                        ((FiniteChunkSource)chunkSource).buildHouse(world, newSpawnPos, settings.func_77167_c());
                    }
                    if (settings.func_77167_c() && (!(chunkSource instanceof FiniteChunkSource) || IndevHouse.fromId(generatorSettings.levelHouse) == IndevHouse.NONE)) {
                        world.func_73047_i();
                    }
                    event.setCanceled(true);
                }
            }
        }
    }
}

