/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.util;

import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.function.Consumer;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.ClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.Clime;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.surface.NoiseSurfaceBuilder;
import mod.bespectacled.modernbetaforge.api.world.chunk.surface.SurfaceBuilder;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.ForgeRegistryUtil;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.BiomeChunk;
import mod.bespectacled.modernbetaforge.util.chunk.ChunkCache;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBetaSky;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionRules;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionStep;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

public class DrawUtil {
    private static final int COLOR_GRASS = MathUtil.convertARGBComponentsToInt(255, 127, 178, 56);
    private static final int COLOR_SAND = MathUtil.convertARGBComponentsToInt(255, 247, 233, 163);
    private static final int COLOR_SNOW = MathUtil.convertARGBComponentsToInt(255, 255, 255, 255);
    private static final int COLOR_WATER = MathUtil.convertARGBComponentsToInt(255, 64, 64, 255);
    private static final int COLOR_ICE = MathUtil.convertARGBComponentsToInt(255, 160, 160, 255);
    private static final int COLOR_FIRE = MathUtil.convertARGBComponentsToInt(255, 255, 0, 0);
    private static final int COLOR_VOID = MathUtil.convertARGBComponentsToInt(0, 0, 0, 0);
    private static final int COLOR_STONE = MathUtil.convertARGBComponentsToInt(255, 112, 112, 112);
    private static final int COLOR_TERRACOTTA = MathUtil.convertARGBComponentsToInt(255, 216, 127, 51);
    private static final int COLOR_MYCELIUM = MathUtil.convertARGBComponentsToInt(255, 127, 63, 178);
    private static final int COLOR_NETHER = MathUtil.convertARGBComponentsToInt(255, 112, 2, 0);
    private static final int COLOR_SOUL_SAND = MathUtil.convertARGBComponentsToInt(255, 102, 76, 51);
    private static final int COLOR_CENTER = MathUtil.convertARGBComponentsToInt(255, 255, 0, 0);

    public static BufferedImage createTerrainMap(ChunkSource chunkSource, BiomeSource biomeSource, SurfaceBuilder surfaceBuilder, BiomeInjectionRules injectionRules, int size, boolean useBiomeBlend, Consumer<Float> progressTracker) {
        return DrawUtil.createTerrainMap(chunkSource, biomeSource, surfaceBuilder, injectionRules, 0, 0, size, size, useBiomeBlend, progressTracker);
    }

    public static BufferedImage createTerrainMap(ChunkSource chunkSource, BiomeSource biomeSource, SurfaceBuilder surfaceBuilder, BiomeInjectionRules injectionRules, int centerX, int centerZ, int sizeX, int sizeZ, boolean useBiomeBlend, Consumer<Float> progressTracker) {
        ChunkCache<BiomeChunk> biomeCache = new ChunkCache<BiomeChunk>("biome_draw", (chunkX, chunkZ) -> new BiomeChunk((int)chunkX, (int)chunkZ, (x, z) -> DrawUtil.getInjectedBiome(x, z, chunkSource, biomeSource, surfaceBuilder, injectionRules)));
        BufferedImage image = new BufferedImage(sizeX, sizeZ, 2);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Random random = new Random(chunkSource.getSeed());
        int chunkWidth = sizeX >> 4;
        int chunkLength = sizeZ >> 4;
        int offsetX = sizeX / 2;
        int offsetZ = sizeZ / 2;
        Block defaultFluid = chunkSource.getDefaultFluid().func_177230_c();
        int snowLineOffset = chunkSource.getGeneratorSettings().snowLineOffset;
        for (int chunkX2 = 0; chunkX2 < chunkWidth; ++chunkX2) {
            int startX = chunkX2 << 4;
            progressTracker.accept(Float.valueOf((float)chunkX2 / (float)chunkWidth));
            for (int chunkZ2 = 0; chunkZ2 < chunkLength; ++chunkZ2) {
                int startZ = chunkZ2 << 4;
                random = surfaceBuilder.createSurfaceRandom(chunkX2, chunkZ2);
                for (int localX = 0; localX < 16; ++localX) {
                    int x = startX + localX - offsetX + centerX;
                    int imageX = startX + localX;
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        int z = startZ + localZ - offsetZ + centerZ;
                        int imageY = startZ + localZ;
                        int height = chunkSource.getHeight(x, z, HeightmapChunk.Type.SURFACE);
                        int oceanHeight = chunkSource.getHeight(x, z, HeightmapChunk.Type.OCEAN);
                        mutablePos.func_181079_c(x, oceanHeight, z);
                        Biome biome = biomeSource.getBiome(x, z);
                        BiomeInjectionRules.BiomeInjectionContext context = DrawUtil.createInjectionContext(chunkSource, surfaceBuilder, x, z, biome);
                        Biome injectedBiome = injectionRules.test(context, x, z, BiomeInjectionStep.PRE_SURFACE);
                        biome = injectedBiome != null ? injectedBiome : biome;
                        context.setBiome(biome);
                        injectedBiome = injectionRules.test(context, x, z, BiomeInjectionStep.CUSTOM);
                        biome = injectedBiome != null ? injectedBiome : biome;
                        TerrainType terrainType = DrawUtil.getBaseTerrainType(chunkSource, surfaceBuilder, x, z, height, biome, random);
                        terrainType = DrawUtil.getTerrainTypeByBiome(biome, terrainType);
                        terrainType = DrawUtil.getTerrainTypeBySnowiness((BlockPos)mutablePos, biome, biomeSource, defaultFluid, terrainType, snowLineOffset);
                        int color = DrawUtil.getTerrainTypeColor((BlockPos)mutablePos, biome, chunkSource, biomeSource, biomeCache, useBiomeBlend, terrainType);
                        Vector4f colorVec = MathUtil.convertARGBIntToVector4f(color);
                        if (terrainType == TerrainType.GRASS) {
                            colorVec = DrawUtil.scale(colorVec, 0.71f);
                        }
                        Vector4f mapColor = DrawUtil.scale(colorVec, 0.86f);
                        int elevationDiff = chunkSource.getHeight(x, z + 1, HeightmapChunk.Type.SURFACE) - height;
                        if (terrainType == TerrainType.ICE) {
                            elevationDiff = 0;
                        }
                        if (elevationDiff > 0) {
                            mapColor = colorVec;
                        } else if (elevationDiff < 0) {
                            mapColor = DrawUtil.scale(colorVec, 0.71f);
                        }
                        image.setRGB(imageX, imageY, MathUtil.convertARGBVector4fToInt(mapColor));
                    }
                }
            }
        }
        return image;
    }

    public static BiomeInjectionRules.BiomeInjectionContext createInjectionContext(ChunkSource chunkSource, SurfaceBuilder surfaceBuilder, int x, int z, Biome biome) {
        NoiseSurfaceBuilder noiseSurfaceBuilder;
        IBlockState stateAbove;
        boolean inWater;
        int height = chunkSource.getHeight(x, z, HeightmapChunk.Type.SURFACE);
        boolean bl = inWater = height < chunkSource.getSeaLevel() - 1;
        if (chunkSource instanceof FiniteChunkSource && ((FiniteChunkSource)chunkSource).inWorldBounds(x, z)) {
            int offsetZ;
            FiniteChunkSource finiteChunkSource = (FiniteChunkSource)chunkSource;
            int offsetX = finiteChunkSource.getLevelWidth() / 2;
            Block blockAbove = finiteChunkSource.getLevelBlock(x += offsetX, height + 1, z += (offsetZ = finiteChunkSource.getLevelLength() / 2));
            inWater = blockAbove == chunkSource.getDefaultFluid().func_177230_c();
        }
        IBlockState state = chunkSource.getDefaultBlock();
        IBlockState iBlockState = stateAbove = inWater ? chunkSource.getDefaultFluid() : BlockStates.AIR;
        if (surfaceBuilder instanceof NoiseSurfaceBuilder && !surfaceBuilder.isCustomSurface(biome) && (noiseSurfaceBuilder = (NoiseSurfaceBuilder)surfaceBuilder).atBeachDepth(height) && noiseSurfaceBuilder.isBeach(x, z, null)) {
            state = BlockStates.SAND;
        }
        return new BiomeInjectionRules.BiomeInjectionContext(new BlockPos(x, height, z), state, stateAbove, biome, biome);
    }

    private static Vector4f scale(Vector4f vector, float factor) {
        Vector4f newVector = new Vector4f((ReadableVector4f)vector);
        newVector.y *= factor;
        newVector.z *= factor;
        newVector.w *= factor;
        return newVector;
    }

    private static TerrainType getBaseTerrainType(ChunkSource chunkSource, SurfaceBuilder surfaceBuilder, int x, int z, int height, Biome biome, Random random) {
        TerrainType terrainType = TerrainType.GRASS;
        TerrainType defaultBlock = DrawUtil.getTerrainTypeByStone(chunkSource);
        TerrainType defaultFluid = DrawUtil.getTerrainTypeByFluid(chunkSource);
        boolean isNether = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
        if (chunkSource instanceof FiniteChunkSource) {
            FiniteChunkSource finiteChunkSource = (FiniteChunkSource)chunkSource;
            if (finiteChunkSource.inWorldBounds(x, z)) {
                int offsetX = finiteChunkSource.getLevelWidth() / 2;
                int offsetZ = finiteChunkSource.getLevelLength() / 2;
                Block block = finiteChunkSource.getLevelBlock(x += offsetX, height, z += offsetZ);
                Block blockAbove = finiteChunkSource.getLevelBlock(x, height + 1, z);
                if (block == Blocks.field_150354_m) {
                    terrainType = TerrainType.SAND;
                } else if (block == Blocks.field_150351_n || block == Blocks.field_150348_b) {
                    terrainType = TerrainType.STONE;
                }
                if (blockAbove == chunkSource.getDefaultFluid().func_177230_c()) {
                    terrainType = defaultFluid;
                }
            } else if (height < chunkSource.getSeaLevel() - 1) {
                terrainType = defaultFluid;
            }
        } else if (surfaceBuilder instanceof NoiseSurfaceBuilder && !surfaceBuilder.isCustomSurface(biome)) {
            NoiseSurfaceBuilder noiseSurfaceBuilder = (NoiseSurfaceBuilder)surfaceBuilder;
            boolean isBeach = noiseSurfaceBuilder.isBeach(x, z, random);
            boolean isGravelBeach = noiseSurfaceBuilder.isGravelBeach(x, z, random);
            int surfaceDepth = noiseSurfaceBuilder.sampleSurfaceDepth(x, z, random);
            if (noiseSurfaceBuilder.isBasin(surfaceDepth)) {
                terrainType = defaultBlock;
            } else if (noiseSurfaceBuilder.atBeachDepth(height)) {
                if (isGravelBeach) {
                    terrainType = TerrainType.STONE;
                    if (!isNether) {
                        --height;
                    }
                }
                if (isBeach) {
                    TerrainType terrainType2 = terrainType = isNether ? TerrainType.SOUL_SAND : TerrainType.SAND;
                    if (isGravelBeach && !isNether) {
                        ++height;
                    }
                }
            }
            if (height < chunkSource.getSeaLevel() - 1) {
                terrainType = defaultFluid;
            }
        } else if (height < chunkSource.getSeaLevel() - 1) {
            terrainType = defaultFluid;
        }
        if (height <= 0) {
            terrainType = TerrainType.VOID;
        }
        return terrainType;
    }

    private static TerrainType getTerrainTypeByBiome(Biome biome, TerrainType terrainType) {
        if (terrainType == TerrainType.GRASS) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                terrainType = TerrainType.MYCELIUM;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
                terrainType = TerrainType.TERRACOTTA;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                terrainType = TerrainType.SAND;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                terrainType = TerrainType.NETHER;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
                terrainType = TerrainType.SAND;
            }
        }
        return terrainType;
    }

    private static TerrainType getTerrainTypeBySnowiness(BlockPos blockPos, Biome biome, BiomeSource biomeSource, Block defaultFluid, TerrainType terrainType, int snowLineOffset) {
        if (terrainType.snowy && DrawUtil.canFreeze(blockPos, biome, biomeSource, snowLineOffset)) {
            terrainType = TerrainType.SNOW;
        }
        if (terrainType == TerrainType.WATER && defaultFluid == Blocks.field_150355_j && DrawUtil.canFreeze(blockPos, biome, biomeSource, snowLineOffset)) {
            terrainType = TerrainType.ICE;
        }
        return terrainType;
    }

    private static TerrainType getTerrainTypeByStone(ChunkSource chunkSource) {
        ResourceLocation defaultBlock = chunkSource.getGeneratorSettings().defaultBlock;
        if (defaultBlock.equals((Object)Blocks.field_150424_aL.getRegistryName())) {
            return TerrainType.NETHER;
        }
        if (defaultBlock.equals((Object)Blocks.field_150377_bs.getRegistryName())) {
            return TerrainType.SAND;
        }
        return TerrainType.STONE;
    }

    private static TerrainType getTerrainTypeByFluid(ChunkSource chunkSource) {
        ResourceLocation defaultFluid = chunkSource.getGeneratorSettings().defaultFluid;
        return defaultFluid.equals((Object)Blocks.field_150353_l.getRegistryName()) ? TerrainType.FIRE : TerrainType.WATER;
    }

    private static boolean canFreeze(BlockPos blockPos, Biome biome, BiomeSource biomeSource, int snowLineOffset) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o() + 1;
        int z = blockPos.func_177952_p();
        boolean canFreeze = false;
        if (biomeSource instanceof ClimateSampler && ((ClimateSampler)((Object)biomeSource)).sampleForFeatureGeneration()) {
            double temp = ((ClimateSampler)((Object)biomeSource)).sample(x, z).temp();
            canFreeze = (temp -= (double)(y - snowLineOffset) / (double)snowLineOffset * 0.3) < 0.5;
        } else if (biome instanceof BiomeBetaSky) {
            double temp = biome.func_185353_n();
            canFreeze = (temp -= (double)(y - snowLineOffset) / (double)snowLineOffset * 0.3) < 0.5;
        } else {
            double temp = biome.func_180626_a(blockPos);
            canFreeze = temp < 0.15;
        }
        return canFreeze;
    }

    private static int getTerrainTypeColor(BlockPos blockPos, Biome biome, ChunkSource chunkSource, BiomeSource biomeSource, ChunkCache<BiomeChunk> biomeCache, boolean useBiomeBlend, TerrainType terrainType) {
        int fluidColor;
        ResourceLocation defaultFluid;
        int color = terrainType.color;
        int x = blockPos.func_177958_n();
        int z = blockPos.func_177952_p();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        biome = biomeCache.get(chunkX, chunkZ).sample(x, z);
        if (terrainType == TerrainType.GRASS) {
            color = biome.func_180627_b(blockPos);
            if (useBiomeBlend) {
                if (biomeSource instanceof ClimateSampler && ((ClimateSampler)((Object)biomeSource)).sampleBiomeColor()) {
                    ClimateSampler climateSampler = (ClimateSampler)((Object)biomeSource);
                    Clime clime = climateSampler.sample(blockPos.func_177958_n(), blockPos.func_177952_p());
                    color = ColorizerGrass.func_77480_a((double)clime.temp(), (double)clime.rain());
                } else {
                    color = DrawUtil.blendBiomeColor(blockPos, biomeCache);
                }
            }
            color = MathUtil.convertRGBtoARGB(color);
        } else if (terrainType == TerrainType.WATER && !(defaultFluid = chunkSource.getGeneratorSettings().defaultFluid).equals((Object)Blocks.field_150355_j.getRegistryName()) && (fluidColor = ForgeRegistryUtil.getFluid(defaultFluid).getColor()) != -1) {
            color = fluidColor;
        }
        return color;
    }

    private static int blendBiomeColor(BlockPos blockPos, ChunkCache<BiomeChunk> biomeCache) {
        Vec3d color = Vec3d.field_186680_a;
        int centerX = blockPos.func_177958_n();
        int centerZ = blockPos.func_177952_p();
        int blendDist = 2;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int blocks = 0;
        for (int x = centerX - blendDist; x <= centerX + blendDist; ++x) {
            for (int z = centerZ - blendDist; z <= centerZ + blendDist; ++z) {
                int chunkX = x >> 4;
                int chunkZ = z >> 4;
                Biome biome = biomeCache.get(chunkX, chunkZ).sample(x, z);
                color = color.func_178787_e(MathUtil.convertRGBIntToVec3d(biome.func_180627_b((BlockPos)mutablePos.func_181079_c(x, 0, z))));
                ++blocks;
            }
        }
        return MathUtil.convertRGBVec3dToInt(color.func_186678_a(1.0 / (double)blocks));
    }

    private static Biome[] getInjectedBiome(int startX, int startZ, ChunkSource chunkSource, BiomeSource biomeSource, SurfaceBuilder surfaceBuilder, BiomeInjectionRules injectionRules) {
        Biome[] biomes = new Biome[256];
        int ndx = 0;
        for (int z = startZ; z < startZ + 16; ++z) {
            for (int x = startX; x < startX + 16; ++x) {
                Biome biome = biomeSource.getBiome(x, z);
                BiomeInjectionRules.BiomeInjectionContext context = DrawUtil.createInjectionContext(chunkSource, surfaceBuilder, x, z, biome);
                Biome injectedBiome = injectionRules.test(context, x, z, BiomeInjectionStep.PRE_SURFACE);
                biome = injectedBiome != null ? injectedBiome : biome;
                context.setBiome(biome);
                injectedBiome = injectionRules.test(context, x, z, BiomeInjectionStep.CUSTOM);
                biome = injectedBiome != null ? injectedBiome : biome;
                context.setBiome(biome);
                injectedBiome = injectionRules.test(context, x, z, BiomeInjectionStep.POST_SURFACE);
                biomes[ndx++] = injectedBiome != null ? injectedBiome : biome;
            }
        }
        return biomes;
    }

    static /* synthetic */ int access$000() {
        return COLOR_GRASS;
    }

    static /* synthetic */ int access$100() {
        return COLOR_SAND;
    }

    static /* synthetic */ int access$200() {
        return COLOR_SNOW;
    }

    static /* synthetic */ int access$300() {
        return COLOR_STONE;
    }

    static /* synthetic */ int access$400() {
        return COLOR_TERRACOTTA;
    }

    static /* synthetic */ int access$500() {
        return COLOR_MYCELIUM;
    }

    static /* synthetic */ int access$600() {
        return COLOR_NETHER;
    }

    static /* synthetic */ int access$700() {
        return COLOR_SOUL_SAND;
    }

    static /* synthetic */ int access$800() {
        return COLOR_WATER;
    }

    static /* synthetic */ int access$900() {
        return COLOR_FIRE;
    }

    static /* synthetic */ int access$1000() {
        return COLOR_ICE;
    }

    static /* synthetic */ int access$1100() {
        return COLOR_VOID;
    }

    static /* synthetic */ int access$1200() {
        return COLOR_CENTER;
    }

    private static enum TerrainType {
        GRASS(DrawUtil.access$000(), true),
        SAND(DrawUtil.access$100(), true),
        SNOW(DrawUtil.access$200(), true),
        STONE(DrawUtil.access$300(), true),
        TERRACOTTA(DrawUtil.access$400(), true),
        MYCELIUM(DrawUtil.access$500(), true),
        NETHER(DrawUtil.access$600(), true),
        SOUL_SAND(DrawUtil.access$700(), true),
        WATER(DrawUtil.access$800()),
        FIRE(DrawUtil.access$900()),
        ICE(DrawUtil.access$1000()),
        VOID(DrawUtil.access$1100()),
        MARKER(DrawUtil.access$1200());

        private final int color;
        private final boolean snowy;

        private TerrainType(int color) {
            this(color, false);
        }

        private TerrainType(int color, boolean snowy) {
            this.color = color;
            this.snowy = snowy;
        }
    }
}

