/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.util.DebugUtil;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.BiomeChunk;
import mod.bespectacled.modernbetaforge.util.chunk.ChunkCache;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.storage.WorldInfo;

public class ModernBetaBiomeProvider
extends BiomeProvider {
    private final ModernBetaGeneratorSettings settings;
    private final BiomeSource biomeSource;
    private final ChunkCache<BiomeChunk> baseBiomeCache;
    private final ChunkCache<BiomeChunk> injectedBiomeCache;
    private ModernBetaChunkGenerator chunkGenerator;

    public ModernBetaBiomeProvider(WorldInfo worldInfo) {
        super(worldInfo);
        this.settings = worldInfo.func_82571_y() != null ? ModernBetaGeneratorSettings.build(worldInfo.func_82571_y()) : ModernBetaGeneratorSettings.build();
        this.biomeSource = ModernBetaRegistries.BIOME_SOURCE.get(this.settings.biomeSource).apply(worldInfo.func_76063_b(), this.settings);
        this.baseBiomeCache = new ChunkCache<BiomeChunk>("base_biomes", (chunkX, chunkZ) -> new BiomeChunk(this.getBaseBiomes(null, chunkX << 4, chunkZ << 4, 16, 16)));
        this.injectedBiomeCache = new ChunkCache<BiomeChunk>("biomes", (chunkX, chunkZ) -> new BiomeChunk(this.chunkGenerator.getBiomes((int)chunkX, (int)chunkZ)));
        this.chunkGenerator = null;
        DebugUtil.resetDebug("modernbeta.getBaseBiomes");
    }

    public Biome func_180631_a(BlockPos blockPos) {
        return this.func_180300_a(blockPos, null);
    }

    public Biome func_180300_a(BlockPos blockPos, Biome defaultBiome) {
        return this.getBiome(blockPos.func_177958_n(), blockPos.func_177952_p());
    }

    public Biome[] func_76937_a(Biome[] biomes, int startX, int startZ, int sizeX, int sizeZ) {
        return this.func_76931_a(biomes, startX >> 2, startZ >> 2, sizeX, sizeZ, true);
    }

    public Biome[] func_76933_b(@Nullable Biome[] biomes, int startX, int startZ, int sizeX, int sizeZ) {
        return this.func_76931_a(biomes, startX, startZ, sizeX, sizeZ, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] biomes, int startX, int startZ, int sizeX, int sizeZ, boolean cacheFlag) {
        if (biomes == null || biomes.length != sizeX * sizeZ) {
            biomes = new Biome[sizeX * sizeZ];
        }
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int x = startX + localX;
                int z = startZ + localZ;
                biomes[localX + localZ * 16] = this.getBiome(x, z);
            }
        }
        return biomes;
    }

    public BlockPos func_180630_a(int startX, int startZ, int range, List<Biome> allowed, Random random) {
        int minX = startX - range >> 2;
        int maxX = startX + range >> 2;
        int minZ = startZ - range >> 2;
        int maxZ = startZ + range >> 2;
        int sizeX = maxX - minX + 1;
        int sizeZ = maxZ - minZ + 1;
        BlockPos blockPos = null;
        int chance = 0;
        HashSet<Biome> allowedBiomes = new HashSet<Biome>(allowed);
        for (int i = 0; i < sizeX * sizeZ; ++i) {
            int x = minX + i % sizeX << 2;
            int z = minZ + i / sizeX << 2;
            Biome biome = this.biomeSource.getBiome(x, z);
            if (!allowedBiomes.contains(biome) || blockPos != null && random.nextInt(chance + 1) != 0) continue;
            blockPos = new BlockPos(x, 0, z);
            ++chance;
        }
        return blockPos;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        HashSet<Biome> allowedBiomes = new HashSet<Biome>(allowed);
        if (radius == 0) {
            return allowedBiomes.contains(this.getBiome(x, z));
        }
        double r2 = radius * radius;
        for (int dX = x - radius; dX < x + radius; ++dX) {
            for (int dZ = z - radius; dZ < z + radius; ++dZ) {
                Biome biome;
                double distance = MathUtil.distance(x, z, dX, dZ);
                if (!(distance < r2) || allowedBiomes.contains(biome = this.getBiome(dX, dZ))) continue;
                return false;
            }
        }
        return true;
    }

    public Biome getBaseBiome(int x, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.baseBiomeCache.get(chunkX, chunkZ).sample(x, z);
    }

    public Biome[] getBaseBiomes(int chunkX, int chunkZ) {
        return this.baseBiomeCache.get(chunkX, chunkZ).getBiomes();
    }

    public BlockPos locateBiome(int startX, int startZ, int range, int steps, Biome biomeToSearch, Random random) {
        BlockPos blockPos = null;
        int chance = 0;
        for (int size = 0; size <= range; size += steps) {
            for (int localX = -size; localX <= size; localX += steps) {
                boolean atEdgeX = Math.abs(localX) == size;
                for (int localZ = -size; localZ <= size; localZ += steps) {
                    boolean atEdgeZ;
                    boolean bl = atEdgeZ = Math.abs(localZ) == size;
                    if (!atEdgeX && !atEdgeZ) continue;
                    int x = startX + localX;
                    int z = startZ + localZ;
                    if (this.getBiome(x, z) == biomeToSearch && (blockPos == null || random.nextInt(chance + 1) == 0)) {
                        return new BlockPos(x, 0, z);
                    }
                    ++chance;
                }
            }
        }
        return blockPos;
    }

    public BiomeSource getBiomeSource() {
        return this.biomeSource;
    }

    public void setChunkGenerator(ModernBetaChunkGenerator chunkGenerator) {
        this.chunkGenerator = chunkGenerator;
    }

    public boolean useVillageVariants() {
        return this.settings.useVillageVariants;
    }

    private Biome[] getBaseBiomes(@Nullable Biome[] biomes, int startX, int startZ, int sizeX, int sizeZ) {
        DebugUtil.startDebug("modernbeta.getBaseBiomes");
        if (biomes == null || biomes.length != sizeX * sizeZ) {
            biomes = new Biome[sizeX * sizeZ];
        }
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int x = startX + localX;
                int z = startZ + localZ;
                biomes[localX + localZ * 16] = this.biomeSource.getBiome(x, z);
            }
        }
        DebugUtil.endDebug("modernbeta.getBaseBiomes");
        return biomes;
    }

    private Biome getBiome(int x, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.injectedBiomeCache.get(chunkX, chunkZ).sample(x, z);
    }
}

