/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.chunk.source;

import java.util.Random;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoiseCombined;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevTheme;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevType;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import org.apache.logging.log4j.Level;

public class IndevChunkSource
extends FiniteChunkSource {
    private final IndevTheme levelTheme;
    private final IndevType levelType;
    private final int seaLevel;
    private PerlinOctaveNoiseCombined lowOctaveNoise;
    private PerlinOctaveNoiseCombined highOctaveNoise;
    private PerlinOctaveNoise selectorOctaveNoise;
    private PerlinOctaveNoise islandOctaveNoise;
    private PerlinOctaveNoiseCombined erodeSelectorOctaveNoise;
    private PerlinOctaveNoiseCombined erodeOctaveNoise;
    private PerlinOctaveNoise soilOctaveNoise;
    private PerlinOctaveNoise floatingOctaveNoise;
    private PerlinOctaveNoise sandOctaveNoise;
    private PerlinOctaveNoise gravelOctaveNoise;
    private int waterLevel;
    private int groundLevel;

    public IndevChunkSource(long seed, ModernBetaGeneratorSettings settings) {
        super(seed, settings);
        this.levelTheme = IndevTheme.fromId(settings.levelTheme);
        this.levelType = IndevType.fromId(settings.levelType);
        int n = this.seaLevel = this.levelType == IndevType.FLOATING ? 0 : this.levelHeight - 32;
        int cloudHeight = this.levelType == IndevType.FLOATING ? -16 : (this.levelTheme == IndevTheme.PARADISE ? this.levelHeight + 64 : this.levelHeight + 2);
        this.setCloudHeight(cloudHeight);
    }

    @Override
    public int getSeaLevel() {
        return this.seaLevel;
    }

    @Override
    protected void pregenerateTerrain() {
        int layers = this.levelType == IndevType.FLOATING ? (this.levelHeight - 64) / 48 + 1 : 1;
        for (int layer = 0; layer < layers; ++layer) {
            this.waterLevel = this.levelHeight - 32 - layer * 48;
            this.groundLevel = this.waterLevel - 2;
            this.lowOctaveNoise = new PerlinOctaveNoiseCombined(this.random, 8, false);
            this.highOctaveNoise = new PerlinOctaveNoiseCombined(this.random, 8, false);
            this.selectorOctaveNoise = new PerlinOctaveNoise(this.random, 6, false);
            this.islandOctaveNoise = new PerlinOctaveNoise(this.random, 2, false);
            this.erodeSelectorOctaveNoise = new PerlinOctaveNoiseCombined(this.random, 8, false);
            this.erodeOctaveNoise = new PerlinOctaveNoiseCombined(this.random, 8, false);
            this.soilOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
            this.floatingOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
            this.sandOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
            this.gravelOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
            this.setPhase("Raising");
            this.raiseLevel();
            this.setPhase("Eroding");
            this.erodeLevel();
            this.setPhase("Soiling");
            this.soilLevel();
            this.setPhase("Growing");
            this.growLevel();
        }
        if (this.settings.useIndevCaves) {
            this.setPhase("Carving");
            this.carveLevel();
        }
        this.oreLevel();
        this.setPhase("Melting");
        this.meltLevel();
        this.updateLevel();
        this.setPhase("Watering");
        this.waterLevel();
        this.setPhase("Planting");
        this.plantLevel();
        this.setPhase("Assembling");
        this.assembleLevel();
    }

    @Override
    protected void generateBorder(ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        switch (this.levelType) {
            case ISLAND: {
                this.generateWaterBorder(chunkPrimer, chunkX, chunkZ);
                break;
            }
            case INLAND: {
                this.generateWorldBorder(chunkPrimer, chunkX, chunkZ);
                break;
            }
        }
    }

    @Override
    protected int getBorderHeight(int x, int z, HeightmapChunk.Type type) {
        int seaLevel = this.getSeaLevel();
        switch (this.levelType) {
            case ISLAND: {
                return type == HeightmapChunk.Type.OCEAN ? seaLevel - 1 : seaLevel - 10;
            }
            case INLAND: {
                return seaLevel;
            }
            case FLOATING: {
                return 0;
            }
        }
        return seaLevel;
    }

    private void raiseLevel() {
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            double normalizedX = Math.abs(((double)x / ((double)this.levelWidth - 1.0) - 0.5) * 2.0);
            for (int z = 0; z < this.levelLength; ++z) {
                double normalizedZ = Math.abs(((double)z / ((double)this.levelLength - 1.0) - 0.5) * 2.0);
                double heightLow = this.lowOctaveNoise.sample((float)x * 1.3f, (float)z * 1.3f) / 6.0 - 4.0;
                double heightHigh = this.highOctaveNoise.sample((float)x * 1.3f, (float)z * 1.3f) / 5.0 + 10.0 - 4.0;
                double heightSelector = this.selectorOctaveNoise.sample(x, z) / 8.0;
                if (heightSelector > 0.0) {
                    heightHigh = heightLow;
                }
                double height = Math.max(heightLow, heightHigh) / 2.0;
                if (this.levelType == IndevType.ISLAND) {
                    double islandRadius = Math.sqrt(normalizedX * normalizedX + normalizedZ * normalizedZ) * 1.2;
                    islandRadius = Math.min(islandRadius, this.islandOctaveNoise.sample((float)x * 0.05f, (float)z * 0.05f) / 4.0 + 1.0);
                    if ((islandRadius = Math.max(islandRadius, Math.max(normalizedX, normalizedZ))) > 1.0) {
                        islandRadius = 1.0;
                    } else if (islandRadius < 0.0) {
                        islandRadius = 0.0;
                    }
                    islandRadius *= islandRadius;
                    height = height * (1.0 - islandRadius) - islandRadius * 10.0 + 5.0;
                    if (height < 0.0) {
                        height -= height * height * (double)0.2f;
                    }
                } else if (height < 0.0) {
                    height *= 0.8;
                }
                this.levelHeightmap[x + z * this.levelWidth] = (int)height;
            }
        }
    }

    private void erodeLevel() {
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            for (int z = 0; z < this.levelLength; ++z) {
                int erodeNoise;
                double erodeSelector = this.erodeSelectorOctaveNoise.sample(x << 1, z << 1) / 8.0;
                int n = erodeNoise = this.erodeOctaveNoise.sample(x << 1, z << 1) > 0.0 ? 1 : 0;
                if (!(erodeSelector > 2.0)) continue;
                int height = this.levelHeightmap[x + z * this.levelWidth];
                this.levelHeightmap[x + z * this.levelWidth] = height = ((height - erodeNoise) / 2 << 1) + erodeNoise;
            }
        }
    }

    private void soilLevel() {
        int seaLevel = this.waterLevel;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            double normalizedX = Math.abs(((double)x / ((double)this.levelWidth - 1.0) - 0.5) * 2.0);
            int worldX = x - this.levelWidth / 2;
            for (int z = 0; z < this.levelLength; ++z) {
                double normalizedZ = Math.max(normalizedX, Math.abs((double)z / ((double)this.levelLength - 1.0) - 0.5) * 2.0);
                int worldZ = z - this.levelLength / 2;
                normalizedZ = normalizedZ * normalizedZ * normalizedZ;
                int dirtDepth = (int)(this.soilOctaveNoise.sample(x, z) / 24.0) - 4;
                int dirtThreshold = this.levelHeightmap[x + z * this.levelWidth] + seaLevel;
                int stoneThreshold = dirtDepth + dirtThreshold;
                this.levelHeightmap[x + z * this.levelWidth] = Math.max(dirtThreshold, stoneThreshold);
                if (this.levelHeightmap[x + z * this.levelWidth] > this.levelHeight - 2) {
                    this.levelHeightmap[x + z * this.levelWidth] = this.levelHeight - 2;
                }
                if (this.levelHeightmap[x + z * this.levelWidth] <= 0) {
                    this.levelHeightmap[x + z * this.levelWidth] = 1;
                }
                double floatingNoise = this.floatingOctaveNoise.sample((double)x * 2.3, (double)z * 2.3) / 24.0;
                int roundedHeight = (int)(Math.sqrt(Math.abs(floatingNoise)) * Math.signum(floatingNoise) * 20.0) + seaLevel;
                if ((roundedHeight = (int)((double)roundedHeight * (1.0 - normalizedZ) + normalizedZ * (double)this.levelHeight)) > seaLevel) {
                    roundedHeight = this.levelHeight;
                }
                blockPos.func_181079_c(worldX, 0, worldZ);
                for (int y = 0; y < this.levelHeight; ++y) {
                    Block existingBlock;
                    Block block = Blocks.field_150350_a;
                    if (y <= dirtThreshold) {
                        block = Blocks.field_150346_d;
                    }
                    if (y <= stoneThreshold) {
                        block = this.defaultBlock.func_177230_c();
                    }
                    if (this.levelType == IndevType.FLOATING && y < roundedHeight) {
                        block = Blocks.field_150350_a;
                    }
                    if (!(existingBlock = this.getLevelBlock(x, y, z)).equals(Blocks.field_150350_a)) continue;
                    this.setLevelBlock(x, y, z, block);
                }
            }
        }
    }

    private void growLevel() {
        int surfaceLevel = this.waterLevel - 1;
        if (this.levelTheme == IndevTheme.PARADISE) {
            surfaceLevel += 2;
        }
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            for (int z = 0; z < this.levelLength; ++z) {
                int height;
                Block blockUp;
                boolean genGravel;
                boolean genSand = this.sandOctaveNoise.sample(x, z) > 8.0;
                boolean bl = genGravel = this.gravelOctaveNoise.sample(x, z) > 12.0;
                if (this.levelType == IndevType.ISLAND) {
                    boolean bl2 = genSand = this.sandOctaveNoise.sample(x, z) > -8.0;
                }
                if (this.levelTheme == IndevTheme.PARADISE) {
                    boolean bl3 = genSand = this.sandOctaveNoise.sample(x, z) > -32.0;
                }
                if (this.levelTheme == IndevTheme.WOODS) {
                    boolean bl4 = genSand = this.sandOctaveNoise.sample(x, z) > -8.0;
                }
                if (((blockUp = this.getLevelBlock(x, (height = this.levelHeightmap[x + z * this.levelWidth]) + 1, z)) == this.defaultFluid.func_177230_c() || blockUp == Blocks.field_150350_a) && height <= this.waterLevel - 1 && genGravel) {
                    this.setLevelBlock(x, height, z, Blocks.field_150351_n);
                }
                if (blockUp != Blocks.field_150350_a) continue;
                BlockSand surfaceBlock = null;
                if (height <= surfaceLevel && genSand) {
                    surfaceBlock = Blocks.field_150354_m;
                }
                if (this.getLevelBlock(x, height, z) == Blocks.field_150350_a || surfaceBlock == null) continue;
                this.setLevelBlock(x, height, z, (Block)surfaceBlock);
            }
        }
    }

    private void carveLevel() {
        int caveCount = this.levelWidth * this.levelLength * this.levelHeight / 256 / 64 << 1;
        Random tunnelRandom = new Random(this.seed);
        for (int i = 0; i < caveCount; ++i) {
            this.setPhaseProgress((float)i / (float)(caveCount - 1));
            float caveX = this.random.nextFloat() * (float)this.levelWidth;
            float caveY = this.random.nextFloat() * (float)this.levelHeight;
            float caveZ = this.random.nextFloat() * (float)this.levelLength;
            int caveLen = (int)((this.random.nextFloat() + this.random.nextFloat()) * 200.0f);
            float theta = this.random.nextFloat() * (float)Math.PI * 2.0f;
            float deltaTheta = 0.0f;
            float phi = this.random.nextFloat() * (float)Math.PI * 2.0f;
            float deltaPhi = 0.0f;
            float caveWidth = this.random.nextFloat() * this.random.nextFloat();
            caveWidth *= MathUtil.getRandomFloatInRange(1.0f, this.levelCaveWidth, tunnelRandom);
            for (int len = 0; len < caveLen; ++len) {
                caveX += MathHelper.func_76126_a((float)theta) * MathHelper.func_76134_b((float)phi);
                caveZ += MathHelper.func_76134_b((float)theta) * MathHelper.func_76134_b((float)phi);
                caveY += MathHelper.func_76126_a((float)phi);
                theta += deltaTheta * 0.2f;
                deltaTheta *= 0.9f;
                deltaTheta += this.random.nextFloat() - this.random.nextFloat();
                phi += deltaPhi * 0.5f;
                phi *= 0.5f;
                deltaPhi *= 0.75f;
                deltaPhi += this.random.nextFloat() - this.random.nextFloat();
                if (!(this.random.nextFloat() >= 0.25f)) continue;
                float centerX = caveX + (this.random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float centerY = caveY + (this.random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float centerZ = caveZ + (this.random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float radius = ((float)this.levelHeight - centerY) / (float)this.levelHeight;
                radius = 1.2f + (radius * 3.5f + 1.0f) * caveWidth;
                this.fillOblateSpheroid(centerX, centerY, centerZ, radius *= MathHelper.func_76126_a((float)((float)len * (float)Math.PI / (float)caveLen)), Blocks.field_150350_a);
            }
        }
    }

    private void oreLevel() {
        this.generateDummyOre(Blocks.field_150365_q, 1000, 10, (this.levelHeight << 2) / 5);
        this.generateDummyOre(Blocks.field_150366_p, 800, 8, this.levelHeight * 3 / 5);
        this.generateDummyOre(Blocks.field_150352_o, 500, 6, (this.levelHeight << 1) / 5);
        this.generateDummyOre(Blocks.field_150482_ag, 800, 2, this.levelHeight / 5);
    }

    private void meltLevel() {
        long totalFlooded = 0L;
        int lavaSourceCount = this.levelWidth * this.levelLength * this.levelHeight / 2000;
        for (int i = 0; i < lavaSourceCount; ++i) {
            Vec3d[] floodedPositions;
            int randZ;
            int randY;
            int randX;
            int numFlooded;
            boolean contained;
            if (i % 100 == 0) {
                this.setPhaseProgress((float)i / (float)(lavaSourceCount - 1));
            }
            boolean bl = contained = (numFlooded = this.flood(randX = this.random.nextInt(this.levelWidth), randY = Math.min(Math.min(this.random.nextInt(this.groundLevel), this.random.nextInt(this.groundLevel)), Math.min(this.random.nextInt(this.groundLevel), this.random.nextInt(this.groundLevel))), randZ = this.random.nextInt(this.levelLength), PLACEHOLDER_BLOCK, Blocks.field_150350_a, floodedPositions = new Vec3d[640])) > 0 && numFlooded < 640;
            if (contained) {
                totalFlooded += (long)numFlooded;
            }
            int ndx = 0;
            while (ndx < 640 && floodedPositions[ndx] != null) {
                Vec3d pos = floodedPositions[ndx++];
                this.setLevelBlock((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c, (Block)(contained ? Blocks.field_150353_l : Blocks.field_150350_a));
            }
        }
        ModernBeta.log(Level.DEBUG, String.format("Flood filled %d tiles", totalFlooded));
    }

    private void updateLevel() {
        if (this.levelType == IndevType.FLOATING) {
            this.groundLevel = -128;
            this.waterLevel = this.groundLevel + 1;
        } else if (this.levelType != IndevType.ISLAND) {
            this.groundLevel = this.waterLevel + 1;
            this.waterLevel = this.groundLevel - 16;
        } else {
            this.groundLevel = this.waterLevel - 9;
        }
    }

    private void waterLevel() {
        long totalFlooded = 0L;
        Block fluidBlock = this.defaultFluid.func_177230_c();
        int waterSourceCount = this.levelWidth * this.levelLength * this.levelHeight / 1000;
        for (int i = 0; i < waterSourceCount; ++i) {
            Vec3d[] floodedPositions;
            int randZ;
            int randY;
            int randX;
            int numFlooded;
            boolean contained;
            if (i % 100 == 0) {
                this.setPhaseProgress((float)i / (float)(waterSourceCount - 1));
            }
            boolean bl = contained = (numFlooded = this.flood(randX = this.random.nextInt(this.levelWidth), randY = this.random.nextInt(this.levelHeight), randZ = this.random.nextInt(this.levelLength), PLACEHOLDER_BLOCK, Blocks.field_150350_a, floodedPositions = new Vec3d[640])) > 0 && numFlooded < 640;
            if (contained) {
                totalFlooded += (long)numFlooded;
            }
            int ndx = 0;
            while (ndx < 640 && floodedPositions[ndx] != null) {
                Vec3d pos = floodedPositions[ndx++];
                this.setLevelBlock((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c, contained ? fluidBlock : Blocks.field_150350_a);
            }
        }
        ModernBeta.log(Level.DEBUG, String.format("Flood filled %d tiles", totalFlooded));
        if (this.levelType != IndevType.FLOATING) {
            for (int x = 0; x < this.levelWidth; ++x) {
                totalFlooded += (long)this.flood(x, this.waterLevel - 1, 0, fluidBlock, Blocks.field_150350_a);
                totalFlooded += (long)this.flood(x, this.waterLevel - 1, this.levelLength - 1, fluidBlock, Blocks.field_150350_a);
            }
            for (int z = 0; z < this.levelLength; ++z) {
                totalFlooded += (long)this.flood(this.levelWidth - 1, this.waterLevel - 1, z, fluidBlock, Blocks.field_150350_a);
                totalFlooded += (long)this.flood(0, this.waterLevel - 1, z, fluidBlock, Blocks.field_150350_a);
            }
        }
        ModernBeta.log(Level.DEBUG, String.format("Flood filled %d tiles, including edges", totalFlooded));
    }

    private void plantLevel() {
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            for (int z = 0; z < this.levelLength; ++z) {
                for (int y = 0; y < this.levelHeight - 2; ++y) {
                    Block block = this.getLevelBlock(x, y, z);
                    Block blockUp = this.getLevelBlock(x, y + 1, z);
                    if (!block.equals(Blocks.field_150346_d) || !blockUp.equals(Blocks.field_150350_a)) continue;
                    this.setLevelBlock(x, y, z, (Block)Blocks.field_150349_c);
                }
            }
        }
    }

    private void assembleLevel() {
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            for (int z = 0; z < this.levelLength; ++z) {
                for (int y = 0; y < this.levelHeight; ++y) {
                    Object block = Blocks.field_150350_a;
                    if (y <= 1 && y < this.groundLevel - 1 && this.getLevelBlock(x, y + 1, z) == Blocks.field_150350_a) {
                        block = Blocks.field_150353_l;
                    } else if (y < this.groundLevel - 1) {
                        block = Blocks.field_150357_h;
                    } else if (y < this.groundLevel) {
                        block = this.groundLevel > this.waterLevel && this.defaultFluid.func_177230_c() == Blocks.field_150355_j ? Blocks.field_150349_c : Blocks.field_150346_d;
                    } else if (y < this.waterLevel) {
                        block = this.defaultFluid.func_177230_c();
                    }
                    this.setLevelBlock(x, y, z, (Block)block);
                    if (y != 1 || x == 0 || z == 0 || x == this.levelWidth - 1 || z == this.levelLength - 1) continue;
                    y = this.levelHeight - 2;
                }
            }
        }
    }

    private void generateDummyOre(Block block, int count, int size, int height) {
        int attempts = this.levelWidth * this.levelLength * this.levelHeight / 256 / 64 * count / 100;
        for (int i = 0; i < attempts; ++i) {
            this.random.nextFloat();
            float randY = this.random.nextFloat() * (float)this.levelHeight;
            this.random.nextFloat();
            if (!(randY < (float)height)) continue;
            int randSize = (int)((this.random.nextFloat() + this.random.nextFloat()) * 75.0f * (float)size / 100.0f);
            this.random.nextFloat();
            this.random.nextFloat();
            for (int j = 0; j < randSize; ++j) {
                this.random.nextFloat();
                this.random.nextFloat();
                this.random.nextFloat();
                this.random.nextFloat();
            }
        }
    }

    private void generateWorldBorder(ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        int groundLevel = this.getSeaLevel();
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = this.biomeSource.getBiome(startX + x, startZ + z);
                for (int y = 0; y < this.levelHeight; ++y) {
                    if (y < groundLevel) {
                        chunkPrimer.func_177855_a(x, y, z, BlockStates.BEDROCK);
                        continue;
                    }
                    if (y != groundLevel) continue;
                    chunkPrimer.func_177855_a(x, y, z, biome.field_76752_A);
                }
            }
        }
    }

    private void generateWaterBorder(ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        int seaLevel = this.getSeaLevel();
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = this.biomeSource.getBiome(startX + x, startZ + z);
                for (int y = 0; y < this.levelHeight; ++y) {
                    if (y < seaLevel - 10) {
                        chunkPrimer.func_177855_a(x, y, z, BlockStates.BEDROCK);
                        continue;
                    }
                    if (y == seaLevel - 10) {
                        chunkPrimer.func_177855_a(x, y, z, biome.field_76753_B);
                        continue;
                    }
                    if (y >= seaLevel) continue;
                    chunkPrimer.func_177855_a(x, y, z, this.defaultFluid);
                }
            }
        }
    }
}

