/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.spawn;

import java.util.Random;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.api.world.spawn.WorldSpawner;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.Level;

public class IndevWorldSpawner
implements WorldSpawner {
    @Override
    public BlockPos locateSpawn(BlockPos spawnPos, ChunkSource chunkSource, BiomeSource biomeSource) {
        int spawnZ;
        int spawnX;
        int spawnY;
        if (!(chunkSource instanceof FiniteChunkSource)) {
            return WorldSpawner.DEFAULT.locateSpawn(spawnPos, chunkSource, biomeSource);
        }
        FiniteChunkSource finiteChunkSource = (FiniteChunkSource)chunkSource;
        Random random = new Random();
        int attempts = 0;
        int width = finiteChunkSource.getLevelWidth();
        int length = finiteChunkSource.getLevelLength();
        do {
            spawnX = random.nextInt(width / 2) + width / 4;
            spawnZ = random.nextInt(length / 2) + length / 4;
            spawnY = finiteChunkSource.getHeight(spawnX - width / 2, spawnZ - length / 2, HeightmapChunk.Type.SURFACE) + 2;
            if (attempts >= 1000000) {
                ModernBeta.log(Level.INFO, "[Indev] Exceeded spawn attempts, spawning anyway..");
                break;
            }
            ++attempts;
        } while (spawnY < 4 || spawnY <= finiteChunkSource.getSeaLevel() || this.nearSolidBlocks0(spawnX, spawnY, spawnZ, finiteChunkSource) || this.nearSolidBlocks1(spawnX, spawnY, spawnZ, finiteChunkSource));
        return new BlockPos(spawnX - width / 2, spawnY - 1, spawnZ - length / 2);
    }

    private boolean nearSolidBlocks0(int spawnX, int spawnY, int spawnZ, FiniteChunkSource chunkSource) {
        for (int x = spawnX - 3; x <= spawnX + 3; ++x) {
            for (int y = spawnY - 1; y <= spawnY + 2; ++y) {
                for (int z = spawnZ - 3 - 2; z <= spawnZ + 3; ++z) {
                    Block block = chunkSource.getLevelBlock(x, y, z);
                    if (block.equals(Blocks.field_150350_a) || block.equals(chunkSource.getDefaultFluid().func_177230_c())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean nearSolidBlocks1(int spawnX, int spawnY, int spawnZ, FiniteChunkSource chunkSource) {
        int y = spawnY - 2;
        for (int x = spawnX - 3; x <= spawnX + 3; ++x) {
            for (int z = spawnZ - 3 - 2; z <= spawnZ + 3; ++z) {
                Block block = chunkSource.getLevelBlock(x, y, z);
                if (!block.equals(Blocks.field_150350_a) && !block.equals(chunkSource.getDefaultFluid().func_177230_c())) continue;
                return true;
            }
        }
        return false;
    }
}

