/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge;

import java.io.File;
import mod.bespectacled.modernbetaforge.ModernBetaProxy;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaModRegistry;
import mod.bespectacled.modernbetaforge.command.CommandDrawMap;
import mod.bespectacled.modernbetaforge.command.CommandGetGeneratorSetting;
import mod.bespectacled.modernbetaforge.command.CommandLocateBiome;
import mod.bespectacled.modernbetaforge.command.CommandLocateStructure;
import mod.bespectacled.modernbetaforge.command.CommandSetGeneratorSetting;
import mod.bespectacled.modernbetaforge.compat.ModCompat;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.event.PlayerEventHandler;
import mod.bespectacled.modernbetaforge.event.WorldEventHandler;
import mod.bespectacled.modernbetaforge.network.ModernBetaPacketHandler;
import mod.bespectacled.modernbetaforge.registry.ModernBetaBuiltInRegistries;
import mod.bespectacled.modernbetaforge.util.datafix.ModDataFixer;
import mod.bespectacled.modernbetaforge.world.ModernBetaWorldType;
import mod.bespectacled.modernbetaforge.world.structure.ModernBetaStructures;
import net.minecraft.command.ICommand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="modernbetaforge", name="Modern Beta Forge", version="1.8.3.0", acceptedMinecraftVersions="1.12.2")
public class ModernBeta {
    public static final String MODID = "modernbetaforge";
    public static final String NAME = "Modern Beta Forge";
    public static final String VERSION = "1.8.3.0";
    public static final String MCVERSION = "1.12.2";
    public static final int DATA_VERSION = 1810;
    private static final Logger LOGGER = LogManager.getLogger((String)"modernbetaforge");
    private static File configDir;
    @SidedProxy(clientSide="mod.bespectacled.modernbetaforge.ModernBetaClientProxy", serverSide="mod.bespectacled.modernbetaforge.ModernBetaServerProxy")
    public static ModernBetaProxy proxy;

    public static void log(Level level, String message) {
        LOGGER.log(level, "{}", (Object)message);
    }

    public static void log(String message) {
        ModernBeta.log(Level.INFO, message);
    }

    public static ResourceLocation createRegistryKey(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static File getConfigDirectory() {
        return configDir;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDir = event.getModConfigurationDirectory();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) throws Exception {
        ModernBetaModRegistry.INSTANCE.register(MODID, 1810);
        MinecraftForge.EVENT_BUS.register((Object)new WorldEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        ModernBetaWorldType.register();
        ModernBetaStructures.register();
        ModernBetaPacketHandler.register();
        ModernBetaBuiltInRegistries.registerChunkSources();
        ModernBetaBuiltInRegistries.registerBiomeSources();
        ModernBetaBuiltInRegistries.registerNoiseSettings();
        ModernBetaBuiltInRegistries.registerSurfaceBuilders();
        ModernBetaBuiltInRegistries.registerCarvers();
        ModernBetaBuiltInRegistries.registerCaveCarvers();
        ModernBetaBuiltInRegistries.registerWorldSpawners();
        ModernBetaBuiltInRegistries.registerDefaultBlocks();
        ModernBetaBuiltInRegistries.registerModDataFixes();
        if (ModernBetaConfig.debugOptions.registerDebugProperties) {
            ModernBetaBuiltInRegistries.registerProperties();
        }
        ModCompat.loadCompat();
        proxy.init();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        ModDataFixer.INSTANCE.register();
    }

    @Mod.EventHandler
    private void onFMLServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
    }

    @Mod.EventHandler
    private void onFMLServerStartingEvent(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandLocateStructure());
        event.registerServerCommand((ICommand)new CommandLocateBiome());
        event.registerServerCommand((ICommand)new CommandDrawMap());
        event.registerServerCommand((ICommand)new CommandSetGeneratorSetting());
        event.registerServerCommand((ICommand)new CommandGetGeneratorSetting());
    }
}

