/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.chunk.surface;

import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.surface.SurfaceBuilder;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.common.BiomeDictionary;

public abstract class NoiseSurfaceBuilder
extends SurfaceBuilder {
    private final PerlinOctaveNoise defaultBeachOctaveNoise;
    private final PerlinOctaveNoise defaultSurfaceOctaveNoise;
    private final boolean useBedrockRandom;
    private final boolean useSandstoneRandom;
    private final boolean swapCoords;

    public NoiseSurfaceBuilder(ChunkSource chunkSource, ModernBetaGeneratorSettings settings, boolean useBedrockRandom, boolean useSandstoneRandom, boolean swapCoords) {
        super(chunkSource, settings);
        Random random = new Random(chunkSource.getSeed());
        this.defaultBeachOctaveNoise = new PerlinOctaveNoise(random, 4, true);
        this.defaultSurfaceOctaveNoise = new PerlinOctaveNoise(random, 4, true);
        this.useBedrockRandom = useBedrockRandom;
        this.useSandstoneRandom = useSandstoneRandom;
        this.swapCoords = swapCoords;
    }

    @Override
    public final void provideSurface(World world, Biome[] biomes, ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        Random random = this.createSurfaceRandom(chunkX, chunkZ);
        Random bedrockRandom = this.createSurfaceRandom(chunkX, chunkZ);
        Random sandstoneRandom = this.createSurfaceRandom(chunkX, chunkZ);
        BiConsumer<Integer, Integer> surfaceGenerator = (localX, localZ) -> {
            int x = startX + localX;
            int z = startZ + localZ;
            boolean isBeach = this.isBeach(x, z, random);
            boolean isGravelBeach = this.isGravelBeach(x, z, random);
            int surfaceDepth = this.sampleSurfaceDepth(x, z, random);
            int runDepth = -1;
            Biome biome = biomes[localX + localZ * 16];
            boolean isNether = this.isNether(biome);
            IBlockState topBlock = biome.field_76752_A;
            IBlockState fillerBlock = biome.field_76753_B;
            if (this.useCustomSurfaceBuilder(world, biome, chunkPrimer, random, x, z, false)) {
                return;
            }
            for (int y = this.getWorldHeight() - 1; y >= 0; --y) {
                if (this.isBedrock(y, this.useBedrockRandom ? bedrockRandom : random)) {
                    chunkPrimer.func_177855_a(localX.intValue(), y, localZ.intValue(), BlockStates.BEDROCK);
                    continue;
                }
                IBlockState blockState = chunkPrimer.func_177856_a(localX.intValue(), y, localZ.intValue());
                if (BlockStates.isAir(blockState)) {
                    runDepth = -1;
                    continue;
                }
                if (!BlockStates.isEqual(blockState, this.defaultBlock)) continue;
                if (runDepth == -1) {
                    if (this.isBasin(surfaceDepth)) {
                        topBlock = BlockStates.AIR;
                        fillerBlock = this.defaultBlock;
                    } else if (this.atBeachDepth(y)) {
                        topBlock = biome.field_76752_A;
                        fillerBlock = biome.field_76753_B;
                        if (isGravelBeach) {
                            topBlock = this.getGravelBeachTopBlock(biome, isNether);
                            fillerBlock = this.getGravelBeachFillerBlock(biome, isNether);
                        }
                        if (isBeach) {
                            IBlockState beachBlock;
                            topBlock = beachBlock = this.getBeachBlock(biome, isNether);
                            fillerBlock = beachBlock;
                        }
                    }
                    if (y < this.getSeaLevel() && BlockStates.isAir(topBlock)) {
                        topBlock = this.defaultFluid;
                    }
                    runDepth = surfaceDepth;
                    if (y >= this.getSeaLevel() - 1) {
                        chunkPrimer.func_177855_a(localX.intValue(), y, localZ.intValue(), topBlock);
                        continue;
                    }
                    chunkPrimer.func_177855_a(localX.intValue(), y, localZ.intValue(), fillerBlock);
                    continue;
                }
                if (runDepth <= 0) continue;
                chunkPrimer.func_177855_a(localX.intValue(), y, localZ.intValue(), fillerBlock);
                if (!this.useSandstone() || --runDepth != 0 || !BlockStates.isEqual(fillerBlock, BlockStates.SAND)) continue;
                runDepth = this.useSandstoneRandom ? sandstoneRandom.nextInt(4) : random.nextInt(4);
                fillerBlock = fillerBlock.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? BlockStates.RED_SANDSTONE : BlockStates.SANDSTONE;
            }
        };
        if (this.swapCoords) {
            for (int localX2 = 0; localX2 < 16; ++localX2) {
                for (int localZ2 = 0; localZ2 < 16; ++localZ2) {
                    surfaceGenerator.accept(localX2, localZ2);
                }
            }
        } else {
            for (int localZ3 = 0; localZ3 < 16; ++localZ3) {
                for (int localX3 = 0; localX3 < 16; ++localX3) {
                    surfaceGenerator.accept(localX3, localZ3);
                }
            }
        }
    }

    public abstract boolean isBeach(int var1, int var2, @Nullable Random var3);

    public abstract boolean isGravelBeach(int var1, int var2, @Nullable Random var3);

    public abstract int sampleSurfaceDepth(int var1, int var2, @Nullable Random var3);

    public abstract boolean isBasin(int var1);

    public boolean atBeachDepth(int y) {
        return y >= this.getSeaLevel() - 4 && y <= this.getSeaLevel() + 1;
    }

    protected PerlinOctaveNoise getBeachOctaveNoise() {
        return this.chunkSource.getBeachOctaveNoise().orElse(this.defaultBeachOctaveNoise);
    }

    protected PerlinOctaveNoise getSurfaceOctaveNoise() {
        return this.chunkSource.getSurfaceOctaveNoise().orElse(this.defaultSurfaceOctaveNoise);
    }

    protected double getSurfaceVariation(@Nullable Random random) {
        return random != null ? random.nextDouble() : 0.0;
    }

    private IBlockState getGravelBeachTopBlock(Biome biome, boolean isNether) {
        if (isNether) {
            return BlockStates.GRAVEL;
        }
        return BlockStates.AIR;
    }

    private IBlockState getGravelBeachFillerBlock(Biome biome, boolean isNether) {
        if (isNether) {
            return this.defaultBlock;
        }
        return BlockStates.GRAVEL;
    }

    private IBlockState getBeachBlock(Biome biome, boolean isNether) {
        if (isNether) {
            return Blocks.field_150425_aM.func_176223_P();
        }
        return BlockStates.SAND;
    }

    private boolean isNether(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
    }
}

