/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.mixin;

import java.util.Random;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.mixin.accessor.AccessorStructureStart;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeHolders;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.structure.StructureWeightSampler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MapGenScatteredFeature.Start.class})
public abstract class MixinMapGenScatteredFeatureStart {
    @Inject(method={"<init>(Lnet/minecraft/world/World;Ljava/util/Random;IILnet/minecraft/world/biome/Biome;)V"}, at={@At(value="TAIL")})
    private void injectStart(World world, Random random, int chunkX, int chunkZ, Biome biome, CallbackInfo info) {
        AccessorStructureStart start = (AccessorStructureStart)((Object)this);
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        if (biome == ModernBetaBiomeHolders.BETA_RAINFOREST) {
            start.getComponents().add((StructureComponent)new ComponentScatteredFeaturePieces.JunglePyramid(random, startX, startZ));
        } else if (biome == ModernBetaBiomeHolders.BETA_SWAMPLAND) {
            start.getComponents().add((StructureComponent)new ComponentScatteredFeaturePieces.SwampHut(random, startX, startZ));
        } else if (biome == ModernBetaBiomeHolders.BETA_DESERT) {
            start.getComponents().add((StructureComponent)new ComponentScatteredFeaturePieces.DesertPyramid(random, startX, startZ));
        } else if (biome == ModernBetaBiomeHolders.BETA_TUNDRA || biome == ModernBetaBiomeHolders.BETA_TAIGA) {
            start.getComponents().add((StructureComponent)new ComponentScatteredFeaturePieces.Igloo(random, startX, startZ));
        }
        start.invokeUpdateBoundingBox();
        WorldServer worldServer = (WorldServer)world;
        IChunkGenerator chunkGenerator = worldServer.func_72863_F().field_186029_c;
        if (chunkGenerator instanceof ModernBetaChunkGenerator) {
            int numComponents = StructureWeightSampler.cacheStructures((ModernBetaChunkGenerator)chunkGenerator, (StructureStart)this, component -> !(component instanceof ComponentScatteredFeaturePieces.JunglePyramid));
            ModernBeta.log(Level.DEBUG, String.format("Start at %d/%d. Number of temple components: %d", startX, startZ, numComponents));
        }
    }
}

