/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.mixin.client;

import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={World.class})
public abstract class MixinWorld {
    @Inject(method={"getCloudColorBody"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectGetCloudColorBody(float partialTicks, CallbackInfoReturnable<Vec3d> info) {
        ModernBetaBiome modernBetaBiome;
        int cloudColor;
        WorldClient world = (WorldClient)this;
        Biome biome = world.func_180494_b(Minecraft.func_71410_x().func_175606_aa().func_180425_c());
        if (biome != null && biome instanceof ModernBetaBiome && (cloudColor = (modernBetaBiome = (ModernBetaBiome)biome).getCloudColor()) != -1) {
            Vec3d cloudColorVec = MathUtil.convertRGBIntToVec3d(cloudColor);
            float r = (float)cloudColorVec.field_72450_a;
            float g = (float)cloudColorVec.field_72448_b;
            float b = (float)cloudColorVec.field_72449_c;
            float celestialAngle = world.func_72826_c(partialTicks);
            celestialAngle = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
            celestialAngle = MathHelper.func_76131_a((float)celestialAngle, (float)0.0f, (float)1.0f);
            float rainStrength = world.func_72867_j(partialTicks);
            if (rainStrength > 0.0f) {
                float colorAddition = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
                float delta = 1.0f - rainStrength * 0.95f;
                r = r * delta + colorAddition * (1.0f - delta);
                g = g * delta + colorAddition * (1.0f - delta);
                b = b * delta + colorAddition * (1.0f - delta);
            }
            r *= celestialAngle * 0.9f + 0.1f;
            g *= celestialAngle * 0.9f + 0.1f;
            b *= celestialAngle * 0.85f + 0.15f;
            float thunderStrength = world.func_72819_i(partialTicks);
            if (thunderStrength > 0.0f) {
                float colorAddition = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
                float delta = 1.0f - thunderStrength * 0.95f;
                r = r * delta + colorAddition * (1.0f - delta);
                g = g * delta + colorAddition * (1.0f - delta);
                b = b * delta + colorAddition * (1.0f - delta);
            }
            info.setReturnValue((Object)new Vec3d((double)r, (double)g, (double)b));
        }
    }
}

