/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.ClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.ForgeRegistryUtil;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBeta;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBetaRainforest;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.feature.WorldGenClay;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenCactus;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public abstract class ModernBetaBiomeDecorator
extends BiomeDecorator {
    public static final WorldGenerator FEATURE_DANDELION = new WorldGenFlowers(Blocks.field_150327_N, BlockFlower.EnumFlowerType.DANDELION);
    public static final WorldGenerator FEATURE_POPPY = new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.POPPY);
    protected static final WorldGenerator FEATURE_DEAD_BUSH = new WorldGenDeadBush();
    protected static final WorldGenerator FEATURE_BROWN_SHROOM = new WorldGenBush(Blocks.field_150338_P);
    protected static final WorldGenerator FEATURE_RED_SHROOM = new WorldGenBush(Blocks.field_150337_Q);
    protected static final WorldGenerator FEATURE_REED = new WorldGenReed();
    protected static final WorldGenerator FEATURE_PUMPKIN = new WorldGenPumpkin();
    protected static final WorldGenerator FEATURE_CACTUS = new WorldGenCactus();
    private static final WorldGenerator FEATURE_LAVA_LAKES = new WorldGenLakes((Block)Blocks.field_150353_l);
    private static final WorldGenerator FEATURE_DUNGEONS = new WorldGenDungeons();
    private static final WorldGenerator FEATURE_LAVA_FALL = new WorldGenLiquids((Block)Blocks.field_150356_k);
    private static final Set<Block> VANILLA_FLUIDS = ImmutableSet.of((Object)Blocks.field_150355_j, (Object)Blocks.field_150358_i, (Object)Blocks.field_150353_l, (Object)Blocks.field_150356_k);
    private WorldGenerator oreClay;
    private WorldGenerator oreDirt;
    private WorldGenerator oreGravel;
    private WorldGenerator oreCoal;
    private WorldGenerator oreIron;
    private WorldGenerator oreGold;
    private WorldGenerator oreRedstone;
    private WorldGenerator oreDiamond;
    private WorldGenerator oreLapis;
    private WorldGenerator oreGranite;
    private WorldGenerator oreDiorite;
    private WorldGenerator oreAndesite;
    private WorldGenerator oreEmerald;

    protected abstract int getTreeCount(World var1, Random var2, Biome var3, BlockPos var4);

    protected void populateOres(World world, Random random, Biome biome, BlockPos startPos, BlockPos.MutableBlockPos mutablePos) {
        ModernBetaGeneratorSettings settings = ModernBetaGeneratorSettings.buildOrGet(world);
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        ChunkPos chunkPos = new ChunkPos(startX >> 4, startZ >> 4);
        this.oreClay = new WorldGenClay(settings.claySize);
        this.oreDirt = new WorldGenMinable(BlockStates.DIRT, settings.dirtSize);
        this.oreGravel = new WorldGenMinable(BlockStates.GRAVEL, settings.gravelSize);
        this.oreCoal = new WorldGenMinable(BlockStates.COAL_ORE, settings.coalSize);
        this.oreIron = new WorldGenMinable(BlockStates.IRON_ORE, settings.ironSize);
        this.oreGold = new WorldGenMinable(BlockStates.GOLD_ORE, settings.goldSize);
        this.oreRedstone = new WorldGenMinable(BlockStates.REDSTONE_ORE, settings.redstoneSize);
        this.oreDiamond = new WorldGenMinable(BlockStates.DIAMOND_ORE, settings.diamondSize);
        this.oreLapis = new WorldGenMinable(BlockStates.LAPIS_ORE, settings.lapisSize);
        this.oreGranite = new WorldGenMinable(BlockStates.GRANITE, settings.graniteSize);
        this.oreDiorite = new WorldGenMinable(BlockStates.DIORITE, settings.dioriteSize);
        this.oreAndesite = new WorldGenMinable(BlockStates.ANDESITE, settings.andesiteSize);
        this.oreEmerald = new WorldGenMinable(BlockStates.EMERALD_ORE, settings.emeraldSize);
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreClay, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreClay, mutablePos, settings.clayCount, settings.clayMinHeight, settings.clayMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreDirt, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIRT)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreDirt, mutablePos, settings.dirtCount, settings.dirtMinHeight, settings.dirtMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreGravel, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GRAVEL)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreGravel, mutablePos, settings.gravelCount, settings.gravelMinHeight, settings.gravelMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreDiorite, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIORITE)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreDiorite, mutablePos, settings.dioriteCount, settings.dioriteMinHeight, settings.dioriteMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreGranite, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GRANITE)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreGranite, mutablePos, settings.graniteCount, settings.graniteMinHeight, settings.graniteMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreAndesite, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.ANDESITE)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreAndesite, mutablePos, settings.andesiteCount, settings.andesiteMinHeight, settings.andesiteMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreCoal, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.COAL)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreCoal, mutablePos, settings.coalCount, settings.coalMinHeight, settings.coalMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreIron, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.IRON)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreIron, mutablePos, settings.ironCount, settings.ironMinHeight, settings.ironMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreGold, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GOLD)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreGold, mutablePos, settings.goldCount, settings.goldMinHeight, settings.goldMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreRedstone, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.REDSTONE)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreRedstone, mutablePos, settings.redstoneCount, settings.redstoneMinHeight, settings.redstoneMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreDiamond, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreDiamond, mutablePos, settings.diamondCount, settings.diamondMinHeight, settings.diamondMaxHeight);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreLapis, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.LAPIS)) {
            ModernBetaBiomeDecorator.populateOreSpread(world, random, startPos, this.oreLapis, mutablePos, settings.lapisCount, settings.lapisCenterHeight, settings.lapisSpread);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.oreEmerald, (BlockPos)startPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.EMERALD)) {
            ModernBetaBiomeDecorator.populateOreStandard(world, random, startPos, this.oreEmerald, mutablePos, settings.emeraldCount, settings.emeraldMinHeight, settings.emeraldMaxHeight);
        }
        if (settings.useSandDisks && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND)) {
            ModernBetaBiomeDecorator.populateDisks(world, random, startPos, this.field_76810_g, mutablePos, this.field_76805_H);
        }
        if (settings.useClayDisks && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CLAY)) {
            ModernBetaBiomeDecorator.populateDisks(world, random, startPos, this.field_76809_f, mutablePos, this.field_76806_I);
        }
        if (settings.useGravelDisks && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND_PASS2)) {
            ModernBetaBiomeDecorator.populateDisks(world, random, startPos, this.field_76822_h, mutablePos, this.field_76801_G);
        }
    }

    protected void populateTrees(World world, Random random, Biome biome, BlockPos startPos, BlockPos.MutableBlockPos mutablePos, Supplier<WorldGenAbstractTree> treeFunc) {
        int treeCount = this.getTreeCount(world, random, biome, startPos);
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        for (int i = 0; i < treeCount; ++i) {
            int x = startX + random.nextInt(16) + 8;
            int z = startZ + random.nextInt(16) + 8;
            WorldGenAbstractTree worldGenTree = treeFunc.get();
            worldGenTree.func_175904_e();
            BlockPos treePos = world.func_175645_m((BlockPos)mutablePos.func_181079_c(x, 0, z));
            if (!worldGenTree.func_180709_b(world, random, treePos)) continue;
            worldGenTree.func_180711_a(world, random, treePos);
        }
    }

    protected void populateWaterfalls(World world, Random random, BlockPos startPos, BlockPos.MutableBlockPos mutablePos, int height) {
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        ModernBetaGeneratorSettings settings = ModernBetaGeneratorSettings.buildOrGet(world);
        Block fluidBlock = ForgeRegistryUtil.getFluid(settings.defaultFluid).getBlock();
        if (fluidBlock == null || VANILLA_FLUIDS.contains(fluidBlock)) {
            fluidBlock = Blocks.field_150358_i;
        }
        WorldGenLiquids worldGenLiquids = new WorldGenLiquids(fluidBlock);
        for (int i = 0; i < 50; ++i) {
            int x = startX + random.nextInt(16) + 8;
            int y = random.nextInt(random.nextInt(height - 8) + 8);
            int z = startZ + random.nextInt(16) + 8;
            worldGenLiquids.func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
    }

    protected void populateLavafalls(World world, Random random, BlockPos startPos, BlockPos.MutableBlockPos mutablePos, int height) {
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        for (int i = 0; i < 20; ++i) {
            int x = startX + random.nextInt(16) + 8;
            int y = random.nextInt(random.nextInt(random.nextInt(height - 16) + 8) + 8);
            int z = startZ + random.nextInt(16) + 8;
            FEATURE_LAVA_FALL.func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
    }

    protected PerlinOctaveNoise getForestOctaveNoise(World world, int chunkX, int chunkZ) {
        ChunkProviderServer chunkProviderServer = (ChunkProviderServer)world.func_72863_F();
        IChunkGenerator chunkGenerator = chunkProviderServer.field_186029_c;
        Random random = new Random(world.func_72905_C());
        if (chunkGenerator instanceof ModernBetaChunkGenerator) {
            ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
            ChunkSource chunkSource = modernBetaChunkGenerator.getChunkSource();
            return chunkSource.getForestOctaveNoise().orElse(new PerlinOctaveNoise(random, 8, true));
        }
        return new PerlinOctaveNoise(random, 8, true);
    }

    public static void populateWorldGenCount(World world, Random random, BlockPos startPos, WorldGenerator generator, BlockPos.MutableBlockPos mutablePos, int count, int height) {
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        for (int i = 0; i < count; ++i) {
            int x = startX + random.nextInt(16) + 8;
            int y = random.nextInt(height);
            int z = startZ + random.nextInt(16) + 8;
            generator.func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
    }

    public static void populateWorldGenChance(World world, Random random, BlockPos startPos, WorldGenerator generator, BlockPos.MutableBlockPos mutablePos, int chance, int height) {
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        if (random.nextInt(chance) == 0) {
            int x = startX + random.nextInt(16) + 8;
            int y = random.nextInt(height);
            int z = startZ + random.nextInt(16) + 8;
            generator.func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
    }

    public static void populateOreStandard(World world, Random random, BlockPos startPos, WorldGenerator generator, BlockPos.MutableBlockPos mutablePos, int count, int minHeight, int maxHeight) {
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        for (int i = 0; i < count; ++i) {
            int x = startX + random.nextInt(16);
            int y = ModernBetaBiomeDecorator.getOreHeight(random, minHeight, maxHeight);
            int z = startZ + random.nextInt(16);
            generator.func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
    }

    public static void populateOreSpread(World world, Random random, BlockPos startPos, WorldGenerator generator, BlockPos.MutableBlockPos mutablePos, int count, int centerHeight, int spread) {
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        for (int i = 0; i < count; ++i) {
            int x = startX + random.nextInt(16);
            int y = ModernBetaBiomeDecorator.getOreHeightSpread(random, centerHeight, spread);
            int z = startZ + random.nextInt(16);
            generator.func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
    }

    public static void populateDisks(World world, Random random, BlockPos startPos, WorldGenerator generator, BlockPos.MutableBlockPos mutablePos, int count) {
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        for (int i = 0; i < count; ++i) {
            int x = startX + random.nextInt(16) + 8;
            int z = startZ + random.nextInt(16) + 8;
            generator.func_180709_b(world, random, world.func_175672_r((BlockPos)mutablePos.func_181079_c(x, 0, z)));
        }
    }

    public static void populateTallGrassCount(World world, Random random, Biome biome, BlockPos startPos, BlockPos.MutableBlockPos mutablePos, int count, int height) {
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        for (int i = 0; i < count; ++i) {
            BlockTallGrass.EnumType tallGrassType = BlockTallGrass.EnumType.GRASS;
            if (biome instanceof BiomeBetaRainforest && random.nextInt(3) != 0) {
                tallGrassType = BlockTallGrass.EnumType.FERN;
            }
            int x = startX + random.nextInt(16) + 8;
            int y = random.nextInt(height);
            int z = startZ + random.nextInt(16) + 8;
            new WorldGenTallGrass(tallGrassType).func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
    }

    public static void populateTallGrassChance(World world, Random random, Biome biome, BlockPos startPos, BlockPos.MutableBlockPos mutablePos, int chance, int height) {
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        if (random.nextInt(chance) == 0) {
            BlockTallGrass.EnumType tallGrassType = BlockTallGrass.EnumType.GRASS;
            if (biome instanceof BiomeBetaRainforest && random.nextInt(3) != 0) {
                tallGrassType = BlockTallGrass.EnumType.FERN;
            }
            int x = startX + random.nextInt(16) + 8;
            int y = random.nextInt(height);
            int z = startZ + random.nextInt(16) + 8;
            new WorldGenTallGrass(tallGrassType).func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
    }

    public static void populateWaterLakes(World world, Random random, ModernBetaGeneratorSettings settings, BlockPos.MutableBlockPos mutablePos, int chunkX, int chunkZ, IBlockState defaultFluid) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        Block fluidBlock = ForgeRegistryUtil.getFluid(settings.defaultFluid).getBlock();
        if (fluidBlock == null || VANILLA_FLUIDS.contains(fluidBlock)) {
            fluidBlock = Blocks.field_150355_j;
        }
        WorldGenLakes worldGenLakes = new WorldGenLakes(fluidBlock);
        if (random.nextInt(settings.waterLakeChance) == 0) {
            int x = startX + random.nextInt(16) + 8;
            int y = random.nextInt(settings.height);
            int z = startZ + random.nextInt(16) + 8;
            worldGenLakes.func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
    }

    public static void populateLavaLakes(World world, Random random, ModernBetaGeneratorSettings settings, BlockPos.MutableBlockPos mutablePos, int chunkX, int chunkZ) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        if (random.nextInt(settings.lavaLakeChance / 10) == 0) {
            int x = startX + random.nextInt(16) + 8;
            int y = random.nextInt(random.nextInt(settings.height - 8) + 8);
            int z = startZ + random.nextInt(16) + 8;
            if (y < 64 || random.nextInt(10) == 0) {
                FEATURE_LAVA_LAKES.func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
            }
        }
    }

    public static void populateDungeons(World world, Random random, ModernBetaGeneratorSettings settings, BlockPos.MutableBlockPos mutablePos, int chunkX, int chunkZ) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        for (int i = 0; i < settings.dungeonChance; ++i) {
            int x = startX + random.nextInt(16) + 8;
            int y = random.nextInt(settings.height);
            int z = startZ + random.nextInt(16) + 8;
            FEATURE_DUNGEONS.func_180709_b(world, random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
    }

    public static void populateSnowIce(World world, Random random, ModernBetaBiomeProvider biomeProvider, BlockPos.MutableBlockPos mutablePos, int chunkX, int chunkZ, int snowLineOffset) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        BiomeSource biomeSource = biomeProvider.getBiomeSource();
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int x = localX + startX + 8;
                int z = localZ + startZ + 8;
                int y = world.func_175725_q((BlockPos)mutablePos.func_181079_c(x, 0, z)).func_177956_o();
                Biome biome = biomeProvider.func_180631_a((BlockPos)mutablePos);
                BlockPos blockPosDown = mutablePos.func_181079_c(x, y, z).func_177977_b();
                boolean canSetIce = false;
                boolean canSetSnow = false;
                if (biomeSource instanceof ClimateSampler && ((ClimateSampler)((Object)biomeSource)).sampleForFeatureGeneration()) {
                    double temp = ((ClimateSampler)((Object)biomeSource)).sample(x, z).temp();
                    canSetIce = BiomeBeta.canSetIceBeta(world, blockPosDown, false, temp -= (double)(y - snowLineOffset) / (double)snowLineOffset * 0.3);
                    canSetSnow = BiomeBeta.canSetSnowBeta(world, (BlockPos)mutablePos, temp);
                } else if (biome instanceof ModernBetaBiome) {
                    ModernBetaBiome modernBetaBiome = (ModernBetaBiome)biome;
                    double temp = biome.func_185353_n();
                    canSetIce = modernBetaBiome.canSetIce(world, blockPosDown, false, temp);
                    canSetSnow = modernBetaBiome.canSetSnow(world, (BlockPos)mutablePos, temp);
                } else {
                    canSetIce = world.func_175675_v(blockPosDown);
                    canSetSnow = world.func_175708_f((BlockPos)mutablePos, true);
                }
                if (canSetIce) {
                    world.func_180501_a(blockPosDown, Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (!canSetSnow) continue;
                world.func_180501_a((BlockPos)mutablePos, Blocks.field_150431_aC.func_176223_P(), 2);
            }
        }
    }

    private static int getOreHeight(Random random, int minHeight, int maxHeight) {
        if (maxHeight < minHeight) {
            int height = minHeight;
            minHeight = maxHeight;
            maxHeight = height;
        } else if (maxHeight == minHeight) {
            if (minHeight < 255) {
                ++maxHeight;
            } else {
                --minHeight;
            }
        }
        return random.nextInt(maxHeight - minHeight) + minHeight;
    }

    private static int getOreHeightSpread(Random random, int centerHeight, int spread) {
        return random.nextInt(spread) + random.nextInt(spread) + centerHeight - spread;
    }
}

