/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.biomes.beta;

import mod.bespectacled.modernbetaforge.client.color.BetaColorSampler;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeDecoratorBeta;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BiomeBeta
extends ModernBetaBiome {
    protected static final Biome.SpawnListEntry RABBIT = new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3);
    protected static final Biome.SpawnListEntry RABBIT_TUNDRA = new Biome.SpawnListEntry(EntityRabbit.class, 10, 2, 3);
    protected static final Biome.SpawnListEntry POLAR_BEAR = new Biome.SpawnListEntry(EntityPolarBear.class, 1, 1, 2);
    protected static final Biome.SpawnListEntry HORSE_PLAINS = new Biome.SpawnListEntry(EntityHorse.class, 5, 2, 6);
    protected static final Biome.SpawnListEntry HORSE_SAVANNA = new Biome.SpawnListEntry(EntityHorse.class, 1, 2, 6);
    protected static final Biome.SpawnListEntry DONKEY_PLAINS = new Biome.SpawnListEntry(EntityDonkey.class, 1, 1, 3);
    protected static final Biome.SpawnListEntry DONKEY_SAVANNA = new Biome.SpawnListEntry(EntityDonkey.class, 1, 1, 1);
    protected static final Biome.SpawnListEntry LLAMA = new Biome.SpawnListEntry(EntityLlama.class, 1, 4, 4);
    protected static final Biome.SpawnListEntry PARROT = new Biome.SpawnListEntry(EntityParrot.class, 40, 1, 2);
    protected static final Biome.SpawnListEntry OCELOT = new Biome.SpawnListEntry(EntityOcelot.class, 2, 1, 1);
    protected static final Biome.SpawnListEntry WOLF_TAIGA = new Biome.SpawnListEntry(EntityWolf.class, 8, 4, 4);
    protected static final Biome.SpawnListEntry HUSK = new Biome.SpawnListEntry(EntityHusk.class, 80, 4, 4);
    protected static final Biome.SpawnListEntry STRAY = new Biome.SpawnListEntry(EntityStray.class, 80, 4, 4);
    protected static final Biome.SpawnListEntry SLIME_SWAMP = new Biome.SpawnListEntry(EntitySlime.class, 1, 1, 1);

    public BiomeBeta(Biome.BiomeProperties properties) {
        super(properties);
        this.populateSpawnableMobs(EnumCreatureType.MONSTER, SPIDER, SKELETON, ZOMBIE, CREEPER, SLIME);
        this.populateSpawnableMobs(EnumCreatureType.CREATURE, SHEEP, PIG, COW, CHICKEN);
    }

    public BiomeDecorator func_76729_a() {
        return this.getModdedBiomeDecorator(new BiomeDecoratorBeta());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float temp) {
        BlockPos blockPos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        if (BetaColorSampler.INSTANCE.canSampleSkyColor()) {
            return BetaColorSampler.INSTANCE.getSkyColor(blockPos);
        }
        return super.func_76731_a(temp);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos blockPos) {
        if (BetaColorSampler.INSTANCE.canSampleBiomeColor()) {
            return BetaColorSampler.INSTANCE.getGrassColor(blockPos);
        }
        return super.func_180627_b(blockPos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos blockPos) {
        if (BetaColorSampler.INSTANCE.canSampleBiomeColor()) {
            return BetaColorSampler.INSTANCE.getFoliageColor(blockPos);
        }
        return super.func_180625_c(blockPos);
    }

    public static boolean canSetIceBeta(World world, BlockPos blockPos, boolean doWaterCheck, double temp) {
        if (temp >= 0.5) {
            return false;
        }
        if (blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, blockPos) < 10) {
            boolean isWater;
            IBlockState blockState = world.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            boolean bl = isWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i;
            if (isWater && (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                boolean submerged;
                if (!doWaterCheck) {
                    return true;
                }
                boolean bl2 = submerged = BiomeBeta.isWater(world, blockPos.func_177976_e()) && BiomeBeta.isWater(world, blockPos.func_177974_f()) && BiomeBeta.isWater(world, blockPos.func_177978_c()) && BiomeBeta.isWater(world, blockPos.func_177968_d());
                if (!submerged) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean canSetSnowBeta(World world, BlockPos blockPos, double temp) {
        IBlockState blockState;
        if (temp >= 0.5) {
            return false;
        }
        return blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, blockPos) < 10 && (blockState = world.func_180495_p(blockPos)).func_177230_c().isAir(blockState, (IBlockAccess)world, blockPos) && Blocks.field_150431_aC.func_176196_c(world, blockPos);
    }

    private static boolean isWater(World world, BlockPos blockPos) {
        return world.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h;
    }
}

