/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.biomes.beta;

import java.util.Random;
import java.util.function.Supplier;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeDecorator;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBetaDesert;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBetaForest;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBetaIceDesert;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBetaPlains;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBetaRainforest;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBetaSeasonalForest;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBetaTaiga;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBetaTundra;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecoratorBeta
extends ModernBetaBiomeDecorator {
    public void func_180292_a(World world, Random random, Biome biome, BlockPos startPos) {
        int plantCount;
        Supplier<WorldGenAbstractTree> treeSupplier;
        ModernBetaGeneratorSettings settings = ModernBetaGeneratorSettings.buildOrGet(world);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        this.field_180294_c = startPos;
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        ChunkPos chunkPos = new ChunkPos(startX >> 4, startZ >> 4);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(world, random, chunkPos));
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(world, random, startPos));
        this.populateOres(world, random, biome, startPos, mutablePos);
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(world, random, startPos));
        Supplier<WorldGenAbstractTree> supplier = treeSupplier = biome instanceof ModernBetaBiome ? () -> ((ModernBetaBiome)biome).getRandomTreeFeature(random, settings) : () -> biome.func_150567_a(random);
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            this.populateTrees(world, random, biome, startPos, mutablePos, treeSupplier);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            plantCount = this.getYellowFlowerCount(biome);
            BiomeDecoratorBeta.populateWorldGenCount(world, random, startPos, FEATURE_DANDELION, mutablePos, plantCount, settings.height);
        }
        if (settings.useTallGrass && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            plantCount = this.getTallGrassCount(biome);
            BiomeDecoratorBeta.populateTallGrassCount(world, random, biome, startPos, mutablePos, plantCount, settings.height);
        }
        if (settings.useTallGrass && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH) && biome instanceof BiomeBetaDesert) {
            BiomeDecoratorBeta.populateWorldGenCount(world, random, startPos, FEATURE_DEAD_BUSH, mutablePos, 2, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            BiomeDecoratorBeta.populateWorldGenChance(world, random, startPos, FEATURE_POPPY, mutablePos, 2, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            BiomeDecoratorBeta.populateWorldGenChance(world, random, startPos, FEATURE_BROWN_SHROOM, mutablePos, 4, settings.height);
            BiomeDecoratorBeta.populateWorldGenChance(world, random, startPos, FEATURE_RED_SHROOM, mutablePos, 8, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED)) {
            BiomeDecoratorBeta.populateWorldGenCount(world, random, startPos, FEATURE_REED, mutablePos, 10, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.PUMPKIN)) {
            BiomeDecoratorBeta.populateWorldGenChance(world, random, startPos, FEATURE_PUMPKIN, mutablePos, 32, settings.height);
        }
        if (biome instanceof BiomeBetaDesert && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            BiomeDecoratorBeta.populateWorldGenCount(world, random, startPos, FEATURE_CACTUS, mutablePos, 10, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
            this.populateWaterfalls(world, random, startPos, mutablePos, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
            this.populateLavafalls(world, random, startPos, mutablePos, settings.height);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(world, random, chunkPos));
    }

    @Override
    protected int getTreeCount(World world, Random random, Biome biome, BlockPos startPos) {
        PerlinOctaveNoise forestOctaveNoise = this.getForestOctaveNoise(world, startPos.func_177958_n() >> 4, startPos.func_177952_p() >> 4);
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        double scale = 0.5;
        int noiseCount = (int)((forestOctaveNoise.sample((double)startX * scale, (double)startZ * scale) / 8.0 + random.nextDouble() * 4.0 + 4.0) / 3.0);
        int treeCount = 0;
        if (random.nextInt(10) == 0) {
            ++treeCount;
        }
        if (biome instanceof BiomeBetaForest) {
            treeCount += noiseCount + 5;
        }
        if (biome instanceof BiomeBetaRainforest) {
            treeCount += noiseCount + 5;
        }
        if (biome instanceof BiomeBetaSeasonalForest) {
            treeCount += noiseCount + 2;
        }
        if (biome instanceof BiomeBetaTaiga) {
            treeCount += noiseCount + 5;
        }
        if (biome instanceof BiomeBetaDesert) {
            treeCount -= 20;
        }
        if (biome instanceof BiomeBetaTundra) {
            treeCount -= 20;
        }
        if (biome instanceof BiomeBetaPlains) {
            treeCount -= 20;
        }
        if (biome instanceof BiomeBetaIceDesert) {
            treeCount -= 20;
        }
        return treeCount;
    }

    private int getYellowFlowerCount(Biome biome) {
        int plantCount = 0;
        if (biome instanceof BiomeBetaForest) {
            plantCount = 2;
        }
        if (biome instanceof BiomeBetaSeasonalForest) {
            plantCount = 4;
        }
        if (biome instanceof BiomeBetaTaiga) {
            plantCount = 2;
        }
        if (biome instanceof BiomeBetaPlains) {
            plantCount = 3;
        }
        return plantCount;
    }

    private int getTallGrassCount(Biome biome) {
        int plantCount = 0;
        if (biome instanceof BiomeBetaForest) {
            plantCount = 2;
        }
        if (biome instanceof BiomeBetaRainforest) {
            plantCount = 10;
        }
        if (biome instanceof BiomeBetaSeasonalForest) {
            plantCount = 2;
        }
        if (biome instanceof BiomeBetaTaiga) {
            plantCount = 1;
        }
        if (biome instanceof BiomeBetaPlains) {
            plantCount = 10;
        }
        return plantCount;
    }
}

