/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.biomes.indev;

import java.util.Random;
import java.util.function.Supplier;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeDecorator;
import mod.bespectacled.modernbetaforge.world.biome.biomes.indev.BiomeIndevParadise;
import mod.bespectacled.modernbetaforge.world.biome.biomes.indev.BiomeIndevWoods;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecoratorIndev
extends ModernBetaBiomeDecorator {
    public void func_180292_a(World world, Random random, Biome biome, BlockPos startPos) {
        int count;
        ModernBetaGeneratorSettings settings = ModernBetaGeneratorSettings.buildOrGet(world);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        this.field_180294_c = startPos;
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        ChunkPos chunkPos = new ChunkPos(startX >> 4, startZ >> 4);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(world, random, chunkPos));
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(world, random, startPos));
        this.populateOres(world, random, biome, startPos, mutablePos);
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(world, random, startPos));
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            this.populateTrees(world, random, biome, startPos, mutablePos, () -> ModernBetaBiome.TREE_FEATURE);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            count = this.getFlowerCount(biome);
            BiomeDecoratorIndev.populateWorldGenCount(world, random, startPos, FEATURE_DANDELION, mutablePos, count, settings.height);
            BiomeDecoratorIndev.populateWorldGenCount(world, random, startPos, FEATURE_POPPY, mutablePos, count, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            count = this.getMushroomCount();
            BiomeDecoratorIndev.populateWorldGenCount(world, random, startPos, FEATURE_BROWN_SHROOM, mutablePos, count, settings.height);
            BiomeDecoratorIndev.populateWorldGenCount(world, random, startPos, FEATURE_RED_SHROOM, mutablePos, count, settings.height);
        }
        if (settings.useTallGrass && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            BiomeDecoratorIndev.populateTallGrassChance(world, random, biome, startPos, mutablePos, 2, settings.height);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(world, random, chunkPos));
    }

    @Override
    protected void populateTrees(World world, Random random, Biome biome, BlockPos startPos, BlockPos.MutableBlockPos mutablePos, Supplier<WorldGenAbstractTree> treeFunc) {
        if (biome instanceof BiomeIndevWoods || random.nextInt(2) == 0) {
            super.populateTrees(world, random, biome, startPos, mutablePos, treeFunc);
        }
    }

    @Override
    protected int getTreeCount(World world, Random random, Biome biome, BlockPos startPos) {
        if (biome instanceof BiomeIndevWoods) {
            return 10;
        }
        return random.nextInt(5);
    }

    private int getFlowerCount(Biome biome) {
        return biome instanceof BiomeIndevParadise ? 20 : 2;
    }

    private int getMushroomCount() {
        return 2;
    }
}

