/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.chunk.indev;

import mod.bespectacled.modernbetaforge.ModernBeta;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import org.apache.logging.log4j.Level;

public enum IndevHouse {
    NONE("none"),
    OAK("oak", Blocks.field_150344_f, Blocks.field_150348_b),
    MOSSY("mossy", Blocks.field_150341_Y, Blocks.field_150341_Y);

    public final String id;
    public final Block wallBlock;
    public final Block floorBlock;

    private IndevHouse(String id, Block wallBlock, Block floorBlock) {
        this.id = id;
        this.wallBlock = wallBlock;
        this.floorBlock = floorBlock;
    }

    private IndevHouse(String id) {
        this(id, null, null);
    }

    public static IndevHouse fromId(String id) {
        for (IndevHouse house : IndevHouse.values()) {
            if (!house.id.equalsIgnoreCase(id)) continue;
            return house;
        }
        throw new IllegalArgumentException("[Modern Beta] No Indev House matching id: " + id);
    }

    public static IndevHouse fromIdOrElse(String id, IndevHouse alternate) {
        IndevHouse house;
        try {
            house = IndevHouse.fromId(id);
        }
        catch (IllegalArgumentException e) {
            ModernBeta.log(Level.WARN, String.format("Did not find IndevHouse id '%s', returning alternate.", id));
            house = alternate;
        }
        return house;
    }
}

