/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.structure.sim;

import java.util.Random;
import java.util.function.BiFunction;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.structure.ModernBetaStructures;
import mod.bespectacled.modernbetaforge.world.structure.sim.StructureSim;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStronghold;

public class StructureSimStronghold
extends StructureSim {
    private static final MapGenStronghold STRONGHOLD = new MapGenStronghold();
    private final ChunkSource chunkSource;
    private final ChunkPos[] structureCoords;
    private final double distance;
    private int spread;
    private boolean generatedPositions;

    public StructureSimStronghold(ChunkSource chunkSource) {
        super(chunkSource.getSeed());
        this.chunkSource = chunkSource;
        this.structureCoords = new ChunkPos[128];
        this.distance = 32.0;
        this.spread = 3;
    }

    @Override
    public boolean canSpawnStructureAtCoords(int chunkX, int chunkZ, BiFunction<Integer, Integer, Biome> biomeFunc) {
        if (!this.generatedPositions) {
            this.generatePositions(biomeFunc);
            this.generatedPositions = true;
        }
        for (ChunkPos chunkPos : this.structureCoords) {
            if (chunkPos == null || chunkX != chunkPos.field_77276_a || chunkZ != chunkPos.field_77275_b) continue;
            return true;
        }
        return false;
    }

    private void generatePositions(BiFunction<Integer, Integer, Biome> biomeFunc) {
        Random random = new Random();
        random.setSeed(this.seed);
        double theta = random.nextDouble() * Math.PI * 2.0;
        int count = 0;
        int ring = 0;
        if (this.chunkSource instanceof FiniteChunkSource) {
            this.structureCoords[0] = ModernBetaStructures.getFiniteStrongholdPosition((FiniteChunkSource)this.chunkSource);
        } else {
            for (int i = 0; i < this.structureCoords.length; ++i) {
                int chunkZ;
                int z;
                if (ring >= 1) {
                    return;
                }
                double a = 4.0 * this.distance + this.distance * (double)ring * 6.0 + (random.nextDouble() - 0.5) * this.distance * 2.5;
                int chunkX = (int)Math.round(Math.cos(theta) * a);
                int x = (chunkX << 4) + 8;
                BlockPos blockPos = ModernBetaBiomeProvider.findBiomePosition(x, z = ((chunkZ = (int)Math.round(Math.sin(theta) * a)) << 4) + 8, 112, StructureSimStronghold.STRONGHOLD.field_151546_e, random, biomeFunc);
                if (blockPos != null) {
                    chunkX = blockPos.func_177958_n() >> 4;
                    chunkZ = blockPos.func_177952_p() >> 4;
                }
                this.structureCoords[i] = new ChunkPos(chunkX, chunkZ);
                theta += Math.PI * 2 / (double)this.spread;
                if (++count != this.spread) continue;
                theta += random.nextDouble() * Math.PI * 2.0;
                count = 0;
                this.spread += 2 * this.spread / (++ring + 1);
                this.spread = Math.min(this.spread, this.structureCoords.length - i);
            }
        }
    }
}

