/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.compat.ModCompat;
import mod.bespectacled.modernbetaforge.compat.biomesoplenty.CompatBiomesOPlenty;
import mod.bespectacled.modernbetaforge.registry.ModernBetaBuiltInTypes;
import mod.bespectacled.modernbetaforge.util.ForgeRegistryUtil;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.biome.climate.ClimateMap;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevHouse;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.init.Blocks;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class DataFixers {
    private static final Gson GSON = new Gson();
    private static final ModernBetaGeneratorSettings DEFAULTS = ModernBetaGeneratorSettings.build();
    private static final Map<String, Boolean> SHOULD_GEN_SANDSTONE = ImmutableMap.builder().put((Object)ModernBetaBuiltInTypes.Chunk.BETA.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.ALPHA.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.SKYLANDS.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_611.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_420.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_415.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.PE.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.RELEASE.getId(), (Object)true).build();
    private static final Map<String, Boolean> SHOULD_SPAWN_WOLVES = ImmutableMap.builder().put((Object)ModernBetaBuiltInTypes.Chunk.BETA.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.ALPHA.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.SKYLANDS.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_611.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_420.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_415.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.PE.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.RELEASE.getId(), (Object)true).build();
    private static final Map<String, String> SURFACE_BUILDERS = ImmutableMap.builder().put((Object)ModernBetaBuiltInTypes.Chunk.BETA.getId(), (Object)ModernBetaBuiltInTypes.Surface.BETA.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.ALPHA.getId(), (Object)ModernBetaBuiltInTypes.Surface.ALPHA.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.SKYLANDS.getId(), (Object)ModernBetaBuiltInTypes.Surface.SKYLANDS.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_611.getId(), (Object)ModernBetaBuiltInTypes.Surface.INFDEV.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_420.getId(), (Object)ModernBetaBuiltInTypes.Surface.INFDEV.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_415.getId(), (Object)ModernBetaBuiltInTypes.Surface.INFDEV.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.PE.getId(), (Object)ModernBetaBuiltInTypes.Surface.PE.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.RELEASE.getId(), (Object)ModernBetaBuiltInTypes.Surface.INFDEV.getId()).build();
    private static final Map<String, String> WORLD_SPAWNERS = ImmutableMap.builder().put((Object)ModernBetaBuiltInTypes.Chunk.BETA.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.BETA.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.ALPHA.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.BETA.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.SKYLANDS.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.DEFAULT.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_611.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.INFDEV.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_420.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.INFDEV.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_415.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.INFDEV.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_227.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.INFDEV.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.PE.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.PE.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.RELEASE.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.DEFAULT.getRegistryString()).build();

    public static JsonElement fixBiome(JsonObject jsonObject, String mapTag, String deprTag, String defaultTag) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, mapTag);
        String biome = biomeMap.getOrDefault(deprTag, defaultTag);
        return new JsonPrimitive(biome);
    }

    public static JsonElement fixDesertBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "desertBiomes", "landBiome", DataFixers.DEFAULTS.desertBiomeBase.toString());
    }

    public static JsonElement fixDesertBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "desertBiomes", "oceanBiome", DataFixers.DEFAULTS.desertBiomeOcean.toString());
    }

    public static JsonElement fixDesertBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "desertBiomes", "beachBiome", DataFixers.DEFAULTS.desertBiomeBeach.toString());
    }

    public static JsonElement fixForestBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "forestBiomes", "landBiome", DataFixers.DEFAULTS.forestBiomeBase.toString());
    }

    public static JsonElement fixForestBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "forestBiomes", "oceanBiome", DataFixers.DEFAULTS.forestBiomeOcean.toString());
    }

    public static JsonElement fixForestBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "forestBiomes", "beachBiome", DataFixers.DEFAULTS.forestBiomeBeach.toString());
    }

    public static JsonElement fixIceDesertBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "iceDesertBiomes", "landBiome", DataFixers.DEFAULTS.iceDesertBiomeBase.toString());
    }

    public static JsonElement fixIceDesertBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "iceDesertBiomes", "oceanBiome", DataFixers.DEFAULTS.iceDesertBiomeOcean.toString());
    }

    public static JsonElement fixIceDesertBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "iceDesertBiomes", "beachBiome", DataFixers.DEFAULTS.iceDesertBiomeBeach.toString());
    }

    public static JsonElement fixPlainsBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "plainsBiomes", "landBiome", DataFixers.DEFAULTS.plainsBiomeBase.toString());
    }

    public static JsonElement fixPlainsBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "plainsBiomes", "oceanBiome", DataFixers.DEFAULTS.plainsBiomeOcean.toString());
    }

    public static JsonElement fixPlainsBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "plainsBiomes", "beachBiome", DataFixers.DEFAULTS.plainsBiomeBeach.toString());
    }

    public static JsonElement fixRainforestBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "rainforestBiomes", "landBiome", DataFixers.DEFAULTS.rainforestBiomeBase.toString());
    }

    public static JsonElement fixRainforestBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "rainforestBiomes", "oceanBiome", DataFixers.DEFAULTS.rainforestBiomeOcean.toString());
    }

    public static JsonElement fixRainforestBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "rainforestBiomes", "beachBiome", DataFixers.DEFAULTS.rainforestBiomeBeach.toString());
    }

    public static JsonElement fixSavannaBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "savannaBiomes", "landBiome", DataFixers.DEFAULTS.savannaBiomeBase.toString());
    }

    public static JsonElement fixSavannaBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "savannaBiomes", "oceanBiome", DataFixers.DEFAULTS.savannaBiomeOcean.toString());
    }

    public static JsonElement fixSavannaBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "savannaBiomes", "beachBiome", DataFixers.DEFAULTS.savannaBiomeBeach.toString());
    }

    public static JsonElement fixShrublandBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "shrublandBiomes", "landBiome", DataFixers.DEFAULTS.shrublandBiomeBase.toString());
    }

    public static JsonElement fixShrublandBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "shrublandBiomes", "oceanBiome", DataFixers.DEFAULTS.shrublandBiomeOcean.toString());
    }

    public static JsonElement fixShrublandBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "shrublandBiomes", "beachBiome", DataFixers.DEFAULTS.shrublandBiomeBeach.toString());
    }

    public static JsonElement fixSeasonalForestBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "seasonalForestBiomes", "landBiome", DataFixers.DEFAULTS.seasonalForestBiomeBase.toString());
    }

    public static JsonElement fixSeasonalForestBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "seasonalForestBiomes", "oceanBiome", DataFixers.DEFAULTS.seasonalForestBiomeOcean.toString());
    }

    public static JsonElement fixSeasonalForestBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "seasonalForestBiomes", "beachBiome", DataFixers.DEFAULTS.seasonalForestBiomeBeach.toString());
    }

    public static JsonElement fixSwamplandBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "swamplandBiomes", "landBiome", DataFixers.DEFAULTS.swamplandBiomeBase.toString());
    }

    public static JsonElement fixSwamplandBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "swamplandBiomes", "oceanBiome", DataFixers.DEFAULTS.swamplandBiomeOcean.toString());
    }

    public static JsonElement fixSwamplandBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "swamplandBiomes", "beachBiome", DataFixers.DEFAULTS.swamplandBiomeBeach.toString());
    }

    public static JsonElement fixTaigaBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "taigaBiomes", "landBiome", DataFixers.DEFAULTS.taigaBiomeBase.toString());
    }

    public static JsonElement fixTaigaBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "taigaBiomes", "oceanBiome", DataFixers.DEFAULTS.taigaBiomeOcean.toString());
    }

    public static JsonElement fixTaigaBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "taigaBiomes", "beachBiome", DataFixers.DEFAULTS.taigaBiomeBeach.toString());
    }

    public static JsonElement fixTundraBiomeBase(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "tundraBiomes", "landBiome", DataFixers.DEFAULTS.tundraBiomeBase.toString());
    }

    public static JsonElement fixTundraBiomeOcean(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "tundraBiomes", "oceanBiome", DataFixers.DEFAULTS.tundraBiomeOcean.toString());
    }

    public static JsonElement fixTundraBiomeBeach(JsonObject jsonObject) {
        return DataFixers.fixBiome(jsonObject, "tundraBiomes", "beachBiome", DataFixers.DEFAULTS.tundraBiomeBeach.toString());
    }

    public static JsonElement fixSandstone(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)ModernBetaBuiltInTypes.Chunk.BETA.getId());
        return new JsonPrimitive(SHOULD_GEN_SANDSTONE.getOrDefault(registryString, DataFixers.DEFAULTS.useSandstone));
    }

    public static JsonElement fixWolves(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)ModernBetaBuiltInTypes.Chunk.BETA.getId());
        return new JsonPrimitive(SHOULD_SPAWN_WOLVES.getOrDefault(registryString, DataFixers.DEFAULTS.spawnWolves));
    }

    public static JsonElement fixSurfaces(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)ModernBetaBuiltInTypes.Chunk.BETA.getId());
        return new JsonPrimitive(SURFACE_BUILDERS.getOrDefault(registryString, DataFixers.DEFAULTS.surfaceBuilder.func_110623_a()));
    }

    public static JsonElement fixBiomeDepthScale(JsonObject jsonObject) {
        return new JsonPrimitive(Boolean.valueOf(false));
    }

    public static JsonElement fixSkylandsSurface(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)ModernBetaBuiltInTypes.Chunk.BETA.getId());
        if (registryString.equals(ModernBetaBuiltInTypes.Chunk.SKYLANDS.getId())) {
            return new JsonPrimitive(ModernBetaBuiltInTypes.Surface.SKYLANDS.getId());
        }
        return null;
    }

    public static JsonElement fixSingleBiome(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"fixedBiome", (String)DataFixers.DEFAULTS.singleBiome.toString());
        return new JsonPrimitive(registryString);
    }

    public static JsonElement fixIndevHouse(JsonObject jsonObject) {
        boolean useIndevHouse = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useIndevHouse", (boolean)true);
        return new JsonPrimitive(useIndevHouse ? IndevHouse.OAK.id : IndevHouse.NONE.id);
    }

    public static JsonElement fixResourceLocationChunk(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)ModernBetaBuiltInTypes.Chunk.BETA.getId());
        if (!DataFixers.isResourceFormat(registryString)) {
            return new JsonPrimitive(ModernBeta.createRegistryKey(registryString).toString());
        }
        return null;
    }

    public static JsonElement fixResourceLocationBiome(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"biomeSource", (String)ModernBetaBuiltInTypes.Biome.BETA.getId());
        if (!DataFixers.isResourceFormat(registryString)) {
            return new JsonPrimitive(ModernBeta.createRegistryKey(registryString).toString());
        }
        return null;
    }

    public static JsonElement fixResourceLocationSurface(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"surfaceBuilder", (String)ModernBetaBuiltInTypes.Surface.BETA.getId());
        if (!DataFixers.isResourceFormat(registryString)) {
            return new JsonPrimitive(ModernBeta.createRegistryKey(registryString).toString());
        }
        return null;
    }

    public static JsonElement fixResourceLocationCarver(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"caveCarver", (String)ModernBetaBuiltInTypes.Carver.BETA.getId());
        if (!DataFixers.isResourceFormat(registryString)) {
            return new JsonPrimitive(ModernBeta.createRegistryKey(registryString).toString());
        }
        return null;
    }

    public static JsonElement fixScaleNoiseScaleX(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)DataFixers.DEFAULTS.chunkSource.toString());
        boolean isAlpha = registryString.equals(ModernBetaBuiltInTypes.Chunk.ALPHA.getRegistryString());
        boolean isInfdev611 = registryString.equals(ModernBetaBuiltInTypes.Chunk.INFDEV_611.getRegistryString());
        if (isAlpha || isInfdev611) {
            return new JsonPrimitive((Number)Float.valueOf(1.0f));
        }
        return null;
    }

    public static JsonElement fixScaleNoiseScaleZ(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)DataFixers.DEFAULTS.chunkSource.toString());
        boolean isAlpha = registryString.equals(ModernBetaBuiltInTypes.Chunk.ALPHA.getRegistryString());
        boolean isInfdev611 = registryString.equals(ModernBetaBuiltInTypes.Chunk.INFDEV_611.getRegistryString());
        if (isAlpha || isInfdev611) {
            return new JsonPrimitive((Number)Float.valueOf(1.0f));
        }
        return null;
    }

    public static JsonElement fixLayerSize(JsonObject jsonObject) {
        int biomeSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"biomeSize", (int)DataFixers.DEFAULTS.layerSize);
        return new JsonPrimitive((Number)biomeSize);
    }

    public static JsonElement fixCaveCarverNone(JsonObject jsonObject) {
        boolean useCaves = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useCaves", (boolean)true);
        if (!useCaves) {
            return new JsonPrimitive(ModernBetaBuiltInTypes.Carver.NONE.getRegistryString());
        }
        return null;
    }

    public static JsonElement fixWorldSpawner(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)DataFixers.DEFAULTS.chunkSource.toString());
        String defaultSpawner = ModernBetaBuiltInTypes.WorldSpawner.DEFAULT.getRegistryString();
        return new JsonPrimitive(WORLD_SPAWNERS.getOrDefault(registryString, defaultSpawner));
    }

    public static JsonElement fixDefaultFluid(JsonObject jsonObject) {
        boolean useLavaOceans = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useLavaOceans", (boolean)false);
        if (useLavaOceans) {
            return new JsonPrimitive(Blocks.field_150353_l.getRegistryName().toString());
        }
        return null;
    }

    public static JsonElement fixSandDisks(JsonObject jsonObject) {
        boolean hasVanillaBiome = DataFixers.hasVanillaBiome(jsonObject);
        if (hasVanillaBiome) {
            return new JsonPrimitive(Boolean.valueOf(true));
        }
        return null;
    }

    public static JsonElement fixGravelDisks(JsonObject jsonObject) {
        boolean hasVanillaBiome = DataFixers.hasVanillaBiome(jsonObject);
        if (hasVanillaBiome) {
            return new JsonPrimitive(Boolean.valueOf(true));
        }
        return null;
    }

    public static JsonElement fixClayDisks(JsonObject jsonObject) {
        boolean hasVanillaBiome = DataFixers.hasVanillaBiome(jsonObject);
        if (hasVanillaBiome) {
            return new JsonPrimitive(Boolean.valueOf(true));
        }
        return null;
    }

    public static JsonElement fixDoublePlants(JsonObject jsonObject) {
        boolean useNewFlowers = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useNewFlowers", (boolean)DataFixers.DEFAULTS.useNewFlowers);
        return new JsonPrimitive(Boolean.valueOf(useNewFlowers));
    }

    public static JsonElement fixSnowyBiomeChance(JsonObject jsonObject) {
        return new JsonPrimitive((Number)6);
    }

    public static JsonElement fixLayerVersion1600(JsonObject jsonObject) {
        return new JsonPrimitive((Number)1600);
    }

    public static JsonElement fixBoPCompat(JsonObject jsonObject) {
        if (ModCompat.isModLoaded("biomesoplenty") && DEFAULTS.containsProperty(CompatBiomesOPlenty.KEY_USE_COMPAT)) {
            boolean useModdedBiomes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useModdedBiomes", (boolean)true);
            return new JsonPrimitive(Boolean.valueOf(useModdedBiomes));
        }
        return null;
    }

    public static JsonElement fixReplaceRiverBiomes(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)DataFixers.DEFAULTS.chunkSource.toString());
        if (!registryString.equals(ModernBetaBuiltInTypes.Chunk.RELEASE.getRegistryString())) {
            return new JsonPrimitive(Boolean.valueOf(false));
        }
        return null;
    }

    public static JsonElement fixReleaseWorldSpawner(JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"worldSpawner", (String)DataFixers.DEFAULTS.worldSpawner.toString());
        if (registryString.equals(ModernBeta.createRegistryKey("none").toString())) {
            return new JsonPrimitive(ModernBetaBuiltInTypes.WorldSpawner.RELEASE.getRegistryString());
        }
        return null;
    }

    private static boolean isResourceFormat(String resourceString) {
        return resourceString.split(":").length == 2;
    }

    private static boolean hasVanillaBiome(JsonObject jsonObject) {
        String biomeSourceStr = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"biomeSource", (String)ModernBetaBuiltInTypes.Biome.BETA.getId());
        ResourceLocation biomeSource = new ResourceLocation(biomeSourceStr);
        boolean hasVanillaBiome = true;
        if (biomeSource.equals((Object)ModernBetaBuiltInTypes.Biome.BETA.getRegistryKey()) || biomeSource.equals((Object)ModernBetaBuiltInTypes.Biome.PE.getRegistryKey())) {
            ModernBetaGeneratorSettings.Factory factory = ModernBetaGeneratorSettings.Factory.jsonToFactory(jsonObject.toString());
            hasVanillaBiome = new ClimateMap(factory.build()).containsNonModernBetaBiomes();
        } else if (biomeSource.equals((Object)ModernBetaBuiltInTypes.Biome.SINGLE.getRegistryKey())) {
            String singleBiomeStr = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"singleBiome", (String)DataFixers.DEFAULTS.singleBiome.toString());
            ResourceLocation singleBiome = new ResourceLocation(singleBiomeStr);
            hasVanillaBiome = !(ForgeRegistryUtil.get(singleBiome, ForgeRegistries.BIOMES) instanceof ModernBetaBiome);
        }
        return hasVanillaBiome;
    }

    private static Map<String, String> deserializeBiomeMap(JsonObject jsonObject, String tag) {
        try {
            return (Map)GSON.fromJson(JsonUtils.func_151200_h((JsonObject)jsonObject, (String)tag), LinkedHashMap.class);
        }
        catch (Exception e) {
            ModernBeta.log(Level.INFO, String.format("Couldn't deserialize tag '%s'.", tag));
            return new LinkedHashMap<String, String>();
        }
    }

    @Deprecated
    public static class DataFix {
        private final String tag;
        private final Consumer<JsonObject> dataFixConsumer;

        public DataFix(String tag, BiConsumer<ModernBetaGeneratorSettings.Factory, JsonObject> dataFixConsumer) {
            this.tag = tag;
            this.dataFixConsumer = jsonObject -> dataFixConsumer.accept(new ModernBetaGeneratorSettings.Factory(), (JsonObject)jsonObject);
        }

        public String getTag() {
            return this.tag;
        }

        public Consumer<JsonObject> getDataFixConsumer() {
            return this.dataFixConsumer;
        }
    }
}

