/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.util.noise;

import java.util.Random;
import mod.bespectacled.modernbetaforge.util.noise.PerlinNoise;

public class PerlinOctaveNoise {
    private final PerlinNoise[] noises;
    private final int octaves;

    public PerlinOctaveNoise(Random random, int octaves, boolean useOffset) {
        this.noises = new PerlinNoise[octaves];
        this.octaves = octaves;
        for (int i = 0; i < octaves; ++i) {
            this.noises[i] = new PerlinNoise(random, useOffset);
        }
    }

    public final double[] sampleBeta(double x, double y, double z, int sizeX, int sizeY, int sizeZ, double scaleX, double scaleY, double scaleZ) {
        double[] noise = new double[sizeX * sizeY * sizeZ];
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            this.noises[i].sampleBeta(noise, x, y, z, sizeX, sizeY, sizeZ, scaleX * frequency, scaleY * frequency, scaleZ * frequency, frequency);
            frequency /= 2.0;
        }
        return noise;
    }

    public final double[] sampleAlpha(double x, double y, double z, int sizeX, int sizeY, int sizeZ, double scaleX, double scaleY, double scaleZ) {
        double[] noise = new double[sizeX * sizeY * sizeZ];
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            this.noises[i].sampleAlpha(noise, x, y, z, sizeX, sizeY, sizeZ, scaleX * frequency, scaleY * frequency, scaleZ * frequency, frequency);
            frequency /= 2.0;
        }
        return noise;
    }

    public final double sample(double x, double y) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            total += this.noises[i].sample(x / frequency, y / frequency) * frequency;
            frequency *= 2.0;
        }
        return total;
    }

    public final double sample(double x, double y, double z) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            total += this.noises[i].sample(x / frequency, y / frequency, z / frequency) * frequency;
            frequency *= 2.0;
        }
        return total;
    }

    public final double scaledSample(double x, double z, double scaleX, double scaleZ) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            total += this.noises[i].sampleXZ(x * scaleX * frequency, z * scaleZ * frequency, frequency);
            frequency /= 2.0;
        }
        return total;
    }

    public final double scaledSample(double x, double y, double z, double scaleX, double scaleY, double scaleZ) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            total += this.noises[i].sampleXYZ(x * scaleX * frequency, y * scaleY * frequency, z * scaleZ * frequency, scaleY * frequency, y * scaleY * frequency) / frequency;
            frequency /= 2.0;
        }
        return total;
    }
}

