/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.biomes.alpha;

import java.util.Random;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeDecorator;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecoratorAlpha
extends ModernBetaBiomeDecorator {
    public void func_180292_a(World world, Random random, Biome biome, BlockPos startPos) {
        ModernBetaGeneratorSettings settings = ModernBetaGeneratorSettings.buildOrGet(world);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        this.field_180294_c = startPos;
        int startX = startPos.func_177958_n();
        int startZ = startPos.func_177952_p();
        ChunkPos chunkPos = new ChunkPos(startX >> 4, startZ >> 4);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(world, random, chunkPos));
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(world, random, startPos));
        this.populateOres(world, random, biome, startPos, mutablePos);
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(world, random, startPos));
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            this.populateTrees(world, random, biome, startPos, mutablePos, () -> biome.func_150567_a(random));
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            BiomeDecoratorAlpha.populateWorldGenCount(world, random, startPos, FEATURE_DANDELION, mutablePos, 2, settings.height);
            BiomeDecoratorAlpha.populateWorldGenChance(world, random, startPos, FEATURE_POPPY, mutablePos, 2, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            BiomeDecoratorAlpha.populateWorldGenChance(world, random, startPos, FEATURE_BROWN_SHROOM, mutablePos, 4, settings.height);
            BiomeDecoratorAlpha.populateWorldGenChance(world, random, startPos, FEATURE_RED_SHROOM, mutablePos, 8, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED)) {
            BiomeDecoratorAlpha.populateWorldGenCount(world, random, startPos, FEATURE_REED, mutablePos, 10, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            BiomeDecoratorAlpha.populateWorldGenCount(world, random, startPos, FEATURE_CACTUS, mutablePos, 1, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
            this.populateWaterfalls(world, random, startPos, mutablePos, settings.height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
            this.populateLavafalls(world, random, startPos, mutablePos, settings.height);
        }
        if (settings.useTallGrass && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            BiomeDecoratorAlpha.populateTallGrassChance(world, random, biome, startPos, mutablePos, 2, settings.height);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(world, random, chunkPos));
    }

    @Override
    protected int getTreeCount(World world, Random random, Biome biome, BlockPos startPos) {
        int startZ;
        double scale;
        int startX;
        PerlinOctaveNoise forestOctaveNoise = this.getForestOctaveNoise(world, startPos.func_177958_n() >> 4, startPos.func_177952_p() >> 4);
        int noiseCount = (int)((forestOctaveNoise.sample((double)(startX = startPos.func_177958_n()) * (scale = 0.5), (double)(startZ = startPos.func_177952_p()) * scale) / 8.0 + random.nextDouble() * 4.0 + 4.0) / 3.0);
        if (noiseCount < 0) {
            noiseCount = 0;
        }
        int treeCount = 0;
        if (random.nextInt(10) == 0) {
            ++treeCount;
        }
        return treeCount += noiseCount;
    }
}

