/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.property;

import com.google.common.base.Predicate;
import com.google.common.primitives.Floats;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import mod.bespectacled.modernbetaforge.api.property.PropertyGuiType;
import mod.bespectacled.modernbetaforge.api.property.RangedProperty;
import mod.bespectacled.modernbetaforge.property.visitor.EntryValuePropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.FactoryPropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.GuiPropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.PropertyVisitor;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public final class FloatProperty
extends RangedProperty<Float> {
    private static final int DEFAULT_SCALE = 2;
    private final int scale;

    public FloatProperty(float value, float minValue, float maxValue, PropertyGuiType guiType, int scale) {
        super(Float.valueOf(MathHelper.func_76131_a((float)value, (float)minValue, (float)maxValue)), Float.valueOf(minValue), Float.valueOf(maxValue), guiType);
        this.scale = MathHelper.func_76125_a((int)scale, (int)1, (int)3);
    }

    public FloatProperty(float value, float minValue, float maxValue, PropertyGuiType guiType) {
        this(value, minValue, maxValue, guiType, 2);
    }

    public FloatProperty(float value) {
        this(value, Float.MIN_VALUE, Float.MAX_VALUE, PropertyGuiType.FIELD);
    }

    @Override
    public void setValue(Float value) {
        BigDecimal bigDecimal = new BigDecimal(value.floatValue());
        bigDecimal = bigDecimal.setScale(this.scale, RoundingMode.HALF_UP);
        super.setValue(Float.valueOf(MathHelper.func_76131_a((float)bigDecimal.floatValue(), (float)((Float)this.getMinValue()).floatValue(), (float)((Float)this.getMaxValue()).floatValue())));
    }

    @Override
    public String getType() {
        return "float";
    }

    @Override
    public void visitFactory(FactoryPropertyVisitor visitor, ModernBetaGeneratorSettings.Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
        visitor.visit(this, factory, registryKey, jsonObject);
    }

    @Override
    public GuiPageButtonList.GuiListEntry visitGui(GuiPropertyVisitor visitor, int guiIdentifier) {
        return visitor.visit(this, guiIdentifier);
    }

    @Override
    public void visitEntryValue(EntryValuePropertyVisitor visitor, int guiIdentifier, Object value, ResourceLocation registryKey) {
        visitor.visit(this, guiIdentifier, value, registryKey);
    }

    @Override
    public String visitNameFormatter(PropertyVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getFormatter() {
        return String.format("%%2.%df", this.scale);
    }

    public Predicate<String> getStringPredicate() {
        return string -> {
            Float value = Floats.tryParse((String)string);
            return string.isEmpty() || string.equals("-") || value != null && Floats.isFinite((float)value.floatValue());
        };
    }

    public int getScale() {
        return this.scale;
    }
}

