/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.chunk.source;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverBeach;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverCustom;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverOcean;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.blocksource.BlockSource;
import mod.bespectacled.modernbetaforge.api.world.spawn.WorldSpawner;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.ModernBetaWorldType;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionRules;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionStep;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjector;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public abstract class ChunkSource {
    protected static final int OCEAN_MIN_DEPTH = 4;
    protected static final int DEEP_OCEAN_MIN_DEPTH = 16;
    protected final long seed;
    protected final ModernBetaGeneratorSettings settings;
    protected final Random random;
    protected final IBlockState defaultBlock;
    protected final IBlockState defaultFluid;
    protected final int worldHeight;
    protected final int seaLevel;
    protected final List<BlockSource> blockSources;
    private Optional<PerlinOctaveNoise> beachOctaveNoise;
    private Optional<PerlinOctaveNoise> surfaceOctaveNoise;
    private Optional<PerlinOctaveNoise> forestOctaveNoise;

    public ChunkSource(long seed, ModernBetaGeneratorSettings settings) {
        this.seed = seed;
        this.settings = settings;
        this.random = this.createRandom(seed);
        this.defaultBlock = ModernBetaRegistries.DEFAULT_BLOCK.get(settings.defaultBlock).get().func_176223_P();
        this.defaultFluid = ((Block)ForgeRegistries.BLOCKS.getValue(settings.defaultFluid)).func_176223_P();
        this.worldHeight = settings.height;
        this.seaLevel = settings.seaLevel;
        this.blockSources = ModernBetaRegistries.BLOCK_SOURCE.getValues().stream().map(e -> e.apply(this, this.settings)).collect(Collectors.toList());
        Random random = this.createRandom(seed);
        this.beachOctaveNoise = Optional.ofNullable(new PerlinOctaveNoise(random, 4, true));
        this.surfaceOctaveNoise = Optional.ofNullable(new PerlinOctaveNoise(random, 4, true));
        this.forestOctaveNoise = Optional.ofNullable(new PerlinOctaveNoise(random, 8, true));
        this.setCloudHeight(this.worldHeight - 20);
    }

    public abstract void provideInitialChunk(ChunkPrimer var1, int var2, int var3);

    public abstract void provideProcessedChunk(ChunkPrimer var1, int var2, int var3, List<StructureComponent> var4);

    public abstract void provideSurface(World var1, Biome[] var2, ChunkPrimer var3, int var4, int var5);

    public abstract int getHeight(int var1, int var2, HeightmapChunk.Type var3);

    public int getSeaLevel() {
        return this.settings.seaLevel;
    }

    public IBlockState getDefaultBlock() {
        return this.defaultBlock;
    }

    public IBlockState getDefaultFluid() {
        return this.defaultFluid;
    }

    public ModernBetaGeneratorSettings getGeneratorSettings() {
        return this.settings;
    }

    public WorldSpawner getWorldSpawner() {
        return ModernBetaRegistries.WORLD_SPAWNER.getOrElse(this.settings.worldSpawner, WorldSpawner.DEFAULT);
    }

    public Optional<PerlinOctaveNoise> getBeachOctaveNoise() {
        return this.beachOctaveNoise;
    }

    public Optional<PerlinOctaveNoise> getSurfaceOctaveNoise() {
        return this.surfaceOctaveNoise;
    }

    public Optional<PerlinOctaveNoise> getForestOctaveNoise() {
        return this.forestOctaveNoise;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean skipChunk(int chunkX, int chunkZ) {
        return false;
    }

    public void pruneChunk(World world, int chunkX, int chunkZ) {
    }

    public BiomeInjectionRules.Builder createBiomeInjectionRules(BiomeSource biomeSource) {
        boolean replaceOceans = this.getGeneratorSettings().replaceOceanBiomes;
        boolean replaceBeaches = this.getGeneratorSettings().replaceBeachBiomes;
        BiomeInjectionRules.Builder builder = new BiomeInjectionRules.Builder();
        Predicate<BiomeInjectionRules.BiomeInjectionContext> deepOceanPredicate = context -> BiomeInjector.atOceanDepth(context.getPos().func_177956_o(), 16, this.getSeaLevel());
        Predicate<BiomeInjectionRules.BiomeInjectionContext> oceanPredicate = context -> BiomeInjector.atOceanDepth(context.getPos().func_177956_o(), 4, this.getSeaLevel());
        Predicate<BiomeInjectionRules.BiomeInjectionContext> beachPredicate = context -> BiomeInjector.atBeachDepth(context.getPos().func_177956_o(), this.getSeaLevel()) && BiomeInjector.isBeachBlock(context.getState(), context.getBiome());
        if (replaceOceans && biomeSource instanceof BiomeResolverOcean) {
            BiomeResolverOcean biomeResolverOcean = (BiomeResolverOcean)((Object)biomeSource);
            builder.add(deepOceanPredicate, biomeResolverOcean::getDeepOceanBiome, BiomeInjectionStep.PRE_SURFACE);
            builder.add(oceanPredicate, biomeResolverOcean::getOceanBiome, BiomeInjectionStep.PRE_SURFACE);
        }
        if (replaceBeaches && biomeSource instanceof BiomeResolverBeach) {
            BiomeResolverBeach biomeResolverBeach = (BiomeResolverBeach)((Object)biomeSource);
            builder.add(beachPredicate, biomeResolverBeach::getBeachBiome, BiomeInjectionStep.POST_SURFACE);
        }
        for (ModernBetaRegistries.BiomeResolverCreator resolverCreator : ModernBetaRegistries.BIOME_RESOLVER.getValues()) {
            BiomeResolverCustom customResolver = resolverCreator.apply(this, this.settings);
            if (!customResolver.useCustomResolver()) continue;
            builder.add(customResolver.getCustomPredicate(), (x, z) -> customResolver.getCustomBiome(x, z, biomeSource), BiomeInjectionStep.CUSTOM);
        }
        return builder;
    }

    protected Random createRandom(long seed) {
        return new Random(seed);
    }

    protected void setCloudHeight(int cloudHeight) {
        ModernBetaWorldType.INSTANCE.setCloudHeight(cloudHeight);
    }

    protected void setBeachOctaveNoise(PerlinOctaveNoise beachOctaveNoise) {
        this.beachOctaveNoise = Optional.ofNullable(beachOctaveNoise);
    }

    protected void setSurfaceOctaveNoise(PerlinOctaveNoise surfaceOctaveNoise) {
        this.surfaceOctaveNoise = Optional.ofNullable(surfaceOctaveNoise);
    }

    protected void setForestOctaveNoise(PerlinOctaveNoise forestOctaveNoise) {
        this.forestOctaveNoise = Optional.ofNullable(forestOctaveNoise);
    }
}

