/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.client.gui;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.surface.SurfaceBuilder;
import mod.bespectacled.modernbetaforge.client.color.BetaColorSampler;
import mod.bespectacled.modernbetaforge.client.gui.GuiBoundsChecker;
import mod.bespectacled.modernbetaforge.client.gui.GuiScreenCustomizeWorld;
import mod.bespectacled.modernbetaforge.util.DrawUtil;
import mod.bespectacled.modernbetaforge.util.ExecutorWrapper;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionRules;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionStep;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import mod.bespectacled.modernbetaforge.world.structure.ModernBetaStructures;
import mod.bespectacled.modernbetaforge.world.structure.sim.StructureSim;
import mod.bespectacled.modernbetaforge.world.structure.sim.StructureSimMansion;
import mod.bespectacled.modernbetaforge.world.structure.sim.StructureSimMineshaft;
import mod.bespectacled.modernbetaforge.world.structure.sim.StructureSimMonument;
import mod.bespectacled.modernbetaforge.world.structure.sim.StructureSimScatteredFeature;
import mod.bespectacled.modernbetaforge.world.structure.sim.StructureSimStronghold;
import mod.bespectacled.modernbetaforge.world.structure.sim.StructureSimVillage;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenCustomizePreview
extends GuiScreen
implements GuiPageButtonList.GuiResponder,
GuiSlider.FormatHelper {
    private static final String PREFIX = "createWorld.customize.preview.modernbetaforge.";
    private static final Map<ResourceLocation, ResourceLocation> STRUCTURE_ICONS = ImmutableMap.builder().put((Object)ModernBetaStructures.VILLAGE, (Object)ModernBeta.createRegistryKey("textures/gui/preview/village.png")).put((Object)ModernBetaStructures.STRONGHOLD, (Object)ModernBeta.createRegistryKey("textures/gui/preview/stronghold.png")).put((Object)ModernBetaStructures.MINESHAFT, (Object)ModernBeta.createRegistryKey("textures/gui/preview/mineshaft.png")).put((Object)ModernBetaStructures.MONUMENT, (Object)ModernBeta.createRegistryKey("textures/gui/preview/monument.png")).put((Object)ModernBetaStructures.MANSION, (Object)ModernBeta.createRegistryKey("textures/gui/preview/mansion.png")).put((Object)ModernBetaStructures.TEMPLE, (Object)ModernBeta.createRegistryKey("textures/gui/preview/temple.png")).build();
    private static final int STRUCTURE_ICON_SIZE = 10;
    private static final int TEXTURE_Y_OFFSET = 20;
    private static final int HINT_TEXT_OFFSET = 30;
    private static final int PROGRESS_TEXT_OFFSET = 13;
    private static final int BUTTON_LARGE_WIDTH = 164;
    private static final int BUTTON_SMALL_WIDTH = 108;
    private static final int BUTTON_SPACE = 4;
    private static final int RGB_WHITE = 0xFFFFFF;
    private static final int RGB_YELLOW = 0xFFFFA0;
    private static final int RGB_GREY = 0xA0A0A0;
    private static final int ARGB_BORDER_LIGHT = -2039584;
    private static final int ARGB_BORDER_DARK = -6250336;
    private static final int ARGB_PREVIEW_BOX = MathUtil.convertARGBComponentsToInt(50, 0, 0, 0);
    private static final int ARGB_PROGRESS_BOX = MathUtil.convertARGBComponentsToInt(200, 0, 0, 0);
    private static final int ARGB_PROGRESS_BAR = MathUtil.convertARGBComponentsToInt(160, 128, 255, 128);
    private static final int GUI_ID_BIOME_COLORS = 0;
    private static final int GUI_ID_ZOOM = 1;
    private static final int GUI_ID_GENERATE = 2;
    private static final int GUI_ID_CANCEL = 3;
    private static final int GUI_ID_STRUCTURES = 4;
    private static final long COPIED_SEED_WAIT_TIME = 1000L;
    private final GuiScreenCustomizeWorld parent;
    private final String worldSeed;
    private final ModernBetaGeneratorSettings settings;
    private final ExecutorWrapper executor;
    private final GuiBoundsChecker mapBounds;
    private final GuiBoundsChecker seedFieldBounds;
    private final GuiBoundsChecker structureButtonBounds;
    private final Map<Long, StructureInfo> structureMap;
    private final Map<Long, GuiBoundsChecker> structureBounds;
    protected String title = I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.title", (Object[])new Object[0]);
    private long seed;
    private ChunkSource chunkSource;
    private BiomeSource biomeSource;
    private SurfaceBuilder surfaceBuilder;
    private BiomeInjectionRules injectionRules;
    private Map<ResourceLocation, StructureSim> structureSims;
    private GuiSlider sliderZoom;
    private GuiListButton buttonBiomeBlend;
    private GuiListButton buttonStructures;
    private GuiButton buttonGenerate;
    private GuiButton buttonCancel;
    private ListPreset list;
    private ProgressState prevState;
    private ProgressState state;
    private PreviewSettings previewSettings;
    private PreviewSettings selectedPreviewSettings;
    private boolean showStructures;
    private float progress;
    private float prevProgress;
    private MapTexture prevMapTexture;
    private MapTexture mapTexture;
    private boolean copiedSeedField;
    private boolean copiedTpCommand;
    private long copiedSeedFieldTime;
    private long copiedTpCommandTime;
    private Supplier<String> tpCallback;
    private boolean haltGeneration;
    private long hoveredStructurePos;
    private boolean hoveredStructure;

    public GuiScreenCustomizePreview(GuiScreenCustomizeWorld parent, String worldSeed, ModernBetaGeneratorSettings settings, PreviewSettings previewSettings) {
        this.parent = parent;
        this.worldSeed = worldSeed;
        this.settings = settings;
        this.executor = new ExecutorWrapper(1, "map_preview");
        this.mapBounds = new GuiBoundsChecker();
        this.seedFieldBounds = new GuiBoundsChecker();
        this.structureButtonBounds = new GuiBoundsChecker();
        this.structureMap = new Long2ObjectOpenHashMap();
        this.structureBounds = new Long2ObjectOpenHashMap();
        this.seed = GuiScreenCustomizePreview.parseSeed(worldSeed);
        this.initSources(this.seed, settings);
        this.state = ProgressState.NOT_STARTED;
        this.previewSettings = new PreviewSettings(previewSettings.zoom, previewSettings.useBiomeBlend);
        this.progress = 0.0f;
        this.mapTexture = new MapTexture(this, ModernBeta.createRegistryKey("map_preview"));
    }

    public void func_73866_w_() {
        int zoomNdX = GuiScreenCustomizePreview.getNdx(ModernBetaGeneratorSettings.LEVEL_WIDTHS, this.previewSettings.zoom);
        int generateX = this.field_146294_l / 2 - 2 - 164;
        int cancelX = this.field_146294_l / 2 + 2;
        int zoomX = generateX;
        int biomeX = zoomX + 108 + 4;
        int structureX = biomeX + 108 + 4;
        this.field_146292_n.clear();
        this.buttonGenerate = this.func_189646_b(new GuiButton(2, generateX, this.field_146295_m - 27, 164, 20, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.generate", (Object[])new Object[0])));
        this.buttonCancel = this.func_189646_b(new GuiButton(3, cancelX, this.field_146295_m - 27, 164, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.sliderZoom = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider((GuiPageButtonList.GuiResponder)this, 1, zoomX, this.field_146295_m - 50, "createWorld.customize.preview.modernbetaforge.zoom", 2.0f, (float)(ModernBetaGeneratorSettings.LEVEL_WIDTHS.length - 1), (float)zoomNdX, (GuiSlider.FormatHelper)this));
        this.buttonBiomeBlend = (GuiListButton)this.func_189646_b((GuiButton)new GuiListButton((GuiPageButtonList.GuiResponder)this, 0, biomeX, this.field_146295_m - 50, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.biomeBlend", (Object[])new Object[0]), true));
        this.buttonStructures = (GuiListButton)this.func_189646_b((GuiButton)new GuiListButton((GuiPageButtonList.GuiResponder)this, 4, structureX, this.field_146295_m - 50, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.structures", (Object[])new Object[0]), true));
        this.sliderZoom.field_146120_f = 108;
        this.buttonBiomeBlend.field_146120_f = 108;
        this.buttonStructures.field_146120_f = 108;
        this.buttonBiomeBlend.func_175212_b(this.previewSettings.useBiomeBlend);
        this.buttonStructures.func_175212_b(this.showStructures);
        this.list = new ListPreset(this);
        int viewportSize = Math.min(this.list.field_148158_l, this.list.field_148155_a) - 32 - 54 - 32;
        int textureX = this.field_146294_l / 2 - viewportSize / 2;
        int textureY = this.field_146295_m / 2 - viewportSize / 2;
        this.mapBounds.updateBounds(textureX, textureY -= 20, viewportSize, viewportSize);
        this.seedFieldBounds.updateBounds(this.getSeedFieldX(), this.getSeedFieldY(), this.getSeedFieldWidth(), this.field_146289_q.field_78288_b);
        this.structureButtonBounds.updateBounds(structureX, this.field_146295_m - 50, 108, 20);
        this.updateButtonsEnabled(this.state);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.structureButtonBounds.updateHovered(mouseX, mouseY);
        this.seedFieldBounds.updateHovered(mouseX, mouseY);
        this.mapBounds.updateHovered(mouseX, mouseY);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 14, 0xFFFFFF);
        if (System.currentTimeMillis() - this.copiedSeedFieldTime > 1000L) {
            this.copiedSeedField = false;
        }
        if (System.currentTimeMillis() - this.copiedTpCommandTime > 1000L) {
            this.copiedTpCommand = false;
        }
        int viewportSize = Math.min(this.list.field_148158_l, this.list.field_148155_a) - 32 - 54 - 32;
        int textureX = this.field_146294_l / 2 - viewportSize / 2;
        int textureY = this.field_146295_m / 2 - viewportSize / 2;
        textureY -= 20;
        int boxL = this.field_146294_l / 2 - 56;
        int boxR = this.field_146294_l / 2 + 56;
        int boxT = this.field_146295_m / 2 - 30 - 6;
        int boxB = this.field_146295_m / 2 - 13 + 18;
        int progressHeight = this.field_146295_m / 2 - 13;
        int progressBarLength = boxR - boxL - 20;
        int progressBarL = boxL + 10;
        int progressBarR = progressBarL + progressBarLength;
        this.prevProgress = MathUtil.lerp(partialTicks, this.prevProgress, this.progress);
        int progressLength = (int)((float)progressBarLength * this.prevProgress);
        GuiScreenCustomizePreview.func_73734_a((int)textureX, (int)textureY, (int)(textureX + viewportSize), (int)(textureY + viewportSize), (int)ARGB_PREVIEW_BOX);
        this.func_73730_a(textureX - 1, textureX + viewportSize, textureY - 1, -2039584);
        this.func_73730_a(textureX - 1, textureX + viewportSize, textureY + viewportSize, -6250336);
        this.func_73728_b(textureX - 1, textureY - 1, textureY + viewportSize, -2039584);
        this.func_73728_b(textureX + viewportSize, textureY - 1, textureY + viewportSize, -6250336);
        switch (this.state) {
            case SUCCEEDED: {
                this.mapTexture.loadMapTexture();
                this.updateState(ProgressState.LOADED);
            }
            case LOADED: {
                this.prevMapTexture.lerpAlpha(partialTicks, 0.5f, 0.0f);
                if (this.mapTexture.mapAlpha < 1.0f) {
                    this.prevMapTexture.drawMapTexture(textureX, textureY, viewportSize);
                    this.mapTexture.lerpAlpha(partialTicks, 0.5f, 1.0f);
                }
                this.mapTexture.drawMapTexture(textureX, textureY, viewportSize);
                this.drawStructureIcons(textureX, textureY, viewportSize, partialTicks);
                break;
            }
            case STARTED: {
                if (this.prevMapTexture.mapTexture != null) {
                    this.prevMapTexture.drawMapTexture(textureX, textureY, viewportSize);
                    this.drawStructureIcons(textureX, textureY, viewportSize, partialTicks);
                    GuiScreenCustomizePreview.func_73734_a((int)boxL, (int)boxT, (int)boxR, (int)boxB, (int)ARGB_PROGRESS_BOX);
                }
                this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.progress", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 30, 0xFFFFFF);
                if (this.chunkSource instanceof FiniteChunkSource && !((FiniteChunkSource)this.chunkSource).hasPregenerated()) {
                    String levelProgressText = ((FiniteChunkSource)this.chunkSource).getPhase();
                    if (levelProgressText == null) break;
                    this.func_73732_a(this.field_146289_q, levelProgressText + "..", this.field_146294_l / 2, progressHeight, 0xFFFFFF);
                    break;
                }
                GuiScreenCustomizePreview.func_73734_a((int)progressBarL, (int)(progressHeight + 9), (int)(progressBarL + progressLength), (int)(progressHeight - 2), (int)ARGB_PROGRESS_BAR);
                this.func_73730_a(progressBarL - 2, progressBarR + 1, progressHeight - 4, -2039584);
                this.func_73730_a(progressBarL - 2, progressBarR + 1, progressHeight + 10, -6250336);
                this.func_73728_b(progressBarL - 2, progressHeight + 10, progressHeight - 4, -2039584);
                this.func_73728_b(progressBarR + 1, progressHeight + 10, progressHeight - 4, -6250336);
                this.func_73732_a(this.field_146289_q, String.format("%d%%", (int)((double)this.progress * 100.0)), this.field_146294_l / 2, progressHeight, 0xFFFFFF);
                break;
            }
            case FAILED: {
                this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.failure", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 30, 0xFFFFFF);
                break;
            }
            default: {
                this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.hint", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 30, 0xFFFFFF);
            }
        }
        String seedPrefix = this.worldSeed.isEmpty() ? "Random " : "";
        String seedLabel = String.format("%s%s: ", seedPrefix, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.seed", (Object[])new Object[0]));
        String seedField = this.getFormattedSeed();
        int seedTextLen = this.field_146289_q.func_78256_a(seedLabel + seedField);
        int seedFieldLen = this.field_146289_q.func_78256_a(seedField);
        int seedColor = this.seedFieldBounds.isHovered() ? (System.currentTimeMillis() - this.copiedSeedFieldTime < 100L ? 0xA0A0A0 : 0xFFFFA0) : 0xFFFFFF;
        int seedFieldX = this.field_146294_l / 2 + seedTextLen / 2 - seedFieldLen;
        int seedFieldHeight = this.getSeedFieldY();
        this.func_73731_b(this.field_146289_q, seedLabel, this.field_146294_l / 2 - seedTextLen / 2, seedFieldHeight, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, seedField, seedFieldX, seedFieldHeight, seedColor);
        int seedUnderlineShadow = MathUtil.convertRGBtoARGB(0x3F3F3F);
        int seedUnderline = MathUtil.convertRGBtoARGB(seedColor);
        if (!seedField.isEmpty()) {
            this.func_73730_a(seedFieldX + 1, seedFieldX + seedFieldLen, seedFieldHeight + this.field_146289_q.field_78288_b + 1, seedUnderlineShadow);
            this.func_73730_a(seedFieldX, seedFieldX + seedFieldLen - 1, seedFieldHeight + this.field_146289_q.field_78288_b, seedUnderline);
        }
        if (this.seedFieldBounds.isHovered() && !this.copiedSeedField && !this.copiedTpCommand) {
            this.func_146279_a(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.copy", (Object[])new Object[0]), mouseX, mouseY);
        } else if (this.copiedSeedField) {
            this.func_146279_a(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.copied", (Object[])new Object[0]), mouseX, mouseY);
        } else if (this.copiedTpCommand) {
            this.func_146279_a(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.copiedTp", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (this.structureButtonBounds.isHovered() && !this.copiedSeedField && !this.copiedTpCommand && this.buttonStructures.field_146124_l) {
            this.func_146279_a(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.structuresNote", (Object[])new Object[0]), mouseX, mouseY);
        }
        this.hoveredStructure = false;
        this.hoveredStructurePos = Long.MIN_VALUE;
        if (this.state == ProgressState.LOADED && this.mapBounds.inBounds(mouseX, mouseY)) {
            int x = (int)((float)this.mapBounds.getRelativeX(mouseX) / (float)viewportSize * (float)this.selectedPreviewSettings.zoom);
            int y = (int)((float)this.mapBounds.getRelativeY(mouseY) / (float)viewportSize * (float)this.selectedPreviewSettings.zoom);
            x = (int)((float)x - (float)this.selectedPreviewSettings.zoom / 2.0f);
            y = (int)((float)y - (float)this.selectedPreviewSettings.zoom / 2.0f);
            int height = this.chunkSource.getHeight(x, y, HeightmapChunk.Type.SURFACE);
            Biome biome = this.sampleInjectedBiome(x, y);
            String coordinateText = String.format("%d, %d, %d", x, height, y);
            String biomeText = biome.func_185359_l();
            for (Map.Entry<Long, GuiBoundsChecker> entry : this.structureBounds.entrySet()) {
                if (!entry.getValue().inBounds(mouseX, mouseY)) continue;
                this.hoveredStructure = true;
                this.hoveredStructurePos = entry.getKey();
            }
            int tpX = x;
            int tpZ = y;
            int tpHeight = height < this.chunkSource.getSeaLevel() ? this.chunkSource.getSeaLevel() : height + 1;
            this.tpCallback = () -> String.format("/tp %d %d %d", tpX, tpHeight, tpZ);
            if (!this.copiedSeedField && !this.copiedTpCommand) {
                ArrayList<String> tooltips = new ArrayList<String>();
                tooltips.add(coordinateText);
                tooltips.add(biomeText);
                if (this.hoveredStructure && this.showStructures) {
                    String structure = this.structureMap.get(this.hoveredStructurePos).structure.func_110623_a().toLowerCase();
                    structure = structure.substring(0, 1).toUpperCase() + structure.substring(1);
                    tooltips.add(structure);
                }
                this.func_146283_a(tooltips, mouseX, mouseY);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public String func_175318_a(int id, String entryString, float entryValue) {
        if (id == 1) {
            return String.format("%s: %d %s", entryString, ModernBetaGeneratorSettings.LEVEL_WIDTHS[(int)entryValue], I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.blocks", (Object[])new Object[0]));
        }
        return String.format("%d", (int)entryValue);
    }

    public void func_175321_a(int id, boolean value) {
        if (id == 0) {
            this.previewSettings.useBiomeBlend = value;
        } else if (id == 4) {
            this.showStructures = value;
        }
        this.updateButtonsEnabled(this.state);
    }

    public void func_175320_a(int id, float value) {
        if (id == 1) {
            this.previewSettings.zoom = ModernBetaGeneratorSettings.LEVEL_WIDTHS[(int)value];
        }
        this.updateButtonsEnabled(this.state);
    }

    public void func_175319_a(int id, String value) {
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 && this.state == ProgressState.STARTED) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0 && this.seedFieldBounds.isHovered()) {
            GuiScreen.func_146275_d((String)this.getFormattedSeed());
            ModernBeta.log(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.copied", (Object[])new Object[0]));
            this.copiedSeedField = true;
            this.copiedSeedFieldTime = System.currentTimeMillis();
            this.copiedTpCommand = false;
        }
        if (mouseButton == 0 && this.mapBounds.isHovered() && this.state == ProgressState.LOADED) {
            if (this.tpCallback != null) {
                GuiScreen.func_146275_d((String)this.tpCallback.get());
            }
            ModernBeta.log(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.copiedTp", (Object[])new Object[0]));
            this.copiedTpCommand = true;
            this.copiedTpCommandTime = System.currentTimeMillis();
            this.copiedSeedField = false;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        switch (guiButton.field_146127_k) {
            case 2: {
                this.createTerrainMap();
                break;
            }
            case 3: {
                this.haltGeneration = true;
                if (this.chunkSource instanceof FiniteChunkSource) {
                    ((FiniteChunkSource)this.chunkSource).haltGeneration();
                }
                this.executor.shutdown();
                this.unloadMapTexture(this.mapTexture);
                this.unloadMapTexture(this.prevMapTexture);
                this.parent.setPreviewSettings(this.previewSettings);
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
            }
        }
    }

    private void updateState(ProgressState state) {
        this.prevState = this.state;
        this.state = state;
    }

    private void createTerrainMap() {
        BufferedImage previousMap = this.mapTexture.mapImage;
        boolean sameBiomeBlend = this.selectedPreviewSettings != null && this.previewSettings.useBiomeBlend == this.selectedPreviewSettings.useBiomeBlend;
        this.prevProgress = 0.0f;
        this.progress = 0.0f;
        this.selectedPreviewSettings = new PreviewSettings(this.previewSettings);
        this.updateState(ProgressState.STARTED);
        this.updateButtonsEnabled(this.state);
        long time = System.currentTimeMillis();
        this.unloadMapTexture(this.prevMapTexture);
        this.prevMapTexture = new MapTexture(this, this.mapTexture.mapIdentifier, this.mapTexture.mapImage, this.mapTexture.mapTexture, 1.0f);
        this.mapTexture = new MapTexture(this, ModernBeta.createRegistryKey("map_preview_" + new Random().nextLong()));
        if (this.worldSeed.isEmpty()) {
            this.seed = new Random().nextLong();
            this.initSources(this.seed, this.settings);
            this.seedFieldBounds.updateBounds(this.getSeedFieldX(), this.getSeedFieldY(), this.getSeedFieldWidth(), this.field_146289_q.field_78288_b);
        }
        Runnable runnable = () -> {
            try {
                ModernBeta.log(Level.DEBUG, String.format("Drawing terrain map of size %s", this.previewSettings.zoom));
                BetaColorSampler.INSTANCE.resetClimateSamplers();
                BufferedImage newMapImage = DrawUtil.createTerrainMap(this.chunkSource, this.biomeSource, this.surfaceBuilder, this.injectionRules, this.previewSettings.zoom, this.previewSettings.useBiomeBlend, progress -> {
                    this.progress = progress.floatValue();
                }, () -> this.haltGeneration, !this.worldSeed.isEmpty() && previousMap != null && sameBiomeBlend ? previousMap : null);
                if (newMapImage == null) {
                    ModernBeta.log(Level.DEBUG, "Terrain map drawing was canceled!");
                    this.mapTexture.loadMapImage(this.prevMapTexture.mapImage);
                } else {
                    ModernBeta.log(Level.DEBUG, String.format("Finished drawing terrain map in %2.3fs!", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f)));
                    this.mapTexture.loadMapImage(newMapImage);
                }
                this.sampleStructures();
                this.updateState(ProgressState.SUCCEEDED);
            }
            catch (Exception e) {
                ModernBeta.log(Level.ERROR, "Failed to draw terrain map!");
                ModernBeta.log(Level.ERROR, "Error: " + e.getLocalizedMessage());
                this.updateState(ProgressState.FAILED);
            }
            finally {
                this.updateButtonsEnabled(this.state);
            }
        };
        this.executor.queueRunnable(runnable);
    }

    private void drawStructureIcons(int startTextureX, int startTextureY, int viewportSize, float partialTicks) {
        int chunkWidth = this.selectedPreviewSettings.zoom >> 4;
        int chunkLength = this.selectedPreviewSettings.zoom >> 4;
        int offsetChunkX = chunkWidth / 2;
        int offsetChunkZ = chunkLength / 2;
        ArrayList<ChunkPos> structurePositions = new ArrayList<ChunkPos>();
        ChunkPos hoveredPosition = null;
        for (int chunkX = -offsetChunkX; chunkX <= offsetChunkX; ++chunkX) {
            for (int chunkZ = -offsetChunkZ; chunkZ <= offsetChunkZ; ++chunkZ) {
                long chunkPos = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
                if (!this.structureMap.containsKey(chunkPos)) continue;
                if (this.hoveredStructure && this.hoveredStructurePos == chunkPos) {
                    hoveredPosition = new ChunkPos(chunkX, chunkZ);
                    continue;
                }
                structurePositions.add(new ChunkPos(chunkX, chunkZ));
            }
        }
        if (hoveredPosition != null) {
            structurePositions.add(hoveredPosition);
        }
        for (int i = 0; i < structurePositions.size(); ++i) {
            ChunkPos position = (ChunkPos)structurePositions.get(i);
            int chunkX = position.field_77276_a;
            int chunkZ = position.field_77275_b;
            long chunkPos = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
            GuiBoundsChecker bounds = this.structureBounds.get(chunkPos);
            StructureInfo info = this.structureMap.get(chunkPos);
            ResourceLocation structure = info.structure;
            float progress = info.iconProgress;
            float alpha = info.iconAlpha;
            int iconSize = 10;
            int iconOffset = 5;
            progress = this.hoveredStructurePos == chunkPos ? (float)MathHelper.func_151238_b((double)progress, (double)2.0, (double)partialTicks) : (float)MathHelper.func_151238_b((double)progress, (double)1.0, (double)partialTicks);
            alpha = this.state == ProgressState.STARTED || !this.showStructures ? (float)MathHelper.func_151238_b((double)alpha, (double)0.0, (double)partialTicks) : (float)MathHelper.func_151238_b((double)alpha, (double)1.0, (double)partialTicks);
            info.iconProgress = progress;
            info.iconAlpha = alpha;
            iconSize = Math.round((float)iconSize * progress);
            iconOffset = Math.round((float)iconOffset * progress);
            int x = chunkX << 4;
            int z = chunkZ << 4;
            float textureX = (float)x + (float)this.selectedPreviewSettings.zoom / 2.0f;
            float textureY = (float)z + (float)this.selectedPreviewSettings.zoom / 2.0f;
            textureX /= (float)this.selectedPreviewSettings.zoom;
            textureY /= (float)this.selectedPreviewSettings.zoom;
            textureX *= (float)viewportSize;
            textureY *= (float)viewportSize;
            int textureL = (int)(textureX += (float)startTextureX) - iconOffset;
            int textureR = (int)textureX - iconOffset + iconSize;
            int textureT = (int)(textureY += (float)startTextureY) - iconOffset;
            int textureB = (int)textureY - iconOffset + iconSize;
            bounds.updateBounds(textureL, textureT, iconSize, iconSize);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)info.iconAlpha);
            this.parent.field_146297_k.func_110434_K().func_110577_a(STRUCTURE_ICONS.get(structure));
            GlStateManager.func_179147_l();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferBuilder.func_181662_b((double)textureL, (double)textureB, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            bufferBuilder.func_181662_b((double)textureR, (double)textureB, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            bufferBuilder.func_181662_b((double)textureR, (double)textureT, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            bufferBuilder.func_181662_b((double)textureL, (double)textureT, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
        }
    }

    private void unloadMapTexture(MapTexture mapTexture) {
        if (mapTexture != null) {
            mapTexture.unloadAll();
        }
    }

    private void updateButtonsEnabled(ProgressState state) {
        boolean enabled;
        this.sliderZoom.field_146124_l = enabled = state != ProgressState.STARTED;
        this.buttonBiomeBlend.field_146124_l = enabled;
        this.buttonStructures.field_146124_l = enabled;
        this.buttonGenerate.field_146124_l = enabled && (!this.previewSettings.equals(this.selectedPreviewSettings) || this.worldSeed.isEmpty());
        this.buttonCancel.field_146124_l = true;
    }

    private void initSources(long seed, ModernBetaGeneratorSettings settings) {
        this.chunkSource = ModernBetaRegistries.CHUNK_SOURCE.get(settings.chunkSource).apply(seed, settings);
        this.biomeSource = ModernBetaRegistries.BIOME_SOURCE.get(settings.biomeSource).apply(seed, settings);
        this.surfaceBuilder = ModernBetaRegistries.SURFACE_BUILDER.get(settings.surfaceBuilder).apply(this.chunkSource, settings);
        this.injectionRules = this.chunkSource.createBiomeInjectionRules(this.biomeSource).build();
        this.structureSims = new Object2ObjectLinkedOpenHashMap();
        if (this.settings.useVillages) {
            this.structureSims.put(ModernBetaStructures.VILLAGE, new StructureSimVillage(seed));
        }
        if (this.settings.useStrongholds) {
            this.structureSims.put(ModernBetaStructures.STRONGHOLD, new StructureSimStronghold(this.chunkSource));
        }
        if (this.settings.useMineShafts) {
            this.structureSims.put(ModernBetaStructures.MINESHAFT, new StructureSimMineshaft(seed));
        }
        if (this.settings.useMonuments) {
            this.structureSims.put(ModernBetaStructures.MONUMENT, new StructureSimMonument(seed));
        }
        if (this.settings.useMansions) {
            this.structureSims.put(ModernBetaStructures.MANSION, new StructureSimMansion(seed));
        }
        if (this.settings.useTemples) {
            this.structureSims.put(ModernBetaStructures.TEMPLE, new StructureSimScatteredFeature(seed));
        }
    }

    private String getFormattedSeed() {
        return this.worldSeed.isEmpty() ? (this.state == ProgressState.NOT_STARTED ? "" : new Long(this.seed).toString()) : this.worldSeed;
    }

    private int getSeedFieldX() {
        String seedPrefix = this.worldSeed.isEmpty() ? "Random " : "";
        String seedLabel = String.format("%s%s: ", seedPrefix, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.seed", (Object[])new Object[0]));
        String seedField = this.getFormattedSeed();
        int seedTextLen = this.field_146289_q.func_78256_a(seedLabel + seedField);
        int seedFieldLen = this.field_146289_q.func_78256_a(seedField);
        return this.field_146294_l / 2 + seedTextLen / 2 - seedFieldLen;
    }

    private int getSeedFieldY() {
        int viewportSize = Math.min(this.list.field_148158_l, this.list.field_148155_a) - 32 - 54 - 32;
        int fieldY = this.field_146295_m / 2 + viewportSize / 2;
        return fieldY -= 10;
    }

    private int getSeedFieldWidth() {
        return this.field_146289_q.func_78256_a(this.getFormattedSeed());
    }

    private void sampleStructures() {
        this.structureMap.clear();
        this.structureBounds.clear();
        int centerChunkX = 0;
        int centerChunkZ = 0;
        int chunkWidth = this.selectedPreviewSettings.zoom >> 4;
        int chunkLength = this.selectedPreviewSettings.zoom >> 4;
        int offsetChunkX = chunkWidth / 2;
        int offsetChunkZ = chunkLength / 2;
        for (int localChunkX = 0; localChunkX < chunkWidth; ++localChunkX) {
            int chunkX = localChunkX - offsetChunkX + centerChunkX;
            for (int localChunkZ = 0; localChunkZ < chunkLength; ++localChunkZ) {
                int chunkZ = localChunkZ - offsetChunkZ + centerChunkZ;
                for (Map.Entry<ResourceLocation, StructureSim> entry : this.structureSims.entrySet()) {
                    BiFunction<Integer, Integer, Biome> biomeFunc = entry.getKey().equals((Object)ModernBetaStructures.STRONGHOLD) ? this.biomeSource::getBiome : this::sampleInjectedBiome;
                    entry.getValue().generatePositions(chunkX, chunkZ, biomeFunc);
                    this.sampleStructure(chunkX, chunkZ, entry);
                }
            }
        }
    }

    private void sampleStructure(int chunkX, int chunkZ, Map.Entry<ResourceLocation, StructureSim> entry) {
        int range = entry.getValue().getRange();
        for (int structureChunkX = chunkX - range; structureChunkX <= chunkX + range; ++structureChunkX) {
            for (int structureChunkZ = chunkZ - range; structureChunkZ <= chunkZ + range; ++structureChunkZ) {
                if (!entry.getValue().canGenerate(structureChunkX, structureChunkZ) || this.chunkSource.skipChunk(structureChunkX, structureChunkZ)) continue;
                this.structureMap.put(ChunkPos.func_77272_a((int)structureChunkX, (int)structureChunkZ), new StructureInfo(entry.getKey()));
                this.structureBounds.put(ChunkPos.func_77272_a((int)structureChunkX, (int)structureChunkZ), new GuiBoundsChecker());
                return;
            }
        }
    }

    private Biome sampleInjectedBiome(int x, int z) {
        Biome biome = this.biomeSource.getBiome(x, z);
        BiomeInjectionRules.BiomeInjectionContext context = DrawUtil.createInjectionContext(this.chunkSource, this.surfaceBuilder, x, z, biome);
        Biome injectedBiome = this.injectionRules.test(context, x, z, BiomeInjectionStep.PRE_SURFACE);
        biome = injectedBiome != null ? injectedBiome : biome;
        context.setBiome(biome);
        injectedBiome = this.injectionRules.test(context, x, z, BiomeInjectionStep.CUSTOM);
        biome = injectedBiome != null ? injectedBiome : biome;
        context.setBiome(biome);
        injectedBiome = this.injectionRules.test(context, x, z, BiomeInjectionStep.POST_SURFACE);
        biome = injectedBiome != null ? injectedBiome : biome;
        return biome;
    }

    private static long parseSeed(String seedString) {
        long seed = new Random().nextLong();
        if (!seedString.isEmpty()) {
            try {
                seed = Longs.tryParse((String)seedString);
            }
            catch (Exception e) {
                seed = seedString.hashCode();
            }
        }
        return seed;
    }

    private static int getNdx(int[] arr, int val) {
        for (int i = 0; i < arr.length; ++i) {
            if (val != arr[i]) continue;
            return i;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static class PreviewSettings {
        private int zoom;
        private boolean useBiomeBlend;

        public PreviewSettings() {
            this.zoom = 512;
            this.useBiomeBlend = true;
        }

        public PreviewSettings(PreviewSettings previewSettings) {
            this.zoom = previewSettings.zoom;
            this.useBiomeBlend = previewSettings.useBiomeBlend;
        }

        public PreviewSettings(int zoom, boolean useBiomeBlend) {
            this.zoom = zoom;
            this.useBiomeBlend = useBiomeBlend;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PreviewSettings)) {
                return false;
            }
            PreviewSettings other = (PreviewSettings)o;
            return this.zoom == other.zoom && this.useBiomeBlend == other.useBiomeBlend;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class StructureInfo {
        private final ResourceLocation structure;
        private float iconProgress;
        private float iconAlpha;

        public StructureInfo(ResourceLocation structure) {
            this.structure = structure;
            this.iconProgress = 1.0f;
            this.iconAlpha = 0.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class MapTexture {
        private final GuiScreenCustomizePreview parent;
        private final ResourceLocation mapIdentifier;
        private BufferedImage mapImage;
        private DynamicTexture mapTexture;
        private float mapAlpha;

        public MapTexture(GuiScreenCustomizePreview parent, ResourceLocation mapIdentifier) {
            this(parent, mapIdentifier, null, null, 0.0f);
        }

        public MapTexture(GuiScreenCustomizePreview parent, ResourceLocation mapIdentifier, BufferedImage mapImage, DynamicTexture mapTexture, float mapAlpha) {
            this.parent = parent;
            this.mapIdentifier = mapIdentifier;
            this.mapImage = mapImage;
            this.mapTexture = mapTexture;
            this.mapAlpha = mapAlpha;
        }

        public void loadMapImage(BufferedImage mapImage) {
            this.mapImage = mapImage;
        }

        public void loadMapTexture() {
            int mapWidth = this.mapImage.getWidth();
            int mapHeight = this.mapImage.getHeight();
            this.mapTexture = new DynamicTexture(mapWidth, mapHeight);
            this.parent.field_146297_k.func_110434_K().func_110579_a(this.mapIdentifier, (ITextureObject)this.mapTexture);
            this.mapImage.getRGB(0, 0, mapWidth, mapHeight, this.mapTexture.func_110565_c(), 0, mapWidth);
            this.mapTexture.func_110564_a();
        }

        public void unloadMapImage() {
            this.mapImage = null;
        }

        public void unloadMapTexture() {
            this.parent.field_146297_k.func_110434_K().func_147645_c(this.mapIdentifier);
            this.mapTexture = null;
        }

        public void unloadAll() {
            this.unloadMapImage();
            this.unloadMapTexture();
        }

        public void drawMapTexture(int textureX, int textureY, int viewportSize) {
            int width = this.parent.field_146294_l;
            int height = this.parent.field_146295_m;
            if (this.mapTexture != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.mapAlpha);
                this.parent.field_146297_k.func_110434_K().func_110577_a(this.mapIdentifier);
                GlStateManager.func_179147_l();
                Gui.func_146110_a((int)textureX, (int)textureY, (float)0.0f, (float)0.0f, (int)viewportSize, (int)viewportSize, (float)viewportSize, (float)viewportSize);
                GlStateManager.func_179084_k();
                this.parent.func_73732_a(this.parent.field_146289_q, "N", width / 2 + 2, height / 2 - viewportSize / 2 + 2 - 20, 0xFFFFA0);
                this.parent.func_73732_a(this.parent.field_146289_q, "S", width / 2 + 2, height / 2 + viewportSize / 2 - 9 - 20, 0xFFFFA0);
                this.parent.func_73732_a(this.parent.field_146289_q, "E", width / 2 + viewportSize / 2 - 4, height / 2 - 3 - 20, 0xFFFFA0);
                this.parent.func_73732_a(this.parent.field_146289_q, "W", width / 2 - viewportSize / 2 + 5, height / 2 - 3 - 20, 0xFFFFA0);
            }
        }

        public void lerpAlpha(float partialTicks, float scale, float target) {
            this.mapAlpha = MathUtil.lerp(partialTicks * scale, this.mapAlpha, target);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ListPreset
    extends GuiSlot {
        private static final int LIST_PADDING_TOP = 32;
        private static final int LIST_PADDING_BOTTOM = 54;

        public ListPreset(GuiScreenCustomizePreview parent) {
            super(parent.field_146297_k, parent.field_146294_l, parent.field_146295_m, 32, parent.field_146295_m - 54, 1);
        }

        protected int func_148127_b() {
            return 1;
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        }

        protected boolean func_148131_a(int slotIndex) {
            return false;
        }

        protected void func_148123_a() {
        }

        protected void func_192637_a(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        }
    }

    private static enum ProgressState {
        NOT_STARTED,
        STARTED,
        FAILED,
        SUCCEEDED,
        LOADED;

    }
}

