/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.client.gui;

import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mod.bespectacled.modernbetaforge.api.client.gui.GuiPredicate;
import mod.bespectacled.modernbetaforge.api.property.BiomeProperty;
import mod.bespectacled.modernbetaforge.api.property.BlockProperty;
import mod.bespectacled.modernbetaforge.api.property.BooleanProperty;
import mod.bespectacled.modernbetaforge.api.property.EntityEntryProperty;
import mod.bespectacled.modernbetaforge.api.property.FloatProperty;
import mod.bespectacled.modernbetaforge.api.property.IntProperty;
import mod.bespectacled.modernbetaforge.api.property.ListProperty;
import mod.bespectacled.modernbetaforge.api.property.Property;
import mod.bespectacled.modernbetaforge.api.property.PropertyGuiType;
import mod.bespectacled.modernbetaforge.api.property.StringProperty;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaClientRegistries;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.client.gui.GuiBoundsChecker;
import mod.bespectacled.modernbetaforge.client.gui.GuiColoredLabelEntry;
import mod.bespectacled.modernbetaforge.client.gui.GuiIdentifiers;
import mod.bespectacled.modernbetaforge.client.gui.GuiScreenCustomizePresets;
import mod.bespectacled.modernbetaforge.client.gui.GuiScreenCustomizePreview;
import mod.bespectacled.modernbetaforge.client.gui.GuiScreenCustomizeRegistry;
import mod.bespectacled.modernbetaforge.client.gui.GuiTabButton;
import mod.bespectacled.modernbetaforge.compat.ModCompat;
import mod.bespectacled.modernbetaforge.compat.dynamictrees.CompatDynamicTrees;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.property.visitor.EntryValuePropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.GuiPropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.PropertyVisitor;
import mod.bespectacled.modernbetaforge.util.ForgeRegistryUtil;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.SoundUtil;
import mod.bespectacled.modernbetaforge.world.biome.layer.GenLayerType;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevHouse;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevTheme;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevType;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiListButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenCustomizeWorld
extends GuiScreen
implements GuiSlider.FormatHelper,
GuiPageButtonList.GuiResponder {
    private static final String PREFIX_ADDON = "createWorld.customize.custom.";
    private static final String PREFIX = "createWorld.customize.custom.modernbetaforge.";
    private static final String PREFIX_TAB = "createWorld.customize.custom.tab.modernbetaforge.";
    private static final String PREFIX_LABEL = "createWorld.customize.custom.label.modernbetaforge.";
    private static final int RGB_INFO = 0xA0A0A0;
    private static final int RGB_HEADER = 0xFFFFFF;
    private static final int ARGB_KEY_ICON_BACK_ACTIVE = MathUtil.convertARGBComponentsToInt(160, 120, 120, 120);
    private static final int ARGB_KEY_ICON_BORDER_ACTIVE = MathUtil.convertARGBComponentsToInt(160, 160, 160, 160);
    private static final int ARGB_KEY_ICON_BACK_INACTIVE = MathUtil.convertARGBComponentsToInt(160, 40, 40, 40);
    private static final int ARGB_KEY_ICON_BORDER_INACTIVE = MathUtil.convertARGBComponentsToInt(160, 0, 0, 0);
    private static final int RGB_KEY_ICON_TEXT_ACTIVE = 0xC8C8C8;
    private static final int RGB_KEY_ICON_TEXT_INACTIVE = 0x787878;
    private static final int RGB_KEY_ICON_TEXT_HOVERED = 13158500;
    private static final int KEY_ICON_WIDTH = 14;
    private static final int PAGE_TITLE_HEIGHT = 6;
    private static final int PAGELIST_PADDING_TOP = 40;
    private static final int PAGELIST_PADDING_BOTTOM = 32;
    private static final int PAGELIST_SCROLLBAR_PADDING = 24;
    private static final int BIOME_TRUNCATE_LEN = 18;
    private static final int DEFAULT_BLOCK_TRUNCATE_LEN = 10;
    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SLOT_HEIGHT = 25;
    private static final int TAB_SPACE = 2;
    private static final int TAB_HEIGHT = 18;
    private static final int TAB_BUTTON_WIDTH = 44;
    private static final int TAB_BUTTON_HEIGHT = 20;
    private final GuiCreateWorld parent;
    private final Predicate<String> floatFilter;
    private final Predicate<String> intFilter;
    private final ModernBetaGeneratorSettings.Factory defaultSettings;
    private final Random random;
    private final GuiBoundsChecker leftKeyBounds;
    private final GuiBoundsChecker rightKeyBounds;
    private final Map<Integer, Boolean> enabledMap;
    protected String title = I18n.func_135052_a((String)"options.customizeTitle", (Object[])new Object[0]);
    protected String subtitle = "Page 1 of 6";
    protected String pageTitle = "Basic Settings";
    protected String[] pageNames = new String[]{I18n.func_135052_a((String)"createWorld.customize.custom.tab.modernbetaforge.page0", (Object[])new Object[0]), I18n.func_135052_a((String)"createWorld.customize.custom.tab.modernbetaforge.page1", (Object[])new Object[0]), I18n.func_135052_a((String)"createWorld.customize.custom.tab.modernbetaforge.page2", (Object[])new Object[0]), I18n.func_135052_a((String)"createWorld.customize.custom.tab.modernbetaforge.page3", (Object[])new Object[0]), I18n.func_135052_a((String)"createWorld.customize.custom.tab.modernbetaforge.page4", (Object[])new Object[0]), I18n.func_135052_a((String)"createWorld.customize.custom.tab.modernbetaforge.page5", (Object[])new Object[0]), I18n.func_135052_a((String)"createWorld.customize.custom.tab.modernbetaforge.page6", (Object[])new Object[0]), I18n.func_135052_a((String)"createWorld.customize.custom.tab.modernbetaforge.page7", (Object[])new Object[0])};
    protected Map<Integer, GuiButton> pageTabMap;
    private ModernBetaGeneratorSettings.Factory settings;
    private GuiPageButtonList pageList;
    private GuiButton buttonDone;
    private GuiButton buttonRandomize;
    private GuiButton buttonDefaults;
    private GuiButton buttonConfirm;
    private GuiButton buttonCancel;
    private GuiButton buttonPresets;
    private GuiButton buttonPreview;
    private boolean settingsModified;
    private int confirmMode;
    private boolean confirmDismissed;
    private boolean clicked;
    private boolean randomClicked;
    private boolean tabClicked;
    private long lastNavPressed;
    private int customId;
    private BiMap<Integer, ResourceLocation> propertyMap;
    private Set<Integer> unlabeledSliders;
    private int tabStartX;
    private int tabEndX;
    private GuiScreenCustomizePreview.PreviewSettings previewSettings;

    public GuiScreenCustomizeWorld(GuiScreen parent, String string) {
        this.floatFilter = new Predicate<String>(){

            public boolean apply(@Nullable String entryString) {
                Float entryValue = Floats.tryParse((String)entryString);
                return entryString.isEmpty() || entryValue != null && Floats.isFinite((float)entryValue.floatValue());
            }
        };
        this.intFilter = new Predicate<String>(){

            public boolean apply(@Nullable String entryString) {
                Integer entryValue = Ints.tryParse((String)entryString);
                return entryString.isEmpty() || entryValue != null;
            }
        };
        String defaultPreset = ModernBetaConfig.guiOptions.defaultPreset;
        this.defaultSettings = ModernBetaGeneratorSettings.Factory.jsonToFactory(defaultPreset);
        this.random = new Random();
        this.parent = (GuiCreateWorld)parent;
        this.leftKeyBounds = new GuiBoundsChecker();
        this.rightKeyBounds = new GuiBoundsChecker();
        this.enabledMap = new HashMap<Integer, Boolean>();
        this.previewSettings = new GuiScreenCustomizePreview.PreviewSettings();
        this.loadValues(string);
    }

    private void createPagedList() {
        this.customId = 5000;
        this.propertyMap = HashBiMap.create();
        this.unlabeledSliders = new HashSet<Integer>();
        int chunkSourceId = ModernBetaRegistries.CHUNK_SOURCE.getKeys().indexOf(new ResourceLocation(this.settings.chunkSource));
        int biomeSourceId = ModernBetaRegistries.BIOME_SOURCE.getKeys().indexOf(new ResourceLocation(this.settings.biomeSource));
        int surfaceBuilderId = ModernBetaRegistries.SURFACE_BUILDER.getKeys().indexOf(new ResourceLocation(this.settings.surfaceBuilder));
        int caveCarverId = ModernBetaRegistries.CAVE_CARVER.getKeys().indexOf(new ResourceLocation(this.settings.caveCarver));
        int worldSpawnerId = ModernBetaRegistries.WORLD_SPAWNER.getKeys().indexOf(new ResourceLocation(this.settings.worldSpawner));
        int defaultBlockId = ModernBetaRegistries.DEFAULT_BLOCK.getKeys().indexOf(new ResourceLocation(this.settings.defaultBlock));
        int defaultFluidId = ForgeRegistryUtil.getFluidBlockRegistryNames().indexOf(new ResourceLocation(this.settings.defaultFluid));
        int levelThemeId = IndevTheme.fromId(this.settings.levelTheme).ordinal();
        int levelTypeId = IndevType.fromId(this.settings.levelType).ordinal();
        int levelWidth = GuiScreenCustomizeWorld.getNdx(ModernBetaGeneratorSettings.LEVEL_WIDTHS, this.settings.levelWidth);
        int levelLength = GuiScreenCustomizeWorld.getNdx(ModernBetaGeneratorSettings.LEVEL_WIDTHS, this.settings.levelLength);
        int levelHeight = GuiScreenCustomizeWorld.getNdx(ModernBetaGeneratorSettings.LEVEL_HEIGHTS, this.settings.levelHeight);
        int levelHouseId = IndevHouse.fromId(this.settings.levelHouse).ordinal();
        int levelSeaLevel = this.getLevelSeaLevel();
        String levelSeaLevelStr = levelSeaLevel == -1 ? "" : Integer.toString(levelSeaLevel);
        int layerTypeId = GenLayerType.fromId(this.settings.layerType).ordinal();
        ArrayList<String> loadedMods = new ArrayList<String>(ModCompat.LOADED_MODS.keySet());
        StringBuilder loadedModsList = new StringBuilder();
        if (loadedMods.isEmpty()) {
            loadedModsList.append("n/a");
        } else if (loadedMods.size() > 0) {
            loadedModsList.append((String)loadedMods.get(0));
        }
        boolean useMenu = ModernBetaConfig.guiOptions.useMenusForBasicSettings;
        GuiPageButtonList.GuiButtonEntry chunkEntry = useMenu ? GuiScreenCustomizeWorld.createGuiButton(190, "chunkSource", true) : GuiScreenCustomizeWorld.createGuiSlider(100, "chunkSource", 0.0f, ModernBetaRegistries.CHUNK_SOURCE.getKeys().size() - 1, chunkSourceId, this);
        GuiPageButtonList.GuiButtonEntry biomeEntry = useMenu ? GuiScreenCustomizeWorld.createGuiButton(191, "biomeSource", true) : GuiScreenCustomizeWorld.createGuiSlider(101, "biomeSource", 0.0f, ModernBetaRegistries.BIOME_SOURCE.getKeys().size() - 1, biomeSourceId, this);
        GuiPageButtonList.GuiButtonEntry surfaceEntry = useMenu ? GuiScreenCustomizeWorld.createGuiButton(192, "surfaceBuilder", true) : GuiScreenCustomizeWorld.createGuiSlider(102, "surfaceBuilder", 0.0f, ModernBetaRegistries.SURFACE_BUILDER.getKeys().size() - 1, surfaceBuilderId, this);
        GuiPageButtonList.GuiButtonEntry carverEntry = useMenu ? GuiScreenCustomizeWorld.createGuiButton(193, "caveCarver", true) : GuiScreenCustomizeWorld.createGuiSlider(103, "caveCarver", 0.0f, ModernBetaRegistries.CAVE_CARVER.getKeys().size() - 1, caveCarverId, this);
        GuiPageButtonList.GuiButtonEntry spawnEntry = useMenu ? GuiScreenCustomizeWorld.createGuiButton(194, "worldSpawner", true) : GuiScreenCustomizeWorld.createGuiSlider(104, "worldSpawner", 0.0f, ModernBetaRegistries.WORLD_SPAWNER.getKeys().size() - 1, worldSpawnerId, this);
        GuiPageButtonList.GuiButtonEntry blockEntry = useMenu ? GuiScreenCustomizeWorld.createGuiButton(195, "defaultBlock", true) : GuiScreenCustomizeWorld.createGuiSlider(134, "defaultBlock", 0.0f, ModernBetaRegistries.DEFAULT_BLOCK.getKeys().size() - 1, defaultBlockId, this);
        GuiPageButtonList.GuiButtonEntry fluidEntry = useMenu ? GuiScreenCustomizeWorld.createGuiButton(196, "defaultFluid", true) : GuiScreenCustomizeWorld.createGuiSlider(135, "defaultFluid", 0.0f, ForgeRegistryUtil.getFluidBlockRegistryNames().size() - 1, defaultFluidId, this);
        GuiPageButtonList.GuiListEntry[] pageBasic = new GuiPageButtonList.GuiListEntry[]{chunkEntry, biomeEntry, surfaceEntry, GuiScreenCustomizeWorld.createGuiButton(105, "singleBiome", true), carverEntry, spawnEntry, GuiScreenCustomizeWorld.createGuiLabel(1002, 0xFFFFFF, "page0", "biomeReplacement"), null, GuiScreenCustomizeWorld.createGuiButton(106, "replaceOceanBiomes", this.settings.replaceOceanBiomes), GuiScreenCustomizeWorld.createGuiButton(107, "replaceBeachBiomes", this.settings.replaceBeachBiomes), GuiScreenCustomizeWorld.createGuiButton(108, "replaceRiverBiomes", this.settings.replaceRiverBiomes), null, GuiScreenCustomizeWorld.createGuiLabel(1003, 0xFFFFFF, "page0", "overworld"), null, blockEntry, fluidEntry, GuiScreenCustomizeWorld.createGuiSlider(109, "seaLevel", 0.0f, 255.0f, this.settings.seaLevel, this), GuiScreenCustomizeWorld.createGuiButton(125, "useSandstone", this.settings.useSandstone), GuiScreenCustomizeWorld.createGuiSlider(130, "caveWidth", 1.0f, 7.5f, this.settings.caveWidth, this), GuiScreenCustomizeWorld.createGuiSlider(131, "caveHeight", 9.0f, 255.0f, this.settings.caveHeight, this), GuiScreenCustomizeWorld.createGuiSlider(132, "caveCount", 1.0f, 100.0f, this.settings.caveCount, this), GuiScreenCustomizeWorld.createGuiSlider(133, "caveChance", 1.0f, 100.0f, this.settings.caveChance, this), GuiScreenCustomizeWorld.createGuiButton(117, "useRavines", this.settings.useRavines), GuiScreenCustomizeWorld.createGuiButton(113, "useMineShafts", this.settings.useMineShafts), GuiScreenCustomizeWorld.createGuiButton(111, "useVillages", this.settings.useVillages), GuiScreenCustomizeWorld.createGuiButton(112, "useVillageVariants", this.settings.useVillageVariants), GuiScreenCustomizeWorld.createGuiButton(110, "useStrongholds", this.settings.useStrongholds), GuiScreenCustomizeWorld.createGuiButton(114, "useTemples", this.settings.useTemples), GuiScreenCustomizeWorld.createGuiButton(115, "useMonuments", this.settings.useMonuments), GuiScreenCustomizeWorld.createGuiButton(116, "useMansions", this.settings.useMansions), GuiScreenCustomizeWorld.createGuiButton(118, "useDungeons", this.settings.useDungeons), GuiScreenCustomizeWorld.createGuiSlider(119, "dungeonChance", 1.0f, 100.0f, this.settings.dungeonChance, this), GuiScreenCustomizeWorld.createGuiButton(120, "useWaterLakes", this.settings.useWaterLakes), GuiScreenCustomizeWorld.createGuiSlider(121, "waterLakeChance", 1.0f, 100.0f, this.settings.waterLakeChance, this), GuiScreenCustomizeWorld.createGuiButton(122, "useLavaLakes", this.settings.useLavaLakes), GuiScreenCustomizeWorld.createGuiSlider(123, "lavaLakeChance", 10.0f, 100.0f, this.settings.lavaLakeChance, this), GuiScreenCustomizeWorld.createGuiButton(136, "useUnderwaterCaves", this.settings.useUnderwaterCaves), null, GuiScreenCustomizeWorld.createGuiLabel(1004, 0xFFFFFF, "page0", "nether"), null, GuiScreenCustomizeWorld.createGuiButton(126, "useOldNether", this.settings.useOldNether), GuiScreenCustomizeWorld.createGuiButton(127, "useNetherCaves", this.settings.useNetherCaves), GuiScreenCustomizeWorld.createGuiButton(128, "useFortresses", this.settings.useFortresses), GuiScreenCustomizeWorld.createGuiButton(129, "useLavaPockets", this.settings.useLavaPockets)};
        GuiPageButtonList.GuiListEntry[] pageChunk = new GuiPageButtonList.GuiListEntry[]{GuiScreenCustomizeWorld.createGuiLabel(2001, 0xFFFFFF, "page1", "infdev227"), null, GuiScreenCustomizeWorld.createGuiButton(208, "useInfdevWalls", this.settings.useInfdevWalls), GuiScreenCustomizeWorld.createGuiButton(209, "useInfdevPyramids", this.settings.useInfdevPyramids), GuiScreenCustomizeWorld.createGuiLabel(2000, 0xFFFFFF, "page1", "indev"), null, GuiScreenCustomizeWorld.createGuiSlider(200, "levelTheme", 0.0f, IndevTheme.values().length - 1, levelThemeId, this), GuiScreenCustomizeWorld.createGuiSlider(201, "levelType", 0.0f, IndevType.values().length - 1, levelTypeId, this), GuiScreenCustomizeWorld.createGuiSlider(202, "levelWidth", 0.0f, ModernBetaGeneratorSettings.LEVEL_WIDTHS.length - 1, levelWidth, this), GuiScreenCustomizeWorld.createGuiSlider(203, "levelLength", 0.0f, ModernBetaGeneratorSettings.LEVEL_WIDTHS.length - 1, levelLength, this), GuiScreenCustomizeWorld.createGuiSlider(204, "levelHeight", 0.0f, ModernBetaGeneratorSettings.LEVEL_HEIGHTS.length - 1, levelHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(150, String.format("%s: %s", I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.seaLevel", (Object[])new Object[0]), levelSeaLevelStr)), GuiScreenCustomizeWorld.createGuiSlider(205, "levelHouse", 0.0f, IndevHouse.values().length - 1, levelHouseId, this), GuiScreenCustomizeWorld.createGuiButton(206, "useIndevCaves", this.settings.useIndevCaves), GuiScreenCustomizeWorld.createGuiSlider(207, "levelCaveWidth", 1.0f, 5.0f, this.settings.levelCaveWidth, this), null, GuiScreenCustomizeWorld.createGuiLabel(2002, 0xFFFFFF, "page1", "release"), null, GuiScreenCustomizeWorld.createGuiSlider(211, "layerSize", 1.0f, 8.0f, this.settings.layerSize, this), GuiScreenCustomizeWorld.createGuiSlider(210, "riverRarity", 1.0f, 5.0f, this.settings.riverSize, this), GuiScreenCustomizeWorld.createGuiSlider(212, "layerType", 0.0f, GenLayerType.values().length - 1, layerTypeId, this)};
        GuiPageButtonList.GuiListEntry[] pageBiome = new GuiPageButtonList.GuiListEntry[]{GuiScreenCustomizeWorld.createGuiLabel(1300, 0xFFFFFF, "page2", "beta"), null, GuiScreenCustomizeWorld.createGuiButton(300, "useTallGrass", this.settings.useTallGrass), GuiScreenCustomizeWorld.createGuiButton(301, "useNewFlowers", this.settings.useNewFlowers), GuiScreenCustomizeWorld.createGuiButton(315, "useDoublePlants", this.settings.useDoublePlants), GuiScreenCustomizeWorld.createGuiButton(302, "useLilyPads", this.settings.useLilyPads), GuiScreenCustomizeWorld.createGuiButton(303, "useMelons", this.settings.useMelons), GuiScreenCustomizeWorld.createGuiButton(304, "useDesertWells", this.settings.useDesertWells), GuiScreenCustomizeWorld.createGuiButton(305, "useFossils", this.settings.useFossils), GuiScreenCustomizeWorld.createGuiButton(312, "useSandDisks", this.settings.useSandDisks), GuiScreenCustomizeWorld.createGuiButton(313, "useGravelDisks", this.settings.useGravelDisks), GuiScreenCustomizeWorld.createGuiButton(314, "useClayDisks", this.settings.useClayDisks), GuiScreenCustomizeWorld.createGuiButton(311, "useNewFancyOakTrees", this.settings.useNewFancyOakTrees), GuiScreenCustomizeWorld.createGuiButton(306, "useBirchTrees", this.settings.useBirchTrees), GuiScreenCustomizeWorld.createGuiButton(307, "usePineTrees", this.settings.usePineTrees), GuiScreenCustomizeWorld.createGuiButton(308, "useSwampTrees", this.settings.useSwampTrees), GuiScreenCustomizeWorld.createGuiButton(309, "useJungleTrees", this.settings.useJungleTrees), GuiScreenCustomizeWorld.createGuiButton(310, "useAcaciaTrees", this.settings.useAcaciaTrees), GuiScreenCustomizeWorld.createGuiLabel(1302, 0xFFFFFF, "page2", "release"), null, GuiScreenCustomizeWorld.createGuiSlider(330, "biomeSize", 1.0f, 8.0f, this.settings.biomeSize, this), GuiScreenCustomizeWorld.createGuiSlider(331, "snowyBiomeChance", 1.0f, 12.0f, this.settings.snowyBiomeChance, this), GuiScreenCustomizeWorld.createGuiLabel(1301, 0xFFFFFF, "page2", "mobSpawn"), null, GuiScreenCustomizeWorld.createGuiButton(320, "spawnNewCreatureMobs", this.settings.spawnNewCreatureMobs), GuiScreenCustomizeWorld.createGuiButton(321, "spawnNewMonsterMobs", this.settings.spawnNewMonsterMobs), GuiScreenCustomizeWorld.createGuiButton(322, "spawnWaterMobs", this.settings.spawnWaterMobs), GuiScreenCustomizeWorld.createGuiButton(323, "spawnAmbientMobs", this.settings.spawnAmbientMobs), GuiScreenCustomizeWorld.createGuiButton(324, "spawnWolves", this.settings.spawnWolves), null};
        GuiPageButtonList.GuiListEntry[] pageOre = new GuiPageButtonList.GuiListEntry[]{GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1401, 0xFFFFFF, I18n.func_135052_a((String)"tile.dirt.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(404, "size", 1.0f, 50.0f, this.settings.dirtSize, this), GuiScreenCustomizeWorld.createGuiSlider(405, "count", 0.0f, 40.0f, this.settings.dirtCount, this), GuiScreenCustomizeWorld.createGuiSlider(406, "minHeight", 0.0f, 255.0f, this.settings.dirtMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(407, "maxHeight", 0.0f, 255.0f, this.settings.dirtMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1402, 0xFFFFFF, I18n.func_135052_a((String)"tile.gravel.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(408, "size", 1.0f, 50.0f, this.settings.gravelSize, this), GuiScreenCustomizeWorld.createGuiSlider(409, "count", 0.0f, 40.0f, this.settings.gravelCount, this), GuiScreenCustomizeWorld.createGuiSlider(410, "minHeight", 0.0f, 255.0f, this.settings.gravelMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(411, "maxHeight", 0.0f, 255.0f, this.settings.gravelMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1403, 0xFFFFFF, I18n.func_135052_a((String)"tile.stone.granite.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(412, "size", 1.0f, 50.0f, this.settings.graniteSize, this), GuiScreenCustomizeWorld.createGuiSlider(413, "count", 0.0f, 40.0f, this.settings.graniteCount, this), GuiScreenCustomizeWorld.createGuiSlider(414, "minHeight", 0.0f, 255.0f, this.settings.graniteMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(415, "maxHeight", 0.0f, 255.0f, this.settings.graniteMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1404, 0xFFFFFF, I18n.func_135052_a((String)"tile.stone.diorite.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(416, "size", 1.0f, 50.0f, this.settings.dioriteSize, this), GuiScreenCustomizeWorld.createGuiSlider(417, "count", 0.0f, 40.0f, this.settings.dioriteCount, this), GuiScreenCustomizeWorld.createGuiSlider(418, "minHeight", 0.0f, 255.0f, this.settings.dioriteMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(419, "maxHeight", 0.0f, 255.0f, this.settings.dioriteMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1405, 0xFFFFFF, I18n.func_135052_a((String)"tile.stone.andesite.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(420, "size", 1.0f, 50.0f, this.settings.andesiteSize, this), GuiScreenCustomizeWorld.createGuiSlider(421, "count", 0.0f, 40.0f, this.settings.andesiteCount, this), GuiScreenCustomizeWorld.createGuiSlider(422, "minHeight", 0.0f, 255.0f, this.settings.andesiteMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(423, "maxHeight", 0.0f, 255.0f, this.settings.andesiteMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1406, 0xFFFFFF, I18n.func_135052_a((String)"tile.oreCoal.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(424, "size", 1.0f, 50.0f, this.settings.coalSize, this), GuiScreenCustomizeWorld.createGuiSlider(425, "count", 0.0f, 40.0f, this.settings.coalCount, this), GuiScreenCustomizeWorld.createGuiSlider(426, "minHeight", 0.0f, 255.0f, this.settings.coalMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(427, "maxHeight", 0.0f, 255.0f, this.settings.coalMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1407, 0xFFFFFF, I18n.func_135052_a((String)"tile.oreIron.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(428, "size", 1.0f, 50.0f, this.settings.ironSize, this), GuiScreenCustomizeWorld.createGuiSlider(429, "count", 0.0f, 40.0f, this.settings.ironCount, this), GuiScreenCustomizeWorld.createGuiSlider(430, "minHeight", 0.0f, 255.0f, this.settings.ironMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(431, "maxHeight", 0.0f, 255.0f, this.settings.ironMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1408, 0xFFFFFF, I18n.func_135052_a((String)"tile.oreGold.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(432, "size", 1.0f, 50.0f, this.settings.goldSize, this), GuiScreenCustomizeWorld.createGuiSlider(433, "count", 0.0f, 40.0f, this.settings.goldCount, this), GuiScreenCustomizeWorld.createGuiSlider(434, "minHeight", 0.0f, 255.0f, this.settings.goldMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(435, "maxHeight", 0.0f, 255.0f, this.settings.goldMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1409, 0xFFFFFF, I18n.func_135052_a((String)"tile.oreRedstone.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(436, "size", 1.0f, 50.0f, this.settings.redstoneSize, this), GuiScreenCustomizeWorld.createGuiSlider(437, "count", 0.0f, 40.0f, this.settings.redstoneCount, this), GuiScreenCustomizeWorld.createGuiSlider(438, "minHeight", 0.0f, 255.0f, this.settings.redstoneMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(439, "maxHeight", 0.0f, 255.0f, this.settings.redstoneMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1410, 0xFFFFFF, I18n.func_135052_a((String)"tile.oreDiamond.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(440, "size", 1.0f, 50.0f, this.settings.diamondSize, this), GuiScreenCustomizeWorld.createGuiSlider(441, "count", 0.0f, 40.0f, this.settings.diamondCount, this), GuiScreenCustomizeWorld.createGuiSlider(442, "minHeight", 0.0f, 255.0f, this.settings.diamondMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(443, "maxHeight", 0.0f, 255.0f, this.settings.diamondMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1411, 0xFFFFFF, I18n.func_135052_a((String)"tile.oreLapis.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(444, "size", 1.0f, 50.0f, this.settings.lapisSize, this), GuiScreenCustomizeWorld.createGuiSlider(445, "count", 0.0f, 40.0f, this.settings.lapisCount, this), GuiScreenCustomizeWorld.createGuiSlider(446, "center", 0.0f, 255.0f, this.settings.lapisCenterHeight, this), GuiScreenCustomizeWorld.createGuiSlider(447, "spread", 1.0f, 255.0f, this.settings.lapisSpread, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1412, 0xFFFFFF, I18n.func_135052_a((String)"tile.oreEmerald.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(448, "size", 1.0f, 50.0f, this.settings.emeraldSize, this), GuiScreenCustomizeWorld.createGuiSlider(449, "count", 0.0f, 40.0f, this.settings.emeraldCount, this), GuiScreenCustomizeWorld.createGuiSlider(450, "minHeight", 0.0f, 255.0f, this.settings.emeraldMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(451, "maxHeight", 0.0f, 255.0f, this.settings.emeraldMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1400, 0xFFFFFF, I18n.func_135052_a((String)"tile.clay.name", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiSlider(400, "size", 1.0f, 50.0f, this.settings.claySize, this), GuiScreenCustomizeWorld.createGuiSlider(401, "count", 0.0f, 40.0f, this.settings.clayCount, this), GuiScreenCustomizeWorld.createGuiSlider(402, "minHeight", 0.0f, 255.0f, this.settings.clayMinHeight, this), GuiScreenCustomizeWorld.createGuiSlider(403, "maxHeight", 0.0f, 255.0f, this.settings.clayMaxHeight, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1413, 0xFFFFFF, String.format("%s (%s)", I18n.func_135052_a((String)"tile.netherquartz.name", (Object[])new Object[0]), I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.useOldNether", (Object[])new Object[0]))), null, GuiScreenCustomizeWorld.createGuiSlider(452, "size", 1.0f, 50.0f, this.settings.quartzSize, this), GuiScreenCustomizeWorld.createGuiSlider(453, "count", 0.0f, 40.0f, this.settings.quartzCount, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1414, 0xFFFFFF, String.format("%s (%s)", I18n.func_135052_a((String)"tile.magma.name", (Object[])new Object[0]), I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.useOldNether", (Object[])new Object[0]))), null, GuiScreenCustomizeWorld.createGuiSlider(454, "size", 1.0f, 50.0f, this.settings.magmaSize, this), GuiScreenCustomizeWorld.createGuiSlider(455, "count", 0.0f, 40.0f, this.settings.magmaCount, this)};
        GuiPageButtonList.GuiListEntry[] pageNoise0 = new GuiPageButtonList.GuiListEntry[]{GuiScreenCustomizeWorld.createGuiSlider(500, "mainNoiseScaleX", 1.0f, 5000.0f, this.settings.mainNoiseScaleX, this), GuiScreenCustomizeWorld.createGuiSlider(501, "mainNoiseScaleY", 1.0f, 5000.0f, this.settings.mainNoiseScaleY, this), GuiScreenCustomizeWorld.createGuiSlider(502, "mainNoiseScaleZ", 1.0f, 5000.0f, this.settings.mainNoiseScaleZ, this), GuiScreenCustomizeWorld.createGuiSlider(524, "scaleNoiseScaleX", 1.0f, 20.0f, this.settings.scaleNoiseScaleX, this), GuiScreenCustomizeWorld.createGuiSlider(525, "scaleNoiseScaleZ", 1.0f, 20.0f, this.settings.scaleNoiseScaleZ, this), GuiScreenCustomizeWorld.createGuiSlider(503, "depthNoiseScaleX", 1.0f, 2000.0f, this.settings.depthNoiseScaleX, this), GuiScreenCustomizeWorld.createGuiSlider(504, "depthNoiseScaleZ", 1.0f, 2000.0f, this.settings.depthNoiseScaleZ, this), GuiScreenCustomizeWorld.createGuiSlider(506, "baseSize", 1.0f, 25.0f, this.settings.baseSize, this), GuiScreenCustomizeWorld.createGuiSlider(507, "coordinateScale", 1.0f, 6000.0f, this.settings.coordinateScale, this), GuiScreenCustomizeWorld.createGuiSlider(508, "heightScale", 1.0f, 6000.0f, this.settings.heightScale, this), GuiScreenCustomizeWorld.createGuiSlider(509, "stretchY", 0.01f, 50.0f, this.settings.stretchY, this), GuiScreenCustomizeWorld.createGuiSlider(510, "upperLimitScale", 1.0f, 5000.0f, this.settings.upperLimitScale, this), GuiScreenCustomizeWorld.createGuiSlider(511, "lowerLimitScale", 1.0f, 5000.0f, this.settings.lowerLimitScale, this), GuiScreenCustomizeWorld.createGuiSlider(512, "height", 1.0f, 255.0f, this.settings.height, this), GuiScreenCustomizeWorld.createGuiLabel(1500, 0xFFFFFF, "page4", "beta"), null, GuiScreenCustomizeWorld.createGuiSlider(520, "tempNoiseScale", 0.1f, 8.0f, this.settings.tempNoiseScale, this), GuiScreenCustomizeWorld.createGuiSlider(521, "rainNoiseScale", 0.1f, 8.0f, this.settings.rainNoiseScale, this), GuiScreenCustomizeWorld.createGuiSlider(522, "detailNoiseScale", 0.1f, 8.0f, this.settings.detailNoiseScale, this), null, GuiScreenCustomizeWorld.createGuiLabel(1501, 0xFFFFFF, "page4", "release"), null, GuiScreenCustomizeWorld.createGuiSlider(513, "biomeDepthWeight", 1.0f, 20.0f, this.settings.biomeDepthWeight, this), GuiScreenCustomizeWorld.createGuiSlider(514, "biomeDepthOffset", 0.0f, 20.0f, this.settings.biomeDepthOffset, this), GuiScreenCustomizeWorld.createGuiSlider(515, "biomeScaleWeight", 1.0f, 20.0f, this.settings.biomeScaleWeight, this), GuiScreenCustomizeWorld.createGuiSlider(516, "biomeScaleOffset", 0.0f, 20.0f, this.settings.biomeScaleOffset, this), GuiScreenCustomizeWorld.createGuiButton(550, "useBiomeDepthScale", this.settings.useBiomeDepthScale), GuiScreenCustomizeWorld.createGuiButton(552, "useAmplified", this.settings.useAmplified), GuiScreenCustomizeWorld.createGuiLabel(1502, 0xFFFFFF, "page4", "end"), null, GuiScreenCustomizeWorld.createGuiSlider(527, "endIslandWeight", 1.0f, 20.0f, this.settings.endIslandWeight, this), GuiScreenCustomizeWorld.createGuiSlider(526, "endIslandOffset", 0.0f, 2000.0f, this.settings.endIslandOffset, this), GuiScreenCustomizeWorld.createGuiSlider(529, "endOuterIslandDistance", 0.0f, 256.0f, this.settings.endOuterIslandDistance, this), GuiScreenCustomizeWorld.createGuiSlider(528, "endOuterIslandOffset", 0.0f, 2000.0f, this.settings.endOuterIslandOffset, this), GuiScreenCustomizeWorld.createGuiButton(551, "useEndOuterIslands", this.settings.useEndOuterIslands), null};
        GuiPageButtonList.GuiListEntry[] pageNoise1 = new GuiPageButtonList.GuiListEntry[]{GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1600, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.mainNoiseScaleX", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(600, String.format("%5.3f", Float.valueOf(this.settings.mainNoiseScaleX)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1601, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.mainNoiseScaleY", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(601, String.format("%5.3f", Float.valueOf(this.settings.mainNoiseScaleY)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1602, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.mainNoiseScaleZ", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(602, String.format("%5.3f", Float.valueOf(this.settings.mainNoiseScaleZ)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1623, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.scaleNoiseScaleX", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(624, String.format("%5.3f", Float.valueOf(this.settings.scaleNoiseScaleX)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1624, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.scaleNoiseScaleZ", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(625, String.format("%5.3f", Float.valueOf(this.settings.scaleNoiseScaleZ)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1603, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.depthNoiseScaleX", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(603, String.format("%5.3f", Float.valueOf(this.settings.depthNoiseScaleX)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1604, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.depthNoiseScaleZ", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(604, String.format("%5.3f", Float.valueOf(this.settings.depthNoiseScaleZ)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1606, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseSize", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(606, String.format("%2.3f", Float.valueOf(this.settings.baseSize)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1607, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.coordinateScale", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(607, String.format("%5.3f", Float.valueOf(this.settings.coordinateScale)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1608, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.heightScale", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(608, String.format("%5.3f", Float.valueOf(this.settings.heightScale)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1609, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.stretchY", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(609, String.format("%2.3f", Float.valueOf(this.settings.stretchY)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1610, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.upperLimitScale", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(610, String.format("%5.3f", Float.valueOf(this.settings.upperLimitScale)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1611, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.lowerLimitScale", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(611, String.format("%5.3f", Float.valueOf(this.settings.lowerLimitScale)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1612, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.height", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(612, String.format("%d", this.settings.height), this.intFilter), GuiScreenCustomizeWorld.createGuiLabel(1500, 0xFFFFFF, "page5", "beta"), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1613, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.tempNoiseScale", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(620, String.format("%2.3f", Float.valueOf(this.settings.tempNoiseScale)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1614, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.rainNoiseScale", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(621, String.format("%2.3f", Float.valueOf(this.settings.rainNoiseScale)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1615, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.detailNoiseScale", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(622, String.format("%2.3f", Float.valueOf(this.settings.detailNoiseScale)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabel(1501, 0xFFFFFF, "page5", "release"), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1617, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.biomeDepthWeight", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(613, String.format("%2.3f", Float.valueOf(this.settings.biomeDepthWeight)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1618, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.biomeDepthOffset", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(614, String.format("%2.3f", Float.valueOf(this.settings.biomeDepthOffset)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1619, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.biomeScaleWeight", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(615, String.format("%2.3f", Float.valueOf(this.settings.biomeScaleWeight)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1620, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.biomeScaleOffset", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(616, String.format("%2.3f", Float.valueOf(this.settings.biomeScaleOffset)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabel(1502, 0xFFFFFF, "page5", "end"), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1626, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.endIslandWeight", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(627, String.format("%2.3f", Float.valueOf(this.settings.endIslandWeight)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1625, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.endIslandOffset", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(626, String.format("%2.3f", Float.valueOf(this.settings.endIslandOffset)), this.floatFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1628, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.endOuterIslandDistance", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(629, String.format("%d", this.settings.endOuterIslandDistance), this.intFilter), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1627, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.endOuterIslandOffset", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiField(628, String.format("%2.3f", Float.valueOf(this.settings.endOuterIslandOffset)), this.floatFilter)};
        GuiPageButtonList.GuiListEntry[] pageClimate = new GuiPageButtonList.GuiListEntry[]{GuiScreenCustomizeWorld.createGuiButton(751, "useClimateFeatures", this.settings.useClimateFeatures), GuiScreenCustomizeWorld.createGuiSlider(750, "snowLineOffset", 0.0f, 255.0f, this.settings.snowLineOffset, this), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1703, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.desertBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(700, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(701, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(702, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1704, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.forestBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(703, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(704, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(705, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1705, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.iceDesertBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(706, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(707, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(708, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1706, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.plainsBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(709, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(710, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(711, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1707, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.rainforestBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(712, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(713, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(714, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1708, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.savannaBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(715, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(716, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(717, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1709, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.shrublandBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(718, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(719, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(720, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1710, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.seasonalForestBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(721, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(722, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(723, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1711, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.swamplandBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(724, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(725, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(726, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1712, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.taigaBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(727, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(728, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(729, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1713, 0xFFFFFF, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.tundraBiomes", (Object[])new Object[0])), null, GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1700, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.baseBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(730, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1701, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.oceanBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(731, "", true), GuiScreenCustomizeWorld.createGuiLabelNoPrefix(1702, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.beachBiome", (Object[])new Object[0]) + ":"), GuiScreenCustomizeWorld.createGuiButton(732, "", true)};
        GuiPageButtonList.GuiListEntry[] pageCustom = this.createCustomPropertyPage();
        if (!ModCompat.isNetherCompatible()) {
            pageBasic = Arrays.copyOf(pageBasic, pageBasic.length + 2);
            pageBasic[pageBasic.length - 2] = GuiScreenCustomizeWorld.createGuiLabel(1005, 0xA0A0A0, "page0", "netherIncompatible");
            pageBasic[pageBasic.length - 1] = null;
        }
        if (ModCompat.isModLoaded("dynamictrees") && CompatDynamicTrees.isEnabled()) {
            pageBiome = Arrays.copyOf(pageBiome, pageBiome.length + 2);
            pageBiome[pageBiome.length - 2] = GuiScreenCustomizeWorld.createGuiLabel(1304, 0xA0A0A0, "page2", "treesIncompatible");
            pageBiome[pageBiome.length - 1] = null;
        }
        GuiPageButtonList.GuiListEntry[][] pages = new GuiPageButtonList.GuiListEntry[][]{pageBasic, pageChunk, pageBiome, pageOre, pageNoise0, pageNoise1, pageClimate, pageCustom};
        if (ModernBetaRegistries.PROPERTY.getValues().isEmpty()) {
            pages = (GuiPageButtonList.GuiListEntry[][])Arrays.copyOf(pages, pages.length - 1);
        }
        this.pageList = new GuiPageButtonList(this.field_146297_k, this.field_146294_l, this.field_146295_m, 40, this.field_146295_m - 32, 25, (GuiPageButtonList.GuiResponder)this, (GuiPageButtonList.GuiListEntry[][])pages);
        this.pageList.field_148155_a += 24;
        this.setTextButton(190, GuiScreenCustomizeWorld.getFormattedRegistryName(this.settings.chunkSource, "chunkSource", -1));
        this.setTextButton(191, GuiScreenCustomizeWorld.getFormattedRegistryName(this.settings.biomeSource, "biomeSource", -1));
        this.setTextButton(192, GuiScreenCustomizeWorld.getFormattedRegistryName(this.settings.surfaceBuilder, "surfaceBuilder", -1));
        this.setTextButton(193, GuiScreenCustomizeWorld.getFormattedRegistryName(this.settings.caveCarver, "caveCarver", -1));
        this.setTextButton(194, GuiScreenCustomizeWorld.getFormattedRegistryName(this.settings.worldSpawner, "worldSpawner", -1));
        this.setTextButton(195, GuiScreenCustomizeWorld.getFormattedBlockName(this.settings.defaultBlock, "defaultBlock", 10));
        this.setTextButton(196, GuiScreenCustomizeWorld.getFormattedFluidName(this.settings.defaultFluid, "defaultFluid", 10));
        this.setTextButton(105, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.singleBiome, "fixedBiome", 18));
        this.setTextButton(700, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.desertBiomeBase));
        this.setTextButton(701, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.desertBiomeOcean));
        this.setTextButton(702, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.desertBiomeBeach));
        this.setTextButton(703, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.forestBiomeBase));
        this.setTextButton(704, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.forestBiomeOcean));
        this.setTextButton(705, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.forestBiomeBeach));
        this.setTextButton(706, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.iceDesertBiomeBase));
        this.setTextButton(707, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.iceDesertBiomeOcean));
        this.setTextButton(708, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.iceDesertBiomeBeach));
        this.setTextButton(709, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.plainsBiomeBase));
        this.setTextButton(710, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.plainsBiomeOcean));
        this.setTextButton(711, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.plainsBiomeBeach));
        this.setTextButton(712, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.rainforestBiomeBase));
        this.setTextButton(713, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.rainforestBiomeOcean));
        this.setTextButton(714, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.rainforestBiomeBeach));
        this.setTextButton(715, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.savannaBiomeBase));
        this.setTextButton(716, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.savannaBiomeOcean));
        this.setTextButton(717, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.savannaBiomeBeach));
        this.setTextButton(718, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.shrublandBiomeBase));
        this.setTextButton(719, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.shrublandBiomeOcean));
        this.setTextButton(720, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.shrublandBiomeBeach));
        this.setTextButton(721, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.seasonalForestBiomeBase));
        this.setTextButton(722, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.seasonalForestBiomeOcean));
        this.setTextButton(723, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.seasonalForestBiomeBeach));
        this.setTextButton(724, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.swamplandBiomeBase));
        this.setTextButton(725, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.swamplandBiomeOcean));
        this.setTextButton(726, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.swamplandBiomeBeach));
        this.setTextButton(727, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.taigaBiomeBase));
        this.setTextButton(728, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.taigaBiomeOcean));
        this.setTextButton(729, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.taigaBiomeBeach));
        this.setTextButton(730, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.tundraBiomeBase));
        this.setTextButton(731, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.tundraBiomeOcean));
        this.setTextButton(732, GuiScreenCustomizeWorld.getFormattedBiomeName(this.settings.tundraBiomeBeach));
        this.setPropertyText();
    }

    private void createPageTabs() {
        int x = this.tabStartX = this.field_146294_l / 2 - 44 * this.pageList.func_178057_f() / 2 - 2 * this.pageList.func_178057_f() / 2;
        this.pageTabMap = new LinkedHashMap<Integer, GuiButton>();
        for (int i = 0; i < this.pageList.func_178057_f(); ++i) {
            GuiTabButton guiButton = new GuiTabButton(30 + i, x, 18, 44, 20, I18n.func_135052_a((String)this.pageNames[i], (Object[])new Object[0]));
            this.pageTabMap.put(30 + i, this.func_189646_b(guiButton));
            x += 46;
        }
        this.tabEndX = x - 2;
    }

    public void func_73866_w_() {
        int curPage = 0;
        int curScroll = 0;
        if (this.pageList != null) {
            curPage = this.pageList.func_178059_e();
            curScroll = this.pageList.func_148148_g();
        }
        this.field_146292_n.clear();
        int buttonY = this.field_146295_m - 27;
        int defaultsX = this.field_146294_l / 2 - 140 - 35 - 6;
        int randomizeX = this.field_146294_l / 2 - 70 - 35 - 3;
        int previewX = this.field_146294_l / 2 - 35;
        int presetsX = this.field_146294_l / 2 + 35 + 3;
        int doneX = this.field_146294_l / 2 + 35 + 70 + 6;
        this.buttonDefaults = this.func_189646_b(new GuiButton(62, defaultsX, buttonY, 70, 20, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.defaults", (Object[])new Object[0])));
        this.buttonRandomize = this.func_189646_b(new GuiButton(61, randomizeX, buttonY, 70, 20, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.randomize", (Object[])new Object[0])));
        this.buttonPreview = this.func_189646_b(new GuiButton(66, previewX, buttonY, 70, 20, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.preview", (Object[])new Object[0])));
        this.buttonPresets = this.func_189646_b(new GuiButton(63, presetsX, buttonY, 70, 20, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.presets", (Object[])new Object[0])));
        this.buttonDone = this.func_189646_b(new GuiButton(60, doneX, buttonY, 70, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.buttonDefaults.field_146124_l = this.settingsModified;
        this.buttonConfirm = new GuiButton(64, this.field_146294_l / 2 - 55, 160, 50, 20, I18n.func_135052_a((String)"gui.yes", (Object[])new Object[0]));
        this.buttonConfirm.field_146125_m = false;
        this.buttonCancel = new GuiButton(65, this.field_146294_l / 2 + 5, 160, 50, 20, I18n.func_135052_a((String)"gui.no", (Object[])new Object[0]));
        this.buttonCancel.field_146125_m = false;
        this.field_146292_n.add(this.buttonConfirm);
        this.field_146292_n.add(this.buttonCancel);
        if (this.confirmMode != 0) {
            this.buttonConfirm.field_146125_m = true;
            this.buttonCancel.field_146125_m = true;
        }
        GuiIdentifiers.assertOffsets();
        this.createPagedList();
        this.createPageTabs();
        this.pageList.func_181156_c(curPage);
        this.pageList.func_148145_f(curScroll);
        this.setGuiEnabled();
        this.updatePageControls();
        this.isSettingsModified();
        if (this.confirmMode == 62) {
            this.setConfirmationControls(true);
        }
        this.leftKeyBounds.updateBounds(this.tabStartX - 14 - 4, 21, 14, 14);
        this.rightKeyBounds.updateBounds(this.tabEndX + 4, 21, 14, 14);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (!this.tabClicked && this.confirmMode != 62) {
            this.pageList.func_178039_p();
        }
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.leftKeyBounds.updateHovered(mouseX, mouseY);
        this.rightKeyBounds.updateHovered(mouseX, mouseY);
    }

    public String func_175318_a(int entry, String entryString, float entryValue) {
        if (this.propertyMap.containsKey((Object)entry) || this.unlabeledSliders.contains(entry)) {
            return this.getFormattedValue(entry, entryValue);
        }
        return entryString + ": " + this.getFormattedValue(entry, entryValue);
    }

    public void func_175319_a(int entry, String entryString) {
        if (this.propertyMap.containsKey((Object)entry)) {
            ResourceLocation registryKey = (ResourceLocation)this.propertyMap.get((Object)entry);
            Property<?> property = this.settings.customProperties.get(registryKey);
            property.visitEntryValue(new SetEntryValuePropertyVisitor(), entry, entryString, registryKey);
        } else {
            Gui gui;
            float entryValue = 0.0f;
            try {
                entryValue = Float.parseFloat(entryString);
            }
            catch (NumberFormatException property) {
                // empty catch block
            }
            float newEntryValue = 0.0f;
            switch (entry) {
                case 600: {
                    newEntryValue = this.settings.mainNoiseScaleX = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)5000.0f);
                    break;
                }
                case 601: {
                    newEntryValue = this.settings.mainNoiseScaleY = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)5000.0f);
                    break;
                }
                case 602: {
                    newEntryValue = this.settings.mainNoiseScaleZ = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)5000.0f);
                    break;
                }
                case 624: {
                    newEntryValue = this.settings.scaleNoiseScaleX = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)20.0f);
                    break;
                }
                case 625: {
                    newEntryValue = this.settings.scaleNoiseScaleZ = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)20.0f);
                    break;
                }
                case 603: {
                    newEntryValue = this.settings.depthNoiseScaleX = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)2000.0f);
                    break;
                }
                case 604: {
                    newEntryValue = this.settings.depthNoiseScaleZ = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)2000.0f);
                    break;
                }
                case 606: {
                    newEntryValue = this.settings.baseSize = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)25.0f);
                    break;
                }
                case 607: {
                    newEntryValue = this.settings.coordinateScale = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)6000.0f);
                    break;
                }
                case 608: {
                    newEntryValue = this.settings.heightScale = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)6000.0f);
                    break;
                }
                case 609: {
                    newEntryValue = this.settings.stretchY = MathHelper.func_76131_a((float)entryValue, (float)0.01f, (float)50.0f);
                    break;
                }
                case 610: {
                    newEntryValue = this.settings.upperLimitScale = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)5000.0f);
                    break;
                }
                case 611: {
                    newEntryValue = this.settings.lowerLimitScale = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)5000.0f);
                    break;
                }
                case 612: {
                    this.settings.height = (int)MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)255.0f);
                    newEntryValue = this.settings.height;
                    break;
                }
                case 620: {
                    newEntryValue = this.settings.tempNoiseScale = MathHelper.func_76131_a((float)entryValue, (float)0.1f, (float)8.0f);
                    break;
                }
                case 621: {
                    newEntryValue = this.settings.rainNoiseScale = MathHelper.func_76131_a((float)entryValue, (float)0.1f, (float)8.0f);
                    break;
                }
                case 622: {
                    newEntryValue = this.settings.detailNoiseScale = MathHelper.func_76131_a((float)entryValue, (float)0.1f, (float)8.0f);
                    break;
                }
                case 613: {
                    newEntryValue = this.settings.biomeDepthWeight = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)20.0f);
                    break;
                }
                case 614: {
                    newEntryValue = this.settings.biomeDepthOffset = MathHelper.func_76131_a((float)entryValue, (float)0.0f, (float)20.0f);
                    break;
                }
                case 615: {
                    newEntryValue = this.settings.biomeScaleWeight = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)20.0f);
                    break;
                }
                case 616: {
                    newEntryValue = this.settings.biomeScaleOffset = MathHelper.func_76131_a((float)entryValue, (float)0.0f, (float)20.0f);
                    break;
                }
                case 627: {
                    newEntryValue = this.settings.endIslandWeight = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)20.0f);
                    break;
                }
                case 626: {
                    newEntryValue = this.settings.endIslandOffset = MathHelper.func_76131_a((float)entryValue, (float)0.0f, (float)2000.0f);
                    break;
                }
                case 629: {
                    this.settings.endOuterIslandDistance = (int)MathHelper.func_76131_a((float)entryValue, (float)0.0f, (float)256.0f);
                    newEntryValue = this.settings.endOuterIslandDistance;
                    break;
                }
                case 628: {
                    newEntryValue = this.settings.endOuterIslandOffset = MathHelper.func_76131_a((float)entryValue, (float)0.0f, (float)2000.0f);
                }
            }
            if (newEntryValue != entryValue && entryValue != 0.0f) {
                ((GuiTextField)this.pageList.func_178061_c(entry)).func_146180_a(this.getFormattedValue(entry, newEntryValue));
            }
            if (entry >= 600 && entry <= 649 && (gui = this.pageList.func_178061_c(GuiIdentifiers.offsetBackward(entry))) != null) {
                ((GuiSlider)gui).func_175218_a(newEntryValue, false);
            }
        }
        this.setSettingsModified(!this.settings.equals(this.defaultSettings));
    }

    public void func_175321_a(int entry, boolean entryValue) {
        if (this.propertyMap.containsKey((Object)entry)) {
            ResourceLocation registryKey = (ResourceLocation)this.propertyMap.get((Object)entry);
            Property<?> property = this.settings.customProperties.get(registryKey);
            property.visitEntryValue(new SetEntryValuePropertyVisitor(), entry, entryValue, registryKey);
        } else {
            switch (entry) {
                case 190: {
                    this.openRegistryScreen((str, factory) -> {
                        factory.chunkSource = str;
                    }, this.settings.chunkSource, "chunkSource", ModernBetaRegistries.CHUNK_SOURCE.getKeys());
                    break;
                }
                case 191: {
                    this.openRegistryScreen((str, factory) -> {
                        factory.biomeSource = str;
                    }, this.settings.biomeSource, "biomeSource", ModernBetaRegistries.BIOME_SOURCE.getKeys());
                    break;
                }
                case 192: {
                    this.openRegistryScreen((str, factory) -> {
                        factory.surfaceBuilder = str;
                    }, this.settings.surfaceBuilder, "surfaceBuilder", ModernBetaRegistries.SURFACE_BUILDER.getKeys());
                    break;
                }
                case 193: {
                    this.openRegistryScreen((str, factory) -> {
                        factory.caveCarver = str;
                    }, this.settings.caveCarver, "caveCarver", ModernBetaRegistries.CAVE_CARVER.getKeys());
                    break;
                }
                case 194: {
                    this.openRegistryScreen((str, factory) -> {
                        factory.worldSpawner = str;
                    }, this.settings.worldSpawner, "worldSpawner", ModernBetaRegistries.WORLD_SPAWNER.getKeys());
                    break;
                }
                case 105: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.singleBiome = str;
                    }, this.settings.singleBiome);
                    break;
                }
                case 195: {
                    this.openBlockScreen((str, factory) -> {
                        factory.defaultBlock = str;
                    }, this.settings.defaultBlock, "defaultBlock", (Predicate<ResourceLocation>)((Predicate)key -> ModernBetaRegistries.DEFAULT_BLOCK.contains((ResourceLocation)key)));
                    break;
                }
                case 196: {
                    this.openFluidScreen((str, factory) -> {
                        factory.defaultFluid = str;
                    }, this.settings.defaultFluid, "defaultFluid", (Predicate<ResourceLocation>)((Predicate)key -> true));
                    break;
                }
                case 700: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.desertBiomeBase = str;
                    }, this.settings.desertBiomeBase);
                    break;
                }
                case 701: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.desertBiomeOcean = str;
                    }, this.settings.desertBiomeOcean);
                    break;
                }
                case 702: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.desertBiomeBeach = str;
                    }, this.settings.desertBiomeBeach);
                    break;
                }
                case 703: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.forestBiomeBase = str;
                    }, this.settings.forestBiomeBase);
                    break;
                }
                case 704: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.forestBiomeOcean = str;
                    }, this.settings.forestBiomeOcean);
                    break;
                }
                case 705: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.forestBiomeBeach = str;
                    }, this.settings.forestBiomeBeach);
                    break;
                }
                case 706: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.iceDesertBiomeBase = str;
                    }, this.settings.iceDesertBiomeBase);
                    break;
                }
                case 707: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.iceDesertBiomeOcean = str;
                    }, this.settings.iceDesertBiomeOcean);
                    break;
                }
                case 708: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.iceDesertBiomeBeach = str;
                    }, this.settings.iceDesertBiomeBeach);
                    break;
                }
                case 709: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.plainsBiomeBase = str;
                    }, this.settings.plainsBiomeBase);
                    break;
                }
                case 710: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.plainsBiomeOcean = str;
                    }, this.settings.plainsBiomeOcean);
                    break;
                }
                case 711: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.plainsBiomeBeach = str;
                    }, this.settings.plainsBiomeBeach);
                    break;
                }
                case 712: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.rainforestBiomeBase = str;
                    }, this.settings.rainforestBiomeBase);
                    break;
                }
                case 713: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.rainforestBiomeOcean = str;
                    }, this.settings.rainforestBiomeOcean);
                    break;
                }
                case 714: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.rainforestBiomeBeach = str;
                    }, this.settings.rainforestBiomeBeach);
                    break;
                }
                case 715: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.savannaBiomeBase = str;
                    }, this.settings.savannaBiomeBase);
                    break;
                }
                case 716: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.savannaBiomeOcean = str;
                    }, this.settings.savannaBiomeOcean);
                    break;
                }
                case 717: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.savannaBiomeBeach = str;
                    }, this.settings.savannaBiomeBeach);
                    break;
                }
                case 718: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.shrublandBiomeBase = str;
                    }, this.settings.shrublandBiomeBase);
                    break;
                }
                case 719: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.shrublandBiomeOcean = str;
                    }, this.settings.shrublandBiomeOcean);
                    break;
                }
                case 720: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.shrublandBiomeBeach = str;
                    }, this.settings.shrublandBiomeBeach);
                    break;
                }
                case 721: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.seasonalForestBiomeBase = str;
                    }, this.settings.seasonalForestBiomeBase);
                    break;
                }
                case 722: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.seasonalForestBiomeOcean = str;
                    }, this.settings.seasonalForestBiomeOcean);
                    break;
                }
                case 723: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.seasonalForestBiomeBeach = str;
                    }, this.settings.seasonalForestBiomeBeach);
                    break;
                }
                case 724: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.swamplandBiomeBase = str;
                    }, this.settings.swamplandBiomeBase);
                    break;
                }
                case 725: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.swamplandBiomeOcean = str;
                    }, this.settings.swamplandBiomeOcean);
                    break;
                }
                case 726: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.swamplandBiomeBeach = str;
                    }, this.settings.swamplandBiomeBeach);
                    break;
                }
                case 727: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.taigaBiomeBase = str;
                    }, this.settings.taigaBiomeBase);
                    break;
                }
                case 728: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.taigaBiomeOcean = str;
                    }, this.settings.taigaBiomeOcean);
                    break;
                }
                case 729: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.taigaBiomeBeach = str;
                    }, this.settings.taigaBiomeBeach);
                    break;
                }
                case 730: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.tundraBiomeBase = str;
                    }, this.settings.tundraBiomeBase);
                    break;
                }
                case 731: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.tundraBiomeOcean = str;
                    }, this.settings.tundraBiomeOcean);
                    break;
                }
                case 732: {
                    this.openBiomeScreen((str, factory) -> {
                        factory.tundraBiomeBeach = str;
                    }, this.settings.tundraBiomeBeach);
                    break;
                }
                case 106: {
                    this.settings.replaceOceanBiomes = entryValue;
                    break;
                }
                case 107: {
                    this.settings.replaceBeachBiomes = entryValue;
                    break;
                }
                case 108: {
                    this.settings.replaceRiverBiomes = entryValue;
                    break;
                }
                case 300: {
                    this.settings.useTallGrass = entryValue;
                    break;
                }
                case 301: {
                    this.settings.useNewFlowers = entryValue;
                    break;
                }
                case 315: {
                    this.settings.useDoublePlants = entryValue;
                    break;
                }
                case 302: {
                    this.settings.useLilyPads = entryValue;
                    break;
                }
                case 303: {
                    this.settings.useMelons = entryValue;
                    break;
                }
                case 304: {
                    this.settings.useDesertWells = entryValue;
                    break;
                }
                case 305: {
                    this.settings.useFossils = entryValue;
                    break;
                }
                case 312: {
                    this.settings.useSandDisks = entryValue;
                    break;
                }
                case 313: {
                    this.settings.useGravelDisks = entryValue;
                    break;
                }
                case 314: {
                    this.settings.useClayDisks = entryValue;
                    break;
                }
                case 306: {
                    this.settings.useBirchTrees = entryValue;
                    break;
                }
                case 307: {
                    this.settings.usePineTrees = entryValue;
                    break;
                }
                case 308: {
                    this.settings.useSwampTrees = entryValue;
                    break;
                }
                case 309: {
                    this.settings.useJungleTrees = entryValue;
                    break;
                }
                case 310: {
                    this.settings.useAcaciaTrees = entryValue;
                    break;
                }
                case 311: {
                    this.settings.useNewFancyOakTrees = entryValue;
                    break;
                }
                case 320: {
                    this.settings.spawnNewCreatureMobs = entryValue;
                    break;
                }
                case 321: {
                    this.settings.spawnNewMonsterMobs = entryValue;
                    break;
                }
                case 324: {
                    this.settings.spawnWolves = entryValue;
                    break;
                }
                case 322: {
                    this.settings.spawnWaterMobs = entryValue;
                    break;
                }
                case 323: {
                    this.settings.spawnAmbientMobs = entryValue;
                    break;
                }
                case 110: {
                    this.settings.useStrongholds = entryValue;
                    break;
                }
                case 111: {
                    this.settings.useVillages = entryValue;
                    break;
                }
                case 112: {
                    this.settings.useVillageVariants = entryValue;
                    break;
                }
                case 113: {
                    this.settings.useMineShafts = entryValue;
                    break;
                }
                case 114: {
                    this.settings.useTemples = entryValue;
                    break;
                }
                case 115: {
                    this.settings.useMonuments = entryValue;
                    break;
                }
                case 116: {
                    this.settings.useMansions = entryValue;
                    break;
                }
                case 117: {
                    this.settings.useRavines = entryValue;
                    break;
                }
                case 118: {
                    this.settings.useDungeons = entryValue;
                    break;
                }
                case 120: {
                    this.settings.useWaterLakes = entryValue;
                    break;
                }
                case 122: {
                    this.settings.useLavaLakes = entryValue;
                    break;
                }
                case 125: {
                    this.settings.useSandstone = entryValue;
                    break;
                }
                case 136: {
                    this.settings.useUnderwaterCaves = entryValue;
                    break;
                }
                case 126: {
                    this.settings.useOldNether = entryValue;
                    break;
                }
                case 127: {
                    this.settings.useNetherCaves = entryValue;
                    break;
                }
                case 128: {
                    this.settings.useFortresses = entryValue;
                    break;
                }
                case 129: {
                    this.settings.useLavaPockets = entryValue;
                    break;
                }
                case 206: {
                    this.settings.useIndevCaves = entryValue;
                    break;
                }
                case 208: {
                    this.settings.useInfdevWalls = entryValue;
                    break;
                }
                case 209: {
                    this.settings.useInfdevPyramids = entryValue;
                    break;
                }
                case 550: {
                    this.settings.useBiomeDepthScale = entryValue;
                    break;
                }
                case 551: {
                    this.settings.useEndOuterIslands = entryValue;
                    break;
                }
                case 552: {
                    this.settings.useAmplified = entryValue;
                    break;
                }
                case 751: {
                    this.settings.useClimateFeatures = entryValue;
                }
            }
        }
        this.setGuiEnabled();
        this.setSettingsModified(!this.settings.equals(this.defaultSettings));
        this.playSound();
    }

    public void func_175320_a(int entry, float entryValue) {
        if (this.propertyMap.containsKey((Object)entry)) {
            ResourceLocation registryKey = (ResourceLocation)this.propertyMap.get((Object)entry);
            Property<?> property = this.settings.customProperties.get(registryKey);
            property.visitEntryValue(new SetEntryValuePropertyVisitor(), entry, Float.valueOf(entryValue), registryKey);
        } else {
            Gui gui;
            switch (entry) {
                case 500: {
                    this.settings.mainNoiseScaleX = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 501: {
                    this.settings.mainNoiseScaleY = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 502: {
                    this.settings.mainNoiseScaleZ = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 524: {
                    this.settings.scaleNoiseScaleX = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 525: {
                    this.settings.scaleNoiseScaleZ = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 503: {
                    this.settings.depthNoiseScaleX = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 504: {
                    this.settings.depthNoiseScaleZ = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 506: {
                    this.settings.baseSize = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 507: {
                    this.settings.coordinateScale = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 508: {
                    this.settings.heightScale = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 509: {
                    this.settings.stretchY = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 510: {
                    this.settings.upperLimitScale = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 511: {
                    this.settings.lowerLimitScale = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 512: {
                    this.settings.height = (int)entryValue;
                    break;
                }
                case 520: {
                    this.settings.tempNoiseScale = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 521: {
                    this.settings.rainNoiseScale = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 522: {
                    this.settings.detailNoiseScale = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 513: {
                    this.settings.biomeDepthWeight = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 514: {
                    this.settings.biomeDepthOffset = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 515: {
                    this.settings.biomeScaleWeight = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 516: {
                    this.settings.biomeScaleOffset = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 526: {
                    this.settings.endIslandOffset = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 527: {
                    this.settings.endIslandWeight = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 529: {
                    this.settings.endOuterIslandDistance = (int)entryValue;
                    break;
                }
                case 528: {
                    this.settings.endOuterIslandOffset = GuiScreenCustomizeWorld.roundToThreeDec(entryValue);
                    break;
                }
                case 100: {
                    this.settings.chunkSource = ModernBetaRegistries.CHUNK_SOURCE.getKeys().get((int)entryValue).toString();
                    break;
                }
                case 101: {
                    this.settings.biomeSource = ModernBetaRegistries.BIOME_SOURCE.getKeys().get((int)entryValue).toString();
                    break;
                }
                case 102: {
                    this.settings.surfaceBuilder = ModernBetaRegistries.SURFACE_BUILDER.getKeys().get((int)entryValue).toString();
                    break;
                }
                case 103: {
                    this.settings.caveCarver = ModernBetaRegistries.CAVE_CARVER.getKeys().get((int)entryValue).toString();
                    break;
                }
                case 104: {
                    this.settings.worldSpawner = ModernBetaRegistries.WORLD_SPAWNER.getKeys().get((int)entryValue).toString();
                    break;
                }
                case 134: {
                    this.settings.defaultBlock = ModernBetaRegistries.DEFAULT_BLOCK.getKeys().get((int)entryValue).toString();
                    break;
                }
                case 135: {
                    this.settings.defaultFluid = ForgeRegistryUtil.getFluidBlockRegistryNames().get((int)entryValue).toString();
                    break;
                }
                case 109: {
                    this.settings.seaLevel = (int)entryValue;
                    break;
                }
                case 130: {
                    this.settings.caveWidth = GuiScreenCustomizeWorld.roundToOneDec(entryValue);
                    break;
                }
                case 131: {
                    this.settings.caveHeight = (int)entryValue;
                    break;
                }
                case 132: {
                    this.settings.caveCount = (int)entryValue;
                    break;
                }
                case 133: {
                    this.settings.caveChance = (int)entryValue;
                    break;
                }
                case 119: {
                    this.settings.dungeonChance = (int)entryValue;
                    break;
                }
                case 121: {
                    this.settings.waterLakeChance = (int)entryValue;
                    break;
                }
                case 123: {
                    this.settings.lavaLakeChance = (int)entryValue;
                    break;
                }
                case 200: {
                    this.settings.levelTheme = IndevTheme.values()[(int)entryValue].id;
                    break;
                }
                case 201: {
                    this.settings.levelType = IndevType.values()[(int)entryValue].id;
                    break;
                }
                case 202: {
                    this.settings.levelWidth = ModernBetaGeneratorSettings.LEVEL_WIDTHS[(int)entryValue];
                    break;
                }
                case 203: {
                    this.settings.levelLength = ModernBetaGeneratorSettings.LEVEL_WIDTHS[(int)entryValue];
                    break;
                }
                case 204: {
                    this.settings.levelHeight = ModernBetaGeneratorSettings.LEVEL_HEIGHTS[(int)entryValue];
                    break;
                }
                case 205: {
                    this.settings.levelHouse = IndevHouse.values()[(int)entryValue].id;
                    break;
                }
                case 207: {
                    this.settings.levelCaveWidth = GuiScreenCustomizeWorld.roundToOneDec(entryValue);
                    break;
                }
                case 210: {
                    this.settings.riverSize = (int)entryValue;
                    break;
                }
                case 212: {
                    this.settings.layerType = GenLayerType.values()[(int)entryValue].id;
                    break;
                }
                case 211: {
                    this.settings.layerSize = (int)entryValue;
                    break;
                }
                case 330: {
                    this.settings.biomeSize = (int)entryValue;
                    break;
                }
                case 331: {
                    this.settings.snowyBiomeChance = (int)entryValue;
                    break;
                }
                case 400: {
                    this.settings.claySize = (int)entryValue;
                    break;
                }
                case 401: {
                    this.settings.clayCount = (int)entryValue;
                    break;
                }
                case 402: {
                    this.settings.clayMinHeight = (int)entryValue;
                    break;
                }
                case 403: {
                    this.settings.clayMaxHeight = (int)entryValue;
                    break;
                }
                case 404: {
                    this.settings.dirtSize = (int)entryValue;
                    break;
                }
                case 405: {
                    this.settings.dirtCount = (int)entryValue;
                    break;
                }
                case 406: {
                    this.settings.dirtMinHeight = (int)entryValue;
                    break;
                }
                case 407: {
                    this.settings.dirtMaxHeight = (int)entryValue;
                    break;
                }
                case 408: {
                    this.settings.gravelSize = (int)entryValue;
                    break;
                }
                case 409: {
                    this.settings.gravelCount = (int)entryValue;
                    break;
                }
                case 410: {
                    this.settings.gravelMinHeight = (int)entryValue;
                    break;
                }
                case 411: {
                    this.settings.gravelMaxHeight = (int)entryValue;
                    break;
                }
                case 412: {
                    this.settings.graniteSize = (int)entryValue;
                    break;
                }
                case 413: {
                    this.settings.graniteCount = (int)entryValue;
                    break;
                }
                case 414: {
                    this.settings.graniteMinHeight = (int)entryValue;
                    break;
                }
                case 415: {
                    this.settings.graniteMaxHeight = (int)entryValue;
                    break;
                }
                case 416: {
                    this.settings.dioriteSize = (int)entryValue;
                    break;
                }
                case 417: {
                    this.settings.dioriteCount = (int)entryValue;
                    break;
                }
                case 418: {
                    this.settings.dioriteMinHeight = (int)entryValue;
                    break;
                }
                case 419: {
                    this.settings.dioriteMaxHeight = (int)entryValue;
                    break;
                }
                case 420: {
                    this.settings.andesiteSize = (int)entryValue;
                    break;
                }
                case 421: {
                    this.settings.andesiteCount = (int)entryValue;
                    break;
                }
                case 422: {
                    this.settings.andesiteMinHeight = (int)entryValue;
                    break;
                }
                case 423: {
                    this.settings.andesiteMaxHeight = (int)entryValue;
                    break;
                }
                case 424: {
                    this.settings.coalSize = (int)entryValue;
                    break;
                }
                case 425: {
                    this.settings.coalCount = (int)entryValue;
                    break;
                }
                case 426: {
                    this.settings.coalMinHeight = (int)entryValue;
                    break;
                }
                case 427: {
                    this.settings.coalMaxHeight = (int)entryValue;
                    break;
                }
                case 428: {
                    this.settings.ironSize = (int)entryValue;
                    break;
                }
                case 429: {
                    this.settings.ironCount = (int)entryValue;
                    break;
                }
                case 430: {
                    this.settings.ironMinHeight = (int)entryValue;
                    break;
                }
                case 431: {
                    this.settings.ironMaxHeight = (int)entryValue;
                    break;
                }
                case 432: {
                    this.settings.goldSize = (int)entryValue;
                    break;
                }
                case 433: {
                    this.settings.goldCount = (int)entryValue;
                    break;
                }
                case 434: {
                    this.settings.goldMinHeight = (int)entryValue;
                    break;
                }
                case 435: {
                    this.settings.goldMaxHeight = (int)entryValue;
                    break;
                }
                case 436: {
                    this.settings.redstoneSize = (int)entryValue;
                    break;
                }
                case 437: {
                    this.settings.redstoneCount = (int)entryValue;
                    break;
                }
                case 438: {
                    this.settings.redstoneMinHeight = (int)entryValue;
                    break;
                }
                case 439: {
                    this.settings.redstoneMaxHeight = (int)entryValue;
                    break;
                }
                case 440: {
                    this.settings.diamondSize = (int)entryValue;
                    break;
                }
                case 441: {
                    this.settings.diamondCount = (int)entryValue;
                    break;
                }
                case 442: {
                    this.settings.diamondMinHeight = (int)entryValue;
                    break;
                }
                case 443: {
                    this.settings.diamondMaxHeight = (int)entryValue;
                    break;
                }
                case 444: {
                    this.settings.lapisSize = (int)entryValue;
                    break;
                }
                case 445: {
                    this.settings.lapisCount = (int)entryValue;
                    break;
                }
                case 446: {
                    this.settings.lapisCenterHeight = (int)entryValue;
                    break;
                }
                case 447: {
                    this.settings.lapisSpread = (int)entryValue;
                    break;
                }
                case 448: {
                    this.settings.emeraldSize = (int)entryValue;
                    break;
                }
                case 449: {
                    this.settings.emeraldCount = (int)entryValue;
                    break;
                }
                case 450: {
                    this.settings.emeraldMinHeight = (int)entryValue;
                    break;
                }
                case 451: {
                    this.settings.emeraldMaxHeight = (int)entryValue;
                    break;
                }
                case 452: {
                    this.settings.quartzSize = (int)entryValue;
                    break;
                }
                case 453: {
                    this.settings.quartzCount = (int)entryValue;
                    break;
                }
                case 454: {
                    this.settings.magmaSize = (int)entryValue;
                    break;
                }
                case 455: {
                    this.settings.magmaCount = (int)entryValue;
                    break;
                }
                case 750: {
                    this.settings.snowLineOffset = (int)entryValue;
                }
            }
            if (entry >= 500 && entry <= 549 && (gui = this.pageList.func_178061_c(GuiIdentifiers.offsetForward(entry))) != null) {
                ((GuiTextField)gui).func_146180_a(this.getFormattedValue(entry, entryValue));
            }
            if ((entry == 204 || entry == 201 || entry == 100) && (gui = this.pageList.func_178061_c(150)) != null && gui instanceof GuiLabel) {
                int levelSeaLevel = this.getLevelSeaLevel();
                String levelSeaLevelStr = levelSeaLevel == -1 ? "" : Integer.toString(levelSeaLevel);
                ((GuiLabel)gui).field_146173_k.set(0, String.format("%s: %s", I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.seaLevel", (Object[])new Object[0]), levelSeaLevelStr));
            }
        }
        this.setGuiEnabled();
        this.setSettingsModified(!this.settings.equals(this.defaultSettings));
        this.playSound();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean leftKeyActive = this.pageList.func_178059_e() > 0;
        boolean rightKeyActive = this.pageList.func_178059_e() < this.pageList.func_178057_f() - 1;
        this.func_146276_q_();
        this.pageList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 6, 0xFFFFFF);
        this.drawKeyIcon("A", this.tabStartX - 14 - 4, 21, leftKeyActive, this.leftKeyBounds.isHovered());
        this.drawKeyIcon("D", this.tabEndX + 4, 21, rightKeyActive, this.rightKeyBounds.isHovered());
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.confirmMode != 0) {
            Gui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)Integer.MIN_VALUE);
            this.func_73730_a(this.field_146294_l / 2 - 91, this.field_146294_l / 2 + 90, 99, -2039584);
            this.func_73730_a(this.field_146294_l / 2 - 91, this.field_146294_l / 2 + 90, 185, -6250336);
            this.func_73728_b(this.field_146294_l / 2 - 91, 99, 185, -2039584);
            this.func_73728_b(this.field_146294_l / 2 + 90, 99, 185, -6250336);
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            this.field_146297_k.func_110434_K().func_110577_a(field_110325_k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferBuilder.func_181662_b((double)(this.field_146294_l / 2 - 90), 185.0, 0.0).func_187315_a(0.0, 2.65625).func_181669_b(64, 64, 64, 64).func_181675_d();
            bufferBuilder.func_181662_b((double)(this.field_146294_l / 2 + 90), 185.0, 0.0).func_187315_a(5.625, 2.65625).func_181669_b(64, 64, 64, 64).func_181675_d();
            bufferBuilder.func_181662_b((double)(this.field_146294_l / 2 + 90), 100.0, 0.0).func_187315_a(5.625, 0.0).func_181669_b(64, 64, 64, 64).func_181675_d();
            bufferBuilder.func_181662_b((double)(this.field_146294_l / 2 - 90), 100.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(64, 64, 64, 64).func_181675_d();
            tessellator.func_78381_a();
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.confirmTitle", (Object[])new Object[0]), this.field_146294_l / 2, 105, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.confirm1", (Object[])new Object[0]), this.field_146294_l / 2, 125, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.custom.modernbetaforge.confirm2", (Object[])new Object[0]), this.field_146294_l / 2, 135, 0xFFFFFF);
            this.buttonConfirm.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.buttonCancel.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
    }

    public ModernBetaGeneratorSettings.Factory getDefaultSettings() {
        return ModernBetaGeneratorSettings.Factory.jsonToFactory(this.defaultSettings.toString());
    }

    public String getSettingsString() {
        return this.settings.toString().replace("\n", "");
    }

    public void loadValues(String string) {
        this.settings = string != null && !string.isEmpty() ? ModernBetaGeneratorSettings.Factory.jsonToFactory(string) : new ModernBetaGeneratorSettings.Factory();
    }

    public void isSettingsModified() {
        this.setSettingsModified(!this.settings.equals(this.defaultSettings));
    }

    public void setSettingsModified(boolean settingsModified) {
        this.settingsModified = settingsModified;
        this.buttonDefaults.field_146124_l = settingsModified;
    }

    public void setPreviewSettings(GuiScreenCustomizePreview.PreviewSettings previewSettings) {
        this.previewSettings = previewSettings;
    }

    public void setWorldSeed(String seed) {
        this.parent.field_146329_I = seed;
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        if (!guiButton.field_146124_l) {
            return;
        }
        switch (guiButton.field_146127_k) {
            case 60: {
                this.parent.field_146334_a = this.settings.toString();
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                break;
            }
            case 61: {
                Set<Gui> biomeButtonComponents = this.getBiomeButtonComponents();
                Set<Gui> baseSliderComponents = this.getBaseSliderComponents();
                Set<Gui> baseButtonComponents = this.getBaseButtonComponents();
                for (int page = 0; page < this.pageList.func_148127_b(); ++page) {
                    this.randomClicked = true;
                    GuiPageButtonList.GuiEntry guiEntry = this.pageList.func_148180_b(page);
                    this.randomizeGuiComponent(guiEntry.func_178022_a(), biomeButtonComponents, baseSliderComponents, baseButtonComponents);
                    this.randomizeGuiComponent(guiEntry.func_178021_b(), biomeButtonComponents, baseSliderComponents, baseButtonComponents);
                    this.randomClicked = false;
                    this.setGuiEnabled();
                    this.setSettingsModified(!this.settings.equals(this.defaultSettings));
                }
                break;
            }
            case 62: {
                if (!this.settingsModified) break;
                this.enterConfirmation(62);
                break;
            }
            case 63: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizePresets(this));
                break;
            }
            case 64: {
                this.exitConfirmation();
                break;
            }
            case 65: {
                this.confirmMode = 0;
                this.exitConfirmation();
                break;
            }
            case 66: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizePreview(this, this.parent.field_146329_I, this.settings.build(), this.previewSettings));
            }
        }
        if (this.pageTabMap.containsKey(guiButton.field_146127_k)) {
            this.pageList.func_181156_c(guiButton.field_146127_k - 30);
            this.updatePageControls();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.confirmMode == 62 && keyCode == 1) {
            this.confirmMode = 0;
            this.exitConfirmation();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
        if (this.confirmMode != 0) {
            return;
        }
        boolean usedSpecialKey = false;
        switch (keyCode) {
            case 208: {
                this.modifyFocusValue(-1.0f);
                usedSpecialKey = true;
                break;
            }
            case 200: {
                this.modifyFocusValue(1.0f);
                usedSpecialKey = true;
                break;
            }
            case 30: {
                usedSpecialKey = this.modifyPageValue(System.currentTimeMillis() - this.lastNavPressed > 50L ? -1 : 0);
                this.lastNavPressed = System.currentTimeMillis();
                break;
            }
            case 32: {
                usedSpecialKey = this.modifyPageValue(System.currentTimeMillis() - this.lastNavPressed > 50L ? 1 : 0);
                this.lastNavPressed = System.currentTimeMillis();
            }
        }
        if (!usedSpecialKey) {
            this.pageList.func_178062_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.pageList.func_148179_a(mouseX, mouseY, mouseButton);
        if (this.leftKeyBounds.isHovered()) {
            this.modifyPageValue(-1);
        }
        if (this.rightKeyBounds.isHovered()) {
            this.modifyPageValue(1);
        }
        this.clicked = true;
        if (this.isMouseOverPageTab(mouseX, mouseY)) {
            this.tabClicked = true;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.confirmMode != 0 || this.confirmDismissed) {
            return;
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        this.pageList.func_148181_b(mouseX, mouseY, mouseButton);
        this.clicked = false;
        this.tabClicked = false;
        super.func_146286_b(mouseX, mouseY, mouseButton);
        if (this.confirmDismissed) {
            this.confirmDismissed = false;
            return;
        }
        if (this.confirmMode != 0) {
            return;
        }
    }

    protected void setPropertyText() {
        for (Map.Entry entry : this.propertyMap.entrySet()) {
            Property<?> property = this.settings.customProperties.get(entry.getValue());
            String formattedName = property.visitNameFormatter(new NameFormatterPropertyVisitor());
            if (formattedName == null || formattedName.isEmpty()) continue;
            this.setTextButton((Integer)entry.getKey(), formattedName);
        }
    }

    private GuiPageButtonList.GuiListEntry[] createCustomPropertyPage() {
        int numEntries = ModernBetaRegistries.PROPERTY.getKeys().size() * 2;
        LinkedHashMap modRegistryKeys = new LinkedHashMap();
        for (ResourceLocation registryKey : ModernBetaRegistries.PROPERTY.getKeys()) {
            if (!ModernBetaRegistries.PROPERTY.get(registryKey).getDisplay()) {
                numEntries -= 2;
                continue;
            }
            String namespace = registryKey.func_110624_b();
            if (!modRegistryKeys.containsKey(namespace)) {
                modRegistryKeys.put(namespace, new LinkedList());
                numEntries += 2;
                if (I18n.func_188566_a((String)(PREFIX_ADDON + namespace + ".info"))) {
                    numEntries += 2;
                }
            }
            if (I18n.func_188566_a((String)(PREFIX_ADDON + GuiScreenCustomizeWorld.getFormattedRegistryString(registryKey) + ".info"))) {
                numEntries += 2;
            }
            ((List)modRegistryKeys.get(namespace)).add(registryKey);
        }
        GuiPageButtonList.GuiListEntry[] pageList = new GuiPageButtonList.GuiListEntry[numEntries];
        int ndx = 0;
        for (String namespace : modRegistryKeys.keySet()) {
            List registryKeys = (List)modRegistryKeys.get(namespace);
            pageList[ndx++] = GuiScreenCustomizeWorld.createGuiLabelNoPrefix(this.customId++, 0xFFFFFF, I18n.func_135052_a((String)(PREFIX_ADDON + namespace), (Object[])new Object[0]));
            pageList[ndx++] = null;
            for (ResourceLocation registryKey : registryKeys) {
                int propertyId;
                Property<?> property = this.settings.customProperties.get(registryKey);
                String localizationKey = PREFIX_ADDON + GuiScreenCustomizeWorld.getFormattedRegistryString(registryKey);
                pageList[ndx++] = GuiScreenCustomizeWorld.createGuiLabelNoPrefix(this.customId++, I18n.func_135052_a((String)localizationKey, (Object[])new Object[0]) + ":");
                int n = ndx++;
                ++this.customId;
                pageList[n] = property.visitGui(new CreateGuiPropertyVisitor(), propertyId);
                if (I18n.func_188566_a((String)(localizationKey + ".info"))) {
                    pageList[ndx++] = GuiScreenCustomizeWorld.createGuiLabelNoPrefix(this.customId++, 0xA0A0A0, I18n.func_135052_a((String)(localizationKey + ".info"), (Object[])new Object[0]));
                    pageList[ndx++] = null;
                }
                this.propertyMap.put((Object)propertyId, (Object)registryKey);
            }
            if (!I18n.func_188566_a((String)(PREFIX_ADDON + namespace + ".info"))) continue;
            pageList[ndx++] = GuiScreenCustomizeWorld.createGuiLabelNoPrefix(this.customId++, 0xA0A0A0, I18n.func_135052_a((String)(PREFIX_ADDON + namespace + ".info"), (Object[])new Object[0]));
            pageList[ndx++] = null;
        }
        return pageList;
    }

    private void randomizeGuiComponent(Gui guiComponent, Set<Gui> biomeButtonComponents, Set<Gui> baseSliderComponents, Set<Gui> baseButtonComponents) {
        if (guiComponent instanceof GuiButton && ((GuiButton)guiComponent).field_146124_l) {
            GuiButton guiButtonComponent = (GuiButton)guiComponent;
            if (baseButtonComponents.contains(guiButtonComponent)) {
                int buttonId = GuiIdentifiers.BASE_SETTINGS.keySet().stream().filter(id -> this.pageList.func_178061_c(id.intValue()) == guiButtonComponent).findFirst().orElse(-1);
                if (guiButtonComponent instanceof GuiListButton && buttonId != -1) {
                    ResourceLocation randomKey = null;
                    String langName = null;
                    switch (buttonId) {
                        case 190: {
                            randomKey = ModernBetaRegistries.CHUNK_SOURCE.getRandomEntry(this.random).getKey();
                            langName = "chunkSource";
                            break;
                        }
                        case 191: {
                            randomKey = ModernBetaRegistries.BIOME_SOURCE.getRandomEntry(this.random).getKey();
                            langName = "biomeSource";
                            break;
                        }
                        case 192: {
                            randomKey = ModernBetaRegistries.SURFACE_BUILDER.getRandomEntry(this.random).getKey();
                            langName = "surfaceBuilder";
                            break;
                        }
                        case 193: {
                            randomKey = ModernBetaRegistries.CAVE_CARVER.getRandomEntry(this.random).getKey();
                            langName = "caveCarver";
                            break;
                        }
                        case 194: {
                            randomKey = ModernBetaRegistries.WORLD_SPAWNER.getRandomEntry(this.random).getKey();
                            langName = "worldSpawner";
                            break;
                        }
                        case 195: {
                            randomKey = ModernBetaRegistries.DEFAULT_BLOCK.getRandomEntry(this.random).getKey();
                            langName = "defaultBlock";
                            break;
                        }
                        case 196: {
                            randomKey = ForgeRegistryUtil.getRandomFluidRegistryName(this.random);
                            langName = "defaultFluid";
                        }
                    }
                    if (randomKey != null && langName != null) {
                        String registryName = randomKey.toString();
                        String formattedName = buttonId == 195 ? GuiScreenCustomizeWorld.getFormattedBlockName(registryName, langName, 10) : (buttonId == 196 ? GuiScreenCustomizeWorld.getFormattedFluidName(registryName, langName, 10) : GuiScreenCustomizeWorld.getFormattedRegistryName(registryName, langName, -1));
                        GuiIdentifiers.BASE_SETTINGS.get(buttonId).accept(registryName, this.settings);
                        this.setTextButton(buttonId, formattedName);
                    }
                }
            } else if (baseSliderComponents.contains(guiButtonComponent)) {
                if (guiButtonComponent instanceof GuiSlider) {
                    GuiSlider guiSlider = (GuiSlider)guiButtonComponent;
                    float randomPos = this.random.nextFloat() * 2.0f;
                    guiSlider.func_175219_a(MathHelper.func_76131_a((float)randomPos, (float)0.0f, (float)1.0f));
                }
            } else if (biomeButtonComponents.contains(guiButtonComponent)) {
                int buttonId = GuiIdentifiers.BIOME_SETTINGS.keySet().stream().filter(id -> this.pageList.func_178061_c(id.intValue()) == guiButtonComponent).findFirst().orElse(-1);
                if (guiButtonComponent instanceof GuiListButton && buttonId != -1) {
                    String registryName = ((Biome)ForgeRegistryUtil.getRandom(this.random, ForgeRegistries.BIOMES)).getRegistryName().toString();
                    String langName = buttonId == 105 ? "fixedBiome" : "";
                    int truncateLen = buttonId == 105 ? 18 : -1;
                    GuiIdentifiers.BIOME_SETTINGS.get(buttonId).accept(registryName, this.settings);
                    this.setTextButton(buttonId, GuiScreenCustomizeWorld.getFormattedBiomeName(registryName, langName, truncateLen));
                }
            } else if (guiButtonComponent instanceof GuiSlider) {
                GuiSlider guiSlider = (GuiSlider)guiButtonComponent;
                float randomFloat = guiSlider.func_175217_d() * (0.75f + this.random.nextFloat() * 0.5f) + (this.random.nextFloat() * 0.1f - 0.05f);
                guiSlider.func_175219_a(MathHelper.func_76131_a((float)randomFloat, (float)0.0f, (float)1.0f));
            } else if (guiButtonComponent instanceof GuiListButton) {
                ((GuiListButton)guiButtonComponent).func_175212_b(this.random.nextBoolean());
            }
        }
    }

    private String getFormattedValue(int entry, float entryValue) {
        if (this.propertyMap.containsKey((Object)entry)) {
            Property<?> property = this.settings.customProperties.get(this.propertyMap.get((Object)entry));
            if (property instanceof FloatProperty) {
                return String.format(((FloatProperty)property).getFormatter(), Float.valueOf(entryValue));
            }
            if (property instanceof IntProperty) {
                return String.format("%d", (int)entryValue);
            }
            if (property instanceof ListProperty) {
                ListProperty listProperty = (ListProperty)property;
                return listProperty.getValues()[(int)entryValue];
            }
        }
        switch (entry) {
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 507: 
            case 508: 
            case 510: 
            case 511: 
            case 524: 
            case 525: 
            case 600: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 607: 
            case 608: 
            case 610: 
            case 611: 
            case 624: 
            case 625: {
                return String.format("%5.3f", Float.valueOf(entryValue));
            }
            case 506: 
            case 509: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 520: 
            case 521: 
            case 522: 
            case 526: 
            case 527: 
            case 528: 
            case 606: 
            case 609: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 620: 
            case 621: 
            case 622: 
            case 626: 
            case 627: 
            case 628: {
                return String.format("%2.3f", Float.valueOf(entryValue));
            }
            case 130: 
            case 207: {
                return String.format("%2.1f", Float.valueOf(entryValue));
            }
            case 100: {
                ResourceLocation registryKey = ModernBetaRegistries.CHUNK_SOURCE.getKeys().get((int)entryValue);
                return I18n.func_135052_a((String)("createWorld.customize.custom.modernbetaforge.chunkSource." + GuiScreenCustomizeWorld.getFormattedRegistryString(registryKey)), (Object[])new Object[0]);
            }
            case 101: {
                ResourceLocation registryKey = ModernBetaRegistries.BIOME_SOURCE.getKeys().get((int)entryValue);
                return I18n.func_135052_a((String)("createWorld.customize.custom.modernbetaforge.biomeSource." + GuiScreenCustomizeWorld.getFormattedRegistryString(registryKey)), (Object[])new Object[0]);
            }
            case 102: {
                ResourceLocation registryKey = ModernBetaRegistries.SURFACE_BUILDER.getKeys().get((int)entryValue);
                return I18n.func_135052_a((String)("createWorld.customize.custom.modernbetaforge.surfaceBuilder." + GuiScreenCustomizeWorld.getFormattedRegistryString(registryKey)), (Object[])new Object[0]);
            }
            case 103: {
                ResourceLocation registryKey = ModernBetaRegistries.CAVE_CARVER.getKeys().get((int)entryValue);
                return I18n.func_135052_a((String)("createWorld.customize.custom.modernbetaforge.caveCarver." + GuiScreenCustomizeWorld.getFormattedRegistryString(registryKey)), (Object[])new Object[0]);
            }
            case 104: {
                ResourceLocation registryKey = ModernBetaRegistries.WORLD_SPAWNER.getKeys().get((int)entryValue);
                return I18n.func_135052_a((String)("createWorld.customize.custom.modernbetaforge.worldSpawner." + GuiScreenCustomizeWorld.getFormattedRegistryString(registryKey)), (Object[])new Object[0]);
            }
            case 134: {
                ResourceLocation registryKey = ModernBetaRegistries.DEFAULT_BLOCK.getKeys().get((int)entryValue);
                return ((Block)ForgeRegistries.BLOCKS.getValue(registryKey)).func_149732_F();
            }
            case 135: {
                ResourceLocation registryKey = ForgeRegistryUtil.getFluidBlockRegistryNames().get((int)entryValue);
                return ForgeRegistryUtil.getFluidLocalizedName(registryKey);
            }
            case 200: {
                String key = IndevTheme.values()[(int)entryValue].id;
                return I18n.func_135052_a((String)("createWorld.customize.custom.modernbetaforge.levelTheme." + key), (Object[])new Object[0]);
            }
            case 201: {
                String key = IndevType.values()[(int)entryValue].id;
                return I18n.func_135052_a((String)("createWorld.customize.custom.modernbetaforge.levelType." + key), (Object[])new Object[0]);
            }
            case 205: {
                String key = IndevHouse.values()[(int)entryValue].id;
                return I18n.func_135052_a((String)("createWorld.customize.custom.modernbetaforge.levelHouse." + key), (Object[])new Object[0]);
            }
            case 212: {
                String key = GenLayerType.values()[(int)entryValue].id;
                return I18n.func_135052_a((String)("createWorld.customize.custom.modernbetaforge.layerType." + key), (Object[])new Object[0]);
            }
            case 202: {
                return String.format("%d", ModernBetaGeneratorSettings.LEVEL_WIDTHS[(int)entryValue]);
            }
            case 203: {
                return String.format("%d", ModernBetaGeneratorSettings.LEVEL_WIDTHS[(int)entryValue]);
            }
            case 204: {
                return String.format("%d", ModernBetaGeneratorSettings.LEVEL_HEIGHTS[(int)entryValue]);
            }
        }
        return String.format("%d", (int)entryValue);
    }

    private void restoreDefaults() {
        String defaultPreset = ModernBetaConfig.guiOptions.defaultPreset;
        this.settings = ModernBetaGeneratorSettings.Factory.jsonToFactory(defaultPreset);
        this.createPagedList();
        this.setSettingsModified(false);
    }

    private void enterConfirmation(int id) {
        this.confirmMode = id;
        this.setConfirmationControls(true);
    }

    private void exitConfirmation() throws IOException {
        switch (this.confirmMode) {
            case 60: {
                this.func_146284_a((GuiButton)this.pageList.func_178061_c(60));
                break;
            }
            case 62: {
                this.restoreDefaults();
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizeWorld((GuiScreen)this.parent, this.settings.toString()));
            }
        }
        this.confirmMode = 0;
        this.confirmDismissed = true;
        this.setConfirmationControls(false);
    }

    private void setConfirmationControls(boolean setConfirm) {
        this.buttonConfirm.field_146125_m = setConfirm;
        this.buttonCancel.field_146125_m = setConfirm;
        this.buttonRandomize.field_146124_l = !setConfirm;
        this.buttonDone.field_146124_l = !setConfirm;
        this.buttonDefaults.field_146124_l = this.settingsModified && !setConfirm;
        this.buttonPresets.field_146124_l = !setConfirm;
        this.buttonPreview.field_146124_l = !setConfirm;
        this.pageList.func_181155_a(!setConfirm);
        for (Map.Entry<Integer, GuiButton> pageTab : this.pageTabMap.entrySet()) {
            pageTab.getValue().field_146124_l = !setConfirm;
        }
    }

    private void updatePageControls() {
        int page = this.pageList.func_178059_e();
        this.subtitle = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{page + 1, this.pageList.func_178057_f()});
        this.buttonRandomize.field_146124_l = page < 5 || page == 6;
        for (Map.Entry<Integer, GuiButton> pageTab : this.pageTabMap.entrySet()) {
            if (pageTab.getKey() == 30 + page) {
                pageTab.getValue().field_146124_l = false;
                continue;
            }
            pageTab.getValue().field_146124_l = true;
        }
    }

    private void modifyFocusValue(float amount) {
        Gui guiComponent = this.pageList.func_178056_g();
        if (!(guiComponent instanceof GuiTextField)) {
            return;
        }
        float increment = amount;
        if (GuiScreen.func_146272_n()) {
            increment *= 0.1f;
            if (GuiScreen.func_146271_m()) {
                increment *= 0.1f;
            }
        } else if (GuiScreen.func_146271_m()) {
            increment *= 10.0f;
            if (GuiScreen.func_175283_s()) {
                increment *= 10.0f;
            }
        }
        GuiTextField guiText = (GuiTextField)guiComponent;
        Float guiTextValue = Floats.tryParse((String)guiText.func_146179_b());
        int guiTextId = guiText.func_175206_d();
        if (guiTextValue == null || this.enabledMap.containsKey(guiTextId) && !this.enabledMap.get(guiTextId).booleanValue()) {
            return;
        }
        guiTextValue = Float.valueOf(guiTextValue.floatValue() + increment);
        String guiTextString = this.getFormattedValue(guiText.func_175206_d(), guiTextValue.floatValue());
        guiText.func_146180_a(guiTextString);
        this.func_175319_a(guiTextId, guiTextString);
    }

    private boolean modifyPageValue(int amount) {
        Gui guiComponent = this.pageList.func_178056_g();
        if (amount == 0 || guiComponent instanceof GuiTextField && ((GuiTextField)guiComponent).func_146206_l()) {
            return false;
        }
        int pageNext = this.pageList.func_178059_e() + amount;
        int pageCount = this.pageList.func_178057_f();
        if (pageNext >= 0 && pageNext < pageCount) {
            this.pageList.func_181156_c(pageNext);
            this.updatePageControls();
            this.playSound();
        }
        return true;
    }

    private void setTextButton(int id, String value) {
        Gui guiComponent = this.pageList.func_178061_c(id);
        if (guiComponent != null) {
            ((GuiButton)guiComponent).field_146126_j = value;
        }
    }

    private int getLevelSeaLevel() {
        ModernBetaGeneratorSettings settings = this.settings.build();
        ChunkSource chunkSource = ModernBetaRegistries.CHUNK_SOURCE.get(settings.chunkSource).apply(0L, settings);
        int levelSeaLevel = -1;
        if (chunkSource instanceof FiniteChunkSource) {
            levelSeaLevel = chunkSource.getSeaLevel();
        }
        return levelSeaLevel;
    }

    private void playSound() {
        if (!this.clicked && !this.randomClicked) {
            SoundUtil.playClickSound(this.field_146297_k.func_147118_V());
        }
    }

    private Set<Gui> getBaseSliderComponents() {
        HashSet<Gui> set = new HashSet<Gui>();
        set.add(this.pageList.func_178061_c(100));
        set.add(this.pageList.func_178061_c(101));
        set.add(this.pageList.func_178061_c(102));
        set.add(this.pageList.func_178061_c(103));
        set.add(this.pageList.func_178061_c(104));
        set.add(this.pageList.func_178061_c(134));
        set.add(this.pageList.func_178061_c(135));
        set.add(this.pageList.func_178061_c(200));
        set.add(this.pageList.func_178061_c(201));
        set.add(this.pageList.func_178061_c(205));
        set.add(this.pageList.func_178061_c(212));
        return set;
    }

    private Set<Gui> getBiomeButtonComponents() {
        return GuiIdentifiers.BIOME_SETTINGS.keySet().stream().map(id -> this.pageList.func_178061_c(id.intValue())).collect(Collectors.toSet());
    }

    private Set<Gui> getBaseButtonComponents() {
        return GuiIdentifiers.BASE_SETTINGS.keySet().stream().map(id -> this.pageList.func_178061_c(id.intValue())).collect(Collectors.toSet());
    }

    private void setGuiEnabled() {
        ModernBetaGeneratorSettings settings = this.settings.build();
        this.enabledMap.clear();
        if (this.pageList != null) {
            for (Map.Entry<ResourceLocation, GuiPredicate> entry : ModernBetaClientRegistries.GUI_PREDICATE.getEntrySet()) {
                int[] guiIds = entry.getValue().getIds();
                boolean enabled = entry.getValue().test(settings);
                for (int i = 0; i < guiIds.length; ++i) {
                    this.setButtonEnabled(guiIds[i], enabled);
                    this.setFieldEnabled(guiIds[i], enabled);
                    this.enabledMap.put(guiIds[i], enabled);
                }
                if (guiIds.length > 0 || !this.propertyMap.containsValue((Object)entry.getKey())) continue;
                int customId = (Integer)this.propertyMap.inverse().get((Object)entry.getKey());
                this.setButtonEnabled(customId, enabled);
                this.setFieldEnabled(customId, enabled);
                this.enabledMap.put(customId, enabled);
            }
        }
    }

    private void setButtonEnabled(int entry, boolean enabled) {
        Gui gui = this.pageList.func_178061_c(entry);
        if (gui != null && gui instanceof GuiButton) {
            ((GuiButton)gui).field_146124_l = enabled;
        }
    }

    private void setFieldEnabled(int entry, boolean enabled) {
        Gui gui = this.pageList.func_178061_c(entry);
        if (gui != null && gui instanceof GuiTextField) {
            ((GuiTextField)gui).func_146184_c(enabled);
        }
    }

    private boolean isMouseOverPageTab(int mouseX, int mouseY) {
        if (this.pageTabMap != null) {
            for (Map.Entry<Integer, GuiButton> pageTab : this.pageTabMap.entrySet()) {
                if (!pageTab.getValue().func_146115_a()) continue;
                return true;
            }
        }
        return false;
    }

    private void drawKeyIcon(String key, int x, int y, boolean active, boolean hovered) {
        int colorBack;
        int colorBorder = active ? ARGB_KEY_ICON_BORDER_ACTIVE : ARGB_KEY_ICON_BORDER_INACTIVE;
        int n = colorBack = active ? ARGB_KEY_ICON_BACK_ACTIVE : ARGB_KEY_ICON_BACK_INACTIVE;
        int colorText = active ? (hovered ? 13158500 : 0xC8C8C8) : 0x787878;
        this.func_73730_a(x, x + 14 - 1, y - 1, colorBorder);
        this.func_73730_a(x, x + 14 - 1, y + 14, colorBorder);
        this.func_73728_b(x - 1, y - 1, y + 14, colorBorder);
        this.func_73728_b(x + 14, y - 1, y + 14, colorBorder);
        GuiScreenCustomizeWorld.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 14 - 1), (int)(y + 14 - 1), (int)colorBack);
        this.func_73732_a(this.field_146289_q, key, x + 7, y + 3, colorText);
    }

    private void openBiomeScreen(BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer, String initial) {
        this.openBiomeScreen(consumer, initial, (Predicate<ResourceLocation>)((Predicate)key -> true));
    }

    private void openBiomeScreen(BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer, String initial, Predicate<ResourceLocation> predicate) {
        Function<ResourceLocation, String> nameFormatter = key -> ((Biome)ForgeRegistries.BIOMES.getValue(key)).func_185359_l();
        this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizeRegistry(this, consumer, nameFormatter, initial, "biome", ForgeRegistryUtil.getKeys(ForgeRegistries.BIOMES, predicate)));
    }

    private void openBlockScreen(BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer, String initial, Predicate<ResourceLocation> predicate) {
        this.openBlockScreen(consumer, initial, "block", predicate);
    }

    private void openBlockScreen(BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer, String initial, String nbtTag, Predicate<ResourceLocation> predicate) {
        Function<ResourceLocation, String> nameFormatter = key -> {
            Block block = (Block)ForgeRegistryUtil.get(key, ForgeRegistries.BLOCKS);
            return ForgeRegistryUtil.isForgeFluid(block) ? ForgeRegistryUtil.getFluidLocalizedName(key) : ((Block)ForgeRegistries.BLOCKS.getValue(key)).func_149732_F();
        };
        this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizeRegistry(this, consumer, nameFormatter, initial, nbtTag, ForgeRegistryUtil.getKeys(ForgeRegistries.BLOCKS, predicate)));
    }

    private void openFluidScreen(BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer, String initial, String nbtTag, Predicate<ResourceLocation> predicate) {
        Function<ResourceLocation, String> nameFormatter = key -> ForgeRegistryUtil.getFluidLocalizedName(key);
        this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizeRegistry(this, consumer, nameFormatter, initial, nbtTag, ForgeRegistryUtil.getFluidBlockRegistryNames()));
    }

    private void openEntityScreen(BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer, String initial, Predicate<ResourceLocation> predicate) {
        Function<ResourceLocation, String> nameFormatter = key -> ((EntityEntry)ForgeRegistries.ENTITIES.getValue(key)).getName();
        this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizeRegistry(this, consumer, nameFormatter, initial, "entity", ForgeRegistryUtil.getKeys(ForgeRegistries.ENTITIES, predicate)));
    }

    private void openRegistryScreen(BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer, String initial, String nbtTag, List<ResourceLocation> registryKeys) {
        Function<ResourceLocation, String> nameFormatter = key -> I18n.func_135052_a((String)String.format("%s%s.%s.%s", PREFIX, nbtTag, key.func_110624_b(), key.func_110623_a()), (Object[])new Object[0]);
        this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizeRegistry(this, consumer, nameFormatter, initial, nbtTag, registryKeys));
    }

    private static String getFormattedRegistryString(ResourceLocation registryKey) {
        return registryKey.func_110624_b() + "." + registryKey.func_110623_a();
    }

    private static GuiPageButtonList.GuiLabelEntry createGuiLabel(int id, String ... tags) {
        return new GuiPageButtonList.GuiLabelEntry(id, I18n.func_135052_a((String)(PREFIX_LABEL + String.join((CharSequence)".", tags)), (Object[])new Object[0]), true);
    }

    private static GuiPageButtonList.GuiLabelEntry createGuiLabel(int id, int color, String ... tags) {
        return new GuiColoredLabelEntry(id, I18n.func_135052_a((String)(PREFIX_LABEL + String.join((CharSequence)".", tags)), (Object[])new Object[0]), true, color);
    }

    private static GuiPageButtonList.GuiLabelEntry createGuiLabelNoPrefix(int id, String ... tags) {
        return new GuiPageButtonList.GuiLabelEntry(id, String.join((CharSequence)".", tags), true);
    }

    private static GuiPageButtonList.GuiLabelEntry createGuiLabelNoPrefix(int id, int color, String ... tags) {
        return new GuiColoredLabelEntry(id, String.join((CharSequence)".", tags), true, color);
    }

    private static GuiPageButtonList.GuiSlideEntry createGuiSlider(int id, String tag, float minValue, float maxValue, float initialValue, GuiSlider.FormatHelper formatHelper) {
        return new GuiPageButtonList.GuiSlideEntry(id, I18n.func_135052_a((String)(PREFIX + tag), (Object[])new Object[0]), true, formatHelper, minValue, maxValue, initialValue);
    }

    private static GuiPageButtonList.GuiSlideEntry createGuiSliderNoLabel(int id, float minValue, float maxValue, float initialValue, GuiSlider.FormatHelper formatHelper, Set<Integer> unlabeledSliders) {
        unlabeledSliders.add(id);
        return new GuiPageButtonList.GuiSlideEntry(id, "", true, formatHelper, minValue, maxValue, initialValue);
    }

    private static GuiPageButtonList.GuiButtonEntry createGuiButton(int id, String tag, boolean initialValue) {
        return new GuiPageButtonList.GuiButtonEntry(id, I18n.func_135052_a((String)(PREFIX + tag), (Object[])new Object[0]), true, initialValue);
    }

    private static GuiPageButtonList.EditBoxEntry createGuiField(int id, String formattedValue, Predicate<String> predicate) {
        return new GuiPageButtonList.EditBoxEntry(id, formattedValue, true, predicate);
    }

    private static String getFormattedRegistryName(String registryName, String langName, int truncateLen) {
        ResourceLocation registryKey = new ResourceLocation(registryName);
        String formattedName = I18n.func_135052_a((String)String.format("%s%s.%s.%s", PREFIX, langName, registryKey.func_110624_b(), registryKey.func_110623_a()), (Object[])new Object[0]);
        if (truncateLen > 0 && formattedName.length() > truncateLen) {
            formattedName = formattedName.substring(0, truncateLen) + "...";
        }
        return String.format("%s: %s", I18n.func_135052_a((String)(PREFIX + langName), (Object[])new Object[0]), formattedName);
    }

    private static String getFormattedBiomeName(String registryName) {
        return GuiScreenCustomizeWorld.getFormattedBiomeName(registryName, "", -1);
    }

    private static String getFormattedBiomeName(String registryName, String langName, int truncateLen) {
        return GuiScreenCustomizeWorld.getFormattedForgeRegistryName(registryName, langName, truncateLen, key -> ((Biome)ForgeRegistryUtil.get(new ResourceLocation(key), ForgeRegistries.BIOMES)).func_185359_l());
    }

    private static String getFormattedBlockName(String registryName, String langName, int truncateLen) {
        return GuiScreenCustomizeWorld.getFormattedForgeRegistryName(registryName, langName, truncateLen, key -> ((Block)ForgeRegistryUtil.get(new ResourceLocation(key), ForgeRegistries.BLOCKS)).func_149732_F());
    }

    private static String getFormattedFluidName(String registryName, String langName, int truncateLen) {
        return GuiScreenCustomizeWorld.getFormattedForgeRegistryName(registryName, langName, truncateLen, key -> ForgeRegistryUtil.getFluidLocalizedName(new ResourceLocation(key)));
    }

    private static String getFormattedForgeRegistryName(String registryName, String langName, int truncateLen, Function<String, String> nameFormatter) {
        String formattedName = nameFormatter.apply(registryName);
        if (truncateLen > 0 && formattedName.length() > truncateLen) {
            formattedName = formattedName.substring(0, truncateLen) + "...";
        }
        return !langName.isEmpty() ? String.format("%s: %s", I18n.func_135052_a((String)(PREFIX + langName), (Object[])new Object[0]), formattedName) : formattedName;
    }

    private static int getNdx(int[] arr, int val) {
        for (int i = 0; i < arr.length; ++i) {
            if (val != arr[i]) continue;
            return i;
        }
        return 0;
    }

    private static float roundToThreeDec(float entryValue) {
        BigDecimal bigDecimal = new BigDecimal(entryValue);
        bigDecimal = bigDecimal.setScale(3, RoundingMode.HALF_UP);
        return bigDecimal.floatValue();
    }

    private static float roundToOneDec(float entryValue) {
        BigDecimal bigDecimal = new BigDecimal(entryValue);
        bigDecimal = bigDecimal.setScale(1, RoundingMode.HALF_UP);
        return bigDecimal.floatValue();
    }

    private class NameFormatterPropertyVisitor
    implements PropertyVisitor {
        private NameFormatterPropertyVisitor() {
        }

        @Override
        public String visit(BooleanProperty property) {
            return I18n.func_135052_a((String)((Boolean)property.getValue() != false ? "gui.yes" : "gui.no"), (Object[])new Object[0]);
        }

        @Override
        public String visit(FloatProperty property) {
            return null;
        }

        @Override
        public String visit(IntProperty property) {
            return null;
        }

        @Override
        public String visit(StringProperty property) {
            return null;
        }

        @Override
        public String visit(ListProperty property) {
            return null;
        }

        @Override
        public String visit(BiomeProperty property) {
            return GuiScreenCustomizeWorld.getFormattedBiomeName((String)property.getValue());
        }

        @Override
        public String visit(BlockProperty property) {
            ResourceLocation registryKey = new ResourceLocation((String)property.getValue());
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(registryKey);
            Function<String, String> nameFormatter = key -> ForgeRegistryUtil.isForgeFluid(block) ? ForgeRegistryUtil.getFluidLocalizedName(new ResourceLocation(key)) : ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key))).func_149732_F();
            return GuiScreenCustomizeWorld.getFormattedForgeRegistryName((String)property.getValue(), "", 20, nameFormatter);
        }

        @Override
        public String visit(EntityEntryProperty property) {
            Function<String, String> nameFormatter = key -> ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(key))).getName();
            return GuiScreenCustomizeWorld.getFormattedForgeRegistryName((String)property.getValue(), "", 20, nameFormatter);
        }
    }

    private class SetEntryValuePropertyVisitor
    implements EntryValuePropertyVisitor {
        private SetEntryValuePropertyVisitor() {
        }

        @Override
        public void visit(BooleanProperty property, int guiIdentifier, boolean value, ResourceLocation registryKey) {
            property.setValue(value);
            GuiScreenCustomizeWorld.this.setTextButton(guiIdentifier, I18n.func_135052_a((String)((Boolean)property.getValue() != false ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
        }

        @Override
        public void visit(FloatProperty property, int guiIdentifier, Object value, ResourceLocation registryKey) {
            if (property.getGuiType() == PropertyGuiType.FIELD) {
                String entryString = (String)value;
                float entryValue = 0.0f;
                float newEntryValue = 0.0f;
                try {
                    entryValue = Float.parseFloat(entryString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                property.setValue(Float.valueOf(entryValue));
                newEntryValue = ((Float)property.getValue()).floatValue();
                if (newEntryValue != entryValue) {
                    ((GuiTextField)GuiScreenCustomizeWorld.this.pageList.func_178061_c(guiIdentifier)).func_146180_a(GuiScreenCustomizeWorld.this.getFormattedValue(guiIdentifier, newEntryValue));
                }
            } else if (property.getGuiType() == PropertyGuiType.SLIDER) {
                property.setValue((Float)value);
            }
        }

        @Override
        public void visit(IntProperty property, int guiIdentifier, Object value, ResourceLocation registryKey) {
            if (property.getGuiType() == PropertyGuiType.FIELD) {
                String entryString = (String)value;
                float entryValue = 0.0f;
                float newEntryValue = 0.0f;
                try {
                    entryValue = Float.parseFloat(entryString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                property.setValue((int)entryValue);
                newEntryValue = ((Integer)property.getValue()).intValue();
                if (newEntryValue != entryValue) {
                    ((GuiTextField)GuiScreenCustomizeWorld.this.pageList.func_178061_c(guiIdentifier)).func_146180_a(GuiScreenCustomizeWorld.this.getFormattedValue(guiIdentifier, newEntryValue));
                }
            } else if (property.getGuiType() == PropertyGuiType.SLIDER) {
                property.setValue(((Float)value).intValue());
            }
        }

        @Override
        public void visit(StringProperty property, int guiIdentifier, String value, ResourceLocation registryKey) {
            property.setValue(value);
        }

        @Override
        public void visit(ListProperty property, int guiIdentifier, float value, ResourceLocation registryKey) {
            property.setValue(property.getValues()[(int)value]);
        }

        @Override
        public void visit(BiomeProperty property, int guiIdentifier, ResourceLocation registryKey) {
            GuiScreenCustomizeWorld.this.openBiomeScreen((str, factory) -> ((BiomeProperty)factory.customProperties.get(registryKey)).setValue(str), (String)property.getValue(), (Predicate<ResourceLocation>)property.getFilter()::test);
        }

        @Override
        public void visit(BlockProperty property, int guiIdentifier, ResourceLocation registryKey) {
            GuiScreenCustomizeWorld.this.openBlockScreen((str, factory) -> ((BlockProperty)factory.customProperties.get(registryKey)).setValue(str), (String)property.getValue(), (Predicate<ResourceLocation>)property.getFilter()::test);
        }

        @Override
        public void visit(EntityEntryProperty property, int guiIdentifier, ResourceLocation registryKey) {
            GuiScreenCustomizeWorld.this.openEntityScreen((str, factory) -> ((EntityEntryProperty)factory.customProperties.get(registryKey)).setValue(str), (String)property.getValue(), (Predicate<ResourceLocation>)property.getFilter()::test);
        }
    }

    private class CreateGuiPropertyVisitor
    implements GuiPropertyVisitor {
        private CreateGuiPropertyVisitor() {
        }

        @Override
        public GuiPageButtonList.GuiListEntry visit(BooleanProperty property, int guiIdentifier) {
            return GuiScreenCustomizeWorld.createGuiButton(guiIdentifier, "enabled", (Boolean)property.getValue());
        }

        @Override
        public GuiPageButtonList.GuiListEntry visit(FloatProperty property, int guiIdentifier) {
            String formattedValue = String.format(property.getFormatter(), property.getValue());
            switch (property.getGuiType()) {
                case FIELD: {
                    return GuiScreenCustomizeWorld.createGuiField(guiIdentifier, formattedValue, (Predicate<String>)property.getStringPredicate());
                }
                case SLIDER: {
                    return GuiScreenCustomizeWorld.createGuiSlider(guiIdentifier, "entry", ((Float)property.getMinValue()).floatValue(), ((Float)property.getMaxValue()).floatValue(), ((Float)property.getValue()).floatValue(), GuiScreenCustomizeWorld.this);
                }
            }
            return GuiScreenCustomizeWorld.createGuiField(guiIdentifier, formattedValue, (Predicate<String>)property.getStringPredicate());
        }

        @Override
        public GuiPageButtonList.GuiListEntry visit(IntProperty property, int guiIdentifier) {
            String formattedValue = String.format(property.getFormatter(), property.getValue());
            switch (property.getGuiType()) {
                case FIELD: {
                    return GuiScreenCustomizeWorld.createGuiField(guiIdentifier, formattedValue, (Predicate<String>)property.getStringPredicate());
                }
                case SLIDER: {
                    return GuiScreenCustomizeWorld.createGuiSlider(guiIdentifier, "entry", ((Integer)property.getMinValue()).intValue(), ((Integer)property.getMaxValue()).intValue(), ((Integer)property.getValue()).intValue(), GuiScreenCustomizeWorld.this);
                }
            }
            return GuiScreenCustomizeWorld.createGuiField(guiIdentifier, formattedValue, (Predicate<String>)property.getStringPredicate());
        }

        @Override
        public GuiPageButtonList.GuiListEntry visit(StringProperty property, int guiIdentifier) {
            return GuiScreenCustomizeWorld.createGuiField(guiIdentifier, (String)property.getValue(), (Predicate<String>)string -> true);
        }

        @Override
        public GuiPageButtonList.GuiListEntry visit(ListProperty property, int guiIdentifier) {
            int listNdx = property.indexOf((String)property.getValue());
            if (listNdx == -1) {
                listNdx = 0;
            }
            return GuiScreenCustomizeWorld.createGuiSlider(guiIdentifier, "entry", 0.0f, property.getValues().length - 1, listNdx, GuiScreenCustomizeWorld.this);
        }

        @Override
        public GuiPageButtonList.GuiListEntry visit(BiomeProperty property, int guiIdentifier) {
            return GuiScreenCustomizeWorld.createGuiButton(guiIdentifier, "enabled", true);
        }

        @Override
        public GuiPageButtonList.GuiListEntry visit(BlockProperty property, int guiIdentifier) {
            return GuiScreenCustomizeWorld.createGuiButton(guiIdentifier, "enabled", true);
        }

        @Override
        public GuiPageButtonList.GuiListEntry visit(EntityEntryProperty property, int guiIdentifier) {
            return GuiScreenCustomizeWorld.createGuiButton(guiIdentifier, "enabled", true);
        }
    }
}

