/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.bespectacled.modernbetaforge.ModernBeta;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public class ForgeRegistryUtil<T> {
    public static <T> T get(ResourceLocation registryKey, IForgeRegistry<? extends T> registry) {
        IForgeRegistryEntry t = registry.getValue(registryKey);
        if (t == null) {
            String errorStr = String.format("[Modern Beta] Forge registry entry '%s' does not exist!", registryKey.toString());
            throw new IllegalArgumentException(errorStr);
        }
        return (T)t;
    }

    public static <T> T getOrElse(ResourceLocation registryKey, ResourceLocation alternateKey, IForgeRegistry<? extends T> registry) {
        Object t = registry.getValue(registryKey);
        if (t == null) {
            String warning = String.format("Did not find key '%s' for registry '%s', getting alternate entry.", registryKey.toString(), registry.getRegistrySuperType());
            ModernBeta.log(Level.WARN, warning);
            t = ForgeRegistryUtil.get(alternateKey, registry);
        }
        return (T)t;
    }

    public static <T> T getRandom(Random random, IForgeRegistry<? extends T> registry) {
        ArrayList entries = new ArrayList(registry.getValuesCollection());
        return (T)entries.get(random.nextInt(entries.size()));
    }

    public static <T> ResourceLocation validateOrElse(ResourceLocation registryKey, ResourceLocation alternateKey, IForgeRegistry<? extends T> registry) {
        IForgeRegistryEntry t = registry.getValue(registryKey);
        if (t == null) {
            String warning = String.format("Did not find key '%s' for registry '%s', returning alternate key.", registryKey.toString(), registry.getRegistrySuperType());
            ModernBeta.log(Level.WARN, warning);
            return alternateKey;
        }
        return registryKey;
    }

    public static <T> List<ResourceLocation> getKeys(IForgeRegistry<? extends T> registry, com.google.common.base.Predicate<ResourceLocation> filter) {
        return registry.getEntries().stream().map(e -> (ResourceLocation)e.getKey()).filter((Predicate<ResourceLocation>)filter).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> List<ResourceLocation> getKeys(IForgeRegistry<? extends T> registry) {
        return ForgeRegistryUtil.getKeys(registry, (com.google.common.base.Predicate<ResourceLocation>)((com.google.common.base.Predicate)e -> true));
    }

    public static <T> List<T> getValues(IForgeRegistry<? extends T> registry, com.google.common.base.Predicate<T> filter) {
        return registry.getValues().stream().filter(filter).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> List<T> getValues(IForgeRegistry<? extends T> registry) {
        return ForgeRegistryUtil.getValues(registry, e -> true);
    }

    public static Fluid getFluid(ResourceLocation registryKey) {
        return FluidRegistry.getRegisteredFluids().values().stream().filter(f -> f.getBlock() != null && registryKey.equals((Object)f.getBlock().getRegistryName())).findFirst().orElse(FluidRegistry.WATER);
    }

    public static List<ResourceLocation> getFluidBlockRegistryNames() {
        return FluidRegistry.getRegisteredFluids().values().stream().filter(f -> f.getBlock() != null).map(f -> f.getBlock().getRegistryName()).collect(Collectors.toCollection(ArrayList::new));
    }

    public static String getFluidLocalizedName(ResourceLocation registryKey) {
        Optional<Fluid> fluid = FluidRegistry.getRegisteredFluids().values().stream().filter(f -> f.getBlock() != null && registryKey.equals((Object)f.getBlock().getRegistryName())).findFirst();
        if (fluid.isPresent()) {
            return fluid.get().getLocalizedName(new FluidStack(fluid.get(), 0));
        }
        return "Unknown Fluid";
    }

    public static boolean isForgeFluid(Block block) {
        return FluidRegistry.getRegisteredFluids().values().stream().filter(f -> f.getBlock() != null).anyMatch(f -> f.getBlock() == block);
    }

    public static ResourceLocation getRandomFluidRegistryName(Random random) {
        ArrayList<ResourceLocation> entries = new ArrayList<ResourceLocation>(ForgeRegistryUtil.getFluidBlockRegistryNames());
        return (ResourceLocation)entries.get(random.nextInt(entries.size()));
    }
}

