/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.util.noise;

import java.util.Random;

public class SimplexNoise {
    private static int[][] gradients = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}};
    private int[] permutations = new int[512];
    public double xOrigin;
    public double yOrigin;
    public double zOrigin;
    private static final double UNSKEW_FACTOR_2D;
    private static final double SKEW_FACTOR_2D;

    public SimplexNoise() {
        this(new Random());
    }

    public SimplexNoise(Random random) {
        int i;
        this.xOrigin = random.nextDouble() * 256.0;
        this.yOrigin = random.nextDouble() * 256.0;
        this.zOrigin = random.nextDouble() * 256.0;
        for (i = 0; i < 256; ++i) {
            this.permutations[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int permNdx = random.nextInt(256 - i) + i;
            int perm = this.permutations[i];
            this.permutations[i] = this.permutations[permNdx];
            this.permutations[permNdx] = perm;
            this.permutations[i + 256] = this.permutations[i];
        }
    }

    private static int fastFloor(double double1) {
        return double1 > 0.0 ? (int)double1 : (int)double1 - 1;
    }

    private static double dot(int[] arr, double double2, double double4) {
        return (double)arr[0] * double2 + (double)arr[1] * double4;
    }

    public void sample(double[] arr, double x, double y, int sizeX, int sizeY, double scaleX, double scaleY, double amplitude) {
        int ndx = 0;
        for (int sX = 0; sX < sizeX; ++sX) {
            double curX = (x + (double)sX) * scaleX + this.xOrigin;
            for (int sY = 0; sY < sizeY; ++sY) {
                int curNdx;
                double contrib2;
                double contrib1;
                double contrib0;
                int offsetJ;
                int offsetI;
                double y0;
                double yDist;
                int j;
                double t;
                double curY = (y + (double)sY) * scaleY + this.yOrigin;
                double s = (curX + curY) * SKEW_FACTOR_2D;
                int i = SimplexNoise.fastFloor(curX + s);
                double x0 = (double)i - (t = (double)(i + (j = SimplexNoise.fastFloor(curY + s))) * UNSKEW_FACTOR_2D);
                double xDist = curX - x0;
                if (xDist > (yDist = curY - (y0 = (double)j - t))) {
                    offsetI = 1;
                    offsetJ = 0;
                } else {
                    offsetI = 0;
                    offsetJ = 1;
                }
                double offsetMidX = xDist - (double)offsetI + UNSKEW_FACTOR_2D;
                double offsetMidY = yDist - (double)offsetJ + UNSKEW_FACTOR_2D;
                double offsetLastX = xDist - 1.0 + 2.0 * UNSKEW_FACTOR_2D;
                double offsetLastY = yDist - 1.0 + 2.0 * UNSKEW_FACTOR_2D;
                int hash0 = i & 0xFF;
                int hash1 = j & 0xFF;
                int gradNdx0 = this.permutations[hash0 + this.permutations[hash1]] % 12;
                int gradNdx1 = this.permutations[hash0 + offsetI + this.permutations[hash1 + offsetJ]] % 12;
                int gradNdx2 = this.permutations[hash0 + 1 + this.permutations[hash1 + 1]] % 12;
                double t0 = 0.5 - xDist * xDist - yDist * yDist;
                if (t0 < 0.0) {
                    contrib0 = 0.0;
                } else {
                    t0 *= t0;
                    contrib0 = t0 * t0 * SimplexNoise.dot(gradients[gradNdx0], xDist, yDist);
                }
                double t1 = 0.5 - offsetMidX * offsetMidX - offsetMidY * offsetMidY;
                if (t1 < 0.0) {
                    contrib1 = 0.0;
                } else {
                    t1 *= t1;
                    contrib1 = t1 * t1 * SimplexNoise.dot(gradients[gradNdx1], offsetMidX, offsetMidY);
                }
                double t2 = 0.5 - offsetLastX * offsetLastX - offsetLastY * offsetLastY;
                if (t2 < 0.0) {
                    contrib2 = 0.0;
                } else {
                    t2 *= t2;
                    contrib2 = t2 * t2 * SimplexNoise.dot(gradients[gradNdx2], offsetLastX, offsetLastY);
                }
                int n = curNdx = ndx++;
                arr[n] = arr[n] + 70.0 * (contrib0 + contrib1 + contrib2) * amplitude;
            }
        }
    }

    public double sample(double x, double y, double scaleX, double scaleY) {
        double contrib2;
        double contrib1;
        double contrib0;
        int offsetJ;
        int offsetI;
        double y0;
        double yDist;
        int j;
        double t;
        double s = (x + (y = y * scaleY + this.yOrigin)) * SKEW_FACTOR_2D;
        int i = SimplexNoise.fastFloor(x + s);
        double x0 = (double)i - (t = (double)(i + (j = SimplexNoise.fastFloor(y + s))) * UNSKEW_FACTOR_2D);
        double xDist = (x = x * scaleX + this.xOrigin) - x0;
        if (xDist > (yDist = y - (y0 = (double)j - t))) {
            offsetI = 1;
            offsetJ = 0;
        } else {
            offsetI = 0;
            offsetJ = 1;
        }
        double offsetMidX = xDist - (double)offsetI + UNSKEW_FACTOR_2D;
        double offsetMidY = yDist - (double)offsetJ + UNSKEW_FACTOR_2D;
        double offsetLastX = xDist - 1.0 + 2.0 * UNSKEW_FACTOR_2D;
        double offsetLastY = yDist - 1.0 + 2.0 * UNSKEW_FACTOR_2D;
        int hash0 = i & 0xFF;
        int hash1 = j & 0xFF;
        int gradNdx0 = this.permutations[hash0 + this.permutations[hash1]] % 12;
        int gradNdx1 = this.permutations[hash0 + offsetI + this.permutations[hash1 + offsetJ]] % 12;
        int gradNdx2 = this.permutations[hash0 + 1 + this.permutations[hash1 + 1]] % 12;
        double t0 = 0.5 - xDist * xDist - yDist * yDist;
        if (t0 < 0.0) {
            contrib0 = 0.0;
        } else {
            t0 *= t0;
            contrib0 = t0 * t0 * SimplexNoise.dot(gradients[gradNdx0], xDist, yDist);
        }
        double t1 = 0.5 - offsetMidX * offsetMidX - offsetMidY * offsetMidY;
        if (t1 < 0.0) {
            contrib1 = 0.0;
        } else {
            t1 *= t1;
            contrib1 = t1 * t1 * SimplexNoise.dot(gradients[gradNdx1], offsetMidX, offsetMidY);
        }
        double t2 = 0.5 - offsetLastX * offsetLastX - offsetLastY * offsetLastY;
        if (t2 < 0.0) {
            contrib2 = 0.0;
        } else {
            t2 *= t2;
            contrib2 = t2 * t2 * SimplexNoise.dot(gradients[gradNdx2], offsetLastX, offsetLastY);
        }
        return 70.0 * (contrib0 + contrib1 + contrib2);
    }

    static {
        SKEW_FACTOR_2D = 0.5 * (Math.sqrt(3.0) - 1.0);
        UNSKEW_FACTOR_2D = (3.0 - Math.sqrt(3.0)) / 6.0;
    }
}

