/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.elementalWeather;

import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jufyer.plugin.elementalWeather.config.PluginConfig;
import org.jufyer.plugin.elementalWeather.language.LanguageManager;
import org.jufyer.plugin.elementalWeather.listeners.PlayerEffectsListener;
import org.jufyer.plugin.elementalWeather.listeners.RainGrowthSlowListener;
import org.jufyer.plugin.elementalWeather.listeners.SunGrowthBoostListener;
import org.jufyer.plugin.elementalWeather.listeners.WeatherChangeListener;
import org.jufyer.plugin.elementalWeather.scoreboard.WeatherEffectScoreboard;
import org.jufyer.plugin.elementalWeather.weather.RainEffect;
import org.jufyer.plugin.elementalWeather.weather.SunEffect;
import org.jufyer.plugin.elementalWeather.weather.ThunderstormEffect;

public final class Main
extends JavaPlugin {
    private static Main instance;
    private static LanguageManager languageManager;

    public static Main getInstance() {
        return instance;
    }

    public static LanguageManager getLanguageManager() {
        return languageManager;
    }

    public void onEnable() {
        instance = this;
        new PluginConfig(this);
        languageManager = new LanguageManager(this, "en_us");
        new WeatherEffectScoreboard(languageManager);
        SunEffect sunEffect = new SunEffect(languageManager);
        RainEffect rainEffect = new RainEffect(languageManager);
        ThunderstormEffect thunderstormEffect = new ThunderstormEffect(languageManager);
        Bukkit.getPluginManager().registerEvents((Listener)new WeatherChangeListener(sunEffect, rainEffect, thunderstormEffect), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerEffectsListener(languageManager, sunEffect, sunEffect, rainEffect, rainEffect, thunderstormEffect, thunderstormEffect), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SunGrowthBoostListener(sunEffect), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new RainGrowthSlowListener(rainEffect), (Plugin)this);
        this.getLogger().info("ElementalWeather has been enabled.");
    }

    public void onDisable() {
        this.getLogger().info("ElementalWeather has been disabled.");
    }
}

