/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.elementalWeather.language;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class LanguageManager {
    private final JavaPlugin plugin;
    private final Map<String, JSONObject> languages = new HashMap<String, JSONObject>();
    private final String defaultLang;

    public LanguageManager(JavaPlugin plugin, String defaultLang) {
        this.plugin = plugin;
        this.defaultLang = defaultLang;
        this.loadLang("en_us");
    }

    private void loadLang(String code) {
        try (InputStreamReader reader = new InputStreamReader(this.plugin.getResource("lang/" + code + ".json"), StandardCharsets.UTF_8);){
            JSONObject obj = (JSONObject)new JSONParser().parse((Reader)reader);
            this.languages.put(code, obj);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load language file: " + code, e);
        }
    }

    public String get(String langCode, String key) {
        JSONObject lang = this.languages.getOrDefault(langCode, this.languages.get(this.defaultLang));
        Object value = lang.getOrDefault((Object)key, (Object)key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)String.valueOf(value));
    }

    public String get(Player player, String key) {
        String code = player.getLocale();
        return this.get(code, key);
    }
}

