/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.elementalWeather.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.jufyer.plugin.elementalWeather.Main;
import org.jufyer.plugin.elementalWeather.scoreboard.WeatherEffectScoreboard;
import org.jufyer.plugin.elementalWeather.weather.WeatherEffect;

public class WeatherChangeListener
implements Listener {
    private final Map<UUID, WeatherEffect> activeEffects = new HashMap<UUID, WeatherEffect>();
    private final WeatherEffect sunEffect;
    private final WeatherEffect rainEffect;
    private final WeatherEffect thunderstormEffect;
    WeatherEffectScoreboard scoreboard = new WeatherEffectScoreboard(Main.getLanguageManager());

    public WeatherChangeListener(WeatherEffect sunEffect, WeatherEffect rainEffect, WeatherEffect thunderstormEffect) {
        this.sunEffect = sunEffect;
        this.rainEffect = rainEffect;
        this.thunderstormEffect = thunderstormEffect;
    }

    @EventHandler
    public void onWeatherChange(WeatherChangeEvent event) {
        World world = event.getWorld();
        UUID worldId = world.getUID();
        if (this.activeEffects.containsKey(worldId)) {
            this.activeEffects.get(worldId).stop(world);
            this.activeEffects.remove(worldId);
        }
        if (!event.toWeatherState()) {
            this.sunEffect.apply(world);
            this.rainEffect.stop(world);
            this.thunderstormEffect.stop(world);
            this.activeEffects.put(worldId, this.sunEffect);
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.scoreboard.update(player, "sun", 2);
            }
        } else {
            this.rainEffect.apply(world);
            this.sunEffect.stop(world);
            this.thunderstormEffect.stop(world);
            this.activeEffects.put(worldId, this.rainEffect);
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.scoreboard.update(player, "rain", 2);
            }
        }
    }

    @EventHandler
    public void onThunderChange(ThunderChangeEvent event) {
        World world = event.getWorld();
        UUID worldId = world.getUID();
        if (this.activeEffects.containsKey(worldId)) {
            this.activeEffects.get(worldId).stop(world);
            this.activeEffects.remove(worldId);
        }
        if (event.toThunderState()) {
            this.thunderstormEffect.apply(world);
            this.rainEffect.stop(world);
            this.sunEffect.stop(world);
            this.activeEffects.put(worldId, this.thunderstormEffect);
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.scoreboard.update(player, "storm", 2);
            }
        }
    }
}

