/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.elementalWeather.scoreboard;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.jufyer.plugin.elementalWeather.language.LanguageManager;

public class WeatherEffectScoreboard {
    private final LanguageManager languageManager;

    public WeatherEffectScoreboard(LanguageManager languageManager) {
        this.languageManager = languageManager;
    }

    public void update(Player player, String effectKey, Integer descLength) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager == null) {
            Bukkit.getLogger().severe("ScoreboardManager ist nicht verf\u00fcgbar!");
            return;
        }
        Scoreboard scoreboard = manager.getNewScoreboard();
        Objective objective = scoreboard.registerNewObjective("weatherEffect", "dummy", this.languageManager.get(player, "scoreboard_title"));
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        String effectLabel = this.languageManager.get(player, "scoreboard_effect_label");
        String effectName = this.languageManager.get(player, "scoreboard_effect_" + effectKey);
        objective.getScore(effectLabel).setScore(descLength + 2);
        objective.getScore(effectName).setScore(descLength + 1);
        for (int i = descLength.intValue(); i > 0; --i) {
            String effectDesc = this.languageManager.get(player, "scoreboard_desc_" + effectKey + i);
            objective.getScore(effectDesc).setScore(i);
        }
        player.setScoreboard(scoreboard);
    }
}

