/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.elementalWeather.weather;

import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jufyer.plugin.elementalWeather.language.LanguageManager;
import org.jufyer.plugin.elementalWeather.weather.WeatherEffect;

public class RainEffect
implements WeatherEffect {
    private final LanguageManager languageManager;
    private boolean active = false;

    public RainEffect(LanguageManager languageManager) {
        this.languageManager = languageManager;
    }

    @Override
    public void apply(World world) {
        this.active = true;
        for (Player player : world.getPlayers()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 200, 0));
            String msg = this.languageManager.get(player, "rain_cooldown");
            player.sendActionBar(msg);
        }
    }

    @Override
    public void stop(World world) {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }
}

