/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.elementalWeather.weather;

import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jufyer.plugin.elementalWeather.language.LanguageManager;
import org.jufyer.plugin.elementalWeather.weather.WeatherEffect;

public class SunEffect
implements WeatherEffect,
Listener {
    private final LanguageManager languageManager;
    private boolean active = false;

    public SunEffect(LanguageManager languageManager) {
        this.languageManager = languageManager;
    }

    @Override
    public void apply(World world) {
        this.active = true;
        for (Player player : world.getPlayers()) {
            if (player.getLocation().getBlock().getLightFromSky() < 13) continue;
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 200, 0));
            String message = this.languageManager.get(player, "sun_warmth");
            player.sendActionBar(message);
        }
    }

    @Override
    public void stop(World world) {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }
}

