/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.elementalWeather.weather;

import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jufyer.plugin.elementalWeather.language.LanguageManager;
import org.jufyer.plugin.elementalWeather.weather.WeatherEffect;

public class ThunderstormEffect
implements WeatherEffect {
    private final LanguageManager languageManager;
    private boolean active = false;

    public ThunderstormEffect(LanguageManager languageManager) {
        this.languageManager = languageManager;
    }

    @Override
    public void apply(World world) {
        this.active = true;
        for (Player player : world.getPlayers()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 200, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 200, 1));
            player.getWorld().strikeLightningEffect(player.getLocation());
            String msg = this.languageManager.get(player, "storm_energy");
            player.sendActionBar(msg);
        }
    }

    @Override
    public void stop(World world) {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }
}

