/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.manaattributes.mixin.entity;

import com.github.theredbrain.manaattributes.ManaAttributes;
import com.github.theredbrain.manaattributes.entity.ManaUsingEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements ManaUsingEntity {
    @Unique
    private int manaTickTimer = 0;
    @Unique
    private int depletedManaRegenerationDelayTimer = 0;
    @Unique
    private int manaRegenerationDelayTimer = 0;
    @Unique
    private boolean delayManaRegeneration = false;
    @Unique
    private Float oldMana = null;
    @Unique
    private boolean applyOldMana = true;
    @Unique
    private boolean applyMaxMana = false;
    @Unique
    private static final class_2940<Float> MANA = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13320);

    @Shadow
    public abstract double method_45325(class_6880<class_1320> var1);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="RETURN")})
    protected void manaattributes$initDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(MANA, (Object)Float.valueOf(10.0f));
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static void manaattributes$createLivingAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(ManaAttributes.MANA_REGENERATION).method_26867(ManaAttributes.MAX_MANA).method_26867(ManaAttributes.MANA_REGENERATION_DELAY_THRESHOLD).method_26867(ManaAttributes.DEPLETED_MANA_REGENERATION_DELAY_THRESHOLD).method_26867(ManaAttributes.MANA_TICK_THRESHOLD).method_26867(ManaAttributes.RESERVED_MANA);
    }

    @Inject(method={"readCustomData"}, at={@At(value="HEAD")})
    public void manaattributes$readCustomData_head(class_11368 view, CallbackInfo ci) {
        float mana = view.contains("mana") ? view.method_71423("mana", this.manaattributes$getMaxMana()) : Float.MIN_VALUE;
        if (mana != Float.MIN_VALUE) {
            this.oldMana = Float.valueOf(mana);
        }
    }

    @Inject(method={"readCustomData"}, at={@At(value="TAIL")})
    public void manaattributes$readCustomData_tail(class_11368 view, CallbackInfo ci) {
        if (view.contains("mana")) {
            this.manaattributes$setMana(view.method_71423("mana", this.manaattributes$getMaxMana()));
        }
    }

    @Inject(method={"writeCustomData"}, at={@At(value="TAIL")})
    public void manaattributes$writeCustomData(class_11372 view, CallbackInfo ci) {
        view.method_71464("mana", this.manaattributes$getMana());
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void manaattributes$tick(CallbackInfo ci) {
        if (!this.method_73183().method_8608()) {
            ++this.manaTickTimer;
            if (this.manaattributes$getMana() <= 0.0f && this.delayManaRegeneration) {
                this.depletedManaRegenerationDelayTimer = 0;
                this.manaRegenerationDelayTimer = this.manaattributes$getManaRegenerationDelayThreshold();
                this.delayManaRegeneration = false;
            }
            if (this.manaattributes$getMana() > 0.0f && !this.delayManaRegeneration) {
                this.delayManaRegeneration = true;
            }
            if (this.depletedManaRegenerationDelayTimer <= this.manaattributes$getDepletedManaRegenerationDelayThreshold()) {
                ++this.depletedManaRegenerationDelayTimer;
            }
            if (this.manaRegenerationDelayTimer <= this.manaattributes$getManaRegenerationDelayThreshold()) {
                ++this.manaRegenerationDelayTimer;
            }
            if (this.manaTickTimer >= this.manaattributes$getManaTickThreshold() && this.manaRegenerationDelayTimer >= this.manaattributes$getManaRegenerationDelayThreshold() && this.depletedManaRegenerationDelayTimer >= this.manaattributes$getDepletedManaRegenerationDelayThreshold()) {
                if (this.manaattributes$getMana() < this.manaattributes$getUnreservedMana() || this.manaattributes$getRegeneratedMana() < 0.0f) {
                    this.manaattributes$addMana(this.manaattributes$getRegeneratedMana());
                }
                if (this.manaattributes$getMana() > this.manaattributes$getUnreservedMana()) {
                    this.manaattributes$setMana(this.manaattributes$getUnreservedMana());
                }
                this.manaTickTimer = 0;
            }
        }
        if (this.applyOldMana) {
            if (this.applyMaxMana) {
                this.oldMana = Float.valueOf(this.manaattributes$getUnreservedMana());
                this.applyMaxMana = false;
            }
            if (this.oldMana != null) {
                this.manaattributes$setMana(this.oldMana.floatValue());
                this.oldMana = null;
            }
        } else {
            this.applyOldMana = true;
        }
    }

    @Override
    public int manaattributes$getDepletedManaRegenerationDelayThreshold() {
        return (int)this.method_45325(ManaAttributes.DEPLETED_MANA_REGENERATION_DELAY_THRESHOLD);
    }

    @Override
    public int manaattributes$getManaRegenerationDelayThreshold() {
        return (int)this.method_45325(ManaAttributes.MANA_REGENERATION_DELAY_THRESHOLD);
    }

    @Override
    public int manaattributes$getManaTickThreshold() {
        return (int)this.method_45325(ManaAttributes.MANA_TICK_THRESHOLD);
    }

    @Override
    public float manaattributes$getRegeneratedMana() {
        return this.manaattributes$getManaRegeneration();
    }

    @Override
    public float manaattributes$getManaRegeneration() {
        return (float)this.method_45325(ManaAttributes.MANA_REGENERATION);
    }

    @Override
    public float manaattributes$getUnreservedMana() {
        return this.manaattributes$getMaxMana() - this.manaattributes$getMaxMana() * this.manaattributes$getReservedMana() / 100.0f;
    }

    @Override
    public float manaattributes$getMaxMana() {
        return (float)this.method_45325(ManaAttributes.MAX_MANA);
    }

    @Override
    public float manaattributes$getReservedMana() {
        return (float)this.method_45325(ManaAttributes.RESERVED_MANA);
    }

    @Override
    public void manaattributes$addMana(float amount) {
        float f = this.manaattributes$getMana();
        this.manaattributes$setMana(f + amount);
        if (amount < 0.0f) {
            this.manaRegenerationDelayTimer = 0;
            this.manaTickTimer = 0;
        }
    }

    @Override
    public float manaattributes$getMana() {
        return ((Float)this.field_6011.method_12789(MANA)).floatValue();
    }

    @Override
    public void manaattributes$setMana(float mana) {
        this.field_6011.method_12778(MANA, (Object)Float.valueOf(class_3532.method_15363((float)mana, (float)0.0f, (float)this.manaattributes$getUnreservedMana())));
    }

    @Override
    public void manaattributes$setApplyOldMana(boolean applyOldMana) {
        this.applyOldMana = applyOldMana;
    }

    @Override
    public void manaattributes$setApplyMaxMana(boolean applyMaxMana) {
        this.applyMaxMana = applyMaxMana;
    }
}

