/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.manaattributes.registry;

import com.github.theredbrain.manaattributes.ManaAttributes;
import com.github.theredbrain.manaattributes.ManaAttributesClient;
import com.github.theredbrain.manaattributes.config.ClientConfig;
import com.github.theredbrain.manaattributes.entity.ManaUsingEntity;
import com.github.theredbrain.resourcebarapi.ResourceBarAPI;
import com.github.theredbrain.resourcebarapi.ResourceBarAPIClient;
import java.util.ArrayList;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.apache.commons.lang3.tuple.MutablePair;

@Environment(value=EnvType.CLIENT)
public class ClientEventsRegistry {
    private static final String RESOURCE_BAR_IDENTIFIER_STRING = "manaattributes:mana";
    private static final class_2960 ICON_MANA_CONTAINER = ManaAttributes.identifier("hud/icon_mana_container");
    private static final class_2960 ICON_MANA_FULL = ManaAttributes.identifier("hud/icon_mana_full");
    private static final class_2960 ICON_MANA_HALF = ManaAttributes.identifier("hud/icon_mana_half");

    public static void initializeClientEvents() {
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.HEALTH_BAR, (class_2960)ManaAttributes.identifier("mana"), (matrixStack, delta) -> {
            class_310 minecraftClient = class_310.method_1551();
            class_746 playerEntity = minecraftClient.field_1724;
            ClientConfig clientConfig = ManaAttributesClient.CLIENT_CONFIG;
            if (playerEntity != null && !minecraftClient.field_1690.field_1842) {
                double mana = class_3532.method_15386((float)((ManaUsingEntity)playerEntity).manaattributes$getMana());
                double maxMana = class_3532.method_15386((float)((ManaUsingEntity)playerEntity).manaattributes$getMaxMana());
                double unreservedMana = class_3532.method_15386((float)((ManaUsingEntity)playerEntity).manaattributes$getUnreservedMana());
                if (!playerEntity.method_68878() && maxMana > 0.0) {
                    int u = playerEntity.method_5748();
                    int v = Math.min(playerEntity.method_5669(), u);
                    int air_offset = clientConfig.dynamically_adjust_to_air_bar && playerEntity.method_5777(class_3486.field_15517) || v < u ? 10 : 0;
                    int armor_offset = clientConfig.dynamically_adjust_to_armor_bar && playerEntity.method_6096() > 0 ? 10 : 0;
                    MutablePair originPos = ResourceBarAPIClient.getOriginPos((class_332)matrixStack, (ResourceBarAPI.ResourceBarOrigin)clientConfig.origin);
                    if (clientConfig.mana_bar_display == ResourceBarAPI.ResourceBarDisplay.ICON && (mana < maxMana || clientConfig.show_full_mana_bar)) {
                        ResourceBarAPIClient.drawIconResourceBar((class_310)minecraftClient, (class_332)matrixStack, (String)RESOURCE_BAR_IDENTIFIER_STRING, (double)mana, (double)maxMana, (class_2960)ICON_MANA_CONTAINER, (class_2960)ICON_MANA_FULL, (class_2960)ICON_MANA_HALF, new ArrayList(), new ArrayList(), (int)((Integer)originPos.getLeft()), (int)((Integer)originPos.getRight()), (int)((Integer)clientConfig.iconBarSettings.offset_x.get()), (int)((Integer)clientConfig.iconBarSettings.offset_y.get() + air_offset + armor_offset), (ResourceBarAPI.ResourceBarFillDirection)clientConfig.fill_direction, (boolean)((Boolean)clientConfig.iconBarSettings.reverse_stack_direction.get()), (int)((Integer)clientConfig.iconBarSettings.max_icon_amount_per_bar.get()));
                    } else if (clientConfig.mana_bar_display == ResourceBarAPI.ResourceBarDisplay.SMOOTH && (mana < maxMana || clientConfig.show_full_mana_bar)) {
                        ResourceBarAPIClient.drawSmoothResourceBar((class_310)minecraftClient, (class_332)matrixStack, (String)RESOURCE_BAR_IDENTIFIER_STRING, (double[])new double[]{-1.0, -1.0, 0.0, -91.0, -45.0, 5.0, 182.0, 5.0, 182.0, 5.0, 182.0, 5.0, 5.0, 0.0, 0.0}, (class_2960[])new class_2960[]{class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_background.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_progress_decrease_animation.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_progress_increase_animation.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_progress_increase_value.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_progress.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_reserved.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_overlay.png"), null}, (double)mana, (double)maxMana, (int)class_3532.method_15386((float)((ManaUsingEntity)playerEntity).manaattributes$getRegeneratedMana()), (double)unreservedMana, (int)((Integer)originPos.getLeft()), (int)((Integer)originPos.getRight()), clientConfig.smoothBarSettings.positionSettings.offsets_x, clientConfig.smoothBarSettings.positionSettings.offsets_y, (int)0, (int)(air_offset + armor_offset), (ResourceBarAPI.ResourceBarFillDirection)clientConfig.fill_direction, clientConfig.smoothBarSettings.textureSettings.backgroundTextureSettings.texture_heights, clientConfig.smoothBarSettings.textureSettings.backgroundTextureSettings.texture_widths, clientConfig.smoothBarSettings.textureSettings.backgroundTextureSettings.texture_ids, (int)clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.offset_x, (int)clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.offset_y, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.texture_heights, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.texture_widths, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.progress_decrease_animation_texture_ids, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.progress_increase_animation_texture_ids, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.progress_increase_value_texture_ids, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.progress_texture_ids, (int)clientConfig.smoothBarSettings.textureSettings.reservedTextureSettings.offset_x, (int)clientConfig.smoothBarSettings.textureSettings.reservedTextureSettings.offset_y, clientConfig.smoothBarSettings.textureSettings.reservedTextureSettings.texture_heights, clientConfig.smoothBarSettings.textureSettings.reservedTextureSettings.texture_widths, clientConfig.smoothBarSettings.textureSettings.reservedTextureSettings.texture_ids, (boolean)clientConfig.smoothBarSettings.show_current_value_overlay, (int)clientConfig.smoothBarSettings.textureSettings.overlayTextureSettings.offset_x, (int)clientConfig.smoothBarSettings.textureSettings.overlayTextureSettings.offset_y, clientConfig.smoothBarSettings.textureSettings.overlayTextureSettings.texture_heights, clientConfig.smoothBarSettings.textureSettings.overlayTextureSettings.texture_widths, clientConfig.smoothBarSettings.textureSettings.overlayTextureSettings.texture_ids, (boolean)clientConfig.smoothBarSettings.show_icon, (int)clientConfig.smoothBarSettings.iconTextureSettings.offset_x, (int)clientConfig.smoothBarSettings.iconTextureSettings.offset_y, clientConfig.smoothBarSettings.iconTextureSettings.texture_heights, clientConfig.smoothBarSettings.iconTextureSettings.texture_widths, clientConfig.smoothBarSettings.iconTextureSettings.texture_ids, (boolean)clientConfig.smoothBarSettings.enable_smooth_animation, (int)clientConfig.smoothBarSettings.animationSettings.animation_interval, (boolean)clientConfig.smoothBarSettings.animationSettings.max_value_change_is_animated);
                    }
                    if (clientConfig.numberSettings.show_number && (mana < maxMana || clientConfig.numberSettings.show_when_mana_full)) {
                        ResourceBarAPIClient.drawResourceNumber((class_310)minecraftClient, (class_327)minecraftClient.field_1772, (class_332)matrixStack, (String)RESOURCE_BAR_IDENTIFIER_STRING, (double)mana, (double)maxMana, (double)unreservedMana, (int)((Integer)originPos.getLeft()), (int)((Integer)originPos.getRight()), (boolean)clientConfig.numberSettings.show_max_value, (int)clientConfig.numberSettings.offset_x, (int)(clientConfig.numberSettings.offset_y + air_offset + armor_offset), (int)clientConfig.numberSettings.color.toInt());
                    }
                }
            }
        });
        ConfigApi.event().onUpdateClient((identifier, config) -> {
            if (identifier.equals((Object)class_2960.method_60655((String)"manaattributes", (String)"client"))) {
                ResourceBarAPIClient.clearCache((String)RESOURCE_BAR_IDENTIFIER_STRING, (double[])new double[]{-1.0, -1.0, 0.0, -91.0, -45.0, 5.0, 182.0, 5.0, 182.0, 5.0, 182.0, 5.0, 5.0, 0.0, 0.0}, (class_2960[])new class_2960[]{class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_background.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_progress_decrease_animation.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_progress_increase_animation.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_progress_increase_value.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_progress.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_reserved.png"), class_2960.method_60655((String)"manaattributes", (String)"textures/gui/sprites/hud/horizontal_mana_overlay.png"), null});
            }
        });
    }
}

