/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.client;

import net.atif.buildnotes.client.ClientCache;
import net.atif.buildnotes.client.ClientImageTransferManager;
import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.client.KeyBinds;
import net.atif.buildnotes.data.ColorConfig;
import net.atif.buildnotes.data.TabType;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.atif.buildnotes.network.ClientPacketHandler;
import net.atif.buildnotes.network.packet.s2c.DeleteBuildS2CPacket;
import net.atif.buildnotes.network.packet.s2c.DeleteNoteS2CPacket;
import net.atif.buildnotes.network.packet.s2c.HandshakeS2CPacket;
import net.atif.buildnotes.network.packet.s2c.ImageChunkS2CPacket;
import net.atif.buildnotes.network.packet.s2c.ImageNotFoundS2CPacket;
import net.atif.buildnotes.network.packet.s2c.InitialSyncS2CPacket;
import net.atif.buildnotes.network.packet.s2c.UpdateBuildS2CPacket;
import net.atif.buildnotes.network.packet.s2c.UpdateNoteS2CPacket;
import net.atif.buildnotes.network.packet.s2c.UpdatePermissionS2CPacket;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class BuildnotesClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ColorConfig.loadColors();
        KeyBinds.register();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (KeyBinds.openGuiKey.method_1436()) {
                if (client.field_1755 != null) continue;
                Colors.reload();
                client.method_1507((class_437)new MainScreen(TabType.NOTES));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(HandshakeS2CPacket.ID, (packet, context) -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> ClientPacketHandler.handleHandshake(client, packet));
        });
        ClientPlayNetworking.registerGlobalReceiver(InitialSyncS2CPacket.ID, (packet, context) -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> ClientPacketHandler.handleInitialSync(client, packet));
        });
        ClientPlayNetworking.registerGlobalReceiver(UpdatePermissionS2CPacket.ID, (payload, context) -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> ClientPacketHandler.handleUpdatePermission(context.client(), payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(UpdateNoteS2CPacket.ID, (packet, context) -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> ClientPacketHandler.handleUpdateNote(client, packet));
        });
        ClientPlayNetworking.registerGlobalReceiver(UpdateBuildS2CPacket.ID, (packet, context) -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> ClientPacketHandler.handleUpdateBuild(client, packet));
        });
        ClientPlayNetworking.registerGlobalReceiver(DeleteNoteS2CPacket.ID, (packet, context) -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> ClientPacketHandler.handleDeleteNote(client, packet));
        });
        ClientPlayNetworking.registerGlobalReceiver(DeleteBuildS2CPacket.ID, (packet, context) -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> ClientPacketHandler.handleDeleteBuild(client, packet));
        });
        ClientPlayNetworking.registerGlobalReceiver(ImageChunkS2CPacket.ID, (packet, context) -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> ClientPacketHandler.handleImageChunk(client, packet));
        });
        ClientPlayNetworking.registerGlobalReceiver(ImageNotFoundS2CPacket.ID, (packet, context) -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> ClientPacketHandler.handleImageNotFound(client, packet));
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ClientCache.clear();
            ClientImageTransferManager.clearFailedDownloads();
            ClientSession.leaveServer();
        });
    }
}

